/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.connector.Projection;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeFamily;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.StructuredType;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;
import org.apache.flink.table.types.logical.utils.LogicalTypeUtils;
import org.apache.flink.table.types.utils.DataTypeUtils;
import org.apache.flink.table.types.utils.TypeInfoDataTypeConverter;

@Internal
public final class SchemaTranslator {
    public static ProducingResult createProducingResult(ResolvedSchema inputSchema, @Nullable Schema declaredSchema) {
        if (declaredSchema == null) {
            DataType physicalDataType = inputSchema.toSourceRowDataType();
            Schema schema = Schema.newBuilder().fromRowDataType(physicalDataType).build();
            return new ProducingResult(null, schema, null);
        }
        List<Schema.UnresolvedColumn> declaredColumns = declaredSchema.getColumns();
        if (declaredColumns.stream().noneMatch(SchemaTranslator::isPhysical)) {
            DataType sourceDataType = inputSchema.toSourceRowDataType();
            DataType physicalDataType = SchemaTranslator.patchDataTypeWithoutMetadataRowtime(sourceDataType, declaredColumns);
            Schema.Builder builder = Schema.newBuilder();
            builder.fromRowDataType(physicalDataType);
            builder.fromSchema(declaredSchema);
            return new ProducingResult(null, builder.build(), null);
        }
        return new ProducingResult(null, declaredSchema, null);
    }

    public static ProducingResult createProducingResult(DataTypeFactory dataTypeFactory, ResolvedSchema inputSchema, AbstractDataType<?> targetDataType) {
        List<String> inputFieldNames = inputSchema.getColumnNames();
        List inputFieldNamesNormalized = inputFieldNames.stream().map(n -> n.toLowerCase(Locale.ROOT)).collect(Collectors.toList());
        DataType resolvedDataType = dataTypeFactory.createDataType(targetDataType);
        List<String> targetFieldNames = DataTypeUtils.flattenToNames(resolvedDataType);
        List targetFieldNamesNormalized = targetFieldNames.stream().map(n -> n.toLowerCase(Locale.ROOT)).collect(Collectors.toList());
        List<DataType> targetFieldDataTypes = DataTypeUtils.flattenToDataTypes(resolvedDataType);
        List<String> projections = null;
        if (targetFieldNames.size() == inputFieldNames.size()) {
            if (targetFieldNames.containsAll(inputFieldNames)) {
                projections = targetFieldNames;
            } else if (targetFieldNamesNormalized.containsAll(inputFieldNamesNormalized) && targetFieldNamesNormalized.stream().distinct().count() == (long)targetFieldNames.size() && inputFieldNamesNormalized.stream().distinct().count() == (long)inputFieldNames.size()) {
                projections = targetFieldNamesNormalized.stream().map(targetName -> {
                    int inputFieldPos = inputFieldNamesNormalized.indexOf(targetName);
                    return (String)inputFieldNames.get(inputFieldPos);
                }).collect(Collectors.toList());
            }
        }
        Schema schema = Schema.newBuilder().fromFields(targetFieldNames, targetFieldDataTypes).build();
        return new ProducingResult(projections, schema, resolvedDataType);
    }

    public static ConsumingResult createConsumingResult(DataTypeFactory dataTypeFactory, TypeInformation<?> inputTypeInfo, @Nullable Schema declaredSchema) {
        DataType inputDataType = TypeInfoDataTypeConverter.toDataType(dataTypeFactory, inputTypeInfo);
        return SchemaTranslator.createConsumingResult(dataTypeFactory, inputDataType, declaredSchema, true);
    }

    public static ConsumingResult createConsumingResult(DataTypeFactory dataTypeFactory, DataType inputDataType, @Nullable Schema declaredSchema, boolean mergePhysicalSchema) {
        LogicalType inputType = inputDataType.getLogicalType();
        boolean isTopLevelRecord = LogicalTypeChecks.isCompositeType(inputType);
        if (declaredSchema == null) {
            Schema.Builder builder = Schema.newBuilder();
            SchemaTranslator.addPhysicalSourceDataTypeFields(builder, inputDataType, null);
            return new ConsumingResult(inputDataType, isTopLevelRecord, builder.build(), null);
        }
        List<Schema.UnresolvedColumn> declaredColumns = declaredSchema.getColumns();
        Schema.UnresolvedPrimaryKey declaredPrimaryKey = declaredSchema.getPrimaryKey().orElse(null);
        if (declaredColumns.stream().noneMatch(SchemaTranslator::isPhysical)) {
            Schema.Builder builder = Schema.newBuilder();
            SchemaTranslator.addPhysicalSourceDataTypeFields(builder, inputDataType, declaredPrimaryKey);
            builder.fromSchema(declaredSchema);
            return new ConsumingResult(inputDataType, isTopLevelRecord, builder.build(), null);
        }
        if (!mergePhysicalSchema) {
            return new ConsumingResult(inputDataType, isTopLevelRecord, declaredSchema, null);
        }
        DataType patchedDataType = SchemaTranslator.patchDataTypeFromDeclaredSchema(dataTypeFactory, inputDataType, declaredColumns);
        Schema patchedSchema = SchemaTranslator.createPatchedSchema(isTopLevelRecord, patchedDataType, declaredSchema);
        List<String> projections = SchemaTranslator.extractProjections(patchedSchema, declaredSchema);
        return new ConsumingResult(patchedDataType, isTopLevelRecord, patchedSchema, projections);
    }

    private static DataType patchDataTypeWithoutMetadataRowtime(DataType dataType, List<Schema.UnresolvedColumn> declaredColumns) {
        List<DataType> columnDataTypes = dataType.getChildren();
        int columnCount = columnDataTypes.size();
        long persistedMetadataCount = declaredColumns.stream().filter(c -> c instanceof Schema.UnresolvedMetadataColumn).map(Schema.UnresolvedMetadataColumn.class::cast).filter(c -> !c.isVirtual()).count();
        if (persistedMetadataCount != 1L || columnCount < 1) {
            return dataType;
        }
        if (!columnDataTypes.get(columnCount - 1).getLogicalType().is(LogicalTypeFamily.TIMESTAMP)) {
            return dataType;
        }
        int[] indices = IntStream.range(0, columnCount - 1).toArray();
        return Projection.of(indices).project(dataType);
    }

    @Nullable
    private static List<String> extractProjections(Schema patchedSchema, Schema declaredSchema) {
        List<String> declaredColumns;
        List patchedColumns = patchedSchema.getColumns().stream().map(Schema.UnresolvedColumn::getName).collect(Collectors.toList());
        if (patchedColumns.equals(declaredColumns = declaredSchema.getColumns().stream().map(Schema.UnresolvedColumn::getName).collect(Collectors.toList()))) {
            return null;
        }
        return declaredColumns;
    }

    private static Schema createPatchedSchema(boolean isTopLevelRecord, DataType patchedDataType, Schema declaredSchema) {
        Schema.Builder builder = Schema.newBuilder();
        if (isTopLevelRecord) {
            SchemaTranslator.addPhysicalSourceDataTypeFields(builder, patchedDataType, null);
        } else {
            builder.column(LogicalTypeUtils.getAtomicName(Collections.emptyList()), patchedDataType);
        }
        List<Schema.UnresolvedColumn> nonPhysicalColumns = declaredSchema.getColumns().stream().filter(c -> !SchemaTranslator.isPhysical(c)).collect(Collectors.toList());
        builder.fromColumns(nonPhysicalColumns);
        declaredSchema.getWatermarkSpecs().forEach(spec -> builder.watermark(spec.getColumnName(), spec.getWatermarkExpression()));
        declaredSchema.getPrimaryKey().ifPresent(key -> builder.primaryKeyNamed(key.getConstraintName(), key.getColumnNames()));
        declaredSchema.getIndexes().forEach(idx -> builder.indexNamed(idx.getIndexName(), idx.getColumnNames()));
        return builder.build();
    }

    private static DataType patchDataTypeFromDeclaredSchema(DataTypeFactory dataTypeFactory, DataType inputDataType, List<Schema.UnresolvedColumn> declaredColumns) {
        List physicalColumns = declaredColumns.stream().filter(SchemaTranslator::isPhysical).map(Schema.UnresolvedPhysicalColumn.class::cast).collect(Collectors.toList());
        DataType patchedDataType = inputDataType;
        for (Schema.UnresolvedPhysicalColumn physicalColumn : physicalColumns) {
            patchedDataType = SchemaTranslator.patchDataTypeFromColumn(dataTypeFactory, patchedDataType, physicalColumn);
        }
        return patchedDataType;
    }

    private static DataType patchDataTypeFromColumn(DataTypeFactory dataTypeFactory, DataType dataType, Schema.UnresolvedPhysicalColumn physicalColumn) {
        String columnName;
        List<String> fieldNames = DataTypeUtils.flattenToNames(dataType);
        if (!fieldNames.contains(columnName = physicalColumn.getName())) {
            throw new ValidationException(String.format("Unable to find a field named '%s' in the physical data type derived from the given type information for schema declaration. Make sure that the type information is not a generic raw type. Currently available fields are: %s", columnName, fieldNames));
        }
        DataType columnDataType = dataTypeFactory.createDataType(physicalColumn.getDataType());
        LogicalType type = dataType.getLogicalType();
        if (type.is(LogicalTypeRoot.ROW)) {
            return SchemaTranslator.patchRowDataType(dataType, columnName, columnDataType);
        }
        if (type.is(LogicalTypeRoot.STRUCTURED_TYPE)) {
            return SchemaTranslator.patchStructuredDataType(dataType, columnName, columnDataType);
        }
        return columnDataType;
    }

    private static DataType patchRowDataType(DataType dataType, String patchedFieldName, DataType patchedFieldDataType) {
        RowType type = (RowType)dataType.getLogicalType();
        List<String> oldFieldNames = DataTypeUtils.flattenToNames(dataType);
        List<DataType> oldFieldDataTypes = dataType.getChildren();
        Class<?> oldConversion = dataType.getConversionClass();
        DataTypes.Field[] fields = SchemaTranslator.patchFields(oldFieldNames, oldFieldDataTypes, patchedFieldName, patchedFieldDataType);
        DataType newDataType = (DataType)DataTypes.ROW(fields).bridgedTo(oldConversion);
        if (!type.isNullable()) {
            return (DataType)newDataType.notNull();
        }
        return newDataType;
    }

    private static DataType patchStructuredDataType(DataType dataType, String patchedFieldName, DataType patchedFieldDataType) {
        StructuredType type = (StructuredType)dataType.getLogicalType();
        List<String> oldFieldNames = DataTypeUtils.flattenToNames(dataType);
        List<DataType> oldFieldDataTypes = dataType.getChildren();
        Class<?> oldConversion = dataType.getConversionClass();
        DataTypes.Field[] fields = SchemaTranslator.patchFields(oldFieldNames, oldFieldDataTypes, patchedFieldName, patchedFieldDataType);
        DataType newDataType = (DataType)DataTypes.STRUCTURED(type.getImplementationClass().orElseThrow(IllegalStateException::new), fields).bridgedTo(oldConversion);
        if (!type.isNullable()) {
            return (DataType)newDataType.notNull();
        }
        return newDataType;
    }

    private static DataTypes.Field[] patchFields(List<String> oldFieldNames, List<DataType> oldFieldDataTypes, String patchedFieldName, DataType patchedFieldDataType) {
        return (DataTypes.Field[])IntStream.range(0, oldFieldNames.size()).mapToObj(pos -> {
            String oldFieldName = (String)oldFieldNames.get(pos);
            DataType newFieldDataType = oldFieldName.equals(patchedFieldName) ? patchedFieldDataType : (DataType)oldFieldDataTypes.get(pos);
            return DataTypes.FIELD(oldFieldName, newFieldDataType);
        }).toArray(DataTypes.Field[]::new);
    }

    private static void addPhysicalSourceDataTypeFields(Schema.Builder builder, DataType dataType, @Nullable Schema.UnresolvedPrimaryKey primaryKey) {
        List<String> fieldNames = DataTypeUtils.flattenToNames(dataType);
        List<DataType> fieldDataTypes = DataTypeUtils.flattenToDataTypes(dataType);
        List fieldDataTypesWithPatchedNullability = IntStream.range(0, fieldNames.size()).mapToObj(pos -> {
            String fieldName = (String)fieldNames.get(pos);
            DataType fieldDataType = (DataType)fieldDataTypes.get(pos);
            if (primaryKey != null && primaryKey.getColumnNames().contains(fieldName)) {
                return (DataType)((DataType)fieldDataTypes.get(pos)).notNull();
            }
            return fieldDataType;
        }).collect(Collectors.toList());
        builder.fromFields(fieldNames, fieldDataTypesWithPatchedNullability);
    }

    private static boolean isPhysical(Schema.UnresolvedColumn column) {
        return column instanceof Schema.UnresolvedPhysicalColumn;
    }

    @Internal
    public static final class ProducingResult {
        @Nullable
        private final List<String> projections;
        private final Schema schema;
        @Nullable
        private final DataType physicalDataType;

        private ProducingResult(@Nullable List<String> projections, Schema schema, @Nullable DataType physicalDataType) {
            this.projections = projections;
            this.schema = schema;
            this.physicalDataType = physicalDataType;
        }

        public Optional<List<String>> getProjections() {
            return Optional.ofNullable(this.projections);
        }

        public Schema getSchema() {
            return this.schema;
        }

        public Optional<DataType> getPhysicalDataType() {
            return Optional.ofNullable(this.physicalDataType);
        }
    }

    @Internal
    public static final class ConsumingResult {
        private final DataType physicalDataType;
        private final boolean isTopLevelRecord;
        private final Schema schema;
        @Nullable
        private final List<String> projections;

        private ConsumingResult(DataType physicalDataType, boolean isTopLevelRecord, Schema schema, @Nullable List<String> projections) {
            this.physicalDataType = physicalDataType;
            this.isTopLevelRecord = isTopLevelRecord;
            this.schema = schema;
            this.projections = projections;
        }

        public DataType getPhysicalDataType() {
            return this.physicalDataType;
        }

        public boolean isTopLevelRecord() {
            return this.isTopLevelRecord;
        }

        public Schema getSchema() {
            return this.schema;
        }

        @Nullable
        public List<String> getProjections() {
            return this.projections;
        }
    }
}

