/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.util;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class JavaCommandBuilder {
    public static List<String> buildCommand(String className, String additionalClasspath, Properties systemProperties, List<String> jvmOptions) {
        ArrayList<String> javaCommandLine = new ArrayList<String>();
        File javaBinDir = new File(System.getProperty("java.home"), "bin");
        File javaCommand = new File(javaBinDir, "java");
        javaCommandLine.add(javaCommand.getPath());
        String dashServerArg = JavaCommandBuilder.getDashServerArg(javaBinDir);
        if (dashServerArg != null) {
            javaCommandLine.add(dashServerArg);
        }
        if (jvmOptions != null) {
            for (String jvmOption : jvmOptions) {
                javaCommandLine.add(jvmOption);
            }
        }
        javaCommandLine.add("-classpath");
        javaCommandLine.add(JavaCommandBuilder.buildClasspath(additionalClasspath));
        if (systemProperties != null) {
            for (Object key : systemProperties.keySet()) {
                javaCommandLine.add("-D" + key + "=" + systemProperties.getProperty(key.toString()));
            }
        }
        javaCommandLine.add(className);
        return javaCommandLine;
    }

    private static String buildClasspath(String additionalClasspath) {
        StringBuilder classpath = new StringBuilder(System.getProperty("java.class.path"));
        if (additionalClasspath != null) {
            classpath.append(File.pathSeparator);
            classpath.append(additionalClasspath);
        }
        return classpath.toString();
    }

    private static String getDashServerArg(File javaBinDir) {
        String altDashServerArg = System.getProperty("gemfire.vmarg.dashserver", null);
        return altDashServerArg != null ? altDashServerArg : (JavaCommandBuilder.omitDashServerArg(javaBinDir) ? null : "-server");
    }

    private static boolean omitDashServerArg(File javaBinDir) {
        String vendor = System.getProperty("java.vm.vendor");
        if (vendor != null) {
            String os;
            String vendorUpperCase = vendor.toUpperCase();
            if (vendorUpperCase.startsWith("IBM")) {
                return true;
            }
            if (vendorUpperCase.startsWith("SUN") && (os = System.getProperty("os.name")) != null && os.indexOf("Windows") != -1) {
                File serverDir = new File(javaBinDir, "server");
                return !serverDir.isDirectory();
            }
        }
        return false;
    }
}

