/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.support.util;

public class StringUtils {
    private static final int PAD_LIMIT = 8192;

    public static String padLeft(String str, int size) {
        return StringUtils.padLeft(str, size, ' ');
    }

    public static String padLeft(String str, int size, char padChar) {
        if (str == null) {
            return null;
        }
        int pads = size - str.length();
        if (pads <= 0) {
            return str;
        }
        if (pads > 8192) {
            return StringUtils.padLeft(str, size, String.valueOf(padChar));
        }
        return StringUtils.padding(pads, padChar).concat(str);
    }

    public static String padLeft(String str, int size, String padStr) {
        if (str == null) {
            return null;
        }
        if (StringUtils.isEmpty(padStr)) {
            padStr = " ";
        }
        int padLen = padStr.length();
        int strLen = str.length();
        int pads = size - strLen;
        if (pads <= 0) {
            return str;
        }
        if (padLen == 1 && pads <= 8192) {
            return StringUtils.padLeft(str, size, padStr.charAt(0));
        }
        if (pads == padLen) {
            return padStr.concat(str);
        }
        if (pads < padLen) {
            return padStr.substring(0, pads).concat(str);
        }
        char[] padding = new char[pads];
        char[] padChars = padStr.toCharArray();
        for (int i = 0; i < pads; ++i) {
            padding[i] = padChars[i % padLen];
        }
        return new String(padding).concat(str);
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    private static String padding(int repeat, char padChar) throws IndexOutOfBoundsException {
        if (repeat < 0) {
            throw new IndexOutOfBoundsException("Cannot pad a negative amount: " + repeat);
        }
        char[] buf = new char[repeat];
        for (int i = 0; i < buf.length; ++i) {
            buf[i] = padChar;
        }
        return new String(buf);
    }

    public static String padRight(String inputString, int size, char paddingChar) {
        String stringToPad = inputString == null ? "" : inputString;
        StringBuilder padded = new StringBuilder(stringToPad);
        while (padded.length() < size) {
            padded.append(paddingChar);
        }
        return padded.toString();
    }

    public static String padRight(String string, int size) {
        return StringUtils.padRight(string, size, ' ');
    }
}

