/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.dto.requests;

import java.util.Arrays;
import org.apache.gravitino.dto.rel.partitions.PartitionDTO;
import org.apache.gravitino.rest.RESTRequest;
import org.apache.gravitino.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.gravitino.shaded.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.gravitino.shaded.com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import org.apache.gravitino.shaded.com.google.common.base.Preconditions;

@JsonDeserialize(builder=AddPartitionsRequestBuilder.class)
public class AddPartitionsRequest
implements RESTRequest {
    @JsonProperty(value="partitions")
    private final PartitionDTO[] partitions;

    public AddPartitionsRequest() {
        this(null);
    }

    public AddPartitionsRequest(PartitionDTO[] partitions) {
        this.partitions = partitions;
    }

    @Override
    public void validate() throws IllegalArgumentException {
        Preconditions.checkArgument(this.partitions != null, "partitions must not be null");
        Preconditions.checkArgument(this.partitions.length == 1, "Haven't yet implemented multiple partitions");
    }

    public static AddPartitionsRequestBuilder builder() {
        return new AddPartitionsRequestBuilder();
    }

    public PartitionDTO[] getPartitions() {
        return this.partitions;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddPartitionsRequest)) {
            return false;
        }
        AddPartitionsRequest other = (AddPartitionsRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Arrays.deepEquals(this.getPartitions(), other.getPartitions());
    }

    protected boolean canEqual(Object other) {
        return other instanceof AddPartitionsRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.deepHashCode(this.getPartitions());
        return result;
    }

    public String toString() {
        return "AddPartitionsRequest(partitions=" + Arrays.deepToString(this.getPartitions()) + ")";
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class AddPartitionsRequestBuilder {
        private PartitionDTO[] partitions;

        AddPartitionsRequestBuilder() {
        }

        @JsonProperty(value="partitions")
        public AddPartitionsRequestBuilder partitions(PartitionDTO[] partitions) {
            this.partitions = partitions;
            return this;
        }

        public AddPartitionsRequest build() {
            return new AddPartitionsRequest(this.partitions);
        }

        public String toString() {
            return "AddPartitionsRequest.AddPartitionsRequestBuilder(partitions=" + Arrays.deepToString(this.partitions) + ")";
        }
    }
}

