/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.dto.responses;

import javax.annotation.Nullable;
import org.apache.gravitino.dto.authorization.OwnerDTO;
import org.apache.gravitino.dto.responses.BaseResponse;
import org.apache.gravitino.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.gravitino.shaded.com.google.common.base.Preconditions;
import org.apache.gravitino.shaded.org.apache.commons.lang3.StringUtils;

public class OwnerResponse
extends BaseResponse {
    @Nullable
    @JsonProperty(value="owner")
    private final OwnerDTO owner;

    public OwnerResponse(OwnerDTO owner) {
        super(0);
        this.owner = owner;
    }

    public OwnerResponse() {
        super(0);
        this.owner = null;
    }

    @Override
    public void validate() throws IllegalArgumentException {
        super.validate();
        if (this.owner != null) {
            Preconditions.checkArgument(StringUtils.isNotBlank(this.owner.name()), "owner 'name' must not be null or empty");
            Preconditions.checkArgument(this.owner.type() != null, "owner 'type' must not be null");
        }
    }

    @Nullable
    public OwnerDTO getOwner() {
        return this.owner;
    }

    @Override
    public String toString() {
        return "OwnerResponse(owner=" + String.valueOf(this.getOwner()) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OwnerResponse)) {
            return false;
        }
        OwnerResponse other = (OwnerResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OwnerDTO this$owner = this.getOwner();
        OwnerDTO other$owner = other.getOwner();
        return !(this$owner == null ? other$owner != null : !this$owner.equals(other$owner));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof OwnerResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        OwnerDTO $owner = this.getOwner();
        result = result * 59 + ($owner == null ? 43 : $owner.hashCode());
        return result;
    }
}

