/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.restrict;

import inet.ipaddr.HostName;
import inet.ipaddr.HostNameException;
import inet.ipaddr.IPAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.auth.restrict.Restrictable;
import org.apache.guacamole.auth.restrict.TranslatableInvalidHostLoginException;
import org.apache.guacamole.auth.restrict.TranslatableInvalidTimeLoginException;
import org.apache.guacamole.calendar.DailyRestriction;
import org.apache.guacamole.calendar.RestrictionType;
import org.apache.guacamole.calendar.TimeRestrictionParser;
import org.apache.guacamole.host.HostRestrictionParser;
import org.apache.guacamole.language.TranslatableGuacamoleSecurityException;
import org.apache.guacamole.net.auth.User;
import org.apache.guacamole.net.auth.UserContext;
import org.apache.guacamole.net.auth.UserGroup;
import org.apache.guacamole.net.auth.permission.SystemPermission;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestrictionVerificationService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestrictionVerificationService.class);

    public static RestrictionType allowedByTimeRestrictions(String allowedTimeString, String deniedTimeString) {
        if (deniedTimeString != null && !deniedTimeString.isEmpty()) {
            List<DailyRestriction> deniedTimes = TimeRestrictionParser.parseString(deniedTimeString);
            for (DailyRestriction restriction : deniedTimes) {
                if (!restriction.appliesNow()) continue;
                return RestrictionType.EXPLICIT_DENY;
            }
        }
        if (allowedTimeString == null || allowedTimeString.isEmpty()) {
            return RestrictionType.IMPLICIT_ALLOW;
        }
        List<DailyRestriction> allowedTimes = TimeRestrictionParser.parseString(allowedTimeString);
        for (DailyRestriction restriction : allowedTimes) {
            if (!restriction.appliesNow()) continue;
            return RestrictionType.EXPLICIT_ALLOW;
        }
        return RestrictionType.IMPLICIT_DENY;
    }

    public static RestrictionType allowedByHostRestrictions(String allowedHostsString, String deniedHostsString, String remoteAddress) {
        if ((allowedHostsString == null || allowedHostsString.isEmpty()) && (deniedHostsString == null || deniedHostsString.isEmpty())) {
            return RestrictionType.IMPLICIT_ALLOW;
        }
        if (remoteAddress == null || remoteAddress.isEmpty()) {
            LOGGER.warn("Host-based restrictions are present, but the remote address is invalid or could not be resolved. The action will not be allowed.");
            return RestrictionType.IMPLICIT_DENY;
        }
        HostName remoteHostName = new HostName(remoteAddress);
        List<HostName> deniedHosts = HostRestrictionParser.parseHostList(deniedHostsString);
        for (HostName hostName : deniedHosts) {
            try {
                if (hostName.isAddress() && hostName.toAddress().contains(remoteHostName.asAddress())) {
                    return RestrictionType.EXPLICIT_DENY;
                }
                for (IPAddress currAddr : hostName.toAllAddresses()) {
                    if (!currAddr.matches(remoteHostName.asAddressString())) continue;
                    return RestrictionType.EXPLICIT_DENY;
                }
            }
            catch (HostNameException | UnknownHostException e) {
                LOGGER.warn("Unknown or invalid host in denied hosts list: \"{}\"", (Object)hostName);
                LOGGER.debug("Exception while trying to resolve host: \"{}\"", (Object)hostName, (Object)e);
                return RestrictionType.IMPLICIT_DENY;
            }
        }
        if (allowedHostsString == null || allowedHostsString.isEmpty()) {
            return RestrictionType.IMPLICIT_ALLOW;
        }
        List<HostName> allowedHosts = HostRestrictionParser.parseHostList(allowedHostsString);
        for (HostName hostName : allowedHosts) {
            try {
                if (hostName.isAddress() && hostName.toAddress().contains(remoteHostName.asAddress())) {
                    return RestrictionType.EXPLICIT_ALLOW;
                }
                for (IPAddress currAddr : hostName.toAllAddresses()) {
                    if (!currAddr.matches(remoteHostName.asAddressString())) continue;
                    return RestrictionType.EXPLICIT_ALLOW;
                }
            }
            catch (HostNameException | UnknownHostException e) {
                LOGGER.warn("Unknown host encountered in allowed host string: {}", (Object)hostName);
                LOGGER.debug("Exception received trying to resolve host: {}", (Object)hostName, (Object)e);
            }
        }
        return RestrictionType.IMPLICIT_DENY;
    }

    public static void verifyHostRestrictions(UserContext context, Set<String> effectiveUserGroups, String remoteAddress) throws GuacamoleException {
        User currentUser = context.self();
        if (currentUser.getEffectivePermissions().getSystemPermissions().hasPermission(SystemPermission.Type.ADMINISTER)) {
            LOGGER.warn("User \"{}\" has System Administration permissions; additional restrictions will be bypassed.", (Object)currentUser.getIdentifier());
            return;
        }
        Map userAttributes = currentUser.getAttributes();
        String allowedHostString = (String)userAttributes.get("guac-restrict-hosts-allowed");
        String deniedHostString = (String)userAttributes.get("guac-restrict-hosts-denied");
        RestrictionType hostRestrictionResult = RestrictionVerificationService.allowedByHostRestrictions(allowedHostString, deniedHostString, remoteAddress);
        switch (hostRestrictionResult) {
            case EXPLICIT_DENY: {
                throw new TranslatableInvalidHostLoginException("User \"" + currentUser.getIdentifier() + "\" is not allowed to log in from \"" + remoteAddress + "\"", "RESTRICT.ERROR_USER_LOGIN_NOT_ALLOWED_FROM_HOST");
            }
            case EXPLICIT_ALLOW: {
                return;
            }
        }
        Collection userGroups = context.getPrivileged().getUserGroupDirectory().getAll(effectiveUserGroups);
        for (UserGroup userGroup : userGroups) {
            String grpDeniedHostString;
            Map grpAttributes = userGroup.getAttributes();
            String grpAllowedHostString = (String)grpAttributes.get("guac-restrict-hosts-allowed");
            RestrictionType grpRestrictionResult = RestrictionVerificationService.allowedByHostRestrictions(grpAllowedHostString, grpDeniedHostString = (String)grpAttributes.get("guac-restrict-hosts-denied"), remoteAddress);
            if (grpRestrictionResult == RestrictionType.EXPLICIT_DENY) {
                throw new TranslatableInvalidHostLoginException("User \"" + currentUser.getIdentifier() + "\" is not allowed to log in from host \"" + remoteAddress + "\" due to restrictions on group \"" + userGroup.getIdentifier() + "\".", "RESTRICT.ERROR_USER_LOGIN_NOT_ALLOWED_FROM_HOST");
            }
            hostRestrictionResult = RestrictionType.getHigherPriority(hostRestrictionResult, grpRestrictionResult);
        }
        switch (hostRestrictionResult) {
            case EXPLICIT_ALLOW: {
                return;
            }
            case IMPLICIT_ALLOW: {
                return;
            }
        }
        throw new TranslatableInvalidHostLoginException("User \"" + currentUser.getIdentifier() + "\" is implicitly denied at this time.", "RESTRICT.ERROR_USER_LOGIN_NOT_ALLOWED_FROM_HOST");
    }

    public static void verifyHostRestrictions(Restrictable restrictable, String remoteAddress) throws GuacamoleException {
        String deniedHostsString;
        String allowedHostsString = (String)restrictable.getAttributes().get("guac-restrict-hosts-allowed");
        RestrictionType hostRestrictionResult = RestrictionVerificationService.allowedByHostRestrictions(allowedHostsString, deniedHostsString = (String)restrictable.getAttributes().get("guac-restrict-hosts-denied"), remoteAddress);
        if (!hostRestrictionResult.isAllowed()) {
            throw new TranslatableGuacamoleSecurityException("Use of this connection is not allowed from this remote host: \"" + remoteAddress + "\".", "RESTRICT.ERROR_CONNECTION_NOT_ALLOWED_NOW");
        }
    }

    public static void verifyTimeRestrictions(UserContext context, Set<String> effectiveUserGroups) throws GuacamoleException {
        User currentUser = context.self();
        if (currentUser.getEffectivePermissions().getSystemPermissions().hasPermission(SystemPermission.Type.ADMINISTER)) {
            LOGGER.warn("User \"{}\" has System Administration permissions; additional restrictions will be bypassed.", (Object)currentUser.getIdentifier());
            return;
        }
        Map userAttributes = currentUser.getAttributes();
        String allowedTimeString = (String)userAttributes.get("guac-restrict-time-allowed");
        String deniedTimeString = (String)userAttributes.get("guac-restrict-time-denied");
        RestrictionType timeRestrictionResult = RestrictionVerificationService.allowedByTimeRestrictions(allowedTimeString, deniedTimeString);
        switch (timeRestrictionResult) {
            case EXPLICIT_DENY: {
                throw new TranslatableInvalidTimeLoginException("User \"" + currentUser.getIdentifier() + "\" is not allowed to log in at this time.", "RESTRICT.ERROR_USER_LOGIN_NOT_ALLOWED_NOW");
            }
            case EXPLICIT_ALLOW: {
                return;
            }
        }
        Collection userGroups = context.getPrivileged().getUserGroupDirectory().getAll(effectiveUserGroups);
        for (UserGroup userGroup : userGroups) {
            String grpDeniedTimeString;
            Map grpAttributes = userGroup.getAttributes();
            String grpAllowedTimeString = (String)grpAttributes.get("guac-restrict-time-allowed");
            RestrictionType grpRestrictionResult = RestrictionVerificationService.allowedByTimeRestrictions(grpAllowedTimeString, grpDeniedTimeString = (String)grpAttributes.get("guac-restrict-time-denied"));
            if (grpRestrictionResult == RestrictionType.EXPLICIT_DENY) {
                throw new TranslatableInvalidTimeLoginException("User \"" + currentUser.getIdentifier() + "\" is not allowed to log in at this time due to restrictions on group \"" + userGroup + "\".", "RESTRICT.ERROR_USER_LOGIN_NOT_ALLOWED_NOW");
            }
            timeRestrictionResult = RestrictionType.getHigherPriority(timeRestrictionResult, grpRestrictionResult);
        }
        switch (timeRestrictionResult) {
            case EXPLICIT_ALLOW: {
                return;
            }
            case IMPLICIT_ALLOW: {
                return;
            }
        }
        throw new TranslatableInvalidTimeLoginException("User \"" + currentUser.getIdentifier() + "\" is implicitly denied at this time.", "RESTRICT.ERROR_USER_LOGIN_NOT_ALLOWED_NOW");
    }

    public static void verifyTimeRestrictions(Restrictable restrictable) throws GuacamoleException {
        String deniedTimeString;
        String allowedTimeString = (String)restrictable.getAttributes().get("guac-restrict-time-allowed");
        RestrictionType timeRestriction = RestrictionVerificationService.allowedByTimeRestrictions(allowedTimeString, deniedTimeString = (String)restrictable.getAttributes().get("guac-restrict-time-denied"));
        if (!timeRestriction.isAllowed()) {
            throw new TranslatableGuacamoleSecurityException("Use of this connection or connection group is not allowed at this time.", "RESTRICT.ERROR_CONNECTION_NOT_ALLOWED_NOW");
        }
    }

    public static void verifyLoginRestrictions(UserContext context, Set<String> effectiveUserGroups, String remoteAddress) throws GuacamoleException {
        RestrictionVerificationService.verifyTimeRestrictions(context, effectiveUserGroups);
        RestrictionVerificationService.verifyHostRestrictions(context, effectiveUserGroups, remoteAddress);
    }

    public static void verifyConnectionRestrictions(Restrictable restrictable, String remoteAddress) throws GuacamoleException {
        RestrictionVerificationService.verifyTimeRestrictions(restrictable);
        RestrictionVerificationService.verifyHostRestrictions(restrictable, remoteAddress);
    }
}

