/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.blockmanagement.SlowPeerLatencyWithReportingNode;
import org.apache.hadoop.hdfs.server.blockmanagement.SlowPeerTracker;
import org.apache.hadoop.hdfs.server.protocol.OutlierMetrics;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableList;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableSet;
import org.apache.hadoop.util.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class SlowPeerDisabledTracker
extends SlowPeerTracker {
    private static final Logger LOG = LoggerFactory.getLogger(SlowPeerDisabledTracker.class);

    public SlowPeerDisabledTracker(Configuration conf, Timer timer) {
        super(conf, timer);
    }

    @Override
    public boolean isSlowPeerTrackerEnabled() {
        return false;
    }

    @Override
    public void addReport(String slowNode, String reportingNode, OutlierMetrics slowNodeMetrics) {
        LOG.trace("Adding slow peer report is disabled. To enable it, please enable config {}.", (Object)"dfs.datanode.peer.stats.enabled");
    }

    @Override
    public Set<SlowPeerLatencyWithReportingNode> getReportsForNode(String slowNode) {
        LOG.trace("Retrieval of slow peer report is disabled. To enable it, please enable config {}.", (Object)"dfs.datanode.peer.stats.enabled");
        return ImmutableSet.of();
    }

    @Override
    public Map<String, SortedSet<SlowPeerLatencyWithReportingNode>> getReportsForAllDataNodes() {
        LOG.trace("Retrieval of slow peer report for all nodes is disabled. To enable it, please enable config {}.", (Object)"dfs.datanode.peer.stats.enabled");
        return ImmutableMap.of();
    }

    @Override
    public String getJson() {
        LOG.trace("Retrieval of slow peer reports as json string is disabled. To enable it, please enable config {}.", (Object)"dfs.datanode.peer.stats.enabled");
        return null;
    }

    @Override
    public List<String> getSlowNodes(int numNodes) {
        return ImmutableList.of();
    }
}

