/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.nfs.nfs3;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSInputStream;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.nfs.conf.NfsConfiguration;
import org.apache.hadoop.io.MultipleIOException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.ShutdownHookManager;

class DFSClientCache {
    private static final Log LOG = LogFactory.getLog(DFSClientCache.class);
    @VisibleForTesting
    final LoadingCache<String, DFSClient> clientCache;
    static final int DEFAULT_DFS_CLIENT_CACHE_SIZE = 256;
    final LoadingCache<DFSInputStreamCaheKey, FSDataInputStream> inputstreamCache;
    static final int DEFAULT_DFS_INPUTSTREAM_CACHE_SIZE = 1024;
    static final int DEFAULT_DFS_INPUTSTREAM_CACHE_TTL = 600;
    private final NfsConfiguration config;
    public static final int SHUTDOWN_HOOK_PRIORITY = 10;

    DFSClientCache(NfsConfiguration config) {
        this(config, 256);
    }

    DFSClientCache(NfsConfiguration config, int clientCache) {
        this.config = config;
        this.clientCache = CacheBuilder.newBuilder().maximumSize((long)clientCache).removalListener(this.clientRemovalListener()).build(this.clientLoader());
        this.inputstreamCache = CacheBuilder.newBuilder().maximumSize(1024L).expireAfterAccess(600L, TimeUnit.SECONDS).removalListener(this.inputStreamRemovalListener()).build(this.inputStreamLoader());
        ShutdownHookManager.get().addShutdownHook((Runnable)new CacheFinalizer(), 10);
    }

    synchronized void closeAll(boolean onlyAutomatic) throws IOException {
        ArrayList<IOException> exceptions = new ArrayList<IOException>();
        ConcurrentMap map = this.clientCache.asMap();
        for (Map.Entry item : map.entrySet()) {
            DFSClient client = (DFSClient)item.getValue();
            if (client == null) continue;
            try {
                client.close();
            }
            catch (IOException ioe) {
                exceptions.add(ioe);
            }
        }
        if (!exceptions.isEmpty()) {
            throw MultipleIOException.createIOException(exceptions);
        }
    }

    private CacheLoader<String, DFSClient> clientLoader() {
        return new CacheLoader<String, DFSClient>(){

            public DFSClient load(String userName) throws Exception {
                UserGroupInformation ugi = DFSClientCache.this.getUserGroupInformation(userName, UserGroupInformation.getCurrentUser());
                return (DFSClient)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<DFSClient>(){

                    @Override
                    public DFSClient run() throws IOException {
                        return new DFSClient(DFSUtilClient.getNNAddress((Configuration)DFSClientCache.this.config), (Configuration)DFSClientCache.this.config);
                    }
                });
            }
        };
    }

    UserGroupInformation getUserGroupInformation(String effectiveUser, UserGroupInformation realUser) throws IOException {
        Preconditions.checkNotNull((Object)effectiveUser);
        Preconditions.checkNotNull((Object)realUser);
        realUser.checkTGTAndReloginFromKeytab();
        UserGroupInformation ugi = UserGroupInformation.createProxyUser((String)effectiveUser, (UserGroupInformation)realUser);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("Created ugi: %s for username: %s", ugi, effectiveUser));
        }
        return ugi;
    }

    private RemovalListener<String, DFSClient> clientRemovalListener() {
        return new RemovalListener<String, DFSClient>(){

            public void onRemoval(RemovalNotification<String, DFSClient> notification) {
                DFSClient client = (DFSClient)notification.getValue();
                try {
                    client.close();
                }
                catch (IOException e) {
                    LOG.warn((Object)String.format("IOException when closing the DFSClient(%s), cause: %s", client, e));
                }
            }
        };
    }

    private RemovalListener<DFSInputStreamCaheKey, FSDataInputStream> inputStreamRemovalListener() {
        return new RemovalListener<DFSInputStreamCaheKey, FSDataInputStream>(){

            public void onRemoval(RemovalNotification<DFSInputStreamCaheKey, FSDataInputStream> notification) {
                try {
                    ((FSDataInputStream)notification.getValue()).close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
    }

    private CacheLoader<DFSInputStreamCaheKey, FSDataInputStream> inputStreamLoader() {
        return new CacheLoader<DFSInputStreamCaheKey, FSDataInputStream>(){

            public FSDataInputStream load(DFSInputStreamCaheKey key) throws Exception {
                DFSClient client = DFSClientCache.this.getDfsClient(key.userId);
                DFSInputStream dis = client.open(key.inodePath);
                return client.createWrappedInputStream(dis);
            }
        };
    }

    DFSClient getDfsClient(String userName) {
        DFSClient client = null;
        try {
            client = (DFSClient)this.clientCache.get((Object)userName);
        }
        catch (ExecutionException e) {
            LOG.error((Object)("Failed to create DFSClient for user:" + userName + " Cause:" + e));
        }
        return client;
    }

    FSDataInputStream getDfsInputStream(String userName, String inodePath) {
        DFSInputStreamCaheKey k = new DFSInputStreamCaheKey(userName, inodePath);
        FSDataInputStream s = null;
        try {
            s = (FSDataInputStream)this.inputstreamCache.get((Object)k);
        }
        catch (ExecutionException e) {
            LOG.warn((Object)("Failed to create DFSInputStream for user:" + userName + " Cause:" + e));
        }
        return s;
    }

    public void invalidateDfsInputStream(String userName, String inodePath) {
        DFSInputStreamCaheKey k = new DFSInputStreamCaheKey(userName, inodePath);
        this.inputstreamCache.invalidate((Object)k);
    }

    private class CacheFinalizer
    implements Runnable {
        private CacheFinalizer() {
        }

        @Override
        public synchronized void run() {
            try {
                DFSClientCache.this.closeAll(true);
            }
            catch (IOException e) {
                LOG.info((Object)"DFSClientCache.closeAll() threw an exception:\n", (Throwable)e);
            }
        }
    }

    private static class DFSInputStreamCaheKey {
        final String userId;
        final String inodePath;

        private DFSInputStreamCaheKey(String userId, String inodePath) {
            this.userId = userId;
            this.inodePath = inodePath;
        }

        public boolean equals(Object obj) {
            if (obj instanceof DFSInputStreamCaheKey) {
                DFSInputStreamCaheKey k = (DFSInputStreamCaheKey)obj;
                return this.userId.equals(k.userId) && this.inodePath.equals(k.inodePath);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.userId, this.inodePath});
        }
    }
}

