/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.analyticsaccelerator;

import lombok.Generated;
import software.amazon.s3.analyticsaccelerator.common.telemetry.Attribute;
import software.amazon.s3.analyticsaccelerator.request.Range;
import software.amazon.s3.analyticsaccelerator.util.S3URI;

enum ObjectClientTelemetry {
    URI("uri"),
    RANGE("range"),
    RANGE_LENGTH("range.length");

    private final String name;
    public static final String OPERATION_GET = "s3.client.get";
    public static final String OPERATION_HEAD = "s3.client.head";

    public static Attribute uri(S3URI s3URI) {
        return Attribute.of(URI.getName(), s3URI.toString());
    }

    public static Attribute range(Range range) {
        return Attribute.of(RANGE.getName(), range.toString());
    }

    public static Attribute rangeLength(Range range) {
        return Attribute.of(RANGE_LENGTH.getName(), Long.toString(range.getLength()));
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    private ObjectClientTelemetry(String name) {
        this.name = name;
    }
}

