/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store;

import org.ojalgo.ProgrammingError;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.ShadingStore;
import org.ojalgo.scalar.Scalar;

final class LowerHermitianStore<N extends Number>
extends ShadingStore<N> {
    private LowerHermitianStore(int aRowDim, int aColDim, MatrixStore<N> base) {
        this(base);
        ProgrammingError.throwForIllegalInvocation();
    }

    LowerHermitianStore(MatrixStore<N> base) {
        super(base, (int)base.countRows(), (int)Math.min(base.countRows(), base.countColumns()));
    }

    @Override
    public double doubleValue(long row, long col) {
        if (row < col) {
            return this.getBase().doubleValue(col, row);
        }
        return this.getBase().doubleValue(row, col);
    }

    @Override
    public N get(long row, long col) {
        return this.toScalar(row, col).getNumber();
    }

    @Override
    public Scalar<N> toScalar(long row, long col) {
        if (row < col) {
            return (Scalar)this.getBase().toScalar(col, row).conjugate();
        }
        return this.getBase().toScalar(row, col);
    }
}

