#
# Autogenerated by Thrift Compiler (0.12.0)
#
# DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
#
#  options string: py
#

from thrift.Thrift import TType, TMessageType, TFrozenDict, TException, TApplicationException
from thrift.protocol.TProtocol import TProtocolException
from thrift.TRecursive import fix_spec

import sys
import logging
from .ttypes import *
from thrift.Thrift import TProcessor
from thrift.transport import TTransport
all_structs = []


class Iface(object):
    def enableTable(self, tableName):
        """
        Brings a table on-line (enables it)

        Parameters:
         - tableName: name of the table

        """
        pass

    def disableTable(self, tableName):
        """
        Disables a table (takes it off-line) If it is being served, the master
        will tell the servers to stop serving it.

        Parameters:
         - tableName: name of the table

        """
        pass

    def isTableEnabled(self, tableName):
        """
        @return true if table is on-line

        Parameters:
         - tableName: name of the table to check

        """
        pass

    def compact(self, tableNameOrRegionName):
        """
        Parameters:
         - tableNameOrRegionName

        """
        pass

    def majorCompact(self, tableNameOrRegionName):
        """
        Parameters:
         - tableNameOrRegionName

        """
        pass

    def getTableNames(self):
        """
        List all the userspace tables.

        @return returns a list of names

        """
        pass

    def getColumnDescriptors(self, tableName):
        """
        List all the column families assoicated with a table.

        @return list of column family descriptors

        Parameters:
         - tableName: table name

        """
        pass

    def getTableRegions(self, tableName):
        """
        List the regions associated with a table.

        @return list of region descriptors

        Parameters:
         - tableName: table name

        """
        pass

    def createTable(self, tableName, columnFamilies):
        """
        Create a table with the specified column families.  The name
        field for each ColumnDescriptor must be set and must end in a
        colon (:). All other fields are optional and will get default
        values if not explicitly specified.

        @throws IllegalArgument if an input parameter is invalid

        @throws AlreadyExists if the table name already exists

        Parameters:
         - tableName: name of table to create
         - columnFamilies: list of column family descriptors

        """
        pass

    def deleteTable(self, tableName):
        """
        Deletes a table

        @throws IOError if table doesn't exist on erer or there was some other
        problem

        Parameters:
         - tableName: name of table to delete

        """
        pass

    def get(self, tableName, row, column, attributes):
        """
        Get a single TCell for the specified table, row, and column at the
        latest timestamp. Returns an empty list if no such value exists.

        @return value for specified row/column

        Parameters:
         - tableName: name of table
         - row: row key
         - column: column name
         - attributes: Get attributes

        """
        pass

    def getVer(self, tableName, row, column, numVersions, attributes):
        """
        Get the specified number of versions for the specified table,
        row, and column.

        @return list of cells for specified row/column

        Parameters:
         - tableName: name of table
         - row: row key
         - column: column name
         - numVersions: number of versions to retrieve
         - attributes: Get attributes

        """
        pass

    def getVerTs(self, tableName, row, column, timestamp, numVersions, attributes):
        """
        Get the specified number of versions for the specified table,
        row, and column.  Only versions less than or equal to the specified
        timestamp will be returned.

        @return list of cells for specified row/column

        Parameters:
         - tableName: name of table
         - row: row key
         - column: column name
         - timestamp: timestamp
         - numVersions: number of versions to retrieve
         - attributes: Get attributes

        """
        pass

    def getRow(self, tableName, row, attributes):
        """
        Get all the data for the specified table and row at the latest
        timestamp. Returns an empty list if the row does not exist.

        @return TRowResult containing the row and map of columns to TCells

        Parameters:
         - tableName: name of table
         - row: row key
         - attributes: Get attributes

        """
        pass

    def getRowWithColumns(self, tableName, row, columns, attributes):
        """
        Get the specified columns for the specified table and row at the latest
        timestamp. Returns an empty list if the row does not exist.

        @return TRowResult containing the row and map of columns to TCells

        Parameters:
         - tableName: name of table
         - row: row key
         - columns: List of columns to return, null for all columns
         - attributes: Get attributes

        """
        pass

    def getRowTs(self, tableName, row, timestamp, attributes):
        """
        Get all the data for the specified table and row at the specified
        timestamp. Returns an empty list if the row does not exist.

        @return TRowResult containing the row and map of columns to TCells

        Parameters:
         - tableName: name of the table
         - row: row key
         - timestamp: timestamp
         - attributes: Get attributes

        """
        pass

    def getRowWithColumnsTs(self, tableName, row, columns, timestamp, attributes):
        """
        Get the specified columns for the specified table and row at the specified
        timestamp. Returns an empty list if the row does not exist.

        @return TRowResult containing the row and map of columns to TCells

        Parameters:
         - tableName: name of table
         - row: row key
         - columns: List of columns to return, null for all columns
         - timestamp
         - attributes: Get attributes

        """
        pass

    def getRows(self, tableName, rows, attributes):
        """
        Get all the data for the specified table and rows at the latest
        timestamp. Returns an empty list if no rows exist.

        @return TRowResult containing the rows and map of columns to TCells

        Parameters:
         - tableName: name of table
         - rows: row keys
         - attributes: Get attributes

        """
        pass

    def getRowsWithColumns(self, tableName, rows, columns, attributes):
        """
        Get the specified columns for the specified table and rows at the latest
        timestamp. Returns an empty list if no rows exist.

        @return TRowResult containing the rows and map of columns to TCells

        Parameters:
         - tableName: name of table
         - rows: row keys
         - columns: List of columns to return, null for all columns
         - attributes: Get attributes

        """
        pass

    def getRowsTs(self, tableName, rows, timestamp, attributes):
        """
        Get all the data for the specified table and rows at the specified
        timestamp. Returns an empty list if no rows exist.

        @return TRowResult containing the rows and map of columns to TCells

        Parameters:
         - tableName: name of the table
         - rows: row keys
         - timestamp: timestamp
         - attributes: Get attributes

        """
        pass

    def getRowsWithColumnsTs(self, tableName, rows, columns, timestamp, attributes):
        """
        Get the specified columns for the specified table and rows at the specified
        timestamp. Returns an empty list if no rows exist.

        @return TRowResult containing the rows and map of columns to TCells

        Parameters:
         - tableName: name of table
         - rows: row keys
         - columns: List of columns to return, null for all columns
         - timestamp
         - attributes: Get attributes

        """
        pass

    def mutateRow(self, tableName, row, mutations, attributes):
        """
        Apply a series of mutations (updates/deletes) to a row in a
        single transaction.  If an exception is thrown, then the
        transaction is aborted.  Default current timestamp is used, and
        all entries will have an identical timestamp.

        Parameters:
         - tableName: name of table
         - row: row key
         - mutations: list of mutation commands
         - attributes: Mutation attributes

        """
        pass

    def mutateRowTs(self, tableName, row, mutations, timestamp, attributes):
        """
        Apply a series of mutations (updates/deletes) to a row in a
        single transaction.  If an exception is thrown, then the
        transaction is aborted.  The specified timestamp is used, and
        all entries will have an identical timestamp.

        Parameters:
         - tableName: name of table
         - row: row key
         - mutations: list of mutation commands
         - timestamp: timestamp
         - attributes: Mutation attributes

        """
        pass

    def mutateRows(self, tableName, rowBatches, attributes):
        """
        Apply a series of batches (each a series of mutations on a single row)
        in a single transaction.  If an exception is thrown, then the
        transaction is aborted.  Default current timestamp is used, and
        all entries will have an identical timestamp.

        Parameters:
         - tableName: name of table
         - rowBatches: list of row batches
         - attributes: Mutation attributes

        """
        pass

    def mutateRowsTs(self, tableName, rowBatches, timestamp, attributes):
        """
        Apply a series of batches (each a series of mutations on a single row)
        in a single transaction.  If an exception is thrown, then the
        transaction is aborted.  The specified timestamp is used, and
        all entries will have an identical timestamp.

        Parameters:
         - tableName: name of table
         - rowBatches: list of row batches
         - timestamp: timestamp
         - attributes: Mutation attributes

        """
        pass

    def atomicIncrement(self, tableName, row, column, value):
        """
        Atomically increment the column value specified.  Returns the next value post increment.

        Parameters:
         - tableName: name of table
         - row: row to increment
         - column: name of column
         - value: amount to increment by

        """
        pass

    def deleteAll(self, tableName, row, column, attributes):
        """
        Delete all cells that match the passed row and column.

        Parameters:
         - tableName: name of table
         - row: Row to update
         - column: name of column whose value is to be deleted
         - attributes: Delete attributes

        """
        pass

    def deleteAllTs(self, tableName, row, column, timestamp, attributes):
        """
        Delete all cells that match the passed row and column and whose
        timestamp is equal-to or older than the passed timestamp.

        Parameters:
         - tableName: name of table
         - row: Row to update
         - column: name of column whose value is to be deleted
         - timestamp: timestamp
         - attributes: Delete attributes

        """
        pass

    def deleteAllRow(self, tableName, row, attributes):
        """
        Completely delete the row's cells.

        Parameters:
         - tableName: name of table
         - row: key of the row to be completely deleted.
         - attributes: Delete attributes

        """
        pass

    def increment(self, increment):
        """
        Increment a cell by the ammount.
        Increments can be applied async if hbase.regionserver.thrift.coalesceIncrement is set to true.
        False is the default.  Turn to true if you need the extra performance and can accept some
        data loss if a thrift server dies with increments still in the queue.

        Parameters:
         - increment: The single increment to apply

        """
        pass

    def incrementRows(self, increments):
        """
        Parameters:
         - increments: The list of increments

        """
        pass

    def deleteAllRowTs(self, tableName, row, timestamp, attributes):
        """
        Completely delete the row's cells marked with a timestamp
        equal-to or older than the passed timestamp.

        Parameters:
         - tableName: name of table
         - row: key of the row to be completely deleted.
         - timestamp: timestamp
         - attributes: Delete attributes

        """
        pass

    def scannerOpenWithScan(self, tableName, scan, attributes):
        """
        Get a scanner on the current table, using the Scan instance
        for the scan parameters.

        Parameters:
         - tableName: name of table
         - scan: Scan instance
         - attributes: Scan attributes

        """
        pass

    def scannerOpen(self, tableName, startRow, columns, attributes):
        """
        Get a scanner on the current table starting at the specified row and
        ending at the last row in the table.  Return the specified columns.

        @return scanner id to be used with other scanner procedures

        Parameters:
         - tableName: name of table
         - startRow: Starting row in table to scan.
        Send "" (empty string) to start at the first row.
         - columns: columns to scan. If column name is a column family, all
        columns of the specified column family are returned. It's also possible
        to pass a regex in the column qualifier.
         - attributes: Scan attributes

        """
        pass

    def scannerOpenWithStop(self, tableName, startRow, stopRow, columns, attributes):
        """
        Get a scanner on the current table starting and stopping at the
        specified rows.  ending at the last row in the table.  Return the
        specified columns.

        @return scanner id to be used with other scanner procedures

        Parameters:
         - tableName: name of table
         - startRow: Starting row in table to scan.
        Send "" (empty string) to start at the first row.
         - stopRow: row to stop scanning on. This row is *not* included in the
        scanner's results
         - columns: columns to scan. If column name is a column family, all
        columns of the specified column family are returned. It's also possible
        to pass a regex in the column qualifier.
         - attributes: Scan attributes

        """
        pass

    def scannerOpenWithPrefix(self, tableName, startAndPrefix, columns, attributes):
        """
        Open a scanner for a given prefix.  That is all rows will have the specified
        prefix. No other rows will be returned.

        @return scanner id to use with other scanner calls

        Parameters:
         - tableName: name of table
         - startAndPrefix: the prefix (and thus start row) of the keys you want
         - columns: the columns you want returned
         - attributes: Scan attributes

        """
        pass

    def scannerOpenTs(self, tableName, startRow, columns, timestamp, attributes):
        """
        Get a scanner on the current table starting at the specified row and
        ending at the last row in the table.  Return the specified columns.
        Only values with the specified timestamp are returned.

        @return scanner id to be used with other scanner procedures

        Parameters:
         - tableName: name of table
         - startRow: Starting row in table to scan.
        Send "" (empty string) to start at the first row.
         - columns: columns to scan. If column name is a column family, all
        columns of the specified column family are returned. It's also possible
        to pass a regex in the column qualifier.
         - timestamp: timestamp
         - attributes: Scan attributes

        """
        pass

    def scannerOpenWithStopTs(self, tableName, startRow, stopRow, columns, timestamp, attributes):
        """
        Get a scanner on the current table starting and stopping at the
        specified rows.  ending at the last row in the table.  Return the
        specified columns.  Only values with the specified timestamp are
        returned.

        @return scanner id to be used with other scanner procedures

        Parameters:
         - tableName: name of table
         - startRow: Starting row in table to scan.
        Send "" (empty string) to start at the first row.
         - stopRow: row to stop scanning on. This row is *not* included in the
        scanner's results
         - columns: columns to scan. If column name is a column family, all
        columns of the specified column family are returned. It's also possible
        to pass a regex in the column qualifier.
         - timestamp: timestamp
         - attributes: Scan attributes

        """
        pass

    def scannerGet(self, id):
        """
        Returns the scanner's current row value and advances to the next
        row in the table.  When there are no more rows in the table, or a key
        greater-than-or-equal-to the scanner's specified stopRow is reached,
        an empty list is returned.

        @return a TRowResult containing the current row and a map of the columns to TCells.

        @throws IllegalArgument if ScannerID is invalid

        @throws NotFound when the scanner reaches the end

        Parameters:
         - id: id of a scanner returned by scannerOpen

        """
        pass

    def scannerGetList(self, id, nbRows):
        """
        Returns, starting at the scanner's current row value nbRows worth of
        rows and advances to the next row in the table.  When there are no more
        rows in the table, or a key greater-than-or-equal-to the scanner's
        specified stopRow is reached,  an empty list is returned.

        @return a TRowResult containing the current row and a map of the columns to TCells.

        @throws IllegalArgument if ScannerID is invalid

        @throws NotFound when the scanner reaches the end

        Parameters:
         - id: id of a scanner returned by scannerOpen
         - nbRows: number of results to return

        """
        pass

    def scannerClose(self, id):
        """
        Closes the server-state associated with an open scanner.

        @throws IllegalArgument if ScannerID is invalid

        Parameters:
         - id: id of a scanner returned by scannerOpen

        """
        pass

    def getRegionInfo(self, row):
        """
        Get the regininfo for the specified row. It scans
        the metatable to find region's start and end keys.

        @return value for specified row/column

        Parameters:
         - row: row key

        """
        pass

    def append(self, append):
        """
        Appends values to one or more columns within a single row.

        @return values of columns after the append operation.

        Parameters:
         - append: The single append operation to apply

        """
        pass

    def checkAndPut(self, tableName, row, column, value, mput, attributes):
        """
        Atomically checks if a row/family/qualifier value matches the expected
        value. If it does, it adds the corresponding mutation operation for put.

        @return true if the new put was executed, false otherwise

        Parameters:
         - tableName: name of table
         - row: row key
         - column: column name
         - value: the expected value for the column parameter, if not
        provided the check is for the non-existence of the
        column in question
         - mput: mutation for the put
         - attributes: Mutation attributes

        """
        pass

    def getThriftServerType(self):
        """
        Get the type of this thrift server.

        @return the type of this thrift server

        """
        pass


class Client(Iface):
    def __init__(self, iprot, oprot=None):
        self._iprot = self._oprot = iprot
        if oprot is not None:
            self._oprot = oprot
        self._seqid = 0

    def enableTable(self, tableName):
        """
        Brings a table on-line (enables it)

        Parameters:
         - tableName: name of the table

        """
        self.send_enableTable(tableName)
        self.recv_enableTable()

    def send_enableTable(self, tableName):
        self._oprot.writeMessageBegin('enableTable', TMessageType.CALL, self._seqid)
        args = enableTable_args()
        args.tableName = tableName
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_enableTable(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = enableTable_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.io is not None:
            raise result.io
        return

    def disableTable(self, tableName):
        """
        Disables a table (takes it off-line) If it is being served, the master
        will tell the servers to stop serving it.

        Parameters:
         - tableName: name of the table

        """
        self.send_disableTable(tableName)
        self.recv_disableTable()

    def send_disableTable(self, tableName):
        self._oprot.writeMessageBegin('disableTable', TMessageType.CALL, self._seqid)
        args = disableTable_args()
        args.tableName = tableName
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_disableTable(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = disableTable_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.io is not None:
            raise result.io
        return

    def isTableEnabled(self, tableName):
        """
        @return true if table is on-line

        Parameters:
         - tableName: name of the table to check

        """
        self.send_isTableEnabled(tableName)
        return self.recv_isTableEnabled()

    def send_isTableEnabled(self, tableName):
        self._oprot.writeMessageBegin('isTableEnabled', TMessageType.CALL, self._seqid)
        args = isTableEnabled_args()
        args.tableName = tableName
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_isTableEnabled(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = isTableEnabled_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.success is not None:
            return result.success
        if result.io is not None:
            raise result.io
        raise TApplicationException(TApplicationException.MISSING_RESULT, "isTableEnabled failed: unknown result")

    def compact(self, tableNameOrRegionName):
        """
        Parameters:
         - tableNameOrRegionName

        """
        self.send_compact(tableNameOrRegionName)
        self.recv_compact()

    def send_compact(self, tableNameOrRegionName):
        self._oprot.writeMessageBegin('compact', TMessageType.CALL, self._seqid)
        args = compact_args()
        args.tableNameOrRegionName = tableNameOrRegionName
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_compact(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = compact_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.io is not None:
            raise result.io
        return

    def majorCompact(self, tableNameOrRegionName):
        """
        Parameters:
         - tableNameOrRegionName

        """
        self.send_majorCompact(tableNameOrRegionName)
        self.recv_majorCompact()

    def send_majorCompact(self, tableNameOrRegionName):
        self._oprot.writeMessageBegin('majorCompact', TMessageType.CALL, self._seqid)
        args = majorCompact_args()
        args.tableNameOrRegionName = tableNameOrRegionName
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_majorCompact(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = majorCompact_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.io is not None:
            raise result.io
        return

    def getTableNames(self):
        """
        List all the userspace tables.

        @return returns a list of names

        """
        self.send_getTableNames()
        return self.recv_getTableNames()

    def send_getTableNames(self):
        self._oprot.writeMessageBegin('getTableNames', TMessageType.CALL, self._seqid)
        args = getTableNames_args()
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_getTableNames(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = getTableNames_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.success is not None:
            return result.success
        if result.io is not None:
            raise result.io
        raise TApplicationException(TApplicationException.MISSING_RESULT, "getTableNames failed: unknown result")

    def getColumnDescriptors(self, tableName):
        """
        List all the column families assoicated with a table.

        @return list of column family descriptors

        Parameters:
         - tableName: table name

        """
        self.send_getColumnDescriptors(tableName)
        return self.recv_getColumnDescriptors()

    def send_getColumnDescriptors(self, tableName):
        self._oprot.writeMessageBegin('getColumnDescriptors', TMessageType.CALL, self._seqid)
        args = getColumnDescriptors_args()
        args.tableName = tableName
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_getColumnDescriptors(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = getColumnDescriptors_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.success is not None:
            return result.success
        if result.io is not None:
            raise result.io
        raise TApplicationException(TApplicationException.MISSING_RESULT, "getColumnDescriptors failed: unknown result")

    def getTableRegions(self, tableName):
        """
        List the regions associated with a table.

        @return list of region descriptors

        Parameters:
         - tableName: table name

        """
        self.send_getTableRegions(tableName)
        return self.recv_getTableRegions()

    def send_getTableRegions(self, tableName):
        self._oprot.writeMessageBegin('getTableRegions', TMessageType.CALL, self._seqid)
        args = getTableRegions_args()
        args.tableName = tableName
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_getTableRegions(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = getTableRegions_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.success is not None:
            return result.success
        if result.io is not None:
            raise result.io
        raise TApplicationException(TApplicationException.MISSING_RESULT, "getTableRegions failed: unknown result")

    def createTable(self, tableName, columnFamilies):
        """
        Create a table with the specified column families.  The name
        field for each ColumnDescriptor must be set and must end in a
        colon (:). All other fields are optional and will get default
        values if not explicitly specified.

        @throws IllegalArgument if an input parameter is invalid

        @throws AlreadyExists if the table name already exists

        Parameters:
         - tableName: name of table to create
         - columnFamilies: list of column family descriptors

        """
        self.send_createTable(tableName, columnFamilies)
        self.recv_createTable()

    def send_createTable(self, tableName, columnFamilies):
        self._oprot.writeMessageBegin('createTable', TMessageType.CALL, self._seqid)
        args = createTable_args()
        args.tableName = tableName
        args.columnFamilies = columnFamilies
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_createTable(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = createTable_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.io is not None:
            raise result.io
        if result.ia is not None:
            raise result.ia
        if result.exist is not None:
            raise result.exist
        return

    def deleteTable(self, tableName):
        """
        Deletes a table

        @throws IOError if table doesn't exist on server or there was some other
        problem

        Parameters:
         - tableName: name of table to delete

        """
        self.send_deleteTable(tableName)
        self.recv_deleteTable()

    def send_deleteTable(self, tableName):
        self._oprot.writeMessageBegin('deleteTable', TMessageType.CALL, self._seqid)
        args = deleteTable_args()
        args.tableName = tableName
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_deleteTable(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = deleteTable_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.io is not None:
            raise result.io
        return

    def get(self, tableName, row, column, attributes):
        """
        Get a single TCell for the specified table, row, and column at the
        latest timestamp. Returns an empty list if no such value exists.

        @return value for specified row/column

        Parameters:
         - tableName: name of table
         - row: row key
         - column: column name
         - attributes: Get attributes

        """
        self.send_get(tableName, row, column, attributes)
        return self.recv_get()

    def send_get(self, tableName, row, column, attributes):
        self._oprot.writeMessageBegin('get', TMessageType.CALL, self._seqid)
        args = get_args()
        args.tableName = tableName
        args.row = row
        args.column = column
        args.attributes = attributes
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_get(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = get_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.success is not None:
            return result.success
        if result.io is not None:
            raise result.io
        raise TApplicationException(TApplicationException.MISSING_RESULT, "get failed: unknown result")

    def getVer(self, tableName, row, column, numVersions, attributes):
        """
        Get the specified number of versions for the specified table,
        row, and column.

        @return list of cells for specified row/column

        Parameters:
         - tableName: name of table
         - row: row key
         - column: column name
         - numVersions: number of versions to retrieve
         - attributes: Get attributes

        """
        self.send_getVer(tableName, row, column, numVersions, attributes)
        return self.recv_getVer()

    def send_getVer(self, tableName, row, column, numVersions, attributes):
        self._oprot.writeMessageBegin('getVer', TMessageType.CALL, self._seqid)
        args = getVer_args()
        args.tableName = tableName
        args.row = row
        args.column = column
        args.numVersions = numVersions
        args.attributes = attributes
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_getVer(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = getVer_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.success is not None:
            return result.success
        if result.io is not None:
            raise result.io
        raise TApplicationException(TApplicationException.MISSING_RESULT, "getVer failed: unknown result")

    def getVerTs(self, tableName, row, column, timestamp, numVersions, attributes):
        """
        Get the specified number of versions for the specified table,
        row, and column.  Only versions less than or equal to the specified
        timestamp will be returned.

        @return list of cells for specified row/column

        Parameters:
         - tableName: name of table
         - row: row key
         - column: column name
         - timestamp: timestamp
         - numVersions: number of versions to retrieve
         - attributes: Get attributes

        """
        self.send_getVerTs(tableName, row, column, timestamp, numVersions, attributes)
        return self.recv_getVerTs()

    def send_getVerTs(self, tableName, row, column, timestamp, numVersions, attributes):
        self._oprot.writeMessageBegin('getVerTs', TMessageType.CALL, self._seqid)
        args = getVerTs_args()
        args.tableName = tableName
        args.row = row
        args.column = column
        args.timestamp = timestamp
        args.numVersions = numVersions
        args.attributes = attributes
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_getVerTs(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = getVerTs_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.success is not None:
            return result.success
        if result.io is not None:
            raise result.io
        raise TApplicationException(TApplicationException.MISSING_RESULT, "getVerTs failed: unknown result")

    def getRow(self, tableName, row, attributes):
        """
        Get all the data for the specified table and row at the latest
        timestamp. Returns an empty list if the row does not exist.

        @return TRowResult containing the row and map of columns to TCells

        Parameters:
         - tableName: name of table
         - row: row key
         - attributes: Get attributes

        """
        self.send_getRow(tableName, row, attributes)
        return self.recv_getRow()

    def send_getRow(self, tableName, row, attributes):
        self._oprot.writeMessageBegin('getRow', TMessageType.CALL, self._seqid)
        args = getRow_args()
        args.tableName = tableName
        args.row = row
        args.attributes = attributes
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_getRow(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = getRow_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.success is not None:
            return result.success
        if result.io is not None:
            raise result.io
        raise TApplicationException(TApplicationException.MISSING_RESULT, "getRow failed: unknown result")

    def getRowWithColumns(self, tableName, row, columns, attributes):
        """
        Get the specified columns for the specified table and row at the latest
        timestamp. Returns an empty list if the row does not exist.

        @return TRowResult containing the row and map of columns to TCells

        Parameters:
         - tableName: name of table
         - row: row key
         - columns: List of columns to return, null for all columns
         - attributes: Get attributes

        """
        self.send_getRowWithColumns(tableName, row, columns, attributes)
        return self.recv_getRowWithColumns()

    def send_getRowWithColumns(self, tableName, row, columns, attributes):
        self._oprot.writeMessageBegin('getRowWithColumns', TMessageType.CALL, self._seqid)
        args = getRowWithColumns_args()
        args.tableName = tableName
        args.row = row
        args.columns = columns
        args.attributes = attributes
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_getRowWithColumns(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = getRowWithColumns_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.success is not None:
            return result.success
        if result.io is not None:
            raise result.io
        raise TApplicationException(TApplicationException.MISSING_RESULT, "getRowWithColumns failed: unknown result")

    def getRowTs(self, tableName, row, timestamp, attributes):
        """
        Get all the data for the specified table and row at the specified
        timestamp. Returns an empty list if the row does not exist.

        @return TRowResult containing the row and map of columns to TCells

        Parameters:
         - tableName: name of the table
         - row: row key
         - timestamp: timestamp
         - attributes: Get attributes

        """
        self.send_getRowTs(tableName, row, timestamp, attributes)
        return self.recv_getRowTs()

    def send_getRowTs(self, tableName, row, timestamp, attributes):
        self._oprot.writeMessageBegin('getRowTs', TMessageType.CALL, self._seqid)
        args = getRowTs_args()
        args.tableName = tableName
        args.row = row
        args.timestamp = timestamp
        args.attributes = attributes
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_getRowTs(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = getRowTs_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.success is not None:
            return result.success
        if result.io is not None:
            raise result.io
        raise TApplicationException(TApplicationException.MISSING_RESULT, "getRowTs failed: unknown result")

    def getRowWithColumnsTs(self, tableName, row, columns, timestamp, attributes):
        """
        Get the specified columns for the specified table and row at the specified
        timestamp. Returns an empty list if the row does not exist.

        @return TRowResult containing the row and map of columns to TCells

        Parameters:
         - tableName: name of table
         - row: row key
         - columns: List of columns to return, null for all columns
         - timestamp
         - attributes: Get attributes

        """
        self.send_getRowWithColumnsTs(tableName, row, columns, timestamp, attributes)
        return self.recv_getRowWithColumnsTs()

    def send_getRowWithColumnsTs(self, tableName, row, columns, timestamp, attributes):
        self._oprot.writeMessageBegin('getRowWithColumnsTs', TMessageType.CALL, self._seqid)
        args = getRowWithColumnsTs_args()
        args.tableName = tableName
        args.row = row
        args.columns = columns
        args.timestamp = timestamp
        args.attributes = attributes
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_getRowWithColumnsTs(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = getRowWithColumnsTs_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.success is not None:
            return result.success
        if result.io is not None:
            raise result.io
        raise TApplicationException(TApplicationException.MISSING_RESULT, "getRowWithColumnsTs failed: unknown result")

    def getRows(self, tableName, rows, attributes):
        """
        Get all the data for the specified table and rows at the latest
        timestamp. Returns an empty list if no rows exist.

        @return TRowResult containing the rows and map of columns to TCells

        Parameters:
         - tableName: name of table
         - rows: row keys
         - attributes: Get attributes

        """
        self.send_getRows(tableName, rows, attributes)
        return self.recv_getRows()

    def send_getRows(self, tableName, rows, attributes):
        self._oprot.writeMessageBegin('getRows', TMessageType.CALL, self._seqid)
        args = getRows_args()
        args.tableName = tableName
        args.rows = rows
        args.attributes = attributes
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_getRows(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = getRows_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.success is not None:
            return result.success
        if result.io is not None:
            raise result.io
        raise TApplicationException(TApplicationException.MISSING_RESULT, "getRows failed: unknown result")

    def getRowsWithColumns(self, tableName, rows, columns, attributes):
        """
        Get the specified columns for the specified table and rows at the latest
        timestamp. Returns an empty list if no rows exist.

        @return TRowResult containing the rows and map of columns to TCells

        Parameters:
         - tableName: name of table
         - rows: row keys
         - columns: List of columns to return, null for all columns
         - attributes: Get attributes

        """
        self.send_getRowsWithColumns(tableName, rows, columns, attributes)
        return self.recv_getRowsWithColumns()

    def send_getRowsWithColumns(self, tableName, rows, columns, attributes):
        self._oprot.writeMessageBegin('getRowsWithColumns', TMessageType.CALL, self._seqid)
        args = getRowsWithColumns_args()
        args.tableName = tableName
        args.rows = rows
        args.columns = columns
        args.attributes = attributes
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_getRowsWithColumns(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = getRowsWithColumns_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.success is not None:
            return result.success
        if result.io is not None:
            raise result.io
        raise TApplicationException(TApplicationException.MISSING_RESULT, "getRowsWithColumns failed: unknown result")

    def getRowsTs(self, tableName, rows, timestamp, attributes):
        """
        Get all the data for the specified table and rows at the specified
        timestamp. Returns an empty list if no rows exist.

        @return TRowResult containing the rows and map of columns to TCells

        Parameters:
         - tableName: name of the table
         - rows: row keys
         - timestamp: timestamp
         - attributes: Get attributes

        """
        self.send_getRowsTs(tableName, rows, timestamp, attributes)
        return self.recv_getRowsTs()

    def send_getRowsTs(self, tableName, rows, timestamp, attributes):
        self._oprot.writeMessageBegin('getRowsTs', TMessageType.CALL, self._seqid)
        args = getRowsTs_args()
        args.tableName = tableName
        args.rows = rows
        args.timestamp = timestamp
        args.attributes = attributes
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_getRowsTs(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = getRowsTs_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.success is not None:
            return result.success
        if result.io is not None:
            raise result.io
        raise TApplicationException(TApplicationException.MISSING_RESULT, "getRowsTs failed: unknown result")

    def getRowsWithColumnsTs(self, tableName, rows, columns, timestamp, attributes):
        """
        Get the specified columns for the specified table and rows at the specified
        timestamp. Returns an empty list if no rows exist.

        @return TRowResult containing the rows and map of columns to TCells

        Parameters:
         - tableName: name of table
         - rows: row keys
         - columns: List of columns to return, null for all columns
         - timestamp
         - attributes: Get attributes

        """
        self.send_getRowsWithColumnsTs(tableName, rows, columns, timestamp, attributes)
        return self.recv_getRowsWithColumnsTs()

    def send_getRowsWithColumnsTs(self, tableName, rows, columns, timestamp, attributes):
        self._oprot.writeMessageBegin('getRowsWithColumnsTs', TMessageType.CALL, self._seqid)
        args = getRowsWithColumnsTs_args()
        args.tableName = tableName
        args.rows = rows
        args.columns = columns
        args.timestamp = timestamp
        args.attributes = attributes
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_getRowsWithColumnsTs(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = getRowsWithColumnsTs_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.success is not None:
            return result.success
        if result.io is not None:
            raise result.io
        raise TApplicationException(TApplicationException.MISSING_RESULT, "getRowsWithColumnsTs failed: unknown result")

    def mutateRow(self, tableName, row, mutations, attributes):
        """
        Apply a series of mutations (updates/deletes) to a row in a
        single transaction.  If an exception is thrown, then the
        transaction is aborted.  Default current timestamp is used, and
        all entries will have an identical timestamp.

        Parameters:
         - tableName: name of table
         - row: row key
         - mutations: list of mutation commands
         - attributes: Mutation attributes

        """
        self.send_mutateRow(tableName, row, mutations, attributes)
        self.recv_mutateRow()

    def send_mutateRow(self, tableName, row, mutations, attributes):
        self._oprot.writeMessageBegin('mutateRow', TMessageType.CALL, self._seqid)
        args = mutateRow_args()
        args.tableName = tableName
        args.row = row
        args.mutations = mutations
        args.attributes = attributes
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_mutateRow(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = mutateRow_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.io is not None:
            raise result.io
        if result.ia is not None:
            raise result.ia
        return

    def mutateRowTs(self, tableName, row, mutations, timestamp, attributes):
        """
        Apply a series of mutations (updates/deletes) to a row in a
        single transaction.  If an exception is thrown, then the
        transaction is aborted.  The specified timestamp is used, and
        all entries will have an identical timestamp.

        Parameters:
         - tableName: name of table
         - row: row key
         - mutations: list of mutation commands
         - timestamp: timestamp
         - attributes: Mutation attributes

        """
        self.send_mutateRowTs(tableName, row, mutations, timestamp, attributes)
        self.recv_mutateRowTs()

    def send_mutateRowTs(self, tableName, row, mutations, timestamp, attributes):
        self._oprot.writeMessageBegin('mutateRowTs', TMessageType.CALL, self._seqid)
        args = mutateRowTs_args()
        args.tableName = tableName
        args.row = row
        args.mutations = mutations
        args.timestamp = timestamp
        args.attributes = attributes
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_mutateRowTs(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = mutateRowTs_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.io is not None:
            raise result.io
        if result.ia is not None:
            raise result.ia
        return

    def mutateRows(self, tableName, rowBatches, attributes):
        """
        Apply a series of batches (each a series of mutations on a single row)
        in a single transaction.  If an exception is thrown, then the
        transaction is aborted.  Default current timestamp is used, and
        all entries will have an identical timestamp.

        Parameters:
         - tableName: name of table
         - rowBatches: list of row batches
         - attributes: Mutation attributes

        """
        self.send_mutateRows(tableName, rowBatches, attributes)
        self.recv_mutateRows()

    def send_mutateRows(self, tableName, rowBatches, attributes):
        self._oprot.writeMessageBegin('mutateRows', TMessageType.CALL, self._seqid)
        args = mutateRows_args()
        args.tableName = tableName
        args.rowBatches = rowBatches
        args.attributes = attributes
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_mutateRows(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = mutateRows_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.io is not None:
            raise result.io
        if result.ia is not None:
            raise result.ia
        return

    def mutateRowsTs(self, tableName, rowBatches, timestamp, attributes):
        """
        Apply a series of batches (each a series of mutations on a single row)
        in a single transaction.  If an exception is thrown, then the
        transaction is aborted.  The specified timestamp is used, and
        all entries will have an identical timestamp.

        Parameters:
         - tableName: name of table
         - rowBatches: list of row batches
         - timestamp: timestamp
         - attributes: Mutation attributes

        """
        self.send_mutateRowsTs(tableName, rowBatches, timestamp, attributes)
        self.recv_mutateRowsTs()

    def send_mutateRowsTs(self, tableName, rowBatches, timestamp, attributes):
        self._oprot.writeMessageBegin('mutateRowsTs', TMessageType.CALL, self._seqid)
        args = mutateRowsTs_args()
        args.tableName = tableName
        args.rowBatches = rowBatches
        args.timestamp = timestamp
        args.attributes = attributes
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_mutateRowsTs(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = mutateRowsTs_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.io is not None:
            raise result.io
        if result.ia is not None:
            raise result.ia
        return

    def atomicIncrement(self, tableName, row, column, value):
        """
        Atomically increment the column value specified.  Returns the next value post increment.

        Parameters:
         - tableName: name of table
         - row: row to increment
         - column: name of column
         - value: amount to increment by

        """
        self.send_atomicIncrement(tableName, row, column, value)
        return self.recv_atomicIncrement()

    def send_atomicIncrement(self, tableName, row, column, value):
        self._oprot.writeMessageBegin('atomicIncrement', TMessageType.CALL, self._seqid)
        args = atomicIncrement_args()
        args.tableName = tableName
        args.row = row
        args.column = column
        args.value = value
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_atomicIncrement(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = atomicIncrement_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.success is not None:
            return result.success
        if result.io is not None:
            raise result.io
        if result.ia is not None:
            raise result.ia
        raise TApplicationException(TApplicationException.MISSING_RESULT, "atomicIncrement failed: unknown result")

    def deleteAll(self, tableName, row, column, attributes):
        """
        Delete all cells that match the passed row and column.

        Parameters:
         - tableName: name of table
         - row: Row to update
         - column: name of column whose value is to be deleted
         - attributes: Delete attributes

        """
        self.send_deleteAll(tableName, row, column, attributes)
        self.recv_deleteAll()

    def send_deleteAll(self, tableName, row, column, attributes):
        self._oprot.writeMessageBegin('deleteAll', TMessageType.CALL, self._seqid)
        args = deleteAll_args()
        args.tableName = tableName
        args.row = row
        args.column = column
        args.attributes = attributes
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_deleteAll(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = deleteAll_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.io is not None:
            raise result.io
        return

    def deleteAllTs(self, tableName, row, column, timestamp, attributes):
        """
        Delete all cells that match the passed row and column and whose
        timestamp is equal-to or older than the passed timestamp.

        Parameters:
         - tableName: name of table
         - row: Row to update
         - column: name of column whose value is to be deleted
         - timestamp: timestamp
         - attributes: Delete attributes

        """
        self.send_deleteAllTs(tableName, row, column, timestamp, attributes)
        self.recv_deleteAllTs()

    def send_deleteAllTs(self, tableName, row, column, timestamp, attributes):
        self._oprot.writeMessageBegin('deleteAllTs', TMessageType.CALL, self._seqid)
        args = deleteAllTs_args()
        args.tableName = tableName
        args.row = row
        args.column = column
        args.timestamp = timestamp
        args.attributes = attributes
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_deleteAllTs(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = deleteAllTs_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.io is not None:
            raise result.io
        return

    def deleteAllRow(self, tableName, row, attributes):
        """
        Completely delete the row's cells.

        Parameters:
         - tableName: name of table
         - row: key of the row to be completely deleted.
         - attributes: Delete attributes

        """
        self.send_deleteAllRow(tableName, row, attributes)
        self.recv_deleteAllRow()

    def send_deleteAllRow(self, tableName, row, attributes):
        self._oprot.writeMessageBegin('deleteAllRow', TMessageType.CALL, self._seqid)
        args = deleteAllRow_args()
        args.tableName = tableName
        args.row = row
        args.attributes = attributes
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_deleteAllRow(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = deleteAllRow_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.io is not None:
            raise result.io
        return

    def increment(self, increment):
        """
        Increment a cell by the ammount.
        Increments can be applied async if hbase.regionserver.thrift.coalesceIncrement is set to true.
        False is the default.  Turn to true if you need the extra performance and can accept some
        data loss if a thrift server dies with increments still in the queue.

        Parameters:
         - increment: The single increment to apply

        """
        self.send_increment(increment)
        self.recv_increment()

    def send_increment(self, increment):
        self._oprot.writeMessageBegin('increment', TMessageType.CALL, self._seqid)
        args = increment_args()
        args.increment = increment
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_increment(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = increment_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.io is not None:
            raise result.io
        return

    def incrementRows(self, increments):
        """
        Parameters:
         - increments: The list of increments

        """
        self.send_incrementRows(increments)
        self.recv_incrementRows()

    def send_incrementRows(self, increments):
        self._oprot.writeMessageBegin('incrementRows', TMessageType.CALL, self._seqid)
        args = incrementRows_args()
        args.increments = increments
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_incrementRows(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = incrementRows_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.io is not None:
            raise result.io
        return

    def deleteAllRowTs(self, tableName, row, timestamp, attributes):
        """
        Completely delete the row's cells marked with a timestamp
        equal-to or older than the passed timestamp.

        Parameters:
         - tableName: name of table
         - row: key of the row to be completely deleted.
         - timestamp: timestamp
         - attributes: Delete attributes

        """
        self.send_deleteAllRowTs(tableName, row, timestamp, attributes)
        self.recv_deleteAllRowTs()

    def send_deleteAllRowTs(self, tableName, row, timestamp, attributes):
        self._oprot.writeMessageBegin('deleteAllRowTs', TMessageType.CALL, self._seqid)
        args = deleteAllRowTs_args()
        args.tableName = tableName
        args.row = row
        args.timestamp = timestamp
        args.attributes = attributes
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_deleteAllRowTs(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = deleteAllRowTs_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.io is not None:
            raise result.io
        return

    def scannerOpenWithScan(self, tableName, scan, attributes):
        """
        Get a scanner on the current table, using the Scan instance
        for the scan parameters.

        Parameters:
         - tableName: name of table
         - scan: Scan instance
         - attributes: Scan attributes

        """
        self.send_scannerOpenWithScan(tableName, scan, attributes)
        return self.recv_scannerOpenWithScan()

    def send_scannerOpenWithScan(self, tableName, scan, attributes):
        self._oprot.writeMessageBegin('scannerOpenWithScan', TMessageType.CALL, self._seqid)
        args = scannerOpenWithScan_args()
        args.tableName = tableName
        args.scan = scan
        args.attributes = attributes
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_scannerOpenWithScan(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = scannerOpenWithScan_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.success is not None:
            return result.success
        if result.io is not None:
            raise result.io
        raise TApplicationException(TApplicationException.MISSING_RESULT, "scannerOpenWithScan failed: unknown result")

    def scannerOpen(self, tableName, startRow, columns, attributes):
        """
        Get a scanner on the current table starting at the specified row and
        ending at the last row in the table.  Return the specified columns.

        @return scanner id to be used with other scanner procedures

        Parameters:
         - tableName: name of table
         - startRow: Starting row in table to scan.
        Send "" (empty string) to start at the first row.
         - columns: columns to scan. If column name is a column family, all
        columns of the specified column family are returned. It's also possible
        to pass a regex in the column qualifier.
         - attributes: Scan attributes

        """
        self.send_scannerOpen(tableName, startRow, columns, attributes)
        return self.recv_scannerOpen()

    def send_scannerOpen(self, tableName, startRow, columns, attributes):
        self._oprot.writeMessageBegin('scannerOpen', TMessageType.CALL, self._seqid)
        args = scannerOpen_args()
        args.tableName = tableName
        args.startRow = startRow
        args.columns = columns
        args.attributes = attributes
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_scannerOpen(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = scannerOpen_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.success is not None:
            return result.success
        if result.io is not None:
            raise result.io
        raise TApplicationException(TApplicationException.MISSING_RESULT, "scannerOpen failed: unknown result")

    def scannerOpenWithStop(self, tableName, startRow, stopRow, columns, attributes):
        """
        Get a scanner on the current table starting and stopping at the
        specified rows.  ending at the last row in the table.  Return the
        specified columns.

        @return scanner id to be used with other scanner procedures

        Parameters:
         - tableName: name of table
         - startRow: Starting row in table to scan.
        Send "" (empty string) to start at the first row.
         - stopRow: row to stop scanning on. This row is *not* included in the
        scanner's results
         - columns: columns to scan. If column name is a column family, all
        columns of the specified column family are returned. It's also possible
        to pass a regex in the column qualifier.
         - attributes: Scan attributes

        """
        self.send_scannerOpenWithStop(tableName, startRow, stopRow, columns, attributes)
        return self.recv_scannerOpenWithStop()

    def send_scannerOpenWithStop(self, tableName, startRow, stopRow, columns, attributes):
        self._oprot.writeMessageBegin('scannerOpenWithStop', TMessageType.CALL, self._seqid)
        args = scannerOpenWithStop_args()
        args.tableName = tableName
        args.startRow = startRow
        args.stopRow = stopRow
        args.columns = columns
        args.attributes = attributes
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_scannerOpenWithStop(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = scannerOpenWithStop_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.success is not None:
            return result.success
        if result.io is not None:
            raise result.io
        raise TApplicationException(TApplicationException.MISSING_RESULT, "scannerOpenWithStop failed: unknown result")

    def scannerOpenWithPrefix(self, tableName, startAndPrefix, columns, attributes):
        """
        Open a scanner for a given prefix.  That is all rows will have the specified
        prefix. No other rows will be returned.

        @return scanner id to use with other scanner calls

        Parameters:
         - tableName: name of table
         - startAndPrefix: the prefix (and thus start row) of the keys you want
         - columns: the columns you want returned
         - attributes: Scan attributes

        """
        self.send_scannerOpenWithPrefix(tableName, startAndPrefix, columns, attributes)
        return self.recv_scannerOpenWithPrefix()

    def send_scannerOpenWithPrefix(self, tableName, startAndPrefix, columns, attributes):
        self._oprot.writeMessageBegin('scannerOpenWithPrefix', TMessageType.CALL, self._seqid)
        args = scannerOpenWithPrefix_args()
        args.tableName = tableName
        args.startAndPrefix = startAndPrefix
        args.columns = columns
        args.attributes = attributes
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_scannerOpenWithPrefix(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = scannerOpenWithPrefix_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.success is not None:
            return result.success
        if result.io is not None:
            raise result.io
        raise TApplicationException(TApplicationException.MISSING_RESULT, "scannerOpenWithPrefix failed: unknown result")

    def scannerOpenTs(self, tableName, startRow, columns, timestamp, attributes):
        """
        Get a scanner on the current table starting at the specified row and
        ending at the last row in the table.  Return the specified columns.
        Only values with the specified timestamp are returned.

        @return scanner id to be used with other scanner procedures

        Parameters:
         - tableName: name of table
         - startRow: Starting row in table to scan.
        Send "" (empty string) to start at the first row.
         - columns: columns to scan. If column name is a column family, all
        columns of the specified column family are returned. It's also possible
        to pass a regex in the column qualifier.
         - timestamp: timestamp
         - attributes: Scan attributes

        """
        self.send_scannerOpenTs(tableName, startRow, columns, timestamp, attributes)
        return self.recv_scannerOpenTs()

    def send_scannerOpenTs(self, tableName, startRow, columns, timestamp, attributes):
        self._oprot.writeMessageBegin('scannerOpenTs', TMessageType.CALL, self._seqid)
        args = scannerOpenTs_args()
        args.tableName = tableName
        args.startRow = startRow
        args.columns = columns
        args.timestamp = timestamp
        args.attributes = attributes
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_scannerOpenTs(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = scannerOpenTs_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.success is not None:
            return result.success
        if result.io is not None:
            raise result.io
        raise TApplicationException(TApplicationException.MISSING_RESULT, "scannerOpenTs failed: unknown result")

    def scannerOpenWithStopTs(self, tableName, startRow, stopRow, columns, timestamp, attributes):
        """
        Get a scanner on the current table starting and stopping at the
        specified rows.  ending at the last row in the table.  Return the
        specified columns.  Only values with the specified timestamp are
        returned.

        @return scanner id to be used with other scanner procedures

        Parameters:
         - tableName: name of table
         - startRow: Starting row in table to scan.
        Send "" (empty string) to start at the first row.
         - stopRow: row to stop scanning on. This row is *not* included in the
        scanner's results
         - columns: columns to scan. If column name is a column family, all
        columns of the specified column family are returned. It's also possible
        to pass a regex in the column qualifier.
         - timestamp: timestamp
         - attributes: Scan attributes

        """
        self.send_scannerOpenWithStopTs(tableName, startRow, stopRow, columns, timestamp, attributes)
        return self.recv_scannerOpenWithStopTs()

    def send_scannerOpenWithStopTs(self, tableName, startRow, stopRow, columns, timestamp, attributes):
        self._oprot.writeMessageBegin('scannerOpenWithStopTs', TMessageType.CALL, self._seqid)
        args = scannerOpenWithStopTs_args()
        args.tableName = tableName
        args.startRow = startRow
        args.stopRow = stopRow
        args.columns = columns
        args.timestamp = timestamp
        args.attributes = attributes
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_scannerOpenWithStopTs(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = scannerOpenWithStopTs_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.success is not None:
            return result.success
        if result.io is not None:
            raise result.io
        raise TApplicationException(TApplicationException.MISSING_RESULT, "scannerOpenWithStopTs failed: unknown result")

    def scannerGet(self, id):
        """
        Returns the scanner's current row value and advances to the next
        row in the table.  When there are no more rows in the table, or a key
        greater-than-or-equal-to the scanner's specified stopRow is reached,
        an empty list is returned.

        @return a TRowResult containing the current row and a map of the columns to TCells.

        @throws IllegalArgument if ScannerID is invalid

        @throws NotFound when the scanner reaches the end

        Parameters:
         - id: id of a scanner returned by scannerOpen

        """
        self.send_scannerGet(id)
        return self.recv_scannerGet()

    def send_scannerGet(self, id):
        self._oprot.writeMessageBegin('scannerGet', TMessageType.CALL, self._seqid)
        args = scannerGet_args()
        args.id = id
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_scannerGet(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = scannerGet_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.success is not None:
            return result.success
        if result.io is not None:
            raise result.io
        if result.ia is not None:
            raise result.ia
        raise TApplicationException(TApplicationException.MISSING_RESULT, "scannerGet failed: unknown result")

    def scannerGetList(self, id, nbRows):
        """
        Returns, starting at the scanner's current row value nbRows worth of
        rows and advances to the next row in the table.  When there are no more
        rows in the table, or a key greater-than-or-equal-to the scanner's
        specified stopRow is reached,  an empty list is returned.

        @return a TRowResult containing the current row and a map of the columns to TCells.

        @throws IllegalArgument if ScannerID is invalid

        @throws NotFound when the scanner reaches the end

        Parameters:
         - id: id of a scanner returned by scannerOpen
         - nbRows: number of results to return

        """
        self.send_scannerGetList(id, nbRows)
        return self.recv_scannerGetList()

    def send_scannerGetList(self, id, nbRows):
        self._oprot.writeMessageBegin('scannerGetList', TMessageType.CALL, self._seqid)
        args = scannerGetList_args()
        args.id = id
        args.nbRows = nbRows
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_scannerGetList(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = scannerGetList_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.success is not None:
            return result.success
        if result.io is not None:
            raise result.io
        if result.ia is not None:
            raise result.ia
        raise TApplicationException(TApplicationException.MISSING_RESULT, "scannerGetList failed: unknown result")

    def scannerClose(self, id):
        """
        Closes the server-state associated with an open scanner.

        @throws IllegalArgument if ScannerID is invalid

        Parameters:
         - id: id of a scanner returned by scannerOpen

        """
        self.send_scannerClose(id)
        self.recv_scannerClose()

    def send_scannerClose(self, id):
        self._oprot.writeMessageBegin('scannerClose', TMessageType.CALL, self._seqid)
        args = scannerClose_args()
        args.id = id
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_scannerClose(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = scannerClose_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.io is not None:
            raise result.io
        if result.ia is not None:
            raise result.ia
        return

    def getRegionInfo(self, row):
        """
        Get the regininfo for the specified row. It scans
        the metatable to find region's start and end keys.

        @return value for specified row/column

        Parameters:
         - row: row key

        """
        self.send_getRegionInfo(row)
        return self.recv_getRegionInfo()

    def send_getRegionInfo(self, row):
        self._oprot.writeMessageBegin('getRegionInfo', TMessageType.CALL, self._seqid)
        args = getRegionInfo_args()
        args.row = row
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_getRegionInfo(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = getRegionInfo_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.success is not None:
            return result.success
        if result.io is not None:
            raise result.io
        raise TApplicationException(TApplicationException.MISSING_RESULT, "getRegionInfo failed: unknown result")

    def append(self, append):
        """
        Appends values to one or more columns within a single row.

        @return values of columns after the append operation.

        Parameters:
         - append: The single append operation to apply

        """
        self.send_append(append)
        return self.recv_append()

    def send_append(self, append):
        self._oprot.writeMessageBegin('append', TMessageType.CALL, self._seqid)
        args = append_args()
        args.append = append
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_append(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = append_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.success is not None:
            return result.success
        if result.io is not None:
            raise result.io
        raise TApplicationException(TApplicationException.MISSING_RESULT, "append failed: unknown result")

    def checkAndPut(self, tableName, row, column, value, mput, attributes):
        """
        Atomically checks if a row/family/qualifier value matches the expected
        value. If it does, it adds the corresponding mutation operation for put.

        @return true if the new put was executed, false otherwise

        Parameters:
         - tableName: name of table
         - row: row key
         - column: column name
         - value: the expected value for the column parameter, if not
        provided the check is for the non-existence of the
        column in question
         - mput: mutation for the put
         - attributes: Mutation attributes

        """
        self.send_checkAndPut(tableName, row, column, value, mput, attributes)
        return self.recv_checkAndPut()

    def send_checkAndPut(self, tableName, row, column, value, mput, attributes):
        self._oprot.writeMessageBegin('checkAndPut', TMessageType.CALL, self._seqid)
        args = checkAndPut_args()
        args.tableName = tableName
        args.row = row
        args.column = column
        args.value = value
        args.mput = mput
        args.attributes = attributes
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_checkAndPut(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = checkAndPut_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.success is not None:
            return result.success
        if result.io is not None:
            raise result.io
        if result.ia is not None:
            raise result.ia
        raise TApplicationException(TApplicationException.MISSING_RESULT, "checkAndPut failed: unknown result")

    def getThriftServerType(self):
        """
        Get the type of this thrift server.

        @return the type of this thrift server

        """
        self.send_getThriftServerType()
        return self.recv_getThriftServerType()

    def send_getThriftServerType(self):
        self._oprot.writeMessageBegin('getThriftServerType', TMessageType.CALL, self._seqid)
        args = getThriftServerType_args()
        args.write(self._oprot)
        self._oprot.writeMessageEnd()
        self._oprot.trans.flush()

    def recv_getThriftServerType(self):
        iprot = self._iprot
        (fname, mtype, rseqid) = iprot.readMessageBegin()
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = getThriftServerType_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.success is not None:
            return result.success
        raise TApplicationException(TApplicationException.MISSING_RESULT, "getThriftServerType failed: unknown result")


class Processor(Iface, TProcessor):
    def __init__(self, handler):
        self._handler = handler
        self._processMap = {}
        self._processMap["enableTable"] = Processor.process_enableTable
        self._processMap["disableTable"] = Processor.process_disableTable
        self._processMap["isTableEnabled"] = Processor.process_isTableEnabled
        self._processMap["compact"] = Processor.process_compact
        self._processMap["majorCompact"] = Processor.process_majorCompact
        self._processMap["getTableNames"] = Processor.process_getTableNames
        self._processMap["getColumnDescriptors"] = Processor.process_getColumnDescriptors
        self._processMap["getTableRegions"] = Processor.process_getTableRegions
        self._processMap["createTable"] = Processor.process_createTable
        self._processMap["deleteTable"] = Processor.process_deleteTable
        self._processMap["get"] = Processor.process_get
        self._processMap["getVer"] = Processor.process_getVer
        self._processMap["getVerTs"] = Processor.process_getVerTs
        self._processMap["getRow"] = Processor.process_getRow
        self._processMap["getRowWithColumns"] = Processor.process_getRowWithColumns
        self._processMap["getRowTs"] = Processor.process_getRowTs
        self._processMap["getRowWithColumnsTs"] = Processor.process_getRowWithColumnsTs
        self._processMap["getRows"] = Processor.process_getRows
        self._processMap["getRowsWithColumns"] = Processor.process_getRowsWithColumns
        self._processMap["getRowsTs"] = Processor.process_getRowsTs
        self._processMap["getRowsWithColumnsTs"] = Processor.process_getRowsWithColumnsTs
        self._processMap["mutateRow"] = Processor.process_mutateRow
        self._processMap["mutateRowTs"] = Processor.process_mutateRowTs
        self._processMap["mutateRows"] = Processor.process_mutateRows
        self._processMap["mutateRowsTs"] = Processor.process_mutateRowsTs
        self._processMap["atomicIncrement"] = Processor.process_atomicIncrement
        self._processMap["deleteAll"] = Processor.process_deleteAll
        self._processMap["deleteAllTs"] = Processor.process_deleteAllTs
        self._processMap["deleteAllRow"] = Processor.process_deleteAllRow
        self._processMap["increment"] = Processor.process_increment
        self._processMap["incrementRows"] = Processor.process_incrementRows
        self._processMap["deleteAllRowTs"] = Processor.process_deleteAllRowTs
        self._processMap["scannerOpenWithScan"] = Processor.process_scannerOpenWithScan
        self._processMap["scannerOpen"] = Processor.process_scannerOpen
        self._processMap["scannerOpenWithStop"] = Processor.process_scannerOpenWithStop
        self._processMap["scannerOpenWithPrefix"] = Processor.process_scannerOpenWithPrefix
        self._processMap["scannerOpenTs"] = Processor.process_scannerOpenTs
        self._processMap["scannerOpenWithStopTs"] = Processor.process_scannerOpenWithStopTs
        self._processMap["scannerGet"] = Processor.process_scannerGet
        self._processMap["scannerGetList"] = Processor.process_scannerGetList
        self._processMap["scannerClose"] = Processor.process_scannerClose
        self._processMap["getRegionInfo"] = Processor.process_getRegionInfo
        self._processMap["append"] = Processor.process_append
        self._processMap["checkAndPut"] = Processor.process_checkAndPut
        self._processMap["getThriftServerType"] = Processor.process_getThriftServerType

    def process(self, iprot, oprot):
        (name, type, seqid) = iprot.readMessageBegin()
        if name not in self._processMap:
            iprot.skip(TType.STRUCT)
            iprot.readMessageEnd()
            x = TApplicationException(TApplicationException.UNKNOWN_METHOD, 'Unknown function %s' % (name))
            oprot.writeMessageBegin(name, TMessageType.EXCEPTION, seqid)
            x.write(oprot)
            oprot.writeMessageEnd()
            oprot.trans.flush()
            return
        else:
            self._processMap[name](self, seqid, iprot, oprot)
        return True

    def process_enableTable(self, seqid, iprot, oprot):
        args = enableTable_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = enableTable_result()
        try:
            self._handler.enableTable(args.tableName)
            msg_type = TMessageType.REPLY
        except TTransport.TTransportException:
            raise
        except IOError as io:
            msg_type = TMessageType.REPLY
            result.io = io
        except TApplicationException as ex:
            logging.exception('TApplication exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = ex
        except Exception:
            logging.exception('Unexpected exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, 'Internal error')
        oprot.writeMessageBegin("enableTable", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_disableTable(self, seqid, iprot, oprot):
        args = disableTable_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = disableTable_result()
        try:
            self._handler.disableTable(args.tableName)
            msg_type = TMessageType.REPLY
        except TTransport.TTransportException:
            raise
        except IOError as io:
            msg_type = TMessageType.REPLY
            result.io = io
        except TApplicationException as ex:
            logging.exception('TApplication exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = ex
        except Exception:
            logging.exception('Unexpected exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, 'Internal error')
        oprot.writeMessageBegin("disableTable", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_isTableEnabled(self, seqid, iprot, oprot):
        args = isTableEnabled_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = isTableEnabled_result()
        try:
            result.success = self._handler.isTableEnabled(args.tableName)
            msg_type = TMessageType.REPLY
        except TTransport.TTransportException:
            raise
        except IOError as io:
            msg_type = TMessageType.REPLY
            result.io = io
        except TApplicationException as ex:
            logging.exception('TApplication exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = ex
        except Exception:
            logging.exception('Unexpected exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, 'Internal error')
        oprot.writeMessageBegin("isTableEnabled", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_compact(self, seqid, iprot, oprot):
        args = compact_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = compact_result()
        try:
            self._handler.compact(args.tableNameOrRegionName)
            msg_type = TMessageType.REPLY
        except TTransport.TTransportException:
            raise
        except IOError as io:
            msg_type = TMessageType.REPLY
            result.io = io
        except TApplicationException as ex:
            logging.exception('TApplication exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = ex
        except Exception:
            logging.exception('Unexpected exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, 'Internal error')
        oprot.writeMessageBegin("compact", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_majorCompact(self, seqid, iprot, oprot):
        args = majorCompact_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = majorCompact_result()
        try:
            self._handler.majorCompact(args.tableNameOrRegionName)
            msg_type = TMessageType.REPLY
        except TTransport.TTransportException:
            raise
        except IOError as io:
            msg_type = TMessageType.REPLY
            result.io = io
        except TApplicationException as ex:
            logging.exception('TApplication exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = ex
        except Exception:
            logging.exception('Unexpected exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, 'Internal error')
        oprot.writeMessageBegin("majorCompact", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_getTableNames(self, seqid, iprot, oprot):
        args = getTableNames_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = getTableNames_result()
        try:
            result.success = self._handler.getTableNames()
            msg_type = TMessageType.REPLY
        except TTransport.TTransportException:
            raise
        except IOError as io:
            msg_type = TMessageType.REPLY
            result.io = io
        except TApplicationException as ex:
            logging.exception('TApplication exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = ex
        except Exception:
            logging.exception('Unexpected exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, 'Internal error')
        oprot.writeMessageBegin("getTableNames", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_getColumnDescriptors(self, seqid, iprot, oprot):
        args = getColumnDescriptors_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = getColumnDescriptors_result()
        try:
            result.success = self._handler.getColumnDescriptors(args.tableName)
            msg_type = TMessageType.REPLY
        except TTransport.TTransportException:
            raise
        except IOError as io:
            msg_type = TMessageType.REPLY
            result.io = io
        except TApplicationException as ex:
            logging.exception('TApplication exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = ex
        except Exception:
            logging.exception('Unexpected exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, 'Internal error')
        oprot.writeMessageBegin("getColumnDescriptors", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_getTableRegions(self, seqid, iprot, oprot):
        args = getTableRegions_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = getTableRegions_result()
        try:
            result.success = self._handler.getTableRegions(args.tableName)
            msg_type = TMessageType.REPLY
        except TTransport.TTransportException:
            raise
        except IOError as io:
            msg_type = TMessageType.REPLY
            result.io = io
        except TApplicationException as ex:
            logging.exception('TApplication exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = ex
        except Exception:
            logging.exception('Unexpected exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, 'Internal error')
        oprot.writeMessageBegin("getTableRegions", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_createTable(self, seqid, iprot, oprot):
        args = createTable_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = createTable_result()
        try:
            self._handler.createTable(args.tableName, args.columnFamilies)
            msg_type = TMessageType.REPLY
        except TTransport.TTransportException:
            raise
        except IOError as io:
            msg_type = TMessageType.REPLY
            result.io = io
        except IllegalArgument as ia:
            msg_type = TMessageType.REPLY
            result.ia = ia
        except AlreadyExists as exist:
            msg_type = TMessageType.REPLY
            result.exist = exist
        except TApplicationException as ex:
            logging.exception('TApplication exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = ex
        except Exception:
            logging.exception('Unexpected exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, 'Internal error')
        oprot.writeMessageBegin("createTable", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_deleteTable(self, seqid, iprot, oprot):
        args = deleteTable_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = deleteTable_result()
        try:
            self._handler.deleteTable(args.tableName)
            msg_type = TMessageType.REPLY
        except TTransport.TTransportException:
            raise
        except IOError as io:
            msg_type = TMessageType.REPLY
            result.io = io
        except TApplicationException as ex:
            logging.exception('TApplication exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = ex
        except Exception:
            logging.exception('Unexpected exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, 'Internal error')
        oprot.writeMessageBegin("deleteTable", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_get(self, seqid, iprot, oprot):
        args = get_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = get_result()
        try:
            result.success = self._handler.get(args.tableName, args.row, args.column, args.attributes)
            msg_type = TMessageType.REPLY
        except TTransport.TTransportException:
            raise
        except IOError as io:
            msg_type = TMessageType.REPLY
            result.io = io
        except TApplicationException as ex:
            logging.exception('TApplication exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = ex
        except Exception:
            logging.exception('Unexpected exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, 'Internal error')
        oprot.writeMessageBegin("get", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_getVer(self, seqid, iprot, oprot):
        args = getVer_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = getVer_result()
        try:
            result.success = self._handler.getVer(args.tableName, args.row, args.column, args.numVersions, args.attributes)
            msg_type = TMessageType.REPLY
        except TTransport.TTransportException:
            raise
        except IOError as io:
            msg_type = TMessageType.REPLY
            result.io = io
        except TApplicationException as ex:
            logging.exception('TApplication exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = ex
        except Exception:
            logging.exception('Unexpected exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, 'Internal error')
        oprot.writeMessageBegin("getVer", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_getVerTs(self, seqid, iprot, oprot):
        args = getVerTs_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = getVerTs_result()
        try:
            result.success = self._handler.getVerTs(args.tableName, args.row, args.column, args.timestamp, args.numVersions, args.attributes)
            msg_type = TMessageType.REPLY
        except TTransport.TTransportException:
            raise
        except IOError as io:
            msg_type = TMessageType.REPLY
            result.io = io
        except TApplicationException as ex:
            logging.exception('TApplication exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = ex
        except Exception:
            logging.exception('Unexpected exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, 'Internal error')
        oprot.writeMessageBegin("getVerTs", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_getRow(self, seqid, iprot, oprot):
        args = getRow_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = getRow_result()
        try:
            result.success = self._handler.getRow(args.tableName, args.row, args.attributes)
            msg_type = TMessageType.REPLY
        except TTransport.TTransportException:
            raise
        except IOError as io:
            msg_type = TMessageType.REPLY
            result.io = io
        except TApplicationException as ex:
            logging.exception('TApplication exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = ex
        except Exception:
            logging.exception('Unexpected exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, 'Internal error')
        oprot.writeMessageBegin("getRow", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_getRowWithColumns(self, seqid, iprot, oprot):
        args = getRowWithColumns_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = getRowWithColumns_result()
        try:
            result.success = self._handler.getRowWithColumns(args.tableName, args.row, args.columns, args.attributes)
            msg_type = TMessageType.REPLY
        except TTransport.TTransportException:
            raise
        except IOError as io:
            msg_type = TMessageType.REPLY
            result.io = io
        except TApplicationException as ex:
            logging.exception('TApplication exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = ex
        except Exception:
            logging.exception('Unexpected exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, 'Internal error')
        oprot.writeMessageBegin("getRowWithColumns", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_getRowTs(self, seqid, iprot, oprot):
        args = getRowTs_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = getRowTs_result()
        try:
            result.success = self._handler.getRowTs(args.tableName, args.row, args.timestamp, args.attributes)
            msg_type = TMessageType.REPLY
        except TTransport.TTransportException:
            raise
        except IOError as io:
            msg_type = TMessageType.REPLY
            result.io = io
        except TApplicationException as ex:
            logging.exception('TApplication exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = ex
        except Exception:
            logging.exception('Unexpected exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, 'Internal error')
        oprot.writeMessageBegin("getRowTs", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_getRowWithColumnsTs(self, seqid, iprot, oprot):
        args = getRowWithColumnsTs_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = getRowWithColumnsTs_result()
        try:
            result.success = self._handler.getRowWithColumnsTs(args.tableName, args.row, args.columns, args.timestamp, args.attributes)
            msg_type = TMessageType.REPLY
        except TTransport.TTransportException:
            raise
        except IOError as io:
            msg_type = TMessageType.REPLY
            result.io = io
        except TApplicationException as ex:
            logging.exception('TApplication exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = ex
        except Exception:
            logging.exception('Unexpected exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, 'Internal error')
        oprot.writeMessageBegin("getRowWithColumnsTs", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_getRows(self, seqid, iprot, oprot):
        args = getRows_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = getRows_result()
        try:
            result.success = self._handler.getRows(args.tableName, args.rows, args.attributes)
            msg_type = TMessageType.REPLY
        except TTransport.TTransportException:
            raise
        except IOError as io:
            msg_type = TMessageType.REPLY
            result.io = io
        except TApplicationException as ex:
            logging.exception('TApplication exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = ex
        except Exception:
            logging.exception('Unexpected exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, 'Internal error')
        oprot.writeMessageBegin("getRows", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_getRowsWithColumns(self, seqid, iprot, oprot):
        args = getRowsWithColumns_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = getRowsWithColumns_result()
        try:
            result.success = self._handler.getRowsWithColumns(args.tableName, args.rows, args.columns, args.attributes)
            msg_type = TMessageType.REPLY
        except TTransport.TTransportException:
            raise
        except IOError as io:
            msg_type = TMessageType.REPLY
            result.io = io
        except TApplicationException as ex:
            logging.exception('TApplication exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = ex
        except Exception:
            logging.exception('Unexpected exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, 'Internal error')
        oprot.writeMessageBegin("getRowsWithColumns", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_getRowsTs(self, seqid, iprot, oprot):
        args = getRowsTs_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = getRowsTs_result()
        try:
            result.success = self._handler.getRowsTs(args.tableName, args.rows, args.timestamp, args.attributes)
            msg_type = TMessageType.REPLY
        except TTransport.TTransportException:
            raise
        except IOError as io:
            msg_type = TMessageType.REPLY
            result.io = io
        except TApplicationException as ex:
            logging.exception('TApplication exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = ex
        except Exception:
            logging.exception('Unexpected exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, 'Internal error')
        oprot.writeMessageBegin("getRowsTs", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_getRowsWithColumnsTs(self, seqid, iprot, oprot):
        args = getRowsWithColumnsTs_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = getRowsWithColumnsTs_result()
        try:
            result.success = self._handler.getRowsWithColumnsTs(args.tableName, args.rows, args.columns, args.timestamp, args.attributes)
            msg_type = TMessageType.REPLY
        except TTransport.TTransportException:
            raise
        except IOError as io:
            msg_type = TMessageType.REPLY
            result.io = io
        except TApplicationException as ex:
            logging.exception('TApplication exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = ex
        except Exception:
            logging.exception('Unexpected exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, 'Internal error')
        oprot.writeMessageBegin("getRowsWithColumnsTs", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_mutateRow(self, seqid, iprot, oprot):
        args = mutateRow_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = mutateRow_result()
        try:
            self._handler.mutateRow(args.tableName, args.row, args.mutations, args.attributes)
            msg_type = TMessageType.REPLY
        except TTransport.TTransportException:
            raise
        except IOError as io:
            msg_type = TMessageType.REPLY
            result.io = io
        except IllegalArgument as ia:
            msg_type = TMessageType.REPLY
            result.ia = ia
        except TApplicationException as ex:
            logging.exception('TApplication exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = ex
        except Exception:
            logging.exception('Unexpected exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, 'Internal error')
        oprot.writeMessageBegin("mutateRow", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_mutateRowTs(self, seqid, iprot, oprot):
        args = mutateRowTs_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = mutateRowTs_result()
        try:
            self._handler.mutateRowTs(args.tableName, args.row, args.mutations, args.timestamp, args.attributes)
            msg_type = TMessageType.REPLY
        except TTransport.TTransportException:
            raise
        except IOError as io:
            msg_type = TMessageType.REPLY
            result.io = io
        except IllegalArgument as ia:
            msg_type = TMessageType.REPLY
            result.ia = ia
        except TApplicationException as ex:
            logging.exception('TApplication exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = ex
        except Exception:
            logging.exception('Unexpected exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, 'Internal error')
        oprot.writeMessageBegin("mutateRowTs", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_mutateRows(self, seqid, iprot, oprot):
        args = mutateRows_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = mutateRows_result()
        try:
            self._handler.mutateRows(args.tableName, args.rowBatches, args.attributes)
            msg_type = TMessageType.REPLY
        except TTransport.TTransportException:
            raise
        except IOError as io:
            msg_type = TMessageType.REPLY
            result.io = io
        except IllegalArgument as ia:
            msg_type = TMessageType.REPLY
            result.ia = ia
        except TApplicationException as ex:
            logging.exception('TApplication exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = ex
        except Exception:
            logging.exception('Unexpected exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, 'Internal error')
        oprot.writeMessageBegin("mutateRows", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_mutateRowsTs(self, seqid, iprot, oprot):
        args = mutateRowsTs_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = mutateRowsTs_result()
        try:
            self._handler.mutateRowsTs(args.tableName, args.rowBatches, args.timestamp, args.attributes)
            msg_type = TMessageType.REPLY
        except TTransport.TTransportException:
            raise
        except IOError as io:
            msg_type = TMessageType.REPLY
            result.io = io
        except IllegalArgument as ia:
            msg_type = TMessageType.REPLY
            result.ia = ia
        except TApplicationException as ex:
            logging.exception('TApplication exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = ex
        except Exception:
            logging.exception('Unexpected exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, 'Internal error')
        oprot.writeMessageBegin("mutateRowsTs", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_atomicIncrement(self, seqid, iprot, oprot):
        args = atomicIncrement_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = atomicIncrement_result()
        try:
            result.success = self._handler.atomicIncrement(args.tableName, args.row, args.column, args.value)
            msg_type = TMessageType.REPLY
        except TTransport.TTransportException:
            raise
        except IOError as io:
            msg_type = TMessageType.REPLY
            result.io = io
        except IllegalArgument as ia:
            msg_type = TMessageType.REPLY
            result.ia = ia
        except TApplicationException as ex:
            logging.exception('TApplication exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = ex
        except Exception:
            logging.exception('Unexpected exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, 'Internal error')
        oprot.writeMessageBegin("atomicIncrement", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_deleteAll(self, seqid, iprot, oprot):
        args = deleteAll_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = deleteAll_result()
        try:
            self._handler.deleteAll(args.tableName, args.row, args.column, args.attributes)
            msg_type = TMessageType.REPLY
        except TTransport.TTransportException:
            raise
        except IOError as io:
            msg_type = TMessageType.REPLY
            result.io = io
        except TApplicationException as ex:
            logging.exception('TApplication exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = ex
        except Exception:
            logging.exception('Unexpected exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, 'Internal error')
        oprot.writeMessageBegin("deleteAll", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_deleteAllTs(self, seqid, iprot, oprot):
        args = deleteAllTs_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = deleteAllTs_result()
        try:
            self._handler.deleteAllTs(args.tableName, args.row, args.column, args.timestamp, args.attributes)
            msg_type = TMessageType.REPLY
        except TTransport.TTransportException:
            raise
        except IOError as io:
            msg_type = TMessageType.REPLY
            result.io = io
        except TApplicationException as ex:
            logging.exception('TApplication exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = ex
        except Exception:
            logging.exception('Unexpected exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, 'Internal error')
        oprot.writeMessageBegin("deleteAllTs", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_deleteAllRow(self, seqid, iprot, oprot):
        args = deleteAllRow_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = deleteAllRow_result()
        try:
            self._handler.deleteAllRow(args.tableName, args.row, args.attributes)
            msg_type = TMessageType.REPLY
        except TTransport.TTransportException:
            raise
        except IOError as io:
            msg_type = TMessageType.REPLY
            result.io = io
        except TApplicationException as ex:
            logging.exception('TApplication exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = ex
        except Exception:
            logging.exception('Unexpected exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, 'Internal error')
        oprot.writeMessageBegin("deleteAllRow", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_increment(self, seqid, iprot, oprot):
        args = increment_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = increment_result()
        try:
            self._handler.increment(args.increment)
            msg_type = TMessageType.REPLY
        except TTransport.TTransportException:
            raise
        except IOError as io:
            msg_type = TMessageType.REPLY
            result.io = io
        except TApplicationException as ex:
            logging.exception('TApplication exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = ex
        except Exception:
            logging.exception('Unexpected exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, 'Internal error')
        oprot.writeMessageBegin("increment", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_incrementRows(self, seqid, iprot, oprot):
        args = incrementRows_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = incrementRows_result()
        try:
            self._handler.incrementRows(args.increments)
            msg_type = TMessageType.REPLY
        except TTransport.TTransportException:
            raise
        except IOError as io:
            msg_type = TMessageType.REPLY
            result.io = io
        except TApplicationException as ex:
            logging.exception('TApplication exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = ex
        except Exception:
            logging.exception('Unexpected exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, 'Internal error')
        oprot.writeMessageBegin("incrementRows", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_deleteAllRowTs(self, seqid, iprot, oprot):
        args = deleteAllRowTs_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = deleteAllRowTs_result()
        try:
            self._handler.deleteAllRowTs(args.tableName, args.row, args.timestamp, args.attributes)
            msg_type = TMessageType.REPLY
        except TTransport.TTransportException:
            raise
        except IOError as io:
            msg_type = TMessageType.REPLY
            result.io = io
        except TApplicationException as ex:
            logging.exception('TApplication exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = ex
        except Exception:
            logging.exception('Unexpected exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, 'Internal error')
        oprot.writeMessageBegin("deleteAllRowTs", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_scannerOpenWithScan(self, seqid, iprot, oprot):
        args = scannerOpenWithScan_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = scannerOpenWithScan_result()
        try:
            result.success = self._handler.scannerOpenWithScan(args.tableName, args.scan, args.attributes)
            msg_type = TMessageType.REPLY
        except TTransport.TTransportException:
            raise
        except IOError as io:
            msg_type = TMessageType.REPLY
            result.io = io
        except TApplicationException as ex:
            logging.exception('TApplication exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = ex
        except Exception:
            logging.exception('Unexpected exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, 'Internal error')
        oprot.writeMessageBegin("scannerOpenWithScan", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_scannerOpen(self, seqid, iprot, oprot):
        args = scannerOpen_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = scannerOpen_result()
        try:
            result.success = self._handler.scannerOpen(args.tableName, args.startRow, args.columns, args.attributes)
            msg_type = TMessageType.REPLY
        except TTransport.TTransportException:
            raise
        except IOError as io:
            msg_type = TMessageType.REPLY
            result.io = io
        except TApplicationException as ex:
            logging.exception('TApplication exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = ex
        except Exception:
            logging.exception('Unexpected exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, 'Internal error')
        oprot.writeMessageBegin("scannerOpen", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_scannerOpenWithStop(self, seqid, iprot, oprot):
        args = scannerOpenWithStop_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = scannerOpenWithStop_result()
        try:
            result.success = self._handler.scannerOpenWithStop(args.tableName, args.startRow, args.stopRow, args.columns, args.attributes)
            msg_type = TMessageType.REPLY
        except TTransport.TTransportException:
            raise
        except IOError as io:
            msg_type = TMessageType.REPLY
            result.io = io
        except TApplicationException as ex:
            logging.exception('TApplication exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = ex
        except Exception:
            logging.exception('Unexpected exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, 'Internal error')
        oprot.writeMessageBegin("scannerOpenWithStop", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_scannerOpenWithPrefix(self, seqid, iprot, oprot):
        args = scannerOpenWithPrefix_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = scannerOpenWithPrefix_result()
        try:
            result.success = self._handler.scannerOpenWithPrefix(args.tableName, args.startAndPrefix, args.columns, args.attributes)
            msg_type = TMessageType.REPLY
        except TTransport.TTransportException:
            raise
        except IOError as io:
            msg_type = TMessageType.REPLY
            result.io = io
        except TApplicationException as ex:
            logging.exception('TApplication exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = ex
        except Exception:
            logging.exception('Unexpected exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, 'Internal error')
        oprot.writeMessageBegin("scannerOpenWithPrefix", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_scannerOpenTs(self, seqid, iprot, oprot):
        args = scannerOpenTs_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = scannerOpenTs_result()
        try:
            result.success = self._handler.scannerOpenTs(args.tableName, args.startRow, args.columns, args.timestamp, args.attributes)
            msg_type = TMessageType.REPLY
        except TTransport.TTransportException:
            raise
        except IOError as io:
            msg_type = TMessageType.REPLY
            result.io = io
        except TApplicationException as ex:
            logging.exception('TApplication exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = ex
        except Exception:
            logging.exception('Unexpected exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, 'Internal error')
        oprot.writeMessageBegin("scannerOpenTs", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_scannerOpenWithStopTs(self, seqid, iprot, oprot):
        args = scannerOpenWithStopTs_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = scannerOpenWithStopTs_result()
        try:
            result.success = self._handler.scannerOpenWithStopTs(args.tableName, args.startRow, args.stopRow, args.columns, args.timestamp, args.attributes)
            msg_type = TMessageType.REPLY
        except TTransport.TTransportException:
            raise
        except IOError as io:
            msg_type = TMessageType.REPLY
            result.io = io
        except TApplicationException as ex:
            logging.exception('TApplication exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = ex
        except Exception:
            logging.exception('Unexpected exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, 'Internal error')
        oprot.writeMessageBegin("scannerOpenWithStopTs", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_scannerGet(self, seqid, iprot, oprot):
        args = scannerGet_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = scannerGet_result()
        try:
            result.success = self._handler.scannerGet(args.id)
            msg_type = TMessageType.REPLY
        except TTransport.TTransportException:
            raise
        except IOError as io:
            msg_type = TMessageType.REPLY
            result.io = io
        except IllegalArgument as ia:
            msg_type = TMessageType.REPLY
            result.ia = ia
        except TApplicationException as ex:
            logging.exception('TApplication exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = ex
        except Exception:
            logging.exception('Unexpected exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, 'Internal error')
        oprot.writeMessageBegin("scannerGet", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_scannerGetList(self, seqid, iprot, oprot):
        args = scannerGetList_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = scannerGetList_result()
        try:
            result.success = self._handler.scannerGetList(args.id, args.nbRows)
            msg_type = TMessageType.REPLY
        except TTransport.TTransportException:
            raise
        except IOError as io:
            msg_type = TMessageType.REPLY
            result.io = io
        except IllegalArgument as ia:
            msg_type = TMessageType.REPLY
            result.ia = ia
        except TApplicationException as ex:
            logging.exception('TApplication exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = ex
        except Exception:
            logging.exception('Unexpected exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, 'Internal error')
        oprot.writeMessageBegin("scannerGetList", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_scannerClose(self, seqid, iprot, oprot):
        args = scannerClose_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = scannerClose_result()
        try:
            self._handler.scannerClose(args.id)
            msg_type = TMessageType.REPLY
        except TTransport.TTransportException:
            raise
        except IOError as io:
            msg_type = TMessageType.REPLY
            result.io = io
        except IllegalArgument as ia:
            msg_type = TMessageType.REPLY
            result.ia = ia
        except TApplicationException as ex:
            logging.exception('TApplication exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = ex
        except Exception:
            logging.exception('Unexpected exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, 'Internal error')
        oprot.writeMessageBegin("scannerClose", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_getRegionInfo(self, seqid, iprot, oprot):
        args = getRegionInfo_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = getRegionInfo_result()
        try:
            result.success = self._handler.getRegionInfo(args.row)
            msg_type = TMessageType.REPLY
        except TTransport.TTransportException:
            raise
        except IOError as io:
            msg_type = TMessageType.REPLY
            result.io = io
        except TApplicationException as ex:
            logging.exception('TApplication exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = ex
        except Exception:
            logging.exception('Unexpected exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, 'Internal error')
        oprot.writeMessageBegin("getRegionInfo", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_append(self, seqid, iprot, oprot):
        args = append_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = append_result()
        try:
            result.success = self._handler.append(args.append)
            msg_type = TMessageType.REPLY
        except TTransport.TTransportException:
            raise
        except IOError as io:
            msg_type = TMessageType.REPLY
            result.io = io
        except TApplicationException as ex:
            logging.exception('TApplication exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = ex
        except Exception:
            logging.exception('Unexpected exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, 'Internal error')
        oprot.writeMessageBegin("append", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_checkAndPut(self, seqid, iprot, oprot):
        args = checkAndPut_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = checkAndPut_result()
        try:
            result.success = self._handler.checkAndPut(args.tableName, args.row, args.column, args.value, args.mput, args.attributes)
            msg_type = TMessageType.REPLY
        except TTransport.TTransportException:
            raise
        except IOError as io:
            msg_type = TMessageType.REPLY
            result.io = io
        except IllegalArgument as ia:
            msg_type = TMessageType.REPLY
            result.ia = ia
        except TApplicationException as ex:
            logging.exception('TApplication exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = ex
        except Exception:
            logging.exception('Unexpected exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, 'Internal error')
        oprot.writeMessageBegin("checkAndPut", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def process_getThriftServerType(self, seqid, iprot, oprot):
        args = getThriftServerType_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = getThriftServerType_result()
        try:
            result.success = self._handler.getThriftServerType()
            msg_type = TMessageType.REPLY
        except TTransport.TTransportException:
            raise
        except TApplicationException as ex:
            logging.exception('TApplication exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = ex
        except Exception:
            logging.exception('Unexpected exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, 'Internal error')
        oprot.writeMessageBegin("getThriftServerType", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

# HELPER FUNCTIONS AND STRUCTURES


class enableTable_args(object):
    """
    Attributes:
     - tableName: name of the table

    """


    def __init__(self, tableName=None,):
        self.tableName = tableName

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.tableName = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('enableTable_args')
        if self.tableName is not None:
            oprot.writeFieldBegin('tableName', TType.STRING, 1)
            oprot.writeBinary(self.tableName)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(enableTable_args)
enableTable_args.thrift_spec = (
    None,  # 0
    (1, TType.STRING, 'tableName', 'BINARY', None, ),  # 1
)


class enableTable_result(object):
    """
    Attributes:
     - io

    """


    def __init__(self, io=None,):
        self.io = io

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRUCT:
                    self.io = IOError()
                    self.io.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('enableTable_result')
        if self.io is not None:
            oprot.writeFieldBegin('io', TType.STRUCT, 1)
            self.io.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(enableTable_result)
enableTable_result.thrift_spec = (
    None,  # 0
    (1, TType.STRUCT, 'io', [IOError, None], None, ),  # 1
)


class disableTable_args(object):
    """
    Attributes:
     - tableName: name of the table

    """


    def __init__(self, tableName=None,):
        self.tableName = tableName

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.tableName = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('disableTable_args')
        if self.tableName is not None:
            oprot.writeFieldBegin('tableName', TType.STRING, 1)
            oprot.writeBinary(self.tableName)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(disableTable_args)
disableTable_args.thrift_spec = (
    None,  # 0
    (1, TType.STRING, 'tableName', 'BINARY', None, ),  # 1
)


class disableTable_result(object):
    """
    Attributes:
     - io

    """


    def __init__(self, io=None,):
        self.io = io

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRUCT:
                    self.io = IOError()
                    self.io.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('disableTable_result')
        if self.io is not None:
            oprot.writeFieldBegin('io', TType.STRUCT, 1)
            self.io.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(disableTable_result)
disableTable_result.thrift_spec = (
    None,  # 0
    (1, TType.STRUCT, 'io', [IOError, None], None, ),  # 1
)


class isTableEnabled_args(object):
    """
    Attributes:
     - tableName: name of the table to check

    """


    def __init__(self, tableName=None,):
        self.tableName = tableName

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.tableName = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('isTableEnabled_args')
        if self.tableName is not None:
            oprot.writeFieldBegin('tableName', TType.STRING, 1)
            oprot.writeBinary(self.tableName)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(isTableEnabled_args)
isTableEnabled_args.thrift_spec = (
    None,  # 0
    (1, TType.STRING, 'tableName', 'BINARY', None, ),  # 1
)


class isTableEnabled_result(object):
    """
    Attributes:
     - success
     - io

    """


    def __init__(self, success=None, io=None,):
        self.success = success
        self.io = io

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 0:
                if ftype == TType.BOOL:
                    self.success = iprot.readBool()
                else:
                    iprot.skip(ftype)
            elif fid == 1:
                if ftype == TType.STRUCT:
                    self.io = IOError()
                    self.io.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('isTableEnabled_result')
        if self.success is not None:
            oprot.writeFieldBegin('success', TType.BOOL, 0)
            oprot.writeBool(self.success)
            oprot.writeFieldEnd()
        if self.io is not None:
            oprot.writeFieldBegin('io', TType.STRUCT, 1)
            self.io.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(isTableEnabled_result)
isTableEnabled_result.thrift_spec = (
    (0, TType.BOOL, 'success', None, None, ),  # 0
    (1, TType.STRUCT, 'io', [IOError, None], None, ),  # 1
)


class compact_args(object):
    """
    Attributes:
     - tableNameOrRegionName

    """


    def __init__(self, tableNameOrRegionName=None,):
        self.tableNameOrRegionName = tableNameOrRegionName

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.tableNameOrRegionName = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('compact_args')
        if self.tableNameOrRegionName is not None:
            oprot.writeFieldBegin('tableNameOrRegionName', TType.STRING, 1)
            oprot.writeBinary(self.tableNameOrRegionName)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(compact_args)
compact_args.thrift_spec = (
    None,  # 0
    (1, TType.STRING, 'tableNameOrRegionName', 'BINARY', None, ),  # 1
)


class compact_result(object):
    """
    Attributes:
     - io

    """


    def __init__(self, io=None,):
        self.io = io

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRUCT:
                    self.io = IOError()
                    self.io.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('compact_result')
        if self.io is not None:
            oprot.writeFieldBegin('io', TType.STRUCT, 1)
            self.io.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(compact_result)
compact_result.thrift_spec = (
    None,  # 0
    (1, TType.STRUCT, 'io', [IOError, None], None, ),  # 1
)


class majorCompact_args(object):
    """
    Attributes:
     - tableNameOrRegionName

    """


    def __init__(self, tableNameOrRegionName=None,):
        self.tableNameOrRegionName = tableNameOrRegionName

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.tableNameOrRegionName = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('majorCompact_args')
        if self.tableNameOrRegionName is not None:
            oprot.writeFieldBegin('tableNameOrRegionName', TType.STRING, 1)
            oprot.writeBinary(self.tableNameOrRegionName)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(majorCompact_args)
majorCompact_args.thrift_spec = (
    None,  # 0
    (1, TType.STRING, 'tableNameOrRegionName', 'BINARY', None, ),  # 1
)


class majorCompact_result(object):
    """
    Attributes:
     - io

    """


    def __init__(self, io=None,):
        self.io = io

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRUCT:
                    self.io = IOError()
                    self.io.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('majorCompact_result')
        if self.io is not None:
            oprot.writeFieldBegin('io', TType.STRUCT, 1)
            self.io.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(majorCompact_result)
majorCompact_result.thrift_spec = (
    None,  # 0
    (1, TType.STRUCT, 'io', [IOError, None], None, ),  # 1
)


class getTableNames_args(object):


    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('getTableNames_args')
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(getTableNames_args)
getTableNames_args.thrift_spec = (
)


class getTableNames_result(object):
    """
    Attributes:
     - success
     - io

    """


    def __init__(self, success=None, io=None,):
        self.success = success
        self.io = io

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 0:
                if ftype == TType.LIST:
                    self.success = []
                    (_etype47, _size44) = iprot.readListBegin()
                    for _i48 in range(_size44):
                        _elem49 = iprot.readBinary()
                        self.success.append(_elem49)
                    iprot.readListEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 1:
                if ftype == TType.STRUCT:
                    self.io = IOError()
                    self.io.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('getTableNames_result')
        if self.success is not None:
            oprot.writeFieldBegin('success', TType.LIST, 0)
            oprot.writeListBegin(TType.STRING, len(self.success))
            for iter50 in self.success:
                oprot.writeBinary(iter50)
            oprot.writeListEnd()
            oprot.writeFieldEnd()
        if self.io is not None:
            oprot.writeFieldBegin('io', TType.STRUCT, 1)
            self.io.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(getTableNames_result)
getTableNames_result.thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRING, 'BINARY', False), None, ),  # 0
    (1, TType.STRUCT, 'io', [IOError, None], None, ),  # 1
)


class getColumnDescriptors_args(object):
    """
    Attributes:
     - tableName: table name

    """


    def __init__(self, tableName=None,):
        self.tableName = tableName

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.tableName = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('getColumnDescriptors_args')
        if self.tableName is not None:
            oprot.writeFieldBegin('tableName', TType.STRING, 1)
            oprot.writeBinary(self.tableName)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(getColumnDescriptors_args)
getColumnDescriptors_args.thrift_spec = (
    None,  # 0
    (1, TType.STRING, 'tableName', 'BINARY', None, ),  # 1
)


class getColumnDescriptors_result(object):
    """
    Attributes:
     - success
     - io

    """


    def __init__(self, success=None, io=None,):
        self.success = success
        self.io = io

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 0:
                if ftype == TType.MAP:
                    self.success = {}
                    (_ktype52, _vtype53, _size51) = iprot.readMapBegin()
                    for _i55 in range(_size51):
                        _key56 = iprot.readBinary()
                        _val57 = ColumnDescriptor()
                        _val57.read(iprot)
                        self.success[_key56] = _val57
                    iprot.readMapEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 1:
                if ftype == TType.STRUCT:
                    self.io = IOError()
                    self.io.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('getColumnDescriptors_result')
        if self.success is not None:
            oprot.writeFieldBegin('success', TType.MAP, 0)
            oprot.writeMapBegin(TType.STRING, TType.STRUCT, len(self.success))
            for kiter58, viter59 in self.success.items():
                oprot.writeBinary(kiter58)
                viter59.write(oprot)
            oprot.writeMapEnd()
            oprot.writeFieldEnd()
        if self.io is not None:
            oprot.writeFieldBegin('io', TType.STRUCT, 1)
            self.io.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(getColumnDescriptors_result)
getColumnDescriptors_result.thrift_spec = (
    (0, TType.MAP, 'success', (TType.STRING, 'BINARY', TType.STRUCT, [ColumnDescriptor, None], False), None, ),  # 0
    (1, TType.STRUCT, 'io', [IOError, None], None, ),  # 1
)


class getTableRegions_args(object):
    """
    Attributes:
     - tableName: table name

    """


    def __init__(self, tableName=None,):
        self.tableName = tableName

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.tableName = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('getTableRegions_args')
        if self.tableName is not None:
            oprot.writeFieldBegin('tableName', TType.STRING, 1)
            oprot.writeBinary(self.tableName)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(getTableRegions_args)
getTableRegions_args.thrift_spec = (
    None,  # 0
    (1, TType.STRING, 'tableName', 'BINARY', None, ),  # 1
)


class getTableRegions_result(object):
    """
    Attributes:
     - success
     - io

    """


    def __init__(self, success=None, io=None,):
        self.success = success
        self.io = io

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 0:
                if ftype == TType.LIST:
                    self.success = []
                    (_etype63, _size60) = iprot.readListBegin()
                    for _i64 in range(_size60):
                        _elem65 = TRegionInfo()
                        _elem65.read(iprot)
                        self.success.append(_elem65)
                    iprot.readListEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 1:
                if ftype == TType.STRUCT:
                    self.io = IOError()
                    self.io.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('getTableRegions_result')
        if self.success is not None:
            oprot.writeFieldBegin('success', TType.LIST, 0)
            oprot.writeListBegin(TType.STRUCT, len(self.success))
            for iter66 in self.success:
                iter66.write(oprot)
            oprot.writeListEnd()
            oprot.writeFieldEnd()
        if self.io is not None:
            oprot.writeFieldBegin('io', TType.STRUCT, 1)
            self.io.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(getTableRegions_result)
getTableRegions_result.thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRUCT, [TRegionInfo, None], False), None, ),  # 0
    (1, TType.STRUCT, 'io', [IOError, None], None, ),  # 1
)


class createTable_args(object):
    """
    Attributes:
     - tableName: name of table to create
     - columnFamilies: list of column family descriptors

    """


    def __init__(self, tableName=None, columnFamilies=None,):
        self.tableName = tableName
        self.columnFamilies = columnFamilies

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.tableName = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.LIST:
                    self.columnFamilies = []
                    (_etype70, _size67) = iprot.readListBegin()
                    for _i71 in range(_size67):
                        _elem72 = ColumnDescriptor()
                        _elem72.read(iprot)
                        self.columnFamilies.append(_elem72)
                    iprot.readListEnd()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('createTable_args')
        if self.tableName is not None:
            oprot.writeFieldBegin('tableName', TType.STRING, 1)
            oprot.writeBinary(self.tableName)
            oprot.writeFieldEnd()
        if self.columnFamilies is not None:
            oprot.writeFieldBegin('columnFamilies', TType.LIST, 2)
            oprot.writeListBegin(TType.STRUCT, len(self.columnFamilies))
            for iter73 in self.columnFamilies:
                iter73.write(oprot)
            oprot.writeListEnd()
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(createTable_args)
createTable_args.thrift_spec = (
    None,  # 0
    (1, TType.STRING, 'tableName', 'BINARY', None, ),  # 1
    (2, TType.LIST, 'columnFamilies', (TType.STRUCT, [ColumnDescriptor, None], False), None, ),  # 2
)


class createTable_result(object):
    """
    Attributes:
     - io
     - ia
     - exist

    """


    def __init__(self, io=None, ia=None, exist=None,):
        self.io = io
        self.ia = ia
        self.exist = exist

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRUCT:
                    self.io = IOError()
                    self.io.read(iprot)
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.STRUCT:
                    self.ia = IllegalArgument()
                    self.ia.read(iprot)
                else:
                    iprot.skip(ftype)
            elif fid == 3:
                if ftype == TType.STRUCT:
                    self.exist = AlreadyExists()
                    self.exist.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('createTable_result')
        if self.io is not None:
            oprot.writeFieldBegin('io', TType.STRUCT, 1)
            self.io.write(oprot)
            oprot.writeFieldEnd()
        if self.ia is not None:
            oprot.writeFieldBegin('ia', TType.STRUCT, 2)
            self.ia.write(oprot)
            oprot.writeFieldEnd()
        if self.exist is not None:
            oprot.writeFieldBegin('exist', TType.STRUCT, 3)
            self.exist.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(createTable_result)
createTable_result.thrift_spec = (
    None,  # 0
    (1, TType.STRUCT, 'io', [IOError, None], None, ),  # 1
    (2, TType.STRUCT, 'ia', [IllegalArgument, None], None, ),  # 2
    (3, TType.STRUCT, 'exist', [AlreadyExists, None], None, ),  # 3
)


class deleteTable_args(object):
    """
    Attributes:
     - tableName: name of table to delete

    """


    def __init__(self, tableName=None,):
        self.tableName = tableName

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.tableName = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('deleteTable_args')
        if self.tableName is not None:
            oprot.writeFieldBegin('tableName', TType.STRING, 1)
            oprot.writeBinary(self.tableName)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(deleteTable_args)
deleteTable_args.thrift_spec = (
    None,  # 0
    (1, TType.STRING, 'tableName', 'BINARY', None, ),  # 1
)


class deleteTable_result(object):
    """
    Attributes:
     - io

    """


    def __init__(self, io=None,):
        self.io = io

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRUCT:
                    self.io = IOError()
                    self.io.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('deleteTable_result')
        if self.io is not None:
            oprot.writeFieldBegin('io', TType.STRUCT, 1)
            self.io.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(deleteTable_result)
deleteTable_result.thrift_spec = (
    None,  # 0
    (1, TType.STRUCT, 'io', [IOError, None], None, ),  # 1
)


class get_args(object):
    """
    Attributes:
     - tableName: name of table
     - row: row key
     - column: column name
     - attributes: Get attributes

    """


    def __init__(self, tableName=None, row=None, column=None, attributes=None,):
        self.tableName = tableName
        self.row = row
        self.column = column
        self.attributes = attributes

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.tableName = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.STRING:
                    self.row = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            elif fid == 3:
                if ftype == TType.STRING:
                    self.column = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            elif fid == 4:
                if ftype == TType.MAP:
                    self.attributes = {}
                    (_ktype75, _vtype76, _size74) = iprot.readMapBegin()
                    for _i78 in range(_size74):
                        _key79 = iprot.readBinary()
                        _val80 = iprot.readBinary()
                        self.attributes[_key79] = _val80
                    iprot.readMapEnd()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('get_args')
        if self.tableName is not None:
            oprot.writeFieldBegin('tableName', TType.STRING, 1)
            oprot.writeBinary(self.tableName)
            oprot.writeFieldEnd()
        if self.row is not None:
            oprot.writeFieldBegin('row', TType.STRING, 2)
            oprot.writeBinary(self.row)
            oprot.writeFieldEnd()
        if self.column is not None:
            oprot.writeFieldBegin('column', TType.STRING, 3)
            oprot.writeBinary(self.column)
            oprot.writeFieldEnd()
        if self.attributes is not None:
            oprot.writeFieldBegin('attributes', TType.MAP, 4)
            oprot.writeMapBegin(TType.STRING, TType.STRING, len(self.attributes))
            for kiter81, viter82 in self.attributes.items():
                oprot.writeBinary(kiter81)
                oprot.writeBinary(viter82)
            oprot.writeMapEnd()
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(get_args)
get_args.thrift_spec = (
    None,  # 0
    (1, TType.STRING, 'tableName', 'BINARY', None, ),  # 1
    (2, TType.STRING, 'row', 'BINARY', None, ),  # 2
    (3, TType.STRING, 'column', 'BINARY', None, ),  # 3
    (4, TType.MAP, 'attributes', (TType.STRING, 'BINARY', TType.STRING, 'BINARY', False), None, ),  # 4
)


class get_result(object):
    """
    Attributes:
     - success
     - io

    """


    def __init__(self, success=None, io=None,):
        self.success = success
        self.io = io

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 0:
                if ftype == TType.LIST:
                    self.success = []
                    (_etype86, _size83) = iprot.readListBegin()
                    for _i87 in range(_size83):
                        _elem88 = TCell()
                        _elem88.read(iprot)
                        self.success.append(_elem88)
                    iprot.readListEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 1:
                if ftype == TType.STRUCT:
                    self.io = IOError()
                    self.io.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('get_result')
        if self.success is not None:
            oprot.writeFieldBegin('success', TType.LIST, 0)
            oprot.writeListBegin(TType.STRUCT, len(self.success))
            for iter89 in self.success:
                iter89.write(oprot)
            oprot.writeListEnd()
            oprot.writeFieldEnd()
        if self.io is not None:
            oprot.writeFieldBegin('io', TType.STRUCT, 1)
            self.io.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(get_result)
get_result.thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRUCT, [TCell, None], False), None, ),  # 0
    (1, TType.STRUCT, 'io', [IOError, None], None, ),  # 1
)


class getVer_args(object):
    """
    Attributes:
     - tableName: name of table
     - row: row key
     - column: column name
     - numVersions: number of versions to retrieve
     - attributes: Get attributes

    """


    def __init__(self, tableName=None, row=None, column=None, numVersions=None, attributes=None,):
        self.tableName = tableName
        self.row = row
        self.column = column
        self.numVersions = numVersions
        self.attributes = attributes

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.tableName = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.STRING:
                    self.row = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            elif fid == 3:
                if ftype == TType.STRING:
                    self.column = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            elif fid == 4:
                if ftype == TType.I32:
                    self.numVersions = iprot.readI32()
                else:
                    iprot.skip(ftype)
            elif fid == 5:
                if ftype == TType.MAP:
                    self.attributes = {}
                    (_ktype91, _vtype92, _size90) = iprot.readMapBegin()
                    for _i94 in range(_size90):
                        _key95 = iprot.readBinary()
                        _val96 = iprot.readBinary()
                        self.attributes[_key95] = _val96
                    iprot.readMapEnd()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('getVer_args')
        if self.tableName is not None:
            oprot.writeFieldBegin('tableName', TType.STRING, 1)
            oprot.writeBinary(self.tableName)
            oprot.writeFieldEnd()
        if self.row is not None:
            oprot.writeFieldBegin('row', TType.STRING, 2)
            oprot.writeBinary(self.row)
            oprot.writeFieldEnd()
        if self.column is not None:
            oprot.writeFieldBegin('column', TType.STRING, 3)
            oprot.writeBinary(self.column)
            oprot.writeFieldEnd()
        if self.numVersions is not None:
            oprot.writeFieldBegin('numVersions', TType.I32, 4)
            oprot.writeI32(self.numVersions)
            oprot.writeFieldEnd()
        if self.attributes is not None:
            oprot.writeFieldBegin('attributes', TType.MAP, 5)
            oprot.writeMapBegin(TType.STRING, TType.STRING, len(self.attributes))
            for kiter97, viter98 in self.attributes.items():
                oprot.writeBinary(kiter97)
                oprot.writeBinary(viter98)
            oprot.writeMapEnd()
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(getVer_args)
getVer_args.thrift_spec = (
    None,  # 0
    (1, TType.STRING, 'tableName', 'BINARY', None, ),  # 1
    (2, TType.STRING, 'row', 'BINARY', None, ),  # 2
    (3, TType.STRING, 'column', 'BINARY', None, ),  # 3
    (4, TType.I32, 'numVersions', None, None, ),  # 4
    (5, TType.MAP, 'attributes', (TType.STRING, 'BINARY', TType.STRING, 'BINARY', False), None, ),  # 5
)


class getVer_result(object):
    """
    Attributes:
     - success
     - io

    """


    def __init__(self, success=None, io=None,):
        self.success = success
        self.io = io

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 0:
                if ftype == TType.LIST:
                    self.success = []
                    (_etype102, _size99) = iprot.readListBegin()
                    for _i103 in range(_size99):
                        _elem104 = TCell()
                        _elem104.read(iprot)
                        self.success.append(_elem104)
                    iprot.readListEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 1:
                if ftype == TType.STRUCT:
                    self.io = IOError()
                    self.io.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('getVer_result')
        if self.success is not None:
            oprot.writeFieldBegin('success', TType.LIST, 0)
            oprot.writeListBegin(TType.STRUCT, len(self.success))
            for iter105 in self.success:
                iter105.write(oprot)
            oprot.writeListEnd()
            oprot.writeFieldEnd()
        if self.io is not None:
            oprot.writeFieldBegin('io', TType.STRUCT, 1)
            self.io.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(getVer_result)
getVer_result.thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRUCT, [TCell, None], False), None, ),  # 0
    (1, TType.STRUCT, 'io', [IOError, None], None, ),  # 1
)


class getVerTs_args(object):
    """
    Attributes:
     - tableName: name of table
     - row: row key
     - column: column name
     - timestamp: timestamp
     - numVersions: number of versions to retrieve
     - attributes: Get attributes

    """


    def __init__(self, tableName=None, row=None, column=None, timestamp=None, numVersions=None, attributes=None,):
        self.tableName = tableName
        self.row = row
        self.column = column
        self.timestamp = timestamp
        self.numVersions = numVersions
        self.attributes = attributes

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.tableName = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.STRING:
                    self.row = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            elif fid == 3:
                if ftype == TType.STRING:
                    self.column = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            elif fid == 4:
                if ftype == TType.I64:
                    self.timestamp = iprot.readI64()
                else:
                    iprot.skip(ftype)
            elif fid == 5:
                if ftype == TType.I32:
                    self.numVersions = iprot.readI32()
                else:
                    iprot.skip(ftype)
            elif fid == 6:
                if ftype == TType.MAP:
                    self.attributes = {}
                    (_ktype107, _vtype108, _size106) = iprot.readMapBegin()
                    for _i110 in range(_size106):
                        _key111 = iprot.readBinary()
                        _val112 = iprot.readBinary()
                        self.attributes[_key111] = _val112
                    iprot.readMapEnd()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('getVerTs_args')
        if self.tableName is not None:
            oprot.writeFieldBegin('tableName', TType.STRING, 1)
            oprot.writeBinary(self.tableName)
            oprot.writeFieldEnd()
        if self.row is not None:
            oprot.writeFieldBegin('row', TType.STRING, 2)
            oprot.writeBinary(self.row)
            oprot.writeFieldEnd()
        if self.column is not None:
            oprot.writeFieldBegin('column', TType.STRING, 3)
            oprot.writeBinary(self.column)
            oprot.writeFieldEnd()
        if self.timestamp is not None:
            oprot.writeFieldBegin('timestamp', TType.I64, 4)
            oprot.writeI64(self.timestamp)
            oprot.writeFieldEnd()
        if self.numVersions is not None:
            oprot.writeFieldBegin('numVersions', TType.I32, 5)
            oprot.writeI32(self.numVersions)
            oprot.writeFieldEnd()
        if self.attributes is not None:
            oprot.writeFieldBegin('attributes', TType.MAP, 6)
            oprot.writeMapBegin(TType.STRING, TType.STRING, len(self.attributes))
            for kiter113, viter114 in self.attributes.items():
                oprot.writeBinary(kiter113)
                oprot.writeBinary(viter114)
            oprot.writeMapEnd()
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(getVerTs_args)
getVerTs_args.thrift_spec = (
    None,  # 0
    (1, TType.STRING, 'tableName', 'BINARY', None, ),  # 1
    (2, TType.STRING, 'row', 'BINARY', None, ),  # 2
    (3, TType.STRING, 'column', 'BINARY', None, ),  # 3
    (4, TType.I64, 'timestamp', None, None, ),  # 4
    (5, TType.I32, 'numVersions', None, None, ),  # 5
    (6, TType.MAP, 'attributes', (TType.STRING, 'BINARY', TType.STRING, 'BINARY', False), None, ),  # 6
)


class getVerTs_result(object):
    """
    Attributes:
     - success
     - io

    """


    def __init__(self, success=None, io=None,):
        self.success = success
        self.io = io

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 0:
                if ftype == TType.LIST:
                    self.success = []
                    (_etype118, _size115) = iprot.readListBegin()
                    for _i119 in range(_size115):
                        _elem120 = TCell()
                        _elem120.read(iprot)
                        self.success.append(_elem120)
                    iprot.readListEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 1:
                if ftype == TType.STRUCT:
                    self.io = IOError()
                    self.io.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('getVerTs_result')
        if self.success is not None:
            oprot.writeFieldBegin('success', TType.LIST, 0)
            oprot.writeListBegin(TType.STRUCT, len(self.success))
            for iter121 in self.success:
                iter121.write(oprot)
            oprot.writeListEnd()
            oprot.writeFieldEnd()
        if self.io is not None:
            oprot.writeFieldBegin('io', TType.STRUCT, 1)
            self.io.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(getVerTs_result)
getVerTs_result.thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRUCT, [TCell, None], False), None, ),  # 0
    (1, TType.STRUCT, 'io', [IOError, None], None, ),  # 1
)


class getRow_args(object):
    """
    Attributes:
     - tableName: name of table
     - row: row key
     - attributes: Get attributes

    """


    def __init__(self, tableName=None, row=None, attributes=None,):
        self.tableName = tableName
        self.row = row
        self.attributes = attributes

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.tableName = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.STRING:
                    self.row = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            elif fid == 3:
                if ftype == TType.MAP:
                    self.attributes = {}
                    (_ktype123, _vtype124, _size122) = iprot.readMapBegin()
                    for _i126 in range(_size122):
                        _key127 = iprot.readBinary()
                        _val128 = iprot.readBinary()
                        self.attributes[_key127] = _val128
                    iprot.readMapEnd()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('getRow_args')
        if self.tableName is not None:
            oprot.writeFieldBegin('tableName', TType.STRING, 1)
            oprot.writeBinary(self.tableName)
            oprot.writeFieldEnd()
        if self.row is not None:
            oprot.writeFieldBegin('row', TType.STRING, 2)
            oprot.writeBinary(self.row)
            oprot.writeFieldEnd()
        if self.attributes is not None:
            oprot.writeFieldBegin('attributes', TType.MAP, 3)
            oprot.writeMapBegin(TType.STRING, TType.STRING, len(self.attributes))
            for kiter129, viter130 in self.attributes.items():
                oprot.writeBinary(kiter129)
                oprot.writeBinary(viter130)
            oprot.writeMapEnd()
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(getRow_args)
getRow_args.thrift_spec = (
    None,  # 0
    (1, TType.STRING, 'tableName', 'BINARY', None, ),  # 1
    (2, TType.STRING, 'row', 'BINARY', None, ),  # 2
    (3, TType.MAP, 'attributes', (TType.STRING, 'BINARY', TType.STRING, 'BINARY', False), None, ),  # 3
)


class getRow_result(object):
    """
    Attributes:
     - success
     - io

    """


    def __init__(self, success=None, io=None,):
        self.success = success
        self.io = io

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 0:
                if ftype == TType.LIST:
                    self.success = []
                    (_etype134, _size131) = iprot.readListBegin()
                    for _i135 in range(_size131):
                        _elem136 = TRowResult()
                        _elem136.read(iprot)
                        self.success.append(_elem136)
                    iprot.readListEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 1:
                if ftype == TType.STRUCT:
                    self.io = IOError()
                    self.io.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('getRow_result')
        if self.success is not None:
            oprot.writeFieldBegin('success', TType.LIST, 0)
            oprot.writeListBegin(TType.STRUCT, len(self.success))
            for iter137 in self.success:
                iter137.write(oprot)
            oprot.writeListEnd()
            oprot.writeFieldEnd()
        if self.io is not None:
            oprot.writeFieldBegin('io', TType.STRUCT, 1)
            self.io.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(getRow_result)
getRow_result.thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRUCT, [TRowResult, None], False), None, ),  # 0
    (1, TType.STRUCT, 'io', [IOError, None], None, ),  # 1
)


class getRowWithColumns_args(object):
    """
    Attributes:
     - tableName: name of table
     - row: row key
     - columns: List of columns to return, null for all columns
     - attributes: Get attributes

    """


    def __init__(self, tableName=None, row=None, columns=None, attributes=None,):
        self.tableName = tableName
        self.row = row
        self.columns = columns
        self.attributes = attributes

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.tableName = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.STRING:
                    self.row = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            elif fid == 3:
                if ftype == TType.LIST:
                    self.columns = []
                    (_etype141, _size138) = iprot.readListBegin()
                    for _i142 in range(_size138):
                        _elem143 = iprot.readBinary()
                        self.columns.append(_elem143)
                    iprot.readListEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 4:
                if ftype == TType.MAP:
                    self.attributes = {}
                    (_ktype145, _vtype146, _size144) = iprot.readMapBegin()
                    for _i148 in range(_size144):
                        _key149 = iprot.readBinary()
                        _val150 = iprot.readBinary()
                        self.attributes[_key149] = _val150
                    iprot.readMapEnd()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('getRowWithColumns_args')
        if self.tableName is not None:
            oprot.writeFieldBegin('tableName', TType.STRING, 1)
            oprot.writeBinary(self.tableName)
            oprot.writeFieldEnd()
        if self.row is not None:
            oprot.writeFieldBegin('row', TType.STRING, 2)
            oprot.writeBinary(self.row)
            oprot.writeFieldEnd()
        if self.columns is not None:
            oprot.writeFieldBegin('columns', TType.LIST, 3)
            oprot.writeListBegin(TType.STRING, len(self.columns))
            for iter151 in self.columns:
                oprot.writeBinary(iter151)
            oprot.writeListEnd()
            oprot.writeFieldEnd()
        if self.attributes is not None:
            oprot.writeFieldBegin('attributes', TType.MAP, 4)
            oprot.writeMapBegin(TType.STRING, TType.STRING, len(self.attributes))
            for kiter152, viter153 in self.attributes.items():
                oprot.writeBinary(kiter152)
                oprot.writeBinary(viter153)
            oprot.writeMapEnd()
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(getRowWithColumns_args)
getRowWithColumns_args.thrift_spec = (
    None,  # 0
    (1, TType.STRING, 'tableName', 'BINARY', None, ),  # 1
    (2, TType.STRING, 'row', 'BINARY', None, ),  # 2
    (3, TType.LIST, 'columns', (TType.STRING, 'BINARY', False), None, ),  # 3
    (4, TType.MAP, 'attributes', (TType.STRING, 'BINARY', TType.STRING, 'BINARY', False), None, ),  # 4
)


class getRowWithColumns_result(object):
    """
    Attributes:
     - success
     - io

    """


    def __init__(self, success=None, io=None,):
        self.success = success
        self.io = io

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 0:
                if ftype == TType.LIST:
                    self.success = []
                    (_etype157, _size154) = iprot.readListBegin()
                    for _i158 in range(_size154):
                        _elem159 = TRowResult()
                        _elem159.read(iprot)
                        self.success.append(_elem159)
                    iprot.readListEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 1:
                if ftype == TType.STRUCT:
                    self.io = IOError()
                    self.io.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('getRowWithColumns_result')
        if self.success is not None:
            oprot.writeFieldBegin('success', TType.LIST, 0)
            oprot.writeListBegin(TType.STRUCT, len(self.success))
            for iter160 in self.success:
                iter160.write(oprot)
            oprot.writeListEnd()
            oprot.writeFieldEnd()
        if self.io is not None:
            oprot.writeFieldBegin('io', TType.STRUCT, 1)
            self.io.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(getRowWithColumns_result)
getRowWithColumns_result.thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRUCT, [TRowResult, None], False), None, ),  # 0
    (1, TType.STRUCT, 'io', [IOError, None], None, ),  # 1
)


class getRowTs_args(object):
    """
    Attributes:
     - tableName: name of the table
     - row: row key
     - timestamp: timestamp
     - attributes: Get attributes

    """


    def __init__(self, tableName=None, row=None, timestamp=None, attributes=None,):
        self.tableName = tableName
        self.row = row
        self.timestamp = timestamp
        self.attributes = attributes

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.tableName = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.STRING:
                    self.row = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            elif fid == 3:
                if ftype == TType.I64:
                    self.timestamp = iprot.readI64()
                else:
                    iprot.skip(ftype)
            elif fid == 4:
                if ftype == TType.MAP:
                    self.attributes = {}
                    (_ktype162, _vtype163, _size161) = iprot.readMapBegin()
                    for _i165 in range(_size161):
                        _key166 = iprot.readBinary()
                        _val167 = iprot.readBinary()
                        self.attributes[_key166] = _val167
                    iprot.readMapEnd()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('getRowTs_args')
        if self.tableName is not None:
            oprot.writeFieldBegin('tableName', TType.STRING, 1)
            oprot.writeBinary(self.tableName)
            oprot.writeFieldEnd()
        if self.row is not None:
            oprot.writeFieldBegin('row', TType.STRING, 2)
            oprot.writeBinary(self.row)
            oprot.writeFieldEnd()
        if self.timestamp is not None:
            oprot.writeFieldBegin('timestamp', TType.I64, 3)
            oprot.writeI64(self.timestamp)
            oprot.writeFieldEnd()
        if self.attributes is not None:
            oprot.writeFieldBegin('attributes', TType.MAP, 4)
            oprot.writeMapBegin(TType.STRING, TType.STRING, len(self.attributes))
            for kiter168, viter169 in self.attributes.items():
                oprot.writeBinary(kiter168)
                oprot.writeBinary(viter169)
            oprot.writeMapEnd()
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(getRowTs_args)
getRowTs_args.thrift_spec = (
    None,  # 0
    (1, TType.STRING, 'tableName', 'BINARY', None, ),  # 1
    (2, TType.STRING, 'row', 'BINARY', None, ),  # 2
    (3, TType.I64, 'timestamp', None, None, ),  # 3
    (4, TType.MAP, 'attributes', (TType.STRING, 'BINARY', TType.STRING, 'BINARY', False), None, ),  # 4
)


class getRowTs_result(object):
    """
    Attributes:
     - success
     - io

    """


    def __init__(self, success=None, io=None,):
        self.success = success
        self.io = io

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 0:
                if ftype == TType.LIST:
                    self.success = []
                    (_etype173, _size170) = iprot.readListBegin()
                    for _i174 in range(_size170):
                        _elem175 = TRowResult()
                        _elem175.read(iprot)
                        self.success.append(_elem175)
                    iprot.readListEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 1:
                if ftype == TType.STRUCT:
                    self.io = IOError()
                    self.io.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('getRowTs_result')
        if self.success is not None:
            oprot.writeFieldBegin('success', TType.LIST, 0)
            oprot.writeListBegin(TType.STRUCT, len(self.success))
            for iter176 in self.success:
                iter176.write(oprot)
            oprot.writeListEnd()
            oprot.writeFieldEnd()
        if self.io is not None:
            oprot.writeFieldBegin('io', TType.STRUCT, 1)
            self.io.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(getRowTs_result)
getRowTs_result.thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRUCT, [TRowResult, None], False), None, ),  # 0
    (1, TType.STRUCT, 'io', [IOError, None], None, ),  # 1
)


class getRowWithColumnsTs_args(object):
    """
    Attributes:
     - tableName: name of table
     - row: row key
     - columns: List of columns to return, null for all columns
     - timestamp
     - attributes: Get attributes

    """


    def __init__(self, tableName=None, row=None, columns=None, timestamp=None, attributes=None,):
        self.tableName = tableName
        self.row = row
        self.columns = columns
        self.timestamp = timestamp
        self.attributes = attributes

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.tableName = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.STRING:
                    self.row = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            elif fid == 3:
                if ftype == TType.LIST:
                    self.columns = []
                    (_etype180, _size177) = iprot.readListBegin()
                    for _i181 in range(_size177):
                        _elem182 = iprot.readBinary()
                        self.columns.append(_elem182)
                    iprot.readListEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 4:
                if ftype == TType.I64:
                    self.timestamp = iprot.readI64()
                else:
                    iprot.skip(ftype)
            elif fid == 5:
                if ftype == TType.MAP:
                    self.attributes = {}
                    (_ktype184, _vtype185, _size183) = iprot.readMapBegin()
                    for _i187 in range(_size183):
                        _key188 = iprot.readBinary()
                        _val189 = iprot.readBinary()
                        self.attributes[_key188] = _val189
                    iprot.readMapEnd()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('getRowWithColumnsTs_args')
        if self.tableName is not None:
            oprot.writeFieldBegin('tableName', TType.STRING, 1)
            oprot.writeBinary(self.tableName)
            oprot.writeFieldEnd()
        if self.row is not None:
            oprot.writeFieldBegin('row', TType.STRING, 2)
            oprot.writeBinary(self.row)
            oprot.writeFieldEnd()
        if self.columns is not None:
            oprot.writeFieldBegin('columns', TType.LIST, 3)
            oprot.writeListBegin(TType.STRING, len(self.columns))
            for iter190 in self.columns:
                oprot.writeBinary(iter190)
            oprot.writeListEnd()
            oprot.writeFieldEnd()
        if self.timestamp is not None:
            oprot.writeFieldBegin('timestamp', TType.I64, 4)
            oprot.writeI64(self.timestamp)
            oprot.writeFieldEnd()
        if self.attributes is not None:
            oprot.writeFieldBegin('attributes', TType.MAP, 5)
            oprot.writeMapBegin(TType.STRING, TType.STRING, len(self.attributes))
            for kiter191, viter192 in self.attributes.items():
                oprot.writeBinary(kiter191)
                oprot.writeBinary(viter192)
            oprot.writeMapEnd()
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(getRowWithColumnsTs_args)
getRowWithColumnsTs_args.thrift_spec = (
    None,  # 0
    (1, TType.STRING, 'tableName', 'BINARY', None, ),  # 1
    (2, TType.STRING, 'row', 'BINARY', None, ),  # 2
    (3, TType.LIST, 'columns', (TType.STRING, 'BINARY', False), None, ),  # 3
    (4, TType.I64, 'timestamp', None, None, ),  # 4
    (5, TType.MAP, 'attributes', (TType.STRING, 'BINARY', TType.STRING, 'BINARY', False), None, ),  # 5
)


class getRowWithColumnsTs_result(object):
    """
    Attributes:
     - success
     - io

    """


    def __init__(self, success=None, io=None,):
        self.success = success
        self.io = io

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 0:
                if ftype == TType.LIST:
                    self.success = []
                    (_etype196, _size193) = iprot.readListBegin()
                    for _i197 in range(_size193):
                        _elem198 = TRowResult()
                        _elem198.read(iprot)
                        self.success.append(_elem198)
                    iprot.readListEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 1:
                if ftype == TType.STRUCT:
                    self.io = IOError()
                    self.io.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('getRowWithColumnsTs_result')
        if self.success is not None:
            oprot.writeFieldBegin('success', TType.LIST, 0)
            oprot.writeListBegin(TType.STRUCT, len(self.success))
            for iter199 in self.success:
                iter199.write(oprot)
            oprot.writeListEnd()
            oprot.writeFieldEnd()
        if self.io is not None:
            oprot.writeFieldBegin('io', TType.STRUCT, 1)
            self.io.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(getRowWithColumnsTs_result)
getRowWithColumnsTs_result.thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRUCT, [TRowResult, None], False), None, ),  # 0
    (1, TType.STRUCT, 'io', [IOError, None], None, ),  # 1
)


class getRows_args(object):
    """
    Attributes:
     - tableName: name of table
     - rows: row keys
     - attributes: Get attributes

    """


    def __init__(self, tableName=None, rows=None, attributes=None,):
        self.tableName = tableName
        self.rows = rows
        self.attributes = attributes

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.tableName = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.LIST:
                    self.rows = []
                    (_etype203, _size200) = iprot.readListBegin()
                    for _i204 in range(_size200):
                        _elem205 = iprot.readBinary()
                        self.rows.append(_elem205)
                    iprot.readListEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 3:
                if ftype == TType.MAP:
                    self.attributes = {}
                    (_ktype207, _vtype208, _size206) = iprot.readMapBegin()
                    for _i210 in range(_size206):
                        _key211 = iprot.readBinary()
                        _val212 = iprot.readBinary()
                        self.attributes[_key211] = _val212
                    iprot.readMapEnd()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('getRows_args')
        if self.tableName is not None:
            oprot.writeFieldBegin('tableName', TType.STRING, 1)
            oprot.writeBinary(self.tableName)
            oprot.writeFieldEnd()
        if self.rows is not None:
            oprot.writeFieldBegin('rows', TType.LIST, 2)
            oprot.writeListBegin(TType.STRING, len(self.rows))
            for iter213 in self.rows:
                oprot.writeBinary(iter213)
            oprot.writeListEnd()
            oprot.writeFieldEnd()
        if self.attributes is not None:
            oprot.writeFieldBegin('attributes', TType.MAP, 3)
            oprot.writeMapBegin(TType.STRING, TType.STRING, len(self.attributes))
            for kiter214, viter215 in self.attributes.items():
                oprot.writeBinary(kiter214)
                oprot.writeBinary(viter215)
            oprot.writeMapEnd()
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(getRows_args)
getRows_args.thrift_spec = (
    None,  # 0
    (1, TType.STRING, 'tableName', 'BINARY', None, ),  # 1
    (2, TType.LIST, 'rows', (TType.STRING, 'BINARY', False), None, ),  # 2
    (3, TType.MAP, 'attributes', (TType.STRING, 'BINARY', TType.STRING, 'BINARY', False), None, ),  # 3
)


class getRows_result(object):
    """
    Attributes:
     - success
     - io

    """


    def __init__(self, success=None, io=None,):
        self.success = success
        self.io = io

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 0:
                if ftype == TType.LIST:
                    self.success = []
                    (_etype219, _size216) = iprot.readListBegin()
                    for _i220 in range(_size216):
                        _elem221 = TRowResult()
                        _elem221.read(iprot)
                        self.success.append(_elem221)
                    iprot.readListEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 1:
                if ftype == TType.STRUCT:
                    self.io = IOError()
                    self.io.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('getRows_result')
        if self.success is not None:
            oprot.writeFieldBegin('success', TType.LIST, 0)
            oprot.writeListBegin(TType.STRUCT, len(self.success))
            for iter222 in self.success:
                iter222.write(oprot)
            oprot.writeListEnd()
            oprot.writeFieldEnd()
        if self.io is not None:
            oprot.writeFieldBegin('io', TType.STRUCT, 1)
            self.io.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(getRows_result)
getRows_result.thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRUCT, [TRowResult, None], False), None, ),  # 0
    (1, TType.STRUCT, 'io', [IOError, None], None, ),  # 1
)


class getRowsWithColumns_args(object):
    """
    Attributes:
     - tableName: name of table
     - rows: row keys
     - columns: List of columns to return, null for all columns
     - attributes: Get attributes

    """


    def __init__(self, tableName=None, rows=None, columns=None, attributes=None,):
        self.tableName = tableName
        self.rows = rows
        self.columns = columns
        self.attributes = attributes

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.tableName = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.LIST:
                    self.rows = []
                    (_etype226, _size223) = iprot.readListBegin()
                    for _i227 in range(_size223):
                        _elem228 = iprot.readBinary()
                        self.rows.append(_elem228)
                    iprot.readListEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 3:
                if ftype == TType.LIST:
                    self.columns = []
                    (_etype232, _size229) = iprot.readListBegin()
                    for _i233 in range(_size229):
                        _elem234 = iprot.readBinary()
                        self.columns.append(_elem234)
                    iprot.readListEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 4:
                if ftype == TType.MAP:
                    self.attributes = {}
                    (_ktype236, _vtype237, _size235) = iprot.readMapBegin()
                    for _i239 in range(_size235):
                        _key240 = iprot.readBinary()
                        _val241 = iprot.readBinary()
                        self.attributes[_key240] = _val241
                    iprot.readMapEnd()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('getRowsWithColumns_args')
        if self.tableName is not None:
            oprot.writeFieldBegin('tableName', TType.STRING, 1)
            oprot.writeBinary(self.tableName)
            oprot.writeFieldEnd()
        if self.rows is not None:
            oprot.writeFieldBegin('rows', TType.LIST, 2)
            oprot.writeListBegin(TType.STRING, len(self.rows))
            for iter242 in self.rows:
                oprot.writeBinary(iter242)
            oprot.writeListEnd()
            oprot.writeFieldEnd()
        if self.columns is not None:
            oprot.writeFieldBegin('columns', TType.LIST, 3)
            oprot.writeListBegin(TType.STRING, len(self.columns))
            for iter243 in self.columns:
                oprot.writeBinary(iter243)
            oprot.writeListEnd()
            oprot.writeFieldEnd()
        if self.attributes is not None:
            oprot.writeFieldBegin('attributes', TType.MAP, 4)
            oprot.writeMapBegin(TType.STRING, TType.STRING, len(self.attributes))
            for kiter244, viter245 in self.attributes.items():
                oprot.writeBinary(kiter244)
                oprot.writeBinary(viter245)
            oprot.writeMapEnd()
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(getRowsWithColumns_args)
getRowsWithColumns_args.thrift_spec = (
    None,  # 0
    (1, TType.STRING, 'tableName', 'BINARY', None, ),  # 1
    (2, TType.LIST, 'rows', (TType.STRING, 'BINARY', False), None, ),  # 2
    (3, TType.LIST, 'columns', (TType.STRING, 'BINARY', False), None, ),  # 3
    (4, TType.MAP, 'attributes', (TType.STRING, 'BINARY', TType.STRING, 'BINARY', False), None, ),  # 4
)


class getRowsWithColumns_result(object):
    """
    Attributes:
     - success
     - io

    """


    def __init__(self, success=None, io=None,):
        self.success = success
        self.io = io

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 0:
                if ftype == TType.LIST:
                    self.success = []
                    (_etype249, _size246) = iprot.readListBegin()
                    for _i250 in range(_size246):
                        _elem251 = TRowResult()
                        _elem251.read(iprot)
                        self.success.append(_elem251)
                    iprot.readListEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 1:
                if ftype == TType.STRUCT:
                    self.io = IOError()
                    self.io.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('getRowsWithColumns_result')
        if self.success is not None:
            oprot.writeFieldBegin('success', TType.LIST, 0)
            oprot.writeListBegin(TType.STRUCT, len(self.success))
            for iter252 in self.success:
                iter252.write(oprot)
            oprot.writeListEnd()
            oprot.writeFieldEnd()
        if self.io is not None:
            oprot.writeFieldBegin('io', TType.STRUCT, 1)
            self.io.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(getRowsWithColumns_result)
getRowsWithColumns_result.thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRUCT, [TRowResult, None], False), None, ),  # 0
    (1, TType.STRUCT, 'io', [IOError, None], None, ),  # 1
)


class getRowsTs_args(object):
    """
    Attributes:
     - tableName: name of the table
     - rows: row keys
     - timestamp: timestamp
     - attributes: Get attributes

    """


    def __init__(self, tableName=None, rows=None, timestamp=None, attributes=None,):
        self.tableName = tableName
        self.rows = rows
        self.timestamp = timestamp
        self.attributes = attributes

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.tableName = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.LIST:
                    self.rows = []
                    (_etype256, _size253) = iprot.readListBegin()
                    for _i257 in range(_size253):
                        _elem258 = iprot.readBinary()
                        self.rows.append(_elem258)
                    iprot.readListEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 3:
                if ftype == TType.I64:
                    self.timestamp = iprot.readI64()
                else:
                    iprot.skip(ftype)
            elif fid == 4:
                if ftype == TType.MAP:
                    self.attributes = {}
                    (_ktype260, _vtype261, _size259) = iprot.readMapBegin()
                    for _i263 in range(_size259):
                        _key264 = iprot.readBinary()
                        _val265 = iprot.readBinary()
                        self.attributes[_key264] = _val265
                    iprot.readMapEnd()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('getRowsTs_args')
        if self.tableName is not None:
            oprot.writeFieldBegin('tableName', TType.STRING, 1)
            oprot.writeBinary(self.tableName)
            oprot.writeFieldEnd()
        if self.rows is not None:
            oprot.writeFieldBegin('rows', TType.LIST, 2)
            oprot.writeListBegin(TType.STRING, len(self.rows))
            for iter266 in self.rows:
                oprot.writeBinary(iter266)
            oprot.writeListEnd()
            oprot.writeFieldEnd()
        if self.timestamp is not None:
            oprot.writeFieldBegin('timestamp', TType.I64, 3)
            oprot.writeI64(self.timestamp)
            oprot.writeFieldEnd()
        if self.attributes is not None:
            oprot.writeFieldBegin('attributes', TType.MAP, 4)
            oprot.writeMapBegin(TType.STRING, TType.STRING, len(self.attributes))
            for kiter267, viter268 in self.attributes.items():
                oprot.writeBinary(kiter267)
                oprot.writeBinary(viter268)
            oprot.writeMapEnd()
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(getRowsTs_args)
getRowsTs_args.thrift_spec = (
    None,  # 0
    (1, TType.STRING, 'tableName', 'BINARY', None, ),  # 1
    (2, TType.LIST, 'rows', (TType.STRING, 'BINARY', False), None, ),  # 2
    (3, TType.I64, 'timestamp', None, None, ),  # 3
    (4, TType.MAP, 'attributes', (TType.STRING, 'BINARY', TType.STRING, 'BINARY', False), None, ),  # 4
)


class getRowsTs_result(object):
    """
    Attributes:
     - success
     - io

    """


    def __init__(self, success=None, io=None,):
        self.success = success
        self.io = io

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 0:
                if ftype == TType.LIST:
                    self.success = []
                    (_etype272, _size269) = iprot.readListBegin()
                    for _i273 in range(_size269):
                        _elem274 = TRowResult()
                        _elem274.read(iprot)
                        self.success.append(_elem274)
                    iprot.readListEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 1:
                if ftype == TType.STRUCT:
                    self.io = IOError()
                    self.io.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('getRowsTs_result')
        if self.success is not None:
            oprot.writeFieldBegin('success', TType.LIST, 0)
            oprot.writeListBegin(TType.STRUCT, len(self.success))
            for iter275 in self.success:
                iter275.write(oprot)
            oprot.writeListEnd()
            oprot.writeFieldEnd()
        if self.io is not None:
            oprot.writeFieldBegin('io', TType.STRUCT, 1)
            self.io.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(getRowsTs_result)
getRowsTs_result.thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRUCT, [TRowResult, None], False), None, ),  # 0
    (1, TType.STRUCT, 'io', [IOError, None], None, ),  # 1
)


class getRowsWithColumnsTs_args(object):
    """
    Attributes:
     - tableName: name of table
     - rows: row keys
     - columns: List of columns to return, null for all columns
     - timestamp
     - attributes: Get attributes

    """


    def __init__(self, tableName=None, rows=None, columns=None, timestamp=None, attributes=None,):
        self.tableName = tableName
        self.rows = rows
        self.columns = columns
        self.timestamp = timestamp
        self.attributes = attributes

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.tableName = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.LIST:
                    self.rows = []
                    (_etype279, _size276) = iprot.readListBegin()
                    for _i280 in range(_size276):
                        _elem281 = iprot.readBinary()
                        self.rows.append(_elem281)
                    iprot.readListEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 3:
                if ftype == TType.LIST:
                    self.columns = []
                    (_etype285, _size282) = iprot.readListBegin()
                    for _i286 in range(_size282):
                        _elem287 = iprot.readBinary()
                        self.columns.append(_elem287)
                    iprot.readListEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 4:
                if ftype == TType.I64:
                    self.timestamp = iprot.readI64()
                else:
                    iprot.skip(ftype)
            elif fid == 5:
                if ftype == TType.MAP:
                    self.attributes = {}
                    (_ktype289, _vtype290, _size288) = iprot.readMapBegin()
                    for _i292 in range(_size288):
                        _key293 = iprot.readBinary()
                        _val294 = iprot.readBinary()
                        self.attributes[_key293] = _val294
                    iprot.readMapEnd()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('getRowsWithColumnsTs_args')
        if self.tableName is not None:
            oprot.writeFieldBegin('tableName', TType.STRING, 1)
            oprot.writeBinary(self.tableName)
            oprot.writeFieldEnd()
        if self.rows is not None:
            oprot.writeFieldBegin('rows', TType.LIST, 2)
            oprot.writeListBegin(TType.STRING, len(self.rows))
            for iter295 in self.rows:
                oprot.writeBinary(iter295)
            oprot.writeListEnd()
            oprot.writeFieldEnd()
        if self.columns is not None:
            oprot.writeFieldBegin('columns', TType.LIST, 3)
            oprot.writeListBegin(TType.STRING, len(self.columns))
            for iter296 in self.columns:
                oprot.writeBinary(iter296)
            oprot.writeListEnd()
            oprot.writeFieldEnd()
        if self.timestamp is not None:
            oprot.writeFieldBegin('timestamp', TType.I64, 4)
            oprot.writeI64(self.timestamp)
            oprot.writeFieldEnd()
        if self.attributes is not None:
            oprot.writeFieldBegin('attributes', TType.MAP, 5)
            oprot.writeMapBegin(TType.STRING, TType.STRING, len(self.attributes))
            for kiter297, viter298 in self.attributes.items():
                oprot.writeBinary(kiter297)
                oprot.writeBinary(viter298)
            oprot.writeMapEnd()
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(getRowsWithColumnsTs_args)
getRowsWithColumnsTs_args.thrift_spec = (
    None,  # 0
    (1, TType.STRING, 'tableName', 'BINARY', None, ),  # 1
    (2, TType.LIST, 'rows', (TType.STRING, 'BINARY', False), None, ),  # 2
    (3, TType.LIST, 'columns', (TType.STRING, 'BINARY', False), None, ),  # 3
    (4, TType.I64, 'timestamp', None, None, ),  # 4
    (5, TType.MAP, 'attributes', (TType.STRING, 'BINARY', TType.STRING, 'BINARY', False), None, ),  # 5
)


class getRowsWithColumnsTs_result(object):
    """
    Attributes:
     - success
     - io

    """


    def __init__(self, success=None, io=None,):
        self.success = success
        self.io = io

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 0:
                if ftype == TType.LIST:
                    self.success = []
                    (_etype302, _size299) = iprot.readListBegin()
                    for _i303 in range(_size299):
                        _elem304 = TRowResult()
                        _elem304.read(iprot)
                        self.success.append(_elem304)
                    iprot.readListEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 1:
                if ftype == TType.STRUCT:
                    self.io = IOError()
                    self.io.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('getRowsWithColumnsTs_result')
        if self.success is not None:
            oprot.writeFieldBegin('success', TType.LIST, 0)
            oprot.writeListBegin(TType.STRUCT, len(self.success))
            for iter305 in self.success:
                iter305.write(oprot)
            oprot.writeListEnd()
            oprot.writeFieldEnd()
        if self.io is not None:
            oprot.writeFieldBegin('io', TType.STRUCT, 1)
            self.io.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(getRowsWithColumnsTs_result)
getRowsWithColumnsTs_result.thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRUCT, [TRowResult, None], False), None, ),  # 0
    (1, TType.STRUCT, 'io', [IOError, None], None, ),  # 1
)


class mutateRow_args(object):
    """
    Attributes:
     - tableName: name of table
     - row: row key
     - mutations: list of mutation commands
     - attributes: Mutation attributes

    """


    def __init__(self, tableName=None, row=None, mutations=None, attributes=None,):
        self.tableName = tableName
        self.row = row
        self.mutations = mutations
        self.attributes = attributes

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.tableName = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.STRING:
                    self.row = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            elif fid == 3:
                if ftype == TType.LIST:
                    self.mutations = []
                    (_etype309, _size306) = iprot.readListBegin()
                    for _i310 in range(_size306):
                        _elem311 = Mutation()
                        _elem311.read(iprot)
                        self.mutations.append(_elem311)
                    iprot.readListEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 4:
                if ftype == TType.MAP:
                    self.attributes = {}
                    (_ktype313, _vtype314, _size312) = iprot.readMapBegin()
                    for _i316 in range(_size312):
                        _key317 = iprot.readBinary()
                        _val318 = iprot.readBinary()
                        self.attributes[_key317] = _val318
                    iprot.readMapEnd()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('mutateRow_args')
        if self.tableName is not None:
            oprot.writeFieldBegin('tableName', TType.STRING, 1)
            oprot.writeBinary(self.tableName)
            oprot.writeFieldEnd()
        if self.row is not None:
            oprot.writeFieldBegin('row', TType.STRING, 2)
            oprot.writeBinary(self.row)
            oprot.writeFieldEnd()
        if self.mutations is not None:
            oprot.writeFieldBegin('mutations', TType.LIST, 3)
            oprot.writeListBegin(TType.STRUCT, len(self.mutations))
            for iter319 in self.mutations:
                iter319.write(oprot)
            oprot.writeListEnd()
            oprot.writeFieldEnd()
        if self.attributes is not None:
            oprot.writeFieldBegin('attributes', TType.MAP, 4)
            oprot.writeMapBegin(TType.STRING, TType.STRING, len(self.attributes))
            for kiter320, viter321 in self.attributes.items():
                oprot.writeBinary(kiter320)
                oprot.writeBinary(viter321)
            oprot.writeMapEnd()
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(mutateRow_args)
mutateRow_args.thrift_spec = (
    None,  # 0
    (1, TType.STRING, 'tableName', 'BINARY', None, ),  # 1
    (2, TType.STRING, 'row', 'BINARY', None, ),  # 2
    (3, TType.LIST, 'mutations', (TType.STRUCT, [Mutation, None], False), None, ),  # 3
    (4, TType.MAP, 'attributes', (TType.STRING, 'BINARY', TType.STRING, 'BINARY', False), None, ),  # 4
)


class mutateRow_result(object):
    """
    Attributes:
     - io
     - ia

    """


    def __init__(self, io=None, ia=None,):
        self.io = io
        self.ia = ia

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRUCT:
                    self.io = IOError()
                    self.io.read(iprot)
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.STRUCT:
                    self.ia = IllegalArgument()
                    self.ia.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('mutateRow_result')
        if self.io is not None:
            oprot.writeFieldBegin('io', TType.STRUCT, 1)
            self.io.write(oprot)
            oprot.writeFieldEnd()
        if self.ia is not None:
            oprot.writeFieldBegin('ia', TType.STRUCT, 2)
            self.ia.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(mutateRow_result)
mutateRow_result.thrift_spec = (
    None,  # 0
    (1, TType.STRUCT, 'io', [IOError, None], None, ),  # 1
    (2, TType.STRUCT, 'ia', [IllegalArgument, None], None, ),  # 2
)


class mutateRowTs_args(object):
    """
    Attributes:
     - tableName: name of table
     - row: row key
     - mutations: list of mutation commands
     - timestamp: timestamp
     - attributes: Mutation attributes

    """


    def __init__(self, tableName=None, row=None, mutations=None, timestamp=None, attributes=None,):
        self.tableName = tableName
        self.row = row
        self.mutations = mutations
        self.timestamp = timestamp
        self.attributes = attributes

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.tableName = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.STRING:
                    self.row = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            elif fid == 3:
                if ftype == TType.LIST:
                    self.mutations = []
                    (_etype325, _size322) = iprot.readListBegin()
                    for _i326 in range(_size322):
                        _elem327 = Mutation()
                        _elem327.read(iprot)
                        self.mutations.append(_elem327)
                    iprot.readListEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 4:
                if ftype == TType.I64:
                    self.timestamp = iprot.readI64()
                else:
                    iprot.skip(ftype)
            elif fid == 5:
                if ftype == TType.MAP:
                    self.attributes = {}
                    (_ktype329, _vtype330, _size328) = iprot.readMapBegin()
                    for _i332 in range(_size328):
                        _key333 = iprot.readBinary()
                        _val334 = iprot.readBinary()
                        self.attributes[_key333] = _val334
                    iprot.readMapEnd()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('mutateRowTs_args')
        if self.tableName is not None:
            oprot.writeFieldBegin('tableName', TType.STRING, 1)
            oprot.writeBinary(self.tableName)
            oprot.writeFieldEnd()
        if self.row is not None:
            oprot.writeFieldBegin('row', TType.STRING, 2)
            oprot.writeBinary(self.row)
            oprot.writeFieldEnd()
        if self.mutations is not None:
            oprot.writeFieldBegin('mutations', TType.LIST, 3)
            oprot.writeListBegin(TType.STRUCT, len(self.mutations))
            for iter335 in self.mutations:
                iter335.write(oprot)
            oprot.writeListEnd()
            oprot.writeFieldEnd()
        if self.timestamp is not None:
            oprot.writeFieldBegin('timestamp', TType.I64, 4)
            oprot.writeI64(self.timestamp)
            oprot.writeFieldEnd()
        if self.attributes is not None:
            oprot.writeFieldBegin('attributes', TType.MAP, 5)
            oprot.writeMapBegin(TType.STRING, TType.STRING, len(self.attributes))
            for kiter336, viter337 in self.attributes.items():
                oprot.writeBinary(kiter336)
                oprot.writeBinary(viter337)
            oprot.writeMapEnd()
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(mutateRowTs_args)
mutateRowTs_args.thrift_spec = (
    None,  # 0
    (1, TType.STRING, 'tableName', 'BINARY', None, ),  # 1
    (2, TType.STRING, 'row', 'BINARY', None, ),  # 2
    (3, TType.LIST, 'mutations', (TType.STRUCT, [Mutation, None], False), None, ),  # 3
    (4, TType.I64, 'timestamp', None, None, ),  # 4
    (5, TType.MAP, 'attributes', (TType.STRING, 'BINARY', TType.STRING, 'BINARY', False), None, ),  # 5
)


class mutateRowTs_result(object):
    """
    Attributes:
     - io
     - ia

    """


    def __init__(self, io=None, ia=None,):
        self.io = io
        self.ia = ia

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRUCT:
                    self.io = IOError()
                    self.io.read(iprot)
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.STRUCT:
                    self.ia = IllegalArgument()
                    self.ia.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('mutateRowTs_result')
        if self.io is not None:
            oprot.writeFieldBegin('io', TType.STRUCT, 1)
            self.io.write(oprot)
            oprot.writeFieldEnd()
        if self.ia is not None:
            oprot.writeFieldBegin('ia', TType.STRUCT, 2)
            self.ia.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(mutateRowTs_result)
mutateRowTs_result.thrift_spec = (
    None,  # 0
    (1, TType.STRUCT, 'io', [IOError, None], None, ),  # 1
    (2, TType.STRUCT, 'ia', [IllegalArgument, None], None, ),  # 2
)


class mutateRows_args(object):
    """
    Attributes:
     - tableName: name of table
     - rowBatches: list of row batches
     - attributes: Mutation attributes

    """


    def __init__(self, tableName=None, rowBatches=None, attributes=None,):
        self.tableName = tableName
        self.rowBatches = rowBatches
        self.attributes = attributes

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.tableName = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.LIST:
                    self.rowBatches = []
                    (_etype341, _size338) = iprot.readListBegin()
                    for _i342 in range(_size338):
                        _elem343 = BatchMutation()
                        _elem343.read(iprot)
                        self.rowBatches.append(_elem343)
                    iprot.readListEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 3:
                if ftype == TType.MAP:
                    self.attributes = {}
                    (_ktype345, _vtype346, _size344) = iprot.readMapBegin()
                    for _i348 in range(_size344):
                        _key349 = iprot.readBinary()
                        _val350 = iprot.readBinary()
                        self.attributes[_key349] = _val350
                    iprot.readMapEnd()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('mutateRows_args')
        if self.tableName is not None:
            oprot.writeFieldBegin('tableName', TType.STRING, 1)
            oprot.writeBinary(self.tableName)
            oprot.writeFieldEnd()
        if self.rowBatches is not None:
            oprot.writeFieldBegin('rowBatches', TType.LIST, 2)
            oprot.writeListBegin(TType.STRUCT, len(self.rowBatches))
            for iter351 in self.rowBatches:
                iter351.write(oprot)
            oprot.writeListEnd()
            oprot.writeFieldEnd()
        if self.attributes is not None:
            oprot.writeFieldBegin('attributes', TType.MAP, 3)
            oprot.writeMapBegin(TType.STRING, TType.STRING, len(self.attributes))
            for kiter352, viter353 in self.attributes.items():
                oprot.writeBinary(kiter352)
                oprot.writeBinary(viter353)
            oprot.writeMapEnd()
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(mutateRows_args)
mutateRows_args.thrift_spec = (
    None,  # 0
    (1, TType.STRING, 'tableName', 'BINARY', None, ),  # 1
    (2, TType.LIST, 'rowBatches', (TType.STRUCT, [BatchMutation, None], False), None, ),  # 2
    (3, TType.MAP, 'attributes', (TType.STRING, 'BINARY', TType.STRING, 'BINARY', False), None, ),  # 3
)


class mutateRows_result(object):
    """
    Attributes:
     - io
     - ia

    """


    def __init__(self, io=None, ia=None,):
        self.io = io
        self.ia = ia

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRUCT:
                    self.io = IOError()
                    self.io.read(iprot)
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.STRUCT:
                    self.ia = IllegalArgument()
                    self.ia.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('mutateRows_result')
        if self.io is not None:
            oprot.writeFieldBegin('io', TType.STRUCT, 1)
            self.io.write(oprot)
            oprot.writeFieldEnd()
        if self.ia is not None:
            oprot.writeFieldBegin('ia', TType.STRUCT, 2)
            self.ia.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(mutateRows_result)
mutateRows_result.thrift_spec = (
    None,  # 0
    (1, TType.STRUCT, 'io', [IOError, None], None, ),  # 1
    (2, TType.STRUCT, 'ia', [IllegalArgument, None], None, ),  # 2
)


class mutateRowsTs_args(object):
    """
    Attributes:
     - tableName: name of table
     - rowBatches: list of row batches
     - timestamp: timestamp
     - attributes: Mutation attributes

    """


    def __init__(self, tableName=None, rowBatches=None, timestamp=None, attributes=None,):
        self.tableName = tableName
        self.rowBatches = rowBatches
        self.timestamp = timestamp
        self.attributes = attributes

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.tableName = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.LIST:
                    self.rowBatches = []
                    (_etype357, _size354) = iprot.readListBegin()
                    for _i358 in range(_size354):
                        _elem359 = BatchMutation()
                        _elem359.read(iprot)
                        self.rowBatches.append(_elem359)
                    iprot.readListEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 3:
                if ftype == TType.I64:
                    self.timestamp = iprot.readI64()
                else:
                    iprot.skip(ftype)
            elif fid == 4:
                if ftype == TType.MAP:
                    self.attributes = {}
                    (_ktype361, _vtype362, _size360) = iprot.readMapBegin()
                    for _i364 in range(_size360):
                        _key365 = iprot.readBinary()
                        _val366 = iprot.readBinary()
                        self.attributes[_key365] = _val366
                    iprot.readMapEnd()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('mutateRowsTs_args')
        if self.tableName is not None:
            oprot.writeFieldBegin('tableName', TType.STRING, 1)
            oprot.writeBinary(self.tableName)
            oprot.writeFieldEnd()
        if self.rowBatches is not None:
            oprot.writeFieldBegin('rowBatches', TType.LIST, 2)
            oprot.writeListBegin(TType.STRUCT, len(self.rowBatches))
            for iter367 in self.rowBatches:
                iter367.write(oprot)
            oprot.writeListEnd()
            oprot.writeFieldEnd()
        if self.timestamp is not None:
            oprot.writeFieldBegin('timestamp', TType.I64, 3)
            oprot.writeI64(self.timestamp)
            oprot.writeFieldEnd()
        if self.attributes is not None:
            oprot.writeFieldBegin('attributes', TType.MAP, 4)
            oprot.writeMapBegin(TType.STRING, TType.STRING, len(self.attributes))
            for kiter368, viter369 in self.attributes.items():
                oprot.writeBinary(kiter368)
                oprot.writeBinary(viter369)
            oprot.writeMapEnd()
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(mutateRowsTs_args)
mutateRowsTs_args.thrift_spec = (
    None,  # 0
    (1, TType.STRING, 'tableName', 'BINARY', None, ),  # 1
    (2, TType.LIST, 'rowBatches', (TType.STRUCT, [BatchMutation, None], False), None, ),  # 2
    (3, TType.I64, 'timestamp', None, None, ),  # 3
    (4, TType.MAP, 'attributes', (TType.STRING, 'BINARY', TType.STRING, 'BINARY', False), None, ),  # 4
)


class mutateRowsTs_result(object):
    """
    Attributes:
     - io
     - ia

    """


    def __init__(self, io=None, ia=None,):
        self.io = io
        self.ia = ia

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRUCT:
                    self.io = IOError()
                    self.io.read(iprot)
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.STRUCT:
                    self.ia = IllegalArgument()
                    self.ia.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('mutateRowsTs_result')
        if self.io is not None:
            oprot.writeFieldBegin('io', TType.STRUCT, 1)
            self.io.write(oprot)
            oprot.writeFieldEnd()
        if self.ia is not None:
            oprot.writeFieldBegin('ia', TType.STRUCT, 2)
            self.ia.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(mutateRowsTs_result)
mutateRowsTs_result.thrift_spec = (
    None,  # 0
    (1, TType.STRUCT, 'io', [IOError, None], None, ),  # 1
    (2, TType.STRUCT, 'ia', [IllegalArgument, None], None, ),  # 2
)


class atomicIncrement_args(object):
    """
    Attributes:
     - tableName: name of table
     - row: row to increment
     - column: name of column
     - value: amount to increment by

    """


    def __init__(self, tableName=None, row=None, column=None, value=None,):
        self.tableName = tableName
        self.row = row
        self.column = column
        self.value = value

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.tableName = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.STRING:
                    self.row = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            elif fid == 3:
                if ftype == TType.STRING:
                    self.column = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            elif fid == 4:
                if ftype == TType.I64:
                    self.value = iprot.readI64()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('atomicIncrement_args')
        if self.tableName is not None:
            oprot.writeFieldBegin('tableName', TType.STRING, 1)
            oprot.writeBinary(self.tableName)
            oprot.writeFieldEnd()
        if self.row is not None:
            oprot.writeFieldBegin('row', TType.STRING, 2)
            oprot.writeBinary(self.row)
            oprot.writeFieldEnd()
        if self.column is not None:
            oprot.writeFieldBegin('column', TType.STRING, 3)
            oprot.writeBinary(self.column)
            oprot.writeFieldEnd()
        if self.value is not None:
            oprot.writeFieldBegin('value', TType.I64, 4)
            oprot.writeI64(self.value)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(atomicIncrement_args)
atomicIncrement_args.thrift_spec = (
    None,  # 0
    (1, TType.STRING, 'tableName', 'BINARY', None, ),  # 1
    (2, TType.STRING, 'row', 'BINARY', None, ),  # 2
    (3, TType.STRING, 'column', 'BINARY', None, ),  # 3
    (4, TType.I64, 'value', None, None, ),  # 4
)


class atomicIncrement_result(object):
    """
    Attributes:
     - success
     - io
     - ia

    """


    def __init__(self, success=None, io=None, ia=None,):
        self.success = success
        self.io = io
        self.ia = ia

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 0:
                if ftype == TType.I64:
                    self.success = iprot.readI64()
                else:
                    iprot.skip(ftype)
            elif fid == 1:
                if ftype == TType.STRUCT:
                    self.io = IOError()
                    self.io.read(iprot)
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.STRUCT:
                    self.ia = IllegalArgument()
                    self.ia.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('atomicIncrement_result')
        if self.success is not None:
            oprot.writeFieldBegin('success', TType.I64, 0)
            oprot.writeI64(self.success)
            oprot.writeFieldEnd()
        if self.io is not None:
            oprot.writeFieldBegin('io', TType.STRUCT, 1)
            self.io.write(oprot)
            oprot.writeFieldEnd()
        if self.ia is not None:
            oprot.writeFieldBegin('ia', TType.STRUCT, 2)
            self.ia.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(atomicIncrement_result)
atomicIncrement_result.thrift_spec = (
    (0, TType.I64, 'success', None, None, ),  # 0
    (1, TType.STRUCT, 'io', [IOError, None], None, ),  # 1
    (2, TType.STRUCT, 'ia', [IllegalArgument, None], None, ),  # 2
)


class deleteAll_args(object):
    """
    Attributes:
     - tableName: name of table
     - row: Row to update
     - column: name of column whose value is to be deleted
     - attributes: Delete attributes

    """


    def __init__(self, tableName=None, row=None, column=None, attributes=None,):
        self.tableName = tableName
        self.row = row
        self.column = column
        self.attributes = attributes

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.tableName = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.STRING:
                    self.row = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            elif fid == 3:
                if ftype == TType.STRING:
                    self.column = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            elif fid == 4:
                if ftype == TType.MAP:
                    self.attributes = {}
                    (_ktype371, _vtype372, _size370) = iprot.readMapBegin()
                    for _i374 in range(_size370):
                        _key375 = iprot.readBinary()
                        _val376 = iprot.readBinary()
                        self.attributes[_key375] = _val376
                    iprot.readMapEnd()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('deleteAll_args')
        if self.tableName is not None:
            oprot.writeFieldBegin('tableName', TType.STRING, 1)
            oprot.writeBinary(self.tableName)
            oprot.writeFieldEnd()
        if self.row is not None:
            oprot.writeFieldBegin('row', TType.STRING, 2)
            oprot.writeBinary(self.row)
            oprot.writeFieldEnd()
        if self.column is not None:
            oprot.writeFieldBegin('column', TType.STRING, 3)
            oprot.writeBinary(self.column)
            oprot.writeFieldEnd()
        if self.attributes is not None:
            oprot.writeFieldBegin('attributes', TType.MAP, 4)
            oprot.writeMapBegin(TType.STRING, TType.STRING, len(self.attributes))
            for kiter377, viter378 in self.attributes.items():
                oprot.writeBinary(kiter377)
                oprot.writeBinary(viter378)
            oprot.writeMapEnd()
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(deleteAll_args)
deleteAll_args.thrift_spec = (
    None,  # 0
    (1, TType.STRING, 'tableName', 'BINARY', None, ),  # 1
    (2, TType.STRING, 'row', 'BINARY', None, ),  # 2
    (3, TType.STRING, 'column', 'BINARY', None, ),  # 3
    (4, TType.MAP, 'attributes', (TType.STRING, 'BINARY', TType.STRING, 'BINARY', False), None, ),  # 4
)


class deleteAll_result(object):
    """
    Attributes:
     - io

    """


    def __init__(self, io=None,):
        self.io = io

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRUCT:
                    self.io = IOError()
                    self.io.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('deleteAll_result')
        if self.io is not None:
            oprot.writeFieldBegin('io', TType.STRUCT, 1)
            self.io.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(deleteAll_result)
deleteAll_result.thrift_spec = (
    None,  # 0
    (1, TType.STRUCT, 'io', [IOError, None], None, ),  # 1
)


class deleteAllTs_args(object):
    """
    Attributes:
     - tableName: name of table
     - row: Row to update
     - column: name of column whose value is to be deleted
     - timestamp: timestamp
     - attributes: Delete attributes

    """


    def __init__(self, tableName=None, row=None, column=None, timestamp=None, attributes=None,):
        self.tableName = tableName
        self.row = row
        self.column = column
        self.timestamp = timestamp
        self.attributes = attributes

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.tableName = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.STRING:
                    self.row = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            elif fid == 3:
                if ftype == TType.STRING:
                    self.column = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            elif fid == 4:
                if ftype == TType.I64:
                    self.timestamp = iprot.readI64()
                else:
                    iprot.skip(ftype)
            elif fid == 5:
                if ftype == TType.MAP:
                    self.attributes = {}
                    (_ktype380, _vtype381, _size379) = iprot.readMapBegin()
                    for _i383 in range(_size379):
                        _key384 = iprot.readBinary()
                        _val385 = iprot.readBinary()
                        self.attributes[_key384] = _val385
                    iprot.readMapEnd()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('deleteAllTs_args')
        if self.tableName is not None:
            oprot.writeFieldBegin('tableName', TType.STRING, 1)
            oprot.writeBinary(self.tableName)
            oprot.writeFieldEnd()
        if self.row is not None:
            oprot.writeFieldBegin('row', TType.STRING, 2)
            oprot.writeBinary(self.row)
            oprot.writeFieldEnd()
        if self.column is not None:
            oprot.writeFieldBegin('column', TType.STRING, 3)
            oprot.writeBinary(self.column)
            oprot.writeFieldEnd()
        if self.timestamp is not None:
            oprot.writeFieldBegin('timestamp', TType.I64, 4)
            oprot.writeI64(self.timestamp)
            oprot.writeFieldEnd()
        if self.attributes is not None:
            oprot.writeFieldBegin('attributes', TType.MAP, 5)
            oprot.writeMapBegin(TType.STRING, TType.STRING, len(self.attributes))
            for kiter386, viter387 in self.attributes.items():
                oprot.writeBinary(kiter386)
                oprot.writeBinary(viter387)
            oprot.writeMapEnd()
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(deleteAllTs_args)
deleteAllTs_args.thrift_spec = (
    None,  # 0
    (1, TType.STRING, 'tableName', 'BINARY', None, ),  # 1
    (2, TType.STRING, 'row', 'BINARY', None, ),  # 2
    (3, TType.STRING, 'column', 'BINARY', None, ),  # 3
    (4, TType.I64, 'timestamp', None, None, ),  # 4
    (5, TType.MAP, 'attributes', (TType.STRING, 'BINARY', TType.STRING, 'BINARY', False), None, ),  # 5
)


class deleteAllTs_result(object):
    """
    Attributes:
     - io

    """


    def __init__(self, io=None,):
        self.io = io

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRUCT:
                    self.io = IOError()
                    self.io.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('deleteAllTs_result')
        if self.io is not None:
            oprot.writeFieldBegin('io', TType.STRUCT, 1)
            self.io.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(deleteAllTs_result)
deleteAllTs_result.thrift_spec = (
    None,  # 0
    (1, TType.STRUCT, 'io', [IOError, None], None, ),  # 1
)


class deleteAllRow_args(object):
    """
    Attributes:
     - tableName: name of table
     - row: key of the row to be completely deleted.
     - attributes: Delete attributes

    """


    def __init__(self, tableName=None, row=None, attributes=None,):
        self.tableName = tableName
        self.row = row
        self.attributes = attributes

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.tableName = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.STRING:
                    self.row = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            elif fid == 3:
                if ftype == TType.MAP:
                    self.attributes = {}
                    (_ktype389, _vtype390, _size388) = iprot.readMapBegin()
                    for _i392 in range(_size388):
                        _key393 = iprot.readBinary()
                        _val394 = iprot.readBinary()
                        self.attributes[_key393] = _val394
                    iprot.readMapEnd()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('deleteAllRow_args')
        if self.tableName is not None:
            oprot.writeFieldBegin('tableName', TType.STRING, 1)
            oprot.writeBinary(self.tableName)
            oprot.writeFieldEnd()
        if self.row is not None:
            oprot.writeFieldBegin('row', TType.STRING, 2)
            oprot.writeBinary(self.row)
            oprot.writeFieldEnd()
        if self.attributes is not None:
            oprot.writeFieldBegin('attributes', TType.MAP, 3)
            oprot.writeMapBegin(TType.STRING, TType.STRING, len(self.attributes))
            for kiter395, viter396 in self.attributes.items():
                oprot.writeBinary(kiter395)
                oprot.writeBinary(viter396)
            oprot.writeMapEnd()
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(deleteAllRow_args)
deleteAllRow_args.thrift_spec = (
    None,  # 0
    (1, TType.STRING, 'tableName', 'BINARY', None, ),  # 1
    (2, TType.STRING, 'row', 'BINARY', None, ),  # 2
    (3, TType.MAP, 'attributes', (TType.STRING, 'BINARY', TType.STRING, 'BINARY', False), None, ),  # 3
)


class deleteAllRow_result(object):
    """
    Attributes:
     - io

    """


    def __init__(self, io=None,):
        self.io = io

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRUCT:
                    self.io = IOError()
                    self.io.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('deleteAllRow_result')
        if self.io is not None:
            oprot.writeFieldBegin('io', TType.STRUCT, 1)
            self.io.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(deleteAllRow_result)
deleteAllRow_result.thrift_spec = (
    None,  # 0
    (1, TType.STRUCT, 'io', [IOError, None], None, ),  # 1
)


class increment_args(object):
    """
    Attributes:
     - increment: The single increment to apply

    """


    def __init__(self, increment=None,):
        self.increment = increment

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRUCT:
                    self.increment = TIncrement()
                    self.increment.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('increment_args')
        if self.increment is not None:
            oprot.writeFieldBegin('increment', TType.STRUCT, 1)
            self.increment.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(increment_args)
increment_args.thrift_spec = (
    None,  # 0
    (1, TType.STRUCT, 'increment', [TIncrement, None], None, ),  # 1
)


class increment_result(object):
    """
    Attributes:
     - io

    """


    def __init__(self, io=None,):
        self.io = io

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRUCT:
                    self.io = IOError()
                    self.io.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('increment_result')
        if self.io is not None:
            oprot.writeFieldBegin('io', TType.STRUCT, 1)
            self.io.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(increment_result)
increment_result.thrift_spec = (
    None,  # 0
    (1, TType.STRUCT, 'io', [IOError, None], None, ),  # 1
)


class incrementRows_args(object):
    """
    Attributes:
     - increments: The list of increments

    """


    def __init__(self, increments=None,):
        self.increments = increments

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.LIST:
                    self.increments = []
                    (_etype400, _size397) = iprot.readListBegin()
                    for _i401 in range(_size397):
                        _elem402 = TIncrement()
                        _elem402.read(iprot)
                        self.increments.append(_elem402)
                    iprot.readListEnd()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('incrementRows_args')
        if self.increments is not None:
            oprot.writeFieldBegin('increments', TType.LIST, 1)
            oprot.writeListBegin(TType.STRUCT, len(self.increments))
            for iter403 in self.increments:
                iter403.write(oprot)
            oprot.writeListEnd()
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(incrementRows_args)
incrementRows_args.thrift_spec = (
    None,  # 0
    (1, TType.LIST, 'increments', (TType.STRUCT, [TIncrement, None], False), None, ),  # 1
)


class incrementRows_result(object):
    """
    Attributes:
     - io

    """


    def __init__(self, io=None,):
        self.io = io

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRUCT:
                    self.io = IOError()
                    self.io.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('incrementRows_result')
        if self.io is not None:
            oprot.writeFieldBegin('io', TType.STRUCT, 1)
            self.io.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(incrementRows_result)
incrementRows_result.thrift_spec = (
    None,  # 0
    (1, TType.STRUCT, 'io', [IOError, None], None, ),  # 1
)


class deleteAllRowTs_args(object):
    """
    Attributes:
     - tableName: name of table
     - row: key of the row to be completely deleted.
     - timestamp: timestamp
     - attributes: Delete attributes

    """


    def __init__(self, tableName=None, row=None, timestamp=None, attributes=None,):
        self.tableName = tableName
        self.row = row
        self.timestamp = timestamp
        self.attributes = attributes

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.tableName = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.STRING:
                    self.row = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            elif fid == 3:
                if ftype == TType.I64:
                    self.timestamp = iprot.readI64()
                else:
                    iprot.skip(ftype)
            elif fid == 4:
                if ftype == TType.MAP:
                    self.attributes = {}
                    (_ktype405, _vtype406, _size404) = iprot.readMapBegin()
                    for _i408 in range(_size404):
                        _key409 = iprot.readBinary()
                        _val410 = iprot.readBinary()
                        self.attributes[_key409] = _val410
                    iprot.readMapEnd()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('deleteAllRowTs_args')
        if self.tableName is not None:
            oprot.writeFieldBegin('tableName', TType.STRING, 1)
            oprot.writeBinary(self.tableName)
            oprot.writeFieldEnd()
        if self.row is not None:
            oprot.writeFieldBegin('row', TType.STRING, 2)
            oprot.writeBinary(self.row)
            oprot.writeFieldEnd()
        if self.timestamp is not None:
            oprot.writeFieldBegin('timestamp', TType.I64, 3)
            oprot.writeI64(self.timestamp)
            oprot.writeFieldEnd()
        if self.attributes is not None:
            oprot.writeFieldBegin('attributes', TType.MAP, 4)
            oprot.writeMapBegin(TType.STRING, TType.STRING, len(self.attributes))
            for kiter411, viter412 in self.attributes.items():
                oprot.writeBinary(kiter411)
                oprot.writeBinary(viter412)
            oprot.writeMapEnd()
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(deleteAllRowTs_args)
deleteAllRowTs_args.thrift_spec = (
    None,  # 0
    (1, TType.STRING, 'tableName', 'BINARY', None, ),  # 1
    (2, TType.STRING, 'row', 'BINARY', None, ),  # 2
    (3, TType.I64, 'timestamp', None, None, ),  # 3
    (4, TType.MAP, 'attributes', (TType.STRING, 'BINARY', TType.STRING, 'BINARY', False), None, ),  # 4
)


class deleteAllRowTs_result(object):
    """
    Attributes:
     - io

    """


    def __init__(self, io=None,):
        self.io = io

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRUCT:
                    self.io = IOError()
                    self.io.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('deleteAllRowTs_result')
        if self.io is not None:
            oprot.writeFieldBegin('io', TType.STRUCT, 1)
            self.io.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(deleteAllRowTs_result)
deleteAllRowTs_result.thrift_spec = (
    None,  # 0
    (1, TType.STRUCT, 'io', [IOError, None], None, ),  # 1
)


class scannerOpenWithScan_args(object):
    """
    Attributes:
     - tableName: name of table
     - scan: Scan instance
     - attributes: Scan attributes

    """


    def __init__(self, tableName=None, scan=None, attributes=None,):
        self.tableName = tableName
        self.scan = scan
        self.attributes = attributes

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.tableName = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.STRUCT:
                    self.scan = TScan()
                    self.scan.read(iprot)
                else:
                    iprot.skip(ftype)
            elif fid == 3:
                if ftype == TType.MAP:
                    self.attributes = {}
                    (_ktype414, _vtype415, _size413) = iprot.readMapBegin()
                    for _i417 in range(_size413):
                        _key418 = iprot.readBinary()
                        _val419 = iprot.readBinary()
                        self.attributes[_key418] = _val419
                    iprot.readMapEnd()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('scannerOpenWithScan_args')
        if self.tableName is not None:
            oprot.writeFieldBegin('tableName', TType.STRING, 1)
            oprot.writeBinary(self.tableName)
            oprot.writeFieldEnd()
        if self.scan is not None:
            oprot.writeFieldBegin('scan', TType.STRUCT, 2)
            self.scan.write(oprot)
            oprot.writeFieldEnd()
        if self.attributes is not None:
            oprot.writeFieldBegin('attributes', TType.MAP, 3)
            oprot.writeMapBegin(TType.STRING, TType.STRING, len(self.attributes))
            for kiter420, viter421 in self.attributes.items():
                oprot.writeBinary(kiter420)
                oprot.writeBinary(viter421)
            oprot.writeMapEnd()
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(scannerOpenWithScan_args)
scannerOpenWithScan_args.thrift_spec = (
    None,  # 0
    (1, TType.STRING, 'tableName', 'BINARY', None, ),  # 1
    (2, TType.STRUCT, 'scan', [TScan, None], None, ),  # 2
    (3, TType.MAP, 'attributes', (TType.STRING, 'BINARY', TType.STRING, 'BINARY', False), None, ),  # 3
)


class scannerOpenWithScan_result(object):
    """
    Attributes:
     - success
     - io

    """


    def __init__(self, success=None, io=None,):
        self.success = success
        self.io = io

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 0:
                if ftype == TType.I32:
                    self.success = iprot.readI32()
                else:
                    iprot.skip(ftype)
            elif fid == 1:
                if ftype == TType.STRUCT:
                    self.io = IOError()
                    self.io.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('scannerOpenWithScan_result')
        if self.success is not None:
            oprot.writeFieldBegin('success', TType.I32, 0)
            oprot.writeI32(self.success)
            oprot.writeFieldEnd()
        if self.io is not None:
            oprot.writeFieldBegin('io', TType.STRUCT, 1)
            self.io.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(scannerOpenWithScan_result)
scannerOpenWithScan_result.thrift_spec = (
    (0, TType.I32, 'success', None, None, ),  # 0
    (1, TType.STRUCT, 'io', [IOError, None], None, ),  # 1
)


class scannerOpen_args(object):
    """
    Attributes:
     - tableName: name of table
     - startRow: Starting row in table to scan.
    Send "" (empty string) to start at the first row.
     - columns: columns to scan. If column name is a column family, all
    columns of the specified column family are returned. It's also possible
    to pass a regex in the column qualifier.
     - attributes: Scan attributes

    """


    def __init__(self, tableName=None, startRow=None, columns=None, attributes=None,):
        self.tableName = tableName
        self.startRow = startRow
        self.columns = columns
        self.attributes = attributes

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.tableName = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.STRING:
                    self.startRow = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            elif fid == 3:
                if ftype == TType.LIST:
                    self.columns = []
                    (_etype425, _size422) = iprot.readListBegin()
                    for _i426 in range(_size422):
                        _elem427 = iprot.readBinary()
                        self.columns.append(_elem427)
                    iprot.readListEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 4:
                if ftype == TType.MAP:
                    self.attributes = {}
                    (_ktype429, _vtype430, _size428) = iprot.readMapBegin()
                    for _i432 in range(_size428):
                        _key433 = iprot.readBinary()
                        _val434 = iprot.readBinary()
                        self.attributes[_key433] = _val434
                    iprot.readMapEnd()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('scannerOpen_args')
        if self.tableName is not None:
            oprot.writeFieldBegin('tableName', TType.STRING, 1)
            oprot.writeBinary(self.tableName)
            oprot.writeFieldEnd()
        if self.startRow is not None:
            oprot.writeFieldBegin('startRow', TType.STRING, 2)
            oprot.writeBinary(self.startRow)
            oprot.writeFieldEnd()
        if self.columns is not None:
            oprot.writeFieldBegin('columns', TType.LIST, 3)
            oprot.writeListBegin(TType.STRING, len(self.columns))
            for iter435 in self.columns:
                oprot.writeBinary(iter435)
            oprot.writeListEnd()
            oprot.writeFieldEnd()
        if self.attributes is not None:
            oprot.writeFieldBegin('attributes', TType.MAP, 4)
            oprot.writeMapBegin(TType.STRING, TType.STRING, len(self.attributes))
            for kiter436, viter437 in self.attributes.items():
                oprot.writeBinary(kiter436)
                oprot.writeBinary(viter437)
            oprot.writeMapEnd()
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(scannerOpen_args)
scannerOpen_args.thrift_spec = (
    None,  # 0
    (1, TType.STRING, 'tableName', 'BINARY', None, ),  # 1
    (2, TType.STRING, 'startRow', 'BINARY', None, ),  # 2
    (3, TType.LIST, 'columns', (TType.STRING, 'BINARY', False), None, ),  # 3
    (4, TType.MAP, 'attributes', (TType.STRING, 'BINARY', TType.STRING, 'BINARY', False), None, ),  # 4
)


class scannerOpen_result(object):
    """
    Attributes:
     - success
     - io

    """


    def __init__(self, success=None, io=None,):
        self.success = success
        self.io = io

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 0:
                if ftype == TType.I32:
                    self.success = iprot.readI32()
                else:
                    iprot.skip(ftype)
            elif fid == 1:
                if ftype == TType.STRUCT:
                    self.io = IOError()
                    self.io.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('scannerOpen_result')
        if self.success is not None:
            oprot.writeFieldBegin('success', TType.I32, 0)
            oprot.writeI32(self.success)
            oprot.writeFieldEnd()
        if self.io is not None:
            oprot.writeFieldBegin('io', TType.STRUCT, 1)
            self.io.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(scannerOpen_result)
scannerOpen_result.thrift_spec = (
    (0, TType.I32, 'success', None, None, ),  # 0
    (1, TType.STRUCT, 'io', [IOError, None], None, ),  # 1
)


class scannerOpenWithStop_args(object):
    """
    Attributes:
     - tableName: name of table
     - startRow: Starting row in table to scan.
    Send "" (empty string) to start at the first row.
     - stopRow: row to stop scanning on. This row is *not* included in the
    scanner's results
     - columns: columns to scan. If column name is a column family, all
    columns of the specified column family are returned. It's also possible
    to pass a regex in the column qualifier.
     - attributes: Scan attributes

    """


    def __init__(self, tableName=None, startRow=None, stopRow=None, columns=None, attributes=None,):
        self.tableName = tableName
        self.startRow = startRow
        self.stopRow = stopRow
        self.columns = columns
        self.attributes = attributes

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.tableName = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.STRING:
                    self.startRow = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            elif fid == 3:
                if ftype == TType.STRING:
                    self.stopRow = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            elif fid == 4:
                if ftype == TType.LIST:
                    self.columns = []
                    (_etype441, _size438) = iprot.readListBegin()
                    for _i442 in range(_size438):
                        _elem443 = iprot.readBinary()
                        self.columns.append(_elem443)
                    iprot.readListEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 5:
                if ftype == TType.MAP:
                    self.attributes = {}
                    (_ktype445, _vtype446, _size444) = iprot.readMapBegin()
                    for _i448 in range(_size444):
                        _key449 = iprot.readBinary()
                        _val450 = iprot.readBinary()
                        self.attributes[_key449] = _val450
                    iprot.readMapEnd()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('scannerOpenWithStop_args')
        if self.tableName is not None:
            oprot.writeFieldBegin('tableName', TType.STRING, 1)
            oprot.writeBinary(self.tableName)
            oprot.writeFieldEnd()
        if self.startRow is not None:
            oprot.writeFieldBegin('startRow', TType.STRING, 2)
            oprot.writeBinary(self.startRow)
            oprot.writeFieldEnd()
        if self.stopRow is not None:
            oprot.writeFieldBegin('stopRow', TType.STRING, 3)
            oprot.writeBinary(self.stopRow)
            oprot.writeFieldEnd()
        if self.columns is not None:
            oprot.writeFieldBegin('columns', TType.LIST, 4)
            oprot.writeListBegin(TType.STRING, len(self.columns))
            for iter451 in self.columns:
                oprot.writeBinary(iter451)
            oprot.writeListEnd()
            oprot.writeFieldEnd()
        if self.attributes is not None:
            oprot.writeFieldBegin('attributes', TType.MAP, 5)
            oprot.writeMapBegin(TType.STRING, TType.STRING, len(self.attributes))
            for kiter452, viter453 in self.attributes.items():
                oprot.writeBinary(kiter452)
                oprot.writeBinary(viter453)
            oprot.writeMapEnd()
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(scannerOpenWithStop_args)
scannerOpenWithStop_args.thrift_spec = (
    None,  # 0
    (1, TType.STRING, 'tableName', 'BINARY', None, ),  # 1
    (2, TType.STRING, 'startRow', 'BINARY', None, ),  # 2
    (3, TType.STRING, 'stopRow', 'BINARY', None, ),  # 3
    (4, TType.LIST, 'columns', (TType.STRING, 'BINARY', False), None, ),  # 4
    (5, TType.MAP, 'attributes', (TType.STRING, 'BINARY', TType.STRING, 'BINARY', False), None, ),  # 5
)


class scannerOpenWithStop_result(object):
    """
    Attributes:
     - success
     - io

    """


    def __init__(self, success=None, io=None,):
        self.success = success
        self.io = io

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 0:
                if ftype == TType.I32:
                    self.success = iprot.readI32()
                else:
                    iprot.skip(ftype)
            elif fid == 1:
                if ftype == TType.STRUCT:
                    self.io = IOError()
                    self.io.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('scannerOpenWithStop_result')
        if self.success is not None:
            oprot.writeFieldBegin('success', TType.I32, 0)
            oprot.writeI32(self.success)
            oprot.writeFieldEnd()
        if self.io is not None:
            oprot.writeFieldBegin('io', TType.STRUCT, 1)
            self.io.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(scannerOpenWithStop_result)
scannerOpenWithStop_result.thrift_spec = (
    (0, TType.I32, 'success', None, None, ),  # 0
    (1, TType.STRUCT, 'io', [IOError, None], None, ),  # 1
)


class scannerOpenWithPrefix_args(object):
    """
    Attributes:
     - tableName: name of table
     - startAndPrefix: the prefix (and thus start row) of the keys you want
     - columns: the columns you want returned
     - attributes: Scan attributes

    """


    def __init__(self, tableName=None, startAndPrefix=None, columns=None, attributes=None,):
        self.tableName = tableName
        self.startAndPrefix = startAndPrefix
        self.columns = columns
        self.attributes = attributes

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.tableName = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.STRING:
                    self.startAndPrefix = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            elif fid == 3:
                if ftype == TType.LIST:
                    self.columns = []
                    (_etype457, _size454) = iprot.readListBegin()
                    for _i458 in range(_size454):
                        _elem459 = iprot.readBinary()
                        self.columns.append(_elem459)
                    iprot.readListEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 4:
                if ftype == TType.MAP:
                    self.attributes = {}
                    (_ktype461, _vtype462, _size460) = iprot.readMapBegin()
                    for _i464 in range(_size460):
                        _key465 = iprot.readBinary()
                        _val466 = iprot.readBinary()
                        self.attributes[_key465] = _val466
                    iprot.readMapEnd()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('scannerOpenWithPrefix_args')
        if self.tableName is not None:
            oprot.writeFieldBegin('tableName', TType.STRING, 1)
            oprot.writeBinary(self.tableName)
            oprot.writeFieldEnd()
        if self.startAndPrefix is not None:
            oprot.writeFieldBegin('startAndPrefix', TType.STRING, 2)
            oprot.writeBinary(self.startAndPrefix)
            oprot.writeFieldEnd()
        if self.columns is not None:
            oprot.writeFieldBegin('columns', TType.LIST, 3)
            oprot.writeListBegin(TType.STRING, len(self.columns))
            for iter467 in self.columns:
                oprot.writeBinary(iter467)
            oprot.writeListEnd()
            oprot.writeFieldEnd()
        if self.attributes is not None:
            oprot.writeFieldBegin('attributes', TType.MAP, 4)
            oprot.writeMapBegin(TType.STRING, TType.STRING, len(self.attributes))
            for kiter468, viter469 in self.attributes.items():
                oprot.writeBinary(kiter468)
                oprot.writeBinary(viter469)
            oprot.writeMapEnd()
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(scannerOpenWithPrefix_args)
scannerOpenWithPrefix_args.thrift_spec = (
    None,  # 0
    (1, TType.STRING, 'tableName', 'BINARY', None, ),  # 1
    (2, TType.STRING, 'startAndPrefix', 'BINARY', None, ),  # 2
    (3, TType.LIST, 'columns', (TType.STRING, 'BINARY', False), None, ),  # 3
    (4, TType.MAP, 'attributes', (TType.STRING, 'BINARY', TType.STRING, 'BINARY', False), None, ),  # 4
)


class scannerOpenWithPrefix_result(object):
    """
    Attributes:
     - success
     - io

    """


    def __init__(self, success=None, io=None,):
        self.success = success
        self.io = io

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 0:
                if ftype == TType.I32:
                    self.success = iprot.readI32()
                else:
                    iprot.skip(ftype)
            elif fid == 1:
                if ftype == TType.STRUCT:
                    self.io = IOError()
                    self.io.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('scannerOpenWithPrefix_result')
        if self.success is not None:
            oprot.writeFieldBegin('success', TType.I32, 0)
            oprot.writeI32(self.success)
            oprot.writeFieldEnd()
        if self.io is not None:
            oprot.writeFieldBegin('io', TType.STRUCT, 1)
            self.io.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(scannerOpenWithPrefix_result)
scannerOpenWithPrefix_result.thrift_spec = (
    (0, TType.I32, 'success', None, None, ),  # 0
    (1, TType.STRUCT, 'io', [IOError, None], None, ),  # 1
)


class scannerOpenTs_args(object):
    """
    Attributes:
     - tableName: name of table
     - startRow: Starting row in table to scan.
    Send "" (empty string) to start at the first row.
     - columns: columns to scan. If column name is a column family, all
    columns of the specified column family are returned. It's also possible
    to pass a regex in the column qualifier.
     - timestamp: timestamp
     - attributes: Scan attributes

    """


    def __init__(self, tableName=None, startRow=None, columns=None, timestamp=None, attributes=None,):
        self.tableName = tableName
        self.startRow = startRow
        self.columns = columns
        self.timestamp = timestamp
        self.attributes = attributes

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.tableName = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.STRING:
                    self.startRow = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            elif fid == 3:
                if ftype == TType.LIST:
                    self.columns = []
                    (_etype473, _size470) = iprot.readListBegin()
                    for _i474 in range(_size470):
                        _elem475 = iprot.readBinary()
                        self.columns.append(_elem475)
                    iprot.readListEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 4:
                if ftype == TType.I64:
                    self.timestamp = iprot.readI64()
                else:
                    iprot.skip(ftype)
            elif fid == 5:
                if ftype == TType.MAP:
                    self.attributes = {}
                    (_ktype477, _vtype478, _size476) = iprot.readMapBegin()
                    for _i480 in range(_size476):
                        _key481 = iprot.readBinary()
                        _val482 = iprot.readBinary()
                        self.attributes[_key481] = _val482
                    iprot.readMapEnd()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('scannerOpenTs_args')
        if self.tableName is not None:
            oprot.writeFieldBegin('tableName', TType.STRING, 1)
            oprot.writeBinary(self.tableName)
            oprot.writeFieldEnd()
        if self.startRow is not None:
            oprot.writeFieldBegin('startRow', TType.STRING, 2)
            oprot.writeBinary(self.startRow)
            oprot.writeFieldEnd()
        if self.columns is not None:
            oprot.writeFieldBegin('columns', TType.LIST, 3)
            oprot.writeListBegin(TType.STRING, len(self.columns))
            for iter483 in self.columns:
                oprot.writeBinary(iter483)
            oprot.writeListEnd()
            oprot.writeFieldEnd()
        if self.timestamp is not None:
            oprot.writeFieldBegin('timestamp', TType.I64, 4)
            oprot.writeI64(self.timestamp)
            oprot.writeFieldEnd()
        if self.attributes is not None:
            oprot.writeFieldBegin('attributes', TType.MAP, 5)
            oprot.writeMapBegin(TType.STRING, TType.STRING, len(self.attributes))
            for kiter484, viter485 in self.attributes.items():
                oprot.writeBinary(kiter484)
                oprot.writeBinary(viter485)
            oprot.writeMapEnd()
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(scannerOpenTs_args)
scannerOpenTs_args.thrift_spec = (
    None,  # 0
    (1, TType.STRING, 'tableName', 'BINARY', None, ),  # 1
    (2, TType.STRING, 'startRow', 'BINARY', None, ),  # 2
    (3, TType.LIST, 'columns', (TType.STRING, 'BINARY', False), None, ),  # 3
    (4, TType.I64, 'timestamp', None, None, ),  # 4
    (5, TType.MAP, 'attributes', (TType.STRING, 'BINARY', TType.STRING, 'BINARY', False), None, ),  # 5
)


class scannerOpenTs_result(object):
    """
    Attributes:
     - success
     - io

    """


    def __init__(self, success=None, io=None,):
        self.success = success
        self.io = io

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 0:
                if ftype == TType.I32:
                    self.success = iprot.readI32()
                else:
                    iprot.skip(ftype)
            elif fid == 1:
                if ftype == TType.STRUCT:
                    self.io = IOError()
                    self.io.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('scannerOpenTs_result')
        if self.success is not None:
            oprot.writeFieldBegin('success', TType.I32, 0)
            oprot.writeI32(self.success)
            oprot.writeFieldEnd()
        if self.io is not None:
            oprot.writeFieldBegin('io', TType.STRUCT, 1)
            self.io.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(scannerOpenTs_result)
scannerOpenTs_result.thrift_spec = (
    (0, TType.I32, 'success', None, None, ),  # 0
    (1, TType.STRUCT, 'io', [IOError, None], None, ),  # 1
)


class scannerOpenWithStopTs_args(object):
    """
    Attributes:
     - tableName: name of table
     - startRow: Starting row in table to scan.
    Send "" (empty string) to start at the first row.
     - stopRow: row to stop scanning on. This row is *not* included in the
    scanner's results
     - columns: columns to scan. If column name is a column family, all
    columns of the specified column family are returned. It's also possible
    to pass a regex in the column qualifier.
     - timestamp: timestamp
     - attributes: Scan attributes

    """


    def __init__(self, tableName=None, startRow=None, stopRow=None, columns=None, timestamp=None, attributes=None,):
        self.tableName = tableName
        self.startRow = startRow
        self.stopRow = stopRow
        self.columns = columns
        self.timestamp = timestamp
        self.attributes = attributes

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.tableName = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.STRING:
                    self.startRow = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            elif fid == 3:
                if ftype == TType.STRING:
                    self.stopRow = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            elif fid == 4:
                if ftype == TType.LIST:
                    self.columns = []
                    (_etype489, _size486) = iprot.readListBegin()
                    for _i490 in range(_size486):
                        _elem491 = iprot.readBinary()
                        self.columns.append(_elem491)
                    iprot.readListEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 5:
                if ftype == TType.I64:
                    self.timestamp = iprot.readI64()
                else:
                    iprot.skip(ftype)
            elif fid == 6:
                if ftype == TType.MAP:
                    self.attributes = {}
                    (_ktype493, _vtype494, _size492) = iprot.readMapBegin()
                    for _i496 in range(_size492):
                        _key497 = iprot.readBinary()
                        _val498 = iprot.readBinary()
                        self.attributes[_key497] = _val498
                    iprot.readMapEnd()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('scannerOpenWithStopTs_args')
        if self.tableName is not None:
            oprot.writeFieldBegin('tableName', TType.STRING, 1)
            oprot.writeBinary(self.tableName)
            oprot.writeFieldEnd()
        if self.startRow is not None:
            oprot.writeFieldBegin('startRow', TType.STRING, 2)
            oprot.writeBinary(self.startRow)
            oprot.writeFieldEnd()
        if self.stopRow is not None:
            oprot.writeFieldBegin('stopRow', TType.STRING, 3)
            oprot.writeBinary(self.stopRow)
            oprot.writeFieldEnd()
        if self.columns is not None:
            oprot.writeFieldBegin('columns', TType.LIST, 4)
            oprot.writeListBegin(TType.STRING, len(self.columns))
            for iter499 in self.columns:
                oprot.writeBinary(iter499)
            oprot.writeListEnd()
            oprot.writeFieldEnd()
        if self.timestamp is not None:
            oprot.writeFieldBegin('timestamp', TType.I64, 5)
            oprot.writeI64(self.timestamp)
            oprot.writeFieldEnd()
        if self.attributes is not None:
            oprot.writeFieldBegin('attributes', TType.MAP, 6)
            oprot.writeMapBegin(TType.STRING, TType.STRING, len(self.attributes))
            for kiter500, viter501 in self.attributes.items():
                oprot.writeBinary(kiter500)
                oprot.writeBinary(viter501)
            oprot.writeMapEnd()
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(scannerOpenWithStopTs_args)
scannerOpenWithStopTs_args.thrift_spec = (
    None,  # 0
    (1, TType.STRING, 'tableName', 'BINARY', None, ),  # 1
    (2, TType.STRING, 'startRow', 'BINARY', None, ),  # 2
    (3, TType.STRING, 'stopRow', 'BINARY', None, ),  # 3
    (4, TType.LIST, 'columns', (TType.STRING, 'BINARY', False), None, ),  # 4
    (5, TType.I64, 'timestamp', None, None, ),  # 5
    (6, TType.MAP, 'attributes', (TType.STRING, 'BINARY', TType.STRING, 'BINARY', False), None, ),  # 6
)


class scannerOpenWithStopTs_result(object):
    """
    Attributes:
     - success
     - io

    """


    def __init__(self, success=None, io=None,):
        self.success = success
        self.io = io

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 0:
                if ftype == TType.I32:
                    self.success = iprot.readI32()
                else:
                    iprot.skip(ftype)
            elif fid == 1:
                if ftype == TType.STRUCT:
                    self.io = IOError()
                    self.io.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('scannerOpenWithStopTs_result')
        if self.success is not None:
            oprot.writeFieldBegin('success', TType.I32, 0)
            oprot.writeI32(self.success)
            oprot.writeFieldEnd()
        if self.io is not None:
            oprot.writeFieldBegin('io', TType.STRUCT, 1)
            self.io.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(scannerOpenWithStopTs_result)
scannerOpenWithStopTs_result.thrift_spec = (
    (0, TType.I32, 'success', None, None, ),  # 0
    (1, TType.STRUCT, 'io', [IOError, None], None, ),  # 1
)


class scannerGet_args(object):
    """
    Attributes:
     - id: id of a scanner returned by scannerOpen

    """


    def __init__(self, id=None,):
        self.id = id

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.I32:
                    self.id = iprot.readI32()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('scannerGet_args')
        if self.id is not None:
            oprot.writeFieldBegin('id', TType.I32, 1)
            oprot.writeI32(self.id)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(scannerGet_args)
scannerGet_args.thrift_spec = (
    None,  # 0
    (1, TType.I32, 'id', None, None, ),  # 1
)


class scannerGet_result(object):
    """
    Attributes:
     - success
     - io
     - ia

    """


    def __init__(self, success=None, io=None, ia=None,):
        self.success = success
        self.io = io
        self.ia = ia

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 0:
                if ftype == TType.LIST:
                    self.success = []
                    (_etype505, _size502) = iprot.readListBegin()
                    for _i506 in range(_size502):
                        _elem507 = TRowResult()
                        _elem507.read(iprot)
                        self.success.append(_elem507)
                    iprot.readListEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 1:
                if ftype == TType.STRUCT:
                    self.io = IOError()
                    self.io.read(iprot)
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.STRUCT:
                    self.ia = IllegalArgument()
                    self.ia.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('scannerGet_result')
        if self.success is not None:
            oprot.writeFieldBegin('success', TType.LIST, 0)
            oprot.writeListBegin(TType.STRUCT, len(self.success))
            for iter508 in self.success:
                iter508.write(oprot)
            oprot.writeListEnd()
            oprot.writeFieldEnd()
        if self.io is not None:
            oprot.writeFieldBegin('io', TType.STRUCT, 1)
            self.io.write(oprot)
            oprot.writeFieldEnd()
        if self.ia is not None:
            oprot.writeFieldBegin('ia', TType.STRUCT, 2)
            self.ia.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(scannerGet_result)
scannerGet_result.thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRUCT, [TRowResult, None], False), None, ),  # 0
    (1, TType.STRUCT, 'io', [IOError, None], None, ),  # 1
    (2, TType.STRUCT, 'ia', [IllegalArgument, None], None, ),  # 2
)


class scannerGetList_args(object):
    """
    Attributes:
     - id: id of a scanner returned by scannerOpen
     - nbRows: number of results to return

    """


    def __init__(self, id=None, nbRows=None,):
        self.id = id
        self.nbRows = nbRows

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.I32:
                    self.id = iprot.readI32()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.I32:
                    self.nbRows = iprot.readI32()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('scannerGetList_args')
        if self.id is not None:
            oprot.writeFieldBegin('id', TType.I32, 1)
            oprot.writeI32(self.id)
            oprot.writeFieldEnd()
        if self.nbRows is not None:
            oprot.writeFieldBegin('nbRows', TType.I32, 2)
            oprot.writeI32(self.nbRows)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(scannerGetList_args)
scannerGetList_args.thrift_spec = (
    None,  # 0
    (1, TType.I32, 'id', None, None, ),  # 1
    (2, TType.I32, 'nbRows', None, None, ),  # 2
)


class scannerGetList_result(object):
    """
    Attributes:
     - success
     - io
     - ia

    """


    def __init__(self, success=None, io=None, ia=None,):
        self.success = success
        self.io = io
        self.ia = ia

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 0:
                if ftype == TType.LIST:
                    self.success = []
                    (_etype512, _size509) = iprot.readListBegin()
                    for _i513 in range(_size509):
                        _elem514 = TRowResult()
                        _elem514.read(iprot)
                        self.success.append(_elem514)
                    iprot.readListEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 1:
                if ftype == TType.STRUCT:
                    self.io = IOError()
                    self.io.read(iprot)
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.STRUCT:
                    self.ia = IllegalArgument()
                    self.ia.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('scannerGetList_result')
        if self.success is not None:
            oprot.writeFieldBegin('success', TType.LIST, 0)
            oprot.writeListBegin(TType.STRUCT, len(self.success))
            for iter515 in self.success:
                iter515.write(oprot)
            oprot.writeListEnd()
            oprot.writeFieldEnd()
        if self.io is not None:
            oprot.writeFieldBegin('io', TType.STRUCT, 1)
            self.io.write(oprot)
            oprot.writeFieldEnd()
        if self.ia is not None:
            oprot.writeFieldBegin('ia', TType.STRUCT, 2)
            self.ia.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(scannerGetList_result)
scannerGetList_result.thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRUCT, [TRowResult, None], False), None, ),  # 0
    (1, TType.STRUCT, 'io', [IOError, None], None, ),  # 1
    (2, TType.STRUCT, 'ia', [IllegalArgument, None], None, ),  # 2
)


class scannerClose_args(object):
    """
    Attributes:
     - id: id of a scanner returned by scannerOpen

    """


    def __init__(self, id=None,):
        self.id = id

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.I32:
                    self.id = iprot.readI32()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('scannerClose_args')
        if self.id is not None:
            oprot.writeFieldBegin('id', TType.I32, 1)
            oprot.writeI32(self.id)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(scannerClose_args)
scannerClose_args.thrift_spec = (
    None,  # 0
    (1, TType.I32, 'id', None, None, ),  # 1
)


class scannerClose_result(object):
    """
    Attributes:
     - io
     - ia

    """


    def __init__(self, io=None, ia=None,):
        self.io = io
        self.ia = ia

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRUCT:
                    self.io = IOError()
                    self.io.read(iprot)
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.STRUCT:
                    self.ia = IllegalArgument()
                    self.ia.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('scannerClose_result')
        if self.io is not None:
            oprot.writeFieldBegin('io', TType.STRUCT, 1)
            self.io.write(oprot)
            oprot.writeFieldEnd()
        if self.ia is not None:
            oprot.writeFieldBegin('ia', TType.STRUCT, 2)
            self.ia.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(scannerClose_result)
scannerClose_result.thrift_spec = (
    None,  # 0
    (1, TType.STRUCT, 'io', [IOError, None], None, ),  # 1
    (2, TType.STRUCT, 'ia', [IllegalArgument, None], None, ),  # 2
)


class getRegionInfo_args(object):
    """
    Attributes:
     - row: row key

    """


    def __init__(self, row=None,):
        self.row = row

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.row = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('getRegionInfo_args')
        if self.row is not None:
            oprot.writeFieldBegin('row', TType.STRING, 1)
            oprot.writeBinary(self.row)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(getRegionInfo_args)
getRegionInfo_args.thrift_spec = (
    None,  # 0
    (1, TType.STRING, 'row', 'BINARY', None, ),  # 1
)


class getRegionInfo_result(object):
    """
    Attributes:
     - success
     - io

    """


    def __init__(self, success=None, io=None,):
        self.success = success
        self.io = io

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 0:
                if ftype == TType.STRUCT:
                    self.success = TRegionInfo()
                    self.success.read(iprot)
                else:
                    iprot.skip(ftype)
            elif fid == 1:
                if ftype == TType.STRUCT:
                    self.io = IOError()
                    self.io.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('getRegionInfo_result')
        if self.success is not None:
            oprot.writeFieldBegin('success', TType.STRUCT, 0)
            self.success.write(oprot)
            oprot.writeFieldEnd()
        if self.io is not None:
            oprot.writeFieldBegin('io', TType.STRUCT, 1)
            self.io.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(getRegionInfo_result)
getRegionInfo_result.thrift_spec = (
    (0, TType.STRUCT, 'success', [TRegionInfo, None], None, ),  # 0
    (1, TType.STRUCT, 'io', [IOError, None], None, ),  # 1
)


class append_args(object):
    """
    Attributes:
     - append: The single append operation to apply

    """


    def __init__(self, append=None,):
        self.append = append

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRUCT:
                    self.append = TAppend()
                    self.append.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('append_args')
        if self.append is not None:
            oprot.writeFieldBegin('append', TType.STRUCT, 1)
            self.append.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(append_args)
append_args.thrift_spec = (
    None,  # 0
    (1, TType.STRUCT, 'append', [TAppend, None], None, ),  # 1
)


class append_result(object):
    """
    Attributes:
     - success
     - io

    """


    def __init__(self, success=None, io=None,):
        self.success = success
        self.io = io

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 0:
                if ftype == TType.LIST:
                    self.success = []
                    (_etype519, _size516) = iprot.readListBegin()
                    for _i520 in range(_size516):
                        _elem521 = TCell()
                        _elem521.read(iprot)
                        self.success.append(_elem521)
                    iprot.readListEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 1:
                if ftype == TType.STRUCT:
                    self.io = IOError()
                    self.io.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('append_result')
        if self.success is not None:
            oprot.writeFieldBegin('success', TType.LIST, 0)
            oprot.writeListBegin(TType.STRUCT, len(self.success))
            for iter522 in self.success:
                iter522.write(oprot)
            oprot.writeListEnd()
            oprot.writeFieldEnd()
        if self.io is not None:
            oprot.writeFieldBegin('io', TType.STRUCT, 1)
            self.io.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(append_result)
append_result.thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRUCT, [TCell, None], False), None, ),  # 0
    (1, TType.STRUCT, 'io', [IOError, None], None, ),  # 1
)


class checkAndPut_args(object):
    """
    Attributes:
     - tableName: name of table
     - row: row key
     - column: column name
     - value: the expected value for the column parameter, if not
    provided the check is for the non-existence of the
    column in question
     - mput: mutation for the put
     - attributes: Mutation attributes

    """


    def __init__(self, tableName=None, row=None, column=None, value=None, mput=None, attributes=None,):
        self.tableName = tableName
        self.row = row
        self.column = column
        self.value = value
        self.mput = mput
        self.attributes = attributes

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.tableName = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.STRING:
                    self.row = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            elif fid == 3:
                if ftype == TType.STRING:
                    self.column = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            elif fid == 5:
                if ftype == TType.STRING:
                    self.value = iprot.readBinary()
                else:
                    iprot.skip(ftype)
            elif fid == 6:
                if ftype == TType.STRUCT:
                    self.mput = Mutation()
                    self.mput.read(iprot)
                else:
                    iprot.skip(ftype)
            elif fid == 7:
                if ftype == TType.MAP:
                    self.attributes = {}
                    (_ktype524, _vtype525, _size523) = iprot.readMapBegin()
                    for _i527 in range(_size523):
                        _key528 = iprot.readBinary()
                        _val529 = iprot.readBinary()
                        self.attributes[_key528] = _val529
                    iprot.readMapEnd()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('checkAndPut_args')
        if self.tableName is not None:
            oprot.writeFieldBegin('tableName', TType.STRING, 1)
            oprot.writeBinary(self.tableName)
            oprot.writeFieldEnd()
        if self.row is not None:
            oprot.writeFieldBegin('row', TType.STRING, 2)
            oprot.writeBinary(self.row)
            oprot.writeFieldEnd()
        if self.column is not None:
            oprot.writeFieldBegin('column', TType.STRING, 3)
            oprot.writeBinary(self.column)
            oprot.writeFieldEnd()
        if self.value is not None:
            oprot.writeFieldBegin('value', TType.STRING, 5)
            oprot.writeBinary(self.value)
            oprot.writeFieldEnd()
        if self.mput is not None:
            oprot.writeFieldBegin('mput', TType.STRUCT, 6)
            self.mput.write(oprot)
            oprot.writeFieldEnd()
        if self.attributes is not None:
            oprot.writeFieldBegin('attributes', TType.MAP, 7)
            oprot.writeMapBegin(TType.STRING, TType.STRING, len(self.attributes))
            for kiter530, viter531 in self.attributes.items():
                oprot.writeBinary(kiter530)
                oprot.writeBinary(viter531)
            oprot.writeMapEnd()
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(checkAndPut_args)
checkAndPut_args.thrift_spec = (
    None,  # 0
    (1, TType.STRING, 'tableName', 'BINARY', None, ),  # 1
    (2, TType.STRING, 'row', 'BINARY', None, ),  # 2
    (3, TType.STRING, 'column', 'BINARY', None, ),  # 3
    None,  # 4
    (5, TType.STRING, 'value', 'BINARY', None, ),  # 5
    (6, TType.STRUCT, 'mput', [Mutation, None], None, ),  # 6
    (7, TType.MAP, 'attributes', (TType.STRING, 'BINARY', TType.STRING, 'BINARY', False), None, ),  # 7
)


class checkAndPut_result(object):
    """
    Attributes:
     - success
     - io
     - ia

    """


    def __init__(self, success=None, io=None, ia=None,):
        self.success = success
        self.io = io
        self.ia = ia

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 0:
                if ftype == TType.BOOL:
                    self.success = iprot.readBool()
                else:
                    iprot.skip(ftype)
            elif fid == 1:
                if ftype == TType.STRUCT:
                    self.io = IOError()
                    self.io.read(iprot)
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.STRUCT:
                    self.ia = IllegalArgument()
                    self.ia.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('checkAndPut_result')
        if self.success is not None:
            oprot.writeFieldBegin('success', TType.BOOL, 0)
            oprot.writeBool(self.success)
            oprot.writeFieldEnd()
        if self.io is not None:
            oprot.writeFieldBegin('io', TType.STRUCT, 1)
            self.io.write(oprot)
            oprot.writeFieldEnd()
        if self.ia is not None:
            oprot.writeFieldBegin('ia', TType.STRUCT, 2)
            self.ia.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(checkAndPut_result)
checkAndPut_result.thrift_spec = (
    (0, TType.BOOL, 'success', None, None, ),  # 0
    (1, TType.STRUCT, 'io', [IOError, None], None, ),  # 1
    (2, TType.STRUCT, 'ia', [IllegalArgument, None], None, ),  # 2
)


class getThriftServerType_args(object):


    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('getThriftServerType_args')
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(getThriftServerType_args)
getThriftServerType_args.thrift_spec = (
)


class getThriftServerType_result(object):
    """
    Attributes:
     - success

    """


    def __init__(self, success=None,):
        self.success = success

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 0:
                if ftype == TType.I32:
                    self.success = iprot.readI32()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('getThriftServerType_result')
        if self.success is not None:
            oprot.writeFieldBegin('success', TType.I32, 0)
            oprot.writeI32(self.success)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, value)
             for key, value in self.__dict__.items()]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not (self == other)
all_structs.append(getThriftServerType_result)
getThriftServerType_result.thrift_spec = (
    (0, TType.I32, 'success', None, None, ),  # 0
)
fix_spec(all_structs)
del all_structs
