/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.HashSet;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.StartMiniClusterOption;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNameTestRule;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.master.assignment.AssignmentManager;
import org.apache.hadoop.hbase.master.assignment.AssignmentTestingUtil;
import org.apache.hadoop.hbase.zookeeper.LoadBalancerTracker;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Rule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaWithReplicasTestBase {
    private static final Logger LOG = LoggerFactory.getLogger(MetaWithReplicasTestBase.class);
    protected static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    protected static final int REGIONSERVERS_COUNT = 3;
    @Rule
    public TableNameTestRule name = new TableNameTestRule();

    protected static void startCluster() throws Exception {
        TEST_UTIL.getConfiguration().setInt("zookeeper.session.timeout", 30000);
        TEST_UTIL.getConfiguration().setInt("hbase.regionserver.storefile.refresh.period", 1000);
        StartMiniClusterOption option = StartMiniClusterOption.builder().numAlwaysStandByMasters(1).numMasters(1).numRegionServers(3).build();
        TEST_UTIL.startMiniCluster(option);
        Admin admin = TEST_UTIL.getAdmin();
        HBaseTestingUtility.setReplicas(admin, TableName.META_TABLE_NAME, 3);
        AssignmentManager am = TEST_UTIL.getMiniHBaseCluster().getMaster().getAssignmentManager();
        HashSet<ServerName> sns = new HashSet<ServerName>();
        ServerName hbaseMetaServerName = am.getRegionStates().getRegionStateNode(RegionInfoBuilder.FIRST_META_REGIONINFO).getRegionLocation();
        LOG.info("HBASE:META DEPLOY: on " + hbaseMetaServerName);
        sns.add(hbaseMetaServerName);
        for (int replicaId = 1; replicaId < 3; ++replicaId) {
            RegionInfo h = RegionReplicaUtil.getRegionInfoForReplica((RegionInfo)RegionInfoBuilder.FIRST_META_REGIONINFO, (int)replicaId);
            AssignmentTestingUtil.waitForAssignment(am, h);
            ServerName sn = am.getRegionStates().getRegionServerOfRegion(h);
            Assert.assertNotNull((Object)sn);
            LOG.info("HBASE:META DEPLOY: " + h.getRegionNameAsString() + " on " + sn);
            sns.add(sn);
        }
        if (sns.size() == 1) {
            int metaServerIndex;
            int count = TEST_UTIL.getMiniHBaseCluster().getLiveRegionServerThreads().size();
            Assert.assertTrue((String)("count=" + count), (count == 3 ? 1 : 0) != 0);
            LOG.warn("All hbase:meta replicas are on the one server; moving hbase:meta: " + sns);
            int newServerIndex = metaServerIndex = TEST_UTIL.getHBaseCluster().getServerWithMeta();
            while (newServerIndex == metaServerIndex) {
                newServerIndex = (newServerIndex + 1) % 3;
            }
            Assert.assertNotEquals((long)metaServerIndex, (long)newServerIndex);
            ServerName destinationServerName = TEST_UTIL.getHBaseCluster().getRegionServer(newServerIndex).getServerName();
            ServerName metaServerName = TEST_UTIL.getHBaseCluster().getRegionServer(metaServerIndex).getServerName();
            Assert.assertNotEquals((Object)destinationServerName, (Object)metaServerName);
            TEST_UTIL.getAdmin().move(RegionInfoBuilder.FIRST_META_REGIONINFO.getEncodedNameAsBytes(), destinationServerName);
        }
        LoadBalancerTracker l = new LoadBalancerTracker(TEST_UTIL.getZooKeeperWatcher(), new Abortable(){
            AtomicBoolean aborted = new AtomicBoolean(false);

            public boolean isAborted() {
                return this.aborted.get();
            }

            public void abort(String why, Throwable e) {
                this.aborted.set(true);
            }
        });
        l.setBalancerOn(false);
        LOG.debug("All meta replicas assigned");
    }

    @AfterClass
    public static void tearDown() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }
}

