/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.redfish;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.hertzbeat.collector.collect.common.http.CommonHttpClient;
import org.apache.hertzbeat.collector.collect.redfish.ConnectSession;
import org.apache.hertzbeat.collector.collect.redfish.Session;
import org.apache.hertzbeat.common.util.IpDomainUtil;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;

public class RedfishConnectSession
implements ConnectSession {
    private final Session session;
    private volatile boolean active = true;

    public RedfishConnectSession(Session session) {
        this.session = session;
    }

    @Override
    public boolean isOpen() {
        return this.active;
    }

    @Override
    public void close() throws Exception {
        this.active = false;
        String url = "/redfish/v1/SessionService/Sessions" + this.session.location();
        HttpDelete httpDelete = new HttpDelete(url);
        httpDelete.setHeader("X-Auth-Token", this.session.token());
        httpDelete.setHeader("Location", this.session.location());
        try (CloseableHttpResponse response = CommonHttpClient.getHttpClient().execute((HttpUriRequest)httpDelete);){
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                throw new Exception("StatusCode " + statusCode);
            }
        }
        catch (Exception e) {
            throw new Exception("Redfish session close error:" + e.getMessage());
        }
        finally {
            httpDelete.abort();
        }
    }

    @Override
    public String getRedfishResource(String uri) throws Exception {
        if (uri.endsWith("/")) {
            uri = uri.substring(0, uri.length() - 1);
        }
        String url = null;
        if (IpDomainUtil.isHasSchema((String)this.session.host())) {
            url = this.session.host() + ":" + this.session.port() + uri;
        } else {
            String ipAddressType = IpDomainUtil.checkIpAddressType((String)this.session.host());
            String baseUri = "ipv6".equals(ipAddressType) ? String.format("[%s]:%s", this.session.host(), this.session.port() + uri) : String.format("%s:%s", this.session.host(), this.session.port() + uri);
            url = "https://" + baseUri;
        }
        HttpGet httpGet = new HttpGet(url);
        httpGet.setHeader("X-Auth-Token", this.session.token());
        httpGet.setHeader("Location", this.session.location());
        try {
            String string;
            block15: {
                CloseableHttpResponse response = CommonHttpClient.getHttpClient().execute((HttpUriRequest)httpGet);
                try {
                    int statusCode = response.getStatusLine().getStatusCode();
                    if (statusCode != 200) {
                        throw new Exception("StatusCode " + statusCode);
                    }
                    string = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
                    if (response == null) break block15;
                }
                catch (Throwable throwable) {
                    try {
                        if (response != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        throw new Exception("Redfish session get resource error:" + e.getMessage());
                    }
                }
                response.close();
            }
            return string;
        }
        finally {
            httpGet.abort();
        }
    }
}

