/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.extension.incubator.fileconfig;

import io.opentelemetry.sdk.autoconfigure.internal.SpiHelper;
import io.opentelemetry.sdk.extension.incubator.fileconfig.Factory;
import io.opentelemetry.sdk.extension.incubator.fileconfig.LogRecordLimitsAndAttributeLimits;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.AttributeLimitsModel;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.LogRecordLimitsModel;
import io.opentelemetry.sdk.logs.LogLimits;
import io.opentelemetry.sdk.logs.LogLimitsBuilder;
import java.io.Closeable;
import java.util.List;

final class LogLimitsFactory
implements Factory<LogRecordLimitsAndAttributeLimits, LogLimits> {
    private static final LogLimitsFactory INSTANCE = new LogLimitsFactory();

    private LogLimitsFactory() {
    }

    static LogLimitsFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public LogLimits create(LogRecordLimitsAndAttributeLimits model, SpiHelper spiHelper, List<Closeable> closeables) {
        LogRecordLimitsModel logRecordLimitsModel;
        LogLimitsBuilder builder = LogLimits.builder();
        AttributeLimitsModel attributeLimitsModel = model.getAttributeLimits();
        if (attributeLimitsModel != null) {
            if (attributeLimitsModel.getAttributeCountLimit() != null) {
                builder.setMaxNumberOfAttributes(attributeLimitsModel.getAttributeCountLimit().intValue());
            }
            if (attributeLimitsModel.getAttributeValueLengthLimit() != null) {
                builder.setMaxAttributeValueLength(attributeLimitsModel.getAttributeValueLengthLimit().intValue());
            }
        }
        if ((logRecordLimitsModel = model.getLogRecordLimits()) != null) {
            if (logRecordLimitsModel.getAttributeCountLimit() != null) {
                builder.setMaxNumberOfAttributes(logRecordLimitsModel.getAttributeCountLimit().intValue());
            }
            if (logRecordLimitsModel.getAttributeValueLengthLimit() != null) {
                builder.setMaxAttributeValueLength(logRecordLimitsModel.getAttributeValueLengthLimit().intValue());
            }
        }
        return builder.build();
    }
}

