/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.ws;

import com.alibaba.fastjson.JSONObject;
import com.taosdata.jdbc.ws.InFlightRequest;
import com.taosdata.jdbc.ws.ResponseFuture;
import com.taosdata.jdbc.ws.entity.Action;
import com.taosdata.jdbc.ws.entity.Code;
import com.taosdata.jdbc.ws.entity.FetchBlockResp;
import com.taosdata.jdbc.ws.entity.Payload;
import com.taosdata.jdbc.ws.entity.Request;
import com.taosdata.jdbc.ws.entity.Response;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ServerHandshake;

public class WSClient
extends WebSocketClient
implements AutoCloseable {
    private final String user;
    private final String password;
    private final String database;
    private final CountDownLatch latch;
    private final InFlightRequest inFlightRequest;
    ThreadPoolExecutor executor;
    private boolean auth;
    private int reqId;

    public boolean isAuth() {
        return this.auth;
    }

    public WSClient(URI serverUri, String user, String password, String database, InFlightRequest inFlightRequest, Map<String, String> httpHeaders, CountDownLatch latch, int maxRequest) {
        super(serverUri, httpHeaders);
        this.user = user;
        this.password = password;
        this.database = database;
        this.inFlightRequest = inFlightRequest;
        this.latch = latch;
        this.executor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(maxRequest), r -> {
            Thread t = new Thread(r);
            t.setName("parse-message-" + t.getId());
            return t;
        }, new ThreadPoolExecutor.CallerRunsPolicy());
    }

    public void onOpen(ServerHandshake serverHandshake) {
        ConnectReq connectReq = new ConnectReq(++this.reqId, this.user, this.password, this.database);
        this.send(new Request(Action.CONN.getAction(), connectReq).toString());
    }

    public void onMessage(String message) {
        if (!"".equals(message)) {
            this.executor.submit(() -> {
                JSONObject jsonObject = JSONObject.parseObject((String)message);
                if (Action.CONN.getAction().equals(jsonObject.getString("action"))) {
                    if (Code.SUCCESS.getCode() != jsonObject.getInteger("code").intValue()) {
                        this.close();
                    } else {
                        this.auth = true;
                    }
                    this.latch.countDown();
                } else {
                    Response response = this.parseMessage(jsonObject);
                    ResponseFuture remove = this.inFlightRequest.remove(response.getAction(), response.getReqId());
                    if (null != remove) {
                        remove.getFuture().complete(response);
                    }
                }
            });
        }
    }

    private Response parseMessage(JSONObject message) {
        Action action = Action.of(message.getString("action"));
        return (Response)message.toJavaObject(action.getResponseClazz());
    }

    public void onMessage(ByteBuffer bytes) {
        bytes.order(ByteOrder.LITTLE_ENDIAN);
        bytes.position(8);
        long id = bytes.getLong();
        ResponseFuture remove = this.inFlightRequest.remove(Action.FETCH_BLOCK.getAction(), id);
        if (null != remove) {
            FetchBlockResp fetchBlockResp = new FetchBlockResp(id, bytes);
            remove.getFuture().complete(fetchBlockResp);
        }
    }

    public void onClose(int code, String reason, boolean remote) {
        if (remote) {
            throw new RuntimeException("The remote server closed the connection: " + reason);
        }
        throw new RuntimeException("close connection: " + reason);
    }

    public void onError(Exception e) {
        this.close();
    }

    @Override
    public void close() {
        super.close();
        this.executor.shutdown();
    }

    static class ConnectReq
    extends Payload {
        private String user;
        private String password;
        private String db;

        public ConnectReq(long reqId, String user, String password, String db) {
            super(reqId);
            this.user = user;
            this.password = password;
            this.db = db;
        }

        public String getUser() {
            return this.user;
        }

        public void setUser(String user) {
            this.user = user;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public String getDb() {
            return this.db;
        }

        public void setDb(String db) {
            this.db = db;
        }
    }
}

