/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.web.v3_1;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import java.io.IOException;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;

final class RestTemplateInterceptor
implements ClientHttpRequestInterceptor {
    private final Instrumenter<HttpRequest, ClientHttpResponse> instrumenter;

    RestTemplateInterceptor(Instrumenter<HttpRequest, ClientHttpResponse> instrumenter) {
        this.instrumenter = instrumenter;
    }

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        ClientHttpResponse response;
        Context parentContext = Context.current();
        if (!this.instrumenter.shouldStart(parentContext, (Object)request)) {
            return execution.execute(request, body);
        }
        Context context = this.instrumenter.start(parentContext, (Object)request);
        try (Scope ignored = context.makeCurrent();){
            response = execution.execute(request, body);
        }
        catch (Throwable t) {
            this.instrumenter.end(context, (Object)request, null, t);
            throw t;
        }
        this.instrumenter.end(context, (Object)request, (Object)response, null);
        return response;
    }
}

