/*
 * Decompiled with CFR 0.152.
 */
package io.greptime.signal;

import io.greptime.common.SPI;
import io.greptime.common.signal.FileOutputHelper;
import io.greptime.common.signal.FileSignal;
import io.greptime.common.signal.FileSignalHelper;
import io.greptime.common.signal.SignalHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SPI(priority=99)
public class ShowHelpSignalHandler
implements SignalHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ShowHelpSignalHandler.class);

    public void handle(String signalName) {
        String outDir = FileOutputHelper.getOutDir();
        LOG.info("-- GreptimeDB Signal Help --");
        LOG.info("    Signal output dir: {}", (Object)outDir);
        for (FileSignal fileSignal : FileSignal.values()) {
            ShowHelpSignalHandler.formatLog(outDir, fileSignal);
        }
        LOG.info("    How to get metrics and display info:");
        LOG.info("      [1] `cd {}`", (Object)outDir);
        LOG.info("      [2] `rm *.sig`");
        LOG.info("      [3] `kill -s SIGUSR2 $pid`");
        LOG.info("");
        LOG.info("    The file signals that is currently open:");
        for (String string : FileSignalHelper.list()) {
            LOG.info("      {}", (Object)string);
        }
        LOG.info("");
    }

    private static void formatLog(String outDir, FileSignal fileSignal) {
        LOG.info("");
        LOG.info("    {}:", (Object)fileSignal.getComment());
        LOG.info("      [1] `cd {}`", (Object)outDir);
        LOG.info("      [2] `touch {}`", (Object)fileSignal.getFilename());
        LOG.info("      [3] `kill -s SIGUSR2 $pid`");
        LOG.info("      [4] `rm {}`", (Object)fileSignal.getFilename());
        LOG.info("");
    }
}

