/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tools.command.message;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.client.exception.MQBrokerException;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageClientExt;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.common.protocol.body.ConsumeMessageDirectlyResult;
import org.apache.rocketmq.remoting.RPCHook;
import org.apache.rocketmq.remoting.common.RemotingHelper;
import org.apache.rocketmq.remoting.exception.RemotingException;
import org.apache.rocketmq.tools.admin.DefaultMQAdminExt;
import org.apache.rocketmq.tools.admin.api.MessageTrack;
import org.apache.rocketmq.tools.command.SubCommand;
import org.apache.rocketmq.tools.command.SubCommandException;

public class QueryMsgByIdSubCommand
implements SubCommand {
    public static void queryById(DefaultMQAdminExt admin, String msgId) throws MQClientException, RemotingException, MQBrokerException, InterruptedException, IOException {
        MessageExt msg = admin.viewMessage(msgId);
        QueryMsgByIdSubCommand.printMsg(admin, msg);
    }

    public static void printMsg(DefaultMQAdminExt admin, MessageExt msg) throws IOException {
        if (msg == null) {
            System.out.printf("%nMessage not found!", new Object[0]);
            return;
        }
        String bodyTmpFilePath = QueryMsgByIdSubCommand.createBodyFile(msg);
        String msgId = msg.getMsgId();
        if (msg instanceof MessageClientExt) {
            msgId = ((MessageClientExt)msg).getOffsetMsgId();
        }
        System.out.printf("%-20s %s%n", "OffsetID:", msgId);
        System.out.printf("%-20s %s%n", "Topic:", msg.getTopic());
        System.out.printf("%-20s %s%n", "Tags:", "[" + msg.getTags() + "]");
        System.out.printf("%-20s %s%n", "Keys:", "[" + msg.getKeys() + "]");
        System.out.printf("%-20s %d%n", "Queue ID:", msg.getQueueId());
        System.out.printf("%-20s %d%n", "Queue Offset:", msg.getQueueOffset());
        System.out.printf("%-20s %d%n", "CommitLog Offset:", msg.getCommitLogOffset());
        System.out.printf("%-20s %d%n", "Reconsume Times:", msg.getReconsumeTimes());
        System.out.printf("%-20s %s%n", "Born Timestamp:", UtilAll.timeMillisToHumanString2((long)msg.getBornTimestamp()));
        System.out.printf("%-20s %s%n", "Store Timestamp:", UtilAll.timeMillisToHumanString2((long)msg.getStoreTimestamp()));
        System.out.printf("%-20s %s%n", "Born Host:", RemotingHelper.parseSocketAddressAddr((SocketAddress)msg.getBornHost()));
        System.out.printf("%-20s %s%n", "Store Host:", RemotingHelper.parseSocketAddressAddr((SocketAddress)msg.getStoreHost()));
        System.out.printf("%-20s %d%n", "System Flag:", msg.getSysFlag());
        System.out.printf("%-20s %s%n", "Properties:", msg.getProperties() != null ? msg.getProperties().toString() : "");
        System.out.printf("%-20s %s%n", "Message Body Path:", bodyTmpFilePath);
        try {
            List<MessageTrack> mtdList = admin.messageTrackDetail(msg);
            if (mtdList.isEmpty()) {
                System.out.printf("%n%nWARN: No Consumer", new Object[0]);
            } else {
                System.out.printf("%n%n", new Object[0]);
                for (MessageTrack mt : mtdList) {
                    System.out.printf("%s", mt);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String createBodyFile(MessageExt msg) throws IOException {
        try (FilterOutputStream dos = null;){
            String bodyTmpFilePath = "/tmp/rocketmq/msgbodys";
            File file = new File(bodyTmpFilePath);
            if (!file.exists()) {
                file.mkdirs();
            }
            bodyTmpFilePath = bodyTmpFilePath + "/" + msg.getMsgId();
            dos = new DataOutputStream(new FileOutputStream(bodyTmpFilePath));
            dos.write(msg.getBody());
            String string = bodyTmpFilePath;
            return string;
        }
    }

    @Override
    public String commandName() {
        return "queryMsgById";
    }

    @Override
    public String commandDesc() {
        return "Query Message by Id";
    }

    @Override
    public Options buildCommandlineOptions(Options options) {
        Option opt = new Option("i", "msgId", true, "Message Id");
        opt.setRequired(true);
        options.addOption(opt);
        opt = new Option("g", "consumerGroup", true, "consumer group name");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("d", "clientId", true, "The consumer's client id");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("s", "sendMessage", true, "resend message");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("u", "unitName", true, "unit name");
        opt.setRequired(false);
        options.addOption(opt);
        return options;
    }

    @Override
    public void execute(CommandLine commandLine, Options options, RPCHook rpcHook) throws SubCommandException {
        DefaultMQAdminExt defaultMQAdminExt = new DefaultMQAdminExt(rpcHook);
        defaultMQAdminExt.setInstanceName(Long.toString(System.currentTimeMillis()));
        DefaultMQProducer defaultMQProducer = new DefaultMQProducer("ReSendMsgById");
        defaultMQProducer.setInstanceName(Long.toString(System.currentTimeMillis()));
        try {
            defaultMQAdminExt.start();
            if (commandLine.hasOption('s')) {
                if (commandLine.hasOption('u')) {
                    String unitName = commandLine.getOptionValue('u').trim();
                    defaultMQProducer.setUnitName(unitName);
                }
                defaultMQProducer.start();
            }
            String msgIds = commandLine.getOptionValue('i').trim();
            String[] msgIdArr = StringUtils.split((String)msgIds, (String)",");
            if (commandLine.hasOption('g') && commandLine.hasOption('d')) {
                String consumerGroup = commandLine.getOptionValue('g').trim();
                String clientId = commandLine.getOptionValue('d').trim();
                for (String msgId : msgIdArr) {
                    if (!StringUtils.isNotBlank((CharSequence)msgId)) continue;
                    this.pushMsg(defaultMQAdminExt, consumerGroup, clientId, msgId.trim());
                }
            } else if (commandLine.hasOption('s')) {
                boolean resend = Boolean.parseBoolean(commandLine.getOptionValue('s', "false").trim());
                if (resend) {
                    for (String msgId : msgIdArr) {
                        if (!StringUtils.isNotBlank((CharSequence)msgId)) continue;
                        this.sendMsg(defaultMQAdminExt, defaultMQProducer, msgId.trim());
                    }
                }
            } else {
                for (String msgId : msgIdArr) {
                    if (!StringUtils.isNotBlank((CharSequence)msgId)) continue;
                    QueryMsgByIdSubCommand.queryById(defaultMQAdminExt, msgId.trim());
                }
            }
        }
        catch (Exception e) {
            throw new SubCommandException(this.getClass().getSimpleName() + " command failed", e);
        }
        finally {
            defaultMQProducer.shutdown();
            defaultMQAdminExt.shutdown();
        }
    }

    private void pushMsg(DefaultMQAdminExt defaultMQAdminExt, String consumerGroup, String clientId, String msgId) {
        try {
            ConsumeMessageDirectlyResult result = defaultMQAdminExt.consumeMessageDirectly(consumerGroup, clientId, msgId);
            System.out.printf("%s", result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void sendMsg(DefaultMQAdminExt defaultMQAdminExt, DefaultMQProducer defaultMQProducer, String msgId) throws RemotingException, MQBrokerException, InterruptedException, MQClientException {
        try {
            MessageExt msg = defaultMQAdminExt.viewMessage(msgId);
            if (msg != null) {
                System.out.printf("prepare resend msg. originalMsgId=%s", msgId);
                SendResult result = defaultMQProducer.send((Message)msg);
                System.out.printf("%s", result);
            } else {
                System.out.printf("no message. msgId=%s", msgId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

