/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.r2dbc.v1_0.internal.shaded.io.r2dbc.proxy.core;

import io.opentelemetry.instrumentation.r2dbc.v1_0.internal.shaded.io.r2dbc.proxy.core.Binding;
import io.opentelemetry.instrumentation.r2dbc.v1_0.internal.shaded.io.r2dbc.proxy.core.BoundValue;
import io.opentelemetry.instrumentation.r2dbc.v1_0.internal.shaded.io.r2dbc.proxy.util.Assert;
import java.util.Comparator;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;
import reactor.util.annotation.NonNull;

public class Bindings {
    private final SortedSet<Binding> indexBindings = new TreeSet<Binding>();
    private final SortedSet<Binding> namedBindings = new TreeSet<Binding>();

    public static IndexBinding indexBinding(int index, BoundValue boundValue) {
        return new IndexBinding(index, boundValue);
    }

    public static NamedBinding namedBinding(String name, BoundValue boundValue) {
        return new NamedBinding(name, boundValue);
    }

    public void addIndexBinding(IndexBinding indexBinding) {
        Assert.requireNonNull(indexBinding, "indexBinding must not be null");
        this.indexBindings.add(indexBinding);
    }

    public void addNamedBinding(NamedBinding namedBinding) {
        Assert.requireNonNull(namedBinding, "namedBinding must not be null");
        this.namedBindings.add(namedBinding);
    }

    public SortedSet<Binding> getIndexBindings() {
        return this.indexBindings;
    }

    public SortedSet<Binding> getNamedBindings() {
        return this.namedBindings;
    }

    public static class NamedBinding
    implements Binding,
    Comparable<NamedBinding> {
        private String name;
        private BoundValue boundValue;

        private NamedBinding(String name, BoundValue boundValue) {
            Assert.requireNonNull(name, "name must not be null");
            Assert.requireNonNull(boundValue, "boundValue must not be null");
            this.name = name;
            this.boundValue = boundValue;
        }

        @Override
        public int compareTo(@NonNull NamedBinding o) {
            return Objects.compare(this.name, o.name, Comparator.naturalOrder());
        }

        @Override
        public Object getKey() {
            return this.name;
        }

        @Override
        public BoundValue getBoundValue() {
            return this.boundValue;
        }
    }

    public static class IndexBinding
    implements Binding,
    Comparable<IndexBinding> {
        private int index;
        private BoundValue boundValue;

        private IndexBinding(int index, BoundValue boundValue) {
            Assert.requireNonNull(boundValue, "boundValue must not be null");
            this.index = index;
            this.boundValue = boundValue;
        }

        @Override
        public int compareTo(@NonNull IndexBinding o) {
            return Integer.compare(this.index, o.index);
        }

        @Override
        public Object getKey() {
            return this.index;
        }

        @Override
        public BoundValue getBoundValue() {
            return this.boundValue;
        }
    }
}

