/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.autoconfigure.internal.instrumentation.logging;

import io.opentelemetry.instrumentation.spring.autoconfigure.internal.instrumentation.logging.LogbackAppenderInstaller;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.GenericApplicationListener;
import org.springframework.core.ResolvableType;

public class LogbackAppenderApplicationListener
implements GenericApplicationListener {
    private static final Class<?>[] SOURCE_TYPES = new Class[]{SpringApplication.class, ApplicationContext.class};
    private static final Class<?>[] EVENT_TYPES = new Class[]{ApplicationEnvironmentPreparedEvent.class};
    private static final boolean LOGBACK_PRESENT = LogbackAppenderApplicationListener.isLogbackPresent();

    public boolean supportsSourceType(Class<?> sourceType) {
        return LogbackAppenderApplicationListener.isAssignableFrom(sourceType, SOURCE_TYPES);
    }

    public boolean supportsEventType(ResolvableType resolvableType) {
        return LogbackAppenderApplicationListener.isAssignableFrom(resolvableType.getRawClass(), EVENT_TYPES);
    }

    private static boolean isAssignableFrom(Class<?> type, Class<?> ... supportedTypes) {
        if (type != null) {
            for (Class<?> supportedType : supportedTypes) {
                if (!supportedType.isAssignableFrom(type)) continue;
                return true;
            }
        }
        return false;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (!LOGBACK_PRESENT) {
            return;
        }
        if (event instanceof ApplicationEnvironmentPreparedEvent) {
            LogbackAppenderInstaller.install((ApplicationEnvironmentPreparedEvent)event);
        }
    }

    public int getOrder() {
        return -2147483627;
    }

    private static boolean isLogbackPresent() {
        try {
            Class.forName("ch.qos.logback.core.Appender");
            return true;
        }
        catch (ClassNotFoundException exception) {
            return false;
        }
    }
}

