/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.common.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.channels.Channels;
import java.util.ArrayList;
import java.util.List;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.ipc.ArrowStreamReader;
import org.apache.arrow.vector.ipc.ArrowStreamWriter;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ArrowUtil {
    private static final Logger log = LoggerFactory.getLogger(ArrowUtil.class);

    private ArrowUtil() {
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static byte[] serializeMultipleRoots(List<VectorSchemaRoot> roots) {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            Object object;
            try (DataOutputStream dataOut = new DataOutputStream(out);){
                dataOut.writeInt(roots.size());
                for (VectorSchemaRoot root : roots) {
                    ArrowStreamWriter writer = new ArrowStreamWriter(root, null, Channels.newChannel(out));
                    writer.start();
                    writer.writeBatch();
                    writer.end();
                    writer.close();
                    root.close();
                }
                object = out.toByteArray();
            }
            return object;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to serialize multiple VectorSchemaRoots", e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static List<VectorSchemaRoot> deserializeMultipleRoots(byte[] data) {
        ArrayList<VectorSchemaRoot> roots = new ArrayList<VectorSchemaRoot>();
        try (ByteArrayInputStream in = new ByteArrayInputStream(data);){
            ArrayList<VectorSchemaRoot> arrayList;
            try (DataInputStream dataIn = new DataInputStream(in);){
                int rootCount = dataIn.readInt();
                RootAllocator allocator = new RootAllocator();
                for (int i = 0; i < rootCount; ++i) {
                    ArrowStreamReader reader = new ArrowStreamReader(Channels.newChannel(in), (BufferAllocator)allocator);
                    VectorSchemaRoot root = reader.getVectorSchemaRoot();
                    reader.loadNextBatch();
                    roots.add(root);
                }
                arrayList = roots;
            }
            return arrayList;
        }
        catch (IOException e) {
            roots.forEach(VectorSchemaRoot::close);
            throw new RuntimeException("Failed to deserialize multiple VectorSchemaRoots", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<CollectRep.MetricsData> deserializeMetricsData(byte[] data) {
        if (data == null || data.length == 0) {
            return new ArrayList<CollectRep.MetricsData>();
        }
        List<VectorSchemaRoot> roots = ArrowUtil.deserializeMultipleRoots(data);
        ArrayList<CollectRep.MetricsData> metricsDataList = new ArrayList<CollectRep.MetricsData>(roots.size());
        try {
            for (VectorSchemaRoot root : roots) {
                if (root == null) continue;
                CollectRep.MetricsData metricsData = new CollectRep.MetricsData(root);
                metricsDataList.add(metricsData);
            }
        }
        finally {
            roots.forEach(VectorSchemaRoot::close);
        }
        return metricsDataList;
    }

    public static byte[] serializeMetricsData(List<CollectRep.MetricsData> metricsDataList) {
        ArrayList<VectorSchemaRoot> roots = new ArrayList<VectorSchemaRoot>(metricsDataList.size());
        for (CollectRep.MetricsData metricsData : metricsDataList) {
            VectorSchemaRoot root = metricsData.toVectorSchemaRootAndRelease();
            roots.add(root);
        }
        return ArrowUtil.serializeMultipleRoots(roots);
    }
}

