/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.manager.service.ai;

import io.jsonwebtoken.lang.Assert;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.hertzbeat.common.constants.AiConstants;
import org.apache.hertzbeat.common.constants.AiTypeEnum;
import org.apache.hertzbeat.manager.config.AiProperties;
import org.apache.hertzbeat.manager.pojo.dto.AiMessage;
import org.apache.hertzbeat.manager.pojo.dto.OpenAiRequestParamDTO;
import org.apache.hertzbeat.manager.pojo.dto.OpenAiResponse;
import org.apache.hertzbeat.manager.service.ai.AiService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.codec.ServerSentEvent;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.ExchangeStrategies;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Flux;

@Service(value="OllamaServiceImpl")
@ConditionalOnProperty(prefix="ai", name={"type"}, havingValue="ollama")
public class OllamaAiService
implements AiService {
    private static final Logger log = LoggerFactory.getLogger(OllamaAiService.class);
    @Autowired
    private AiProperties aiProperties;
    private WebClient webClient;

    @PostConstruct
    private void init() {
        Assert.notNull((Object)this.aiProperties.getApiUrl(), (String)"Ollama API URL is null");
        this.webClient = WebClient.builder().baseUrl(this.aiProperties.getApiUrl()).defaultHeader("Content-Type", new String[]{"application/json"}).exchangeStrategies(ExchangeStrategies.builder().codecs(item -> item.defaultCodecs().maxInMemorySize(0x1000000)).build()).build();
    }

    @Override
    public AiTypeEnum getType() {
        return AiTypeEnum.ollama;
    }

    @Override
    public Flux<ServerSentEvent<String>> requestAi(String text) {
        this.checkParam(text, this.aiProperties.getModel());
        OpenAiRequestParamDTO ollamaParam = OpenAiRequestParamDTO.builder().model(this.aiProperties.getModel()).stream(Boolean.TRUE).maxTokens(AiConstants.OllamaConstants.MAX_TOKENS).temperature(0.7f).messages(List.of(new AiMessage("user", text))).build();
        return this.webClient.post().body(BodyInserters.fromValue((Object)ollamaParam)).retrieve().bodyToFlux(String.class).filter(aiResponse -> !"[DONE]".equals(aiResponse)).map(OpenAiResponse::convertToResponse).doOnError(error -> log.info("OllamaAiService.requestAi exception:{}", (Object)error.getMessage()));
    }

    private void checkParam(String param, String model) {
        Assert.notNull((Object)param, (String)"text is null");
        Assert.notNull((Object)model, (String)"model is null");
    }
}

