/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.accumulo.serde;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.hadoop.hive.accumulo.columns.ColumnEncoding;
import org.apache.hadoop.hive.accumulo.columns.ColumnMapping;
import org.apache.hadoop.hive.accumulo.columns.HiveAccumuloColumnMapping;
import org.apache.hadoop.hive.accumulo.columns.HiveAccumuloMapColumnMapping;
import org.apache.hadoop.hive.accumulo.serde.AccumuloRowIdFactory;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.hive.serde2.lazy.LazySerDeParameters;
import org.apache.hadoop.hive.serde2.lazy.LazyUtils;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccumuloRowSerializer {
    private static final Logger log = LoggerFactory.getLogger(AccumuloRowSerializer.class);
    private final int rowIdOffset;
    private final ByteStream.Output output;
    private final LazySerDeParameters serDeParams;
    private final List<ColumnMapping> mappings;
    private final ColumnVisibility visibility;
    private final AccumuloRowIdFactory rowIdFactory;

    public AccumuloRowSerializer(int primaryKeyOffset, LazySerDeParameters serDeParams, List<ColumnMapping> mappings, ColumnVisibility visibility, AccumuloRowIdFactory rowIdFactory) {
        Preconditions.checkArgument((primaryKeyOffset >= 0 ? 1 : 0) != 0, (Object)("A valid offset to the mapping for the Accumulo RowID is required, received " + primaryKeyOffset));
        this.rowIdOffset = primaryKeyOffset;
        this.output = new ByteStream.Output();
        this.serDeParams = serDeParams;
        this.mappings = mappings;
        this.visibility = visibility;
        this.rowIdFactory = rowIdFactory;
    }

    public Mutation serialize(Object obj, ObjectInspector objInspector) throws SerDeException, IOException {
        if (objInspector.getCategory() != ObjectInspector.Category.STRUCT) {
            throw new SerDeException(this.getClass().toString() + " can only serialize struct types, but we got: " + objInspector.getTypeName());
        }
        StructObjectInspector soi = (StructObjectInspector)objInspector;
        List fields = soi.getAllStructFieldRefs();
        List columnValues = soi.getStructFieldsDataAsList(obj);
        if (this.rowIdOffset >= fields.size()) {
            throw new IllegalStateException("Attempted to access field outside of definition for struct. Have " + fields.size() + " fields and tried to access offset " + this.rowIdOffset);
        }
        StructField field = (StructField)fields.get(this.rowIdOffset);
        Object value = columnValues.get(this.rowIdOffset);
        ObjectInspector fieldObjectInspector = field.getFieldObjectInspector();
        byte[] data = this.rowIdFactory.serializeRowId(value, field, this.output);
        Mutation mutation = new Mutation(data);
        for (int i = 0; i < fields.size(); ++i) {
            if (this.rowIdOffset == i) continue;
            field = (StructField)fields.get(i);
            value = columnValues.get(i);
            if (null == value) continue;
            fieldObjectInspector = field.getFieldObjectInspector();
            ColumnMapping mapping = this.mappings.get(i);
            if (mapping instanceof HiveAccumuloColumnMapping) {
                this.serializeColumnMapping((HiveAccumuloColumnMapping)mapping, fieldObjectInspector, value, mutation);
                continue;
            }
            if (mapping instanceof HiveAccumuloMapColumnMapping) {
                this.serializeColumnMapping((HiveAccumuloMapColumnMapping)mapping, fieldObjectInspector, value, mutation);
                continue;
            }
            throw new IllegalArgumentException("Mapping for " + field.getFieldName() + " was not a HiveColumnMapping, but was " + String.valueOf(mapping.getClass()));
        }
        return mutation;
    }

    protected void serializeColumnMapping(HiveAccumuloColumnMapping columnMapping, ObjectInspector fieldObjectInspector, Object value, Mutation mutation) throws IOException {
        byte[] serializedValue = this.getSerializedValue(fieldObjectInspector, value, this.output, columnMapping);
        mutation.put(columnMapping.getColumnFamilyBytes(), columnMapping.getColumnQualifierBytes(), this.visibility, serializedValue);
    }

    protected void serializeColumnMapping(HiveAccumuloMapColumnMapping columnMapping, ObjectInspector fieldObjectInspector, Object value, Mutation mutation) throws IOException {
        MapObjectInspector mapObjectInspector = (MapObjectInspector)fieldObjectInspector;
        Map map = mapObjectInspector.getMap(value);
        if (map == null) {
            return;
        }
        ObjectInspector keyObjectInspector = mapObjectInspector.getMapKeyObjectInspector();
        ObjectInspector valueObjectInspector = mapObjectInspector.getMapValueObjectInspector();
        byte[] cfBytes = columnMapping.getColumnFamily().getBytes(Charsets.UTF_8);
        byte[] cqPrefixBytes = columnMapping.getColumnQualifierPrefix().getBytes(Charsets.UTF_8);
        for (Map.Entry entry : map.entrySet()) {
            this.output.reset();
            if (0 < cqPrefixBytes.length) {
                this.output.write(cqPrefixBytes, 0, cqPrefixBytes.length);
            }
            this.writeWithLevel(keyObjectInspector, entry.getKey(), this.output, columnMapping, 3);
            byte[] cqBytes = this.output.toByteArray();
            this.output.reset();
            this.writeWithLevel(valueObjectInspector, entry.getValue(), this.output, columnMapping, 3);
            byte[] valueBytes = this.output.toByteArray();
            mutation.put(cfBytes, cqBytes, this.visibility, valueBytes);
        }
    }

    protected byte[] serializeRowId(Object rowId, StructField rowIdField, ColumnMapping rowIdMapping) throws IOException {
        if (rowId == null) {
            throw new IOException("Accumulo rowId cannot be NULL");
        }
        this.output.reset();
        ObjectInspector rowIdFieldOI = rowIdField.getFieldObjectInspector();
        String rowIdMappingType = rowIdMapping.getColumnType();
        TypeInfo rowIdTypeInfo = TypeInfoUtils.getTypeInfoFromTypeString((String)rowIdMappingType);
        if (!rowIdFieldOI.getCategory().equals((Object)ObjectInspector.Category.PRIMITIVE) && rowIdTypeInfo.getCategory() == ObjectInspector.Category.PRIMITIVE) {
            this.writeString(this.output, SerDeUtils.getJSONString((Object)rowId, (ObjectInspector)rowIdFieldOI), (PrimitiveObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector);
            return this.output.toByteArray();
        }
        this.getSerializedValue(rowIdFieldOI, rowId, this.output, rowIdMapping);
        return this.output.toByteArray();
    }

    protected byte[] getSerializedValue(ObjectInspector fieldObjectInspector, Object value, ByteStream.Output output, ColumnMapping mapping) throws IOException {
        output.reset();
        if (fieldObjectInspector.getCategory() == ObjectInspector.Category.PRIMITIVE) {
            this.writeSerializedPrimitive((PrimitiveObjectInspector)fieldObjectInspector, output, value, mapping.getEncoding());
        } else {
            this.writeWithLevel(fieldObjectInspector, value, output, mapping, 2);
        }
        return output.toByteArray();
    }

    protected void writeWithLevel(ObjectInspector oi, Object value, ByteStream.Output output, ColumnMapping mapping, int level) throws IOException {
        switch (oi.getCategory()) {
            case PRIMITIVE: {
                if (mapping.getEncoding() == ColumnEncoding.BINARY) {
                    this.writeBinary(output, value, (PrimitiveObjectInspector)oi);
                } else {
                    this.writeString(output, value, (PrimitiveObjectInspector)oi);
                }
                return;
            }
            case LIST: {
                char separator = (char)this.serDeParams.getSeparators()[level];
                ListObjectInspector loi = (ListObjectInspector)oi;
                List list = loi.getList(value);
                ObjectInspector eoi = loi.getListElementObjectInspector();
                if (list == null) {
                    log.debug("No objects found when serializing list");
                    return;
                }
                for (int i = 0; i < list.size(); ++i) {
                    if (i > 0) {
                        output.write((int)separator);
                    }
                    this.writeWithLevel(eoi, list.get(i), output, mapping, level + 1);
                }
                return;
            }
            case MAP: {
                char sep = (char)this.serDeParams.getSeparators()[level];
                char keyValueSeparator = (char)this.serDeParams.getSeparators()[level + 1];
                MapObjectInspector moi = (MapObjectInspector)oi;
                ObjectInspector koi = moi.getMapKeyObjectInspector();
                ObjectInspector voi = moi.getMapValueObjectInspector();
                Map map = moi.getMap(value);
                if (map == null) {
                    log.debug("No object found when serializing map");
                    return;
                }
                boolean first = true;
                for (Map.Entry entry : map.entrySet()) {
                    if (first) {
                        first = false;
                    } else {
                        output.write((int)sep);
                    }
                    this.writeWithLevel(koi, entry.getKey(), output, mapping, level + 2);
                    output.write((int)keyValueSeparator);
                    this.writeWithLevel(voi, entry.getValue(), output, mapping, level + 2);
                }
                return;
            }
            case STRUCT: {
                char sep = (char)this.serDeParams.getSeparators()[level];
                StructObjectInspector soi = (StructObjectInspector)oi;
                List fields = soi.getAllStructFieldRefs();
                List list = soi.getStructFieldsDataAsList(value);
                if (list == null) {
                    log.debug("No object found when serializing struct");
                    return;
                }
                for (int i = 0; i < list.size(); ++i) {
                    if (i > 0) {
                        output.write((int)sep);
                    }
                    this.writeWithLevel(((StructField)fields.get(i)).getFieldObjectInspector(), list.get(i), output, mapping, level + 1);
                }
                return;
            }
        }
        throw new RuntimeException("Unknown category type: " + String.valueOf(oi.getCategory()));
    }

    protected void writeSerializedPrimitive(PrimitiveObjectInspector objectInspector, ByteStream.Output output, Object value, ColumnEncoding encoding) throws IOException {
        if (objectInspector.getPrimitiveCategory() != PrimitiveObjectInspector.PrimitiveCategory.STRING && ColumnEncoding.BINARY == encoding) {
            this.writeBinary(output, value, objectInspector);
        } else {
            this.writeString(output, value, objectInspector);
        }
    }

    protected void writeBinary(ByteStream.Output output, Object value, PrimitiveObjectInspector inspector) throws IOException {
        LazyUtils.writePrimitive((OutputStream)output, (Object)value, (PrimitiveObjectInspector)inspector);
    }

    protected void writeString(ByteStream.Output output, Object value, PrimitiveObjectInspector inspector) throws IOException {
        LazyUtils.writePrimitiveUTF8((OutputStream)output, (Object)value, (PrimitiveObjectInspector)inspector, (boolean)this.serDeParams.isEscaped(), (byte)this.serDeParams.getEscapeChar(), (boolean[])this.serDeParams.getNeedsEscape());
    }

    protected ColumnVisibility getVisibility() {
        return this.visibility;
    }
}

