/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.file.rfile;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.RandomAccess;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.file.blockfile.ABlockReader;
import org.apache.accumulo.core.file.blockfile.ABlockWriter;
import org.apache.accumulo.core.file.blockfile.BlockFileReader;
import org.apache.accumulo.core.file.blockfile.BlockFileWriter;
import org.apache.accumulo.core.file.blockfile.impl.SeekableByteArrayInputStream;
import org.apache.accumulo.core.file.rfile.bcfile.Utils;
import org.apache.hadoop.io.WritableComparable;

public class MultiLevelIndex {

    public static class Reader {
        private IndexBlock rootBlock;
        private BlockFileReader blockStore;
        private int version;
        private int size;

        public Reader(BlockFileReader blockStore, int version) {
            this.version = version;
            this.blockStore = blockStore;
        }

        private IndexBlock getIndexBlock(IndexEntry ie) throws IOException {
            IndexBlock iblock = new IndexBlock();
            ABlockReader in = this.blockStore.getMetaBlock(ie.getOffset(), ie.getCompressedSize(), ie.getRawSize());
            iblock.readFields(in, this.version);
            in.close();
            return iblock;
        }

        public IndexIterator lookup(Key key) throws IOException {
            Node node = new Node(this.rootBlock);
            return new IndexIterator(node.lookup(key));
        }

        public void readFields(DataInput in) throws IOException {
            this.size = 0;
            if (this.version == 6 || this.version == 7 || this.version == 8) {
                this.size = in.readInt();
            }
            this.rootBlock = new IndexBlock();
            this.rootBlock.readFields(in, this.version);
            if (this.version == 3 || this.version == 4) {
                this.size = this.rootBlock.getIndex().size();
            }
        }

        public int size() {
            return this.size;
        }

        private void getIndexInfo(IndexBlock ib, Map<Integer, Long> sizesByLevel, Map<Integer, Long> countsByLevel) throws IOException {
            Long count;
            Long size = sizesByLevel.get(ib.getLevel());
            if (size == null) {
                size = 0L;
            }
            if ((count = countsByLevel.get(ib.getLevel())) == null) {
                count = 0L;
            }
            List<IndexEntry> index = ib.getIndex();
            size = size + ((SerializedIndex)index).sizeInBytes();
            Long l = count;
            Long l2 = count = Long.valueOf(count + 1L);
            sizesByLevel.put(ib.getLevel(), size);
            countsByLevel.put(ib.getLevel(), count);
            if (ib.getLevel() > 0) {
                for (IndexEntry ie : index) {
                    IndexBlock cib = this.getIndexBlock(ie);
                    this.getIndexInfo(cib, sizesByLevel, countsByLevel);
                }
            }
        }

        public void getIndexInfo(Map<Integer, Long> sizes, Map<Integer, Long> counts) throws IOException {
            this.getIndexInfo(this.rootBlock, sizes, counts);
        }

        private void printIndex(IndexBlock ib, String prefix, PrintStream out) throws IOException {
            List<IndexEntry> index = ib.getIndex();
            StringBuilder sb = new StringBuilder();
            sb.append(prefix);
            sb.append("Level: ");
            sb.append(ib.getLevel());
            int resetLen = sb.length();
            String recursePrefix = prefix + "  ";
            for (IndexEntry ie : index) {
                sb.setLength(resetLen);
                sb.append(" Key: ");
                sb.append(ie.key);
                sb.append(" NumEntries: ");
                sb.append(ie.entries);
                sb.append(" Offset: ");
                sb.append(ie.offset);
                sb.append(" CompressedSize: ");
                sb.append(ie.compressedSize);
                sb.append(" RawSize : ");
                sb.append(ie.rawSize);
                out.println(sb.toString());
                if (ib.getLevel() <= 0) continue;
                IndexBlock cib = this.getIndexBlock(ie);
                this.printIndex(cib, recursePrefix, out);
            }
        }

        public void printIndex(String prefix, PrintStream out) throws IOException {
            this.printIndex(this.rootBlock, prefix, out);
        }

        public Key getLastKey() {
            return this.rootBlock.getIndex().get(this.rootBlock.getIndex().size() - 1).getKey();
        }

        public static class IndexIterator
        implements ListIterator<IndexEntry> {
            private Node node;
            private ListIterator<IndexEntry> liter;

            private Node getPrevNode() {
                try {
                    return this.node.getPreviousNode();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            private Node getNextNode() {
                try {
                    return this.node.getNextNode();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            public IndexIterator() {
                this.node = null;
            }

            public IndexIterator(Node node) {
                this.node = node;
                this.liter = node.indexBlock.getIndex().listIterator(node.currentPos);
            }

            @Override
            public boolean hasNext() {
                if (this.node == null) {
                    return false;
                }
                if (!this.liter.hasNext()) {
                    return this.node.indexBlock.hasNext();
                }
                return true;
            }

            public IndexEntry peekPrevious() {
                IndexEntry ret = this.previous();
                this.next();
                return ret;
            }

            public IndexEntry peek() {
                IndexEntry ret = this.next();
                this.previous();
                return ret;
            }

            @Override
            public IndexEntry next() {
                if (!this.liter.hasNext()) {
                    this.node = this.getNextNode();
                    this.liter = this.node.indexBlock.getIndex().listIterator();
                }
                return this.liter.next();
            }

            @Override
            public boolean hasPrevious() {
                if (this.node == null) {
                    return false;
                }
                if (!this.liter.hasPrevious()) {
                    return this.node.indexBlock.getOffset() > 0;
                }
                return true;
            }

            @Override
            public IndexEntry previous() {
                if (!this.liter.hasPrevious()) {
                    this.node = this.getPrevNode();
                    this.liter = this.node.indexBlock.getIndex().listIterator(this.node.indexBlock.getIndex().size());
                }
                return this.liter.previous();
            }

            @Override
            public int nextIndex() {
                return this.node.indexBlock.getOffset() + this.liter.nextIndex();
            }

            @Override
            public int previousIndex() {
                return this.node.indexBlock.getOffset() + this.liter.previousIndex();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void set(IndexEntry e) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void add(IndexEntry e) {
                throw new UnsupportedOperationException();
            }
        }

        public class Node {
            private Node parent;
            private IndexBlock indexBlock;
            private int currentPos;

            Node(Node parent, IndexBlock iBlock) {
                this.parent = parent;
                this.indexBlock = iBlock;
            }

            Node(IndexBlock rootInfo) {
                this.parent = null;
                this.indexBlock = rootInfo;
            }

            private Node lookup(Key key) throws IOException {
                int pos = Collections.binarySearch(this.indexBlock.getKeyIndex(), key, new Comparator<Key>(){

                    @Override
                    public int compare(Key o1, Key o2) {
                        return o1.compareTo(o2);
                    }
                });
                if (pos < 0) {
                    pos = pos * -1 - 1;
                }
                if (pos == this.indexBlock.getIndex().size()) {
                    if (this.parent != null) {
                        throw new IllegalStateException();
                    }
                    this.currentPos = pos;
                    return this;
                }
                this.currentPos = pos;
                if (this.indexBlock.getLevel() == 0) {
                    return this;
                }
                IndexEntry ie = this.indexBlock.getIndex().get(pos);
                Node child = new Node(this, Reader.this.getIndexBlock(ie));
                return child.lookup(key);
            }

            private Node getLast() throws IOException {
                this.currentPos = this.indexBlock.getIndex().size() - 1;
                if (this.indexBlock.getLevel() == 0) {
                    return this;
                }
                IndexEntry ie = this.indexBlock.getIndex().get(this.currentPos);
                Node child = new Node(this, Reader.this.getIndexBlock(ie));
                return child.getLast();
            }

            private Node getFirst() throws IOException {
                this.currentPos = 0;
                if (this.indexBlock.getLevel() == 0) {
                    return this;
                }
                IndexEntry ie = this.indexBlock.getIndex().get(this.currentPos);
                Node child = new Node(this, Reader.this.getIndexBlock(ie));
                return child.getFirst();
            }

            private Node getPrevious() throws IOException {
                if (this.currentPos == 0) {
                    return this.parent.getPrevious();
                }
                --this.currentPos;
                IndexEntry ie = this.indexBlock.getIndex().get(this.currentPos);
                Node child = new Node(this, Reader.this.getIndexBlock(ie));
                return child.getLast();
            }

            private Node getNext() throws IOException {
                if (this.currentPos == this.indexBlock.getIndex().size() - 1) {
                    return this.parent.getNext();
                }
                ++this.currentPos;
                IndexEntry ie = this.indexBlock.getIndex().get(this.currentPos);
                Node child = new Node(this, Reader.this.getIndexBlock(ie));
                return child.getFirst();
            }

            Node getNextNode() throws IOException {
                return this.parent.getNext();
            }

            Node getPreviousNode() throws IOException {
                return this.parent.getPrevious();
            }
        }
    }

    public static class Writer {
        private int threshold;
        private ArrayList<IndexBlock> levels;
        private int totalAdded;
        private boolean addedLast = false;
        private BlockFileWriter blockFileWriter;

        Writer(BlockFileWriter blockFileWriter, int maxBlockSize) {
            this.blockFileWriter = blockFileWriter;
            this.threshold = maxBlockSize;
            this.levels = new ArrayList();
        }

        private void add(int level, Key key, int data, long offset, long compressedSize, long rawSize) throws IOException {
            if (level == this.levels.size()) {
                this.levels.add(new IndexBlock(level, 0));
            }
            IndexBlock iblock = this.levels.get(level);
            iblock.add(key, data, offset, compressedSize, rawSize);
        }

        private void flush(int level, Key lastKey, boolean last) throws IOException {
            if (last && level == this.levels.size() - 1) {
                return;
            }
            IndexBlock iblock = this.levels.get(level);
            if (iblock.getSize() > this.threshold && iblock.offsets.size() > 1 || last) {
                ABlockWriter out = this.blockFileWriter.prepareDataBlock();
                iblock.setHasNext(!last);
                iblock.write(out);
                out.close();
                this.add(level + 1, lastKey, 0, out.getStartPos(), out.getCompressedSize(), out.getRawSize());
                this.flush(level + 1, lastKey, last);
                if (last) {
                    this.levels.set(level, null);
                } else {
                    this.levels.set(level, new IndexBlock(level, this.totalAdded));
                }
            }
        }

        public void add(Key key, int data, long offset, long compressedSize, long rawSize) throws IOException {
            ++this.totalAdded;
            this.add(0, key, data, offset, compressedSize, rawSize);
            this.flush(0, key, false);
        }

        public void addLast(Key key, int data, long offset, long compressedSize, long rawSize) throws IOException {
            if (this.addedLast) {
                throw new IllegalStateException("already added last");
            }
            ++this.totalAdded;
            this.add(0, key, data, offset, compressedSize, rawSize);
            this.flush(0, key, true);
            this.addedLast = true;
        }

        public void close(DataOutput out) throws IOException {
            if (this.totalAdded > 0 && !this.addedLast) {
                throw new IllegalStateException("did not call addLast");
            }
            out.writeInt(this.totalAdded);
            if (this.levels.size() > 0) {
                this.levels.get(this.levels.size() - 1).write(out);
            } else {
                new IndexBlock(0, 0).write(out);
            }
        }
    }

    public static class BufferedWriter {
        private Writer writer;
        private DataOutputStream buffer;
        private int buffered;
        private ByteArrayOutputStream baos;

        public BufferedWriter(Writer writer) {
            this.writer = writer;
            this.baos = new ByteArrayOutputStream(0x100000);
            this.buffer = new DataOutputStream(this.baos);
            this.buffered = 0;
        }

        private void flush() throws IOException {
            this.buffer.close();
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(this.baos.toByteArray()));
            IndexEntry ie = new IndexEntry(true);
            for (int i = 0; i < this.buffered; ++i) {
                ie.readFields(dis);
                this.writer.add(ie.getKey(), ie.getNumEntries(), ie.getOffset(), ie.getCompressedSize(), ie.getRawSize());
            }
            this.buffered = 0;
            this.baos = new ByteArrayOutputStream(0x100000);
            this.buffer = new DataOutputStream(this.baos);
        }

        public void add(Key key, int data, long offset, long compressedSize, long rawSize) throws IOException {
            if (this.buffer.size() > 0xA00000) {
                this.flush();
            }
            new IndexEntry(key, data, offset, compressedSize, rawSize).write(this.buffer);
            ++this.buffered;
        }

        public void addLast(Key key, int data, long offset, long compressedSize, long rawSize) throws IOException {
            this.flush();
            this.writer.addLast(key, data, offset, compressedSize, rawSize);
        }

        public void close(DataOutput out) throws IOException {
            this.writer.close(out);
        }
    }

    static class IndexBlock {
        private ByteArrayOutputStream indexBytes;
        private DataOutputStream indexOut;
        private ArrayList<Integer> offsets;
        private int level;
        private int offset;
        private boolean hasNext;
        private byte[] data;
        private int[] offsetsArray;
        private int numOffsets;
        private int offsetsOffset;
        private int indexSize;
        private int indexOffset;
        private boolean newFormat;

        public IndexBlock(int level, int totalAdded) {
            this.level = level;
            this.offset = totalAdded;
            this.indexBytes = new ByteArrayOutputStream();
            this.indexOut = new DataOutputStream(this.indexBytes);
            this.offsets = new ArrayList();
        }

        public IndexBlock() {
        }

        public void add(Key key, int value, long offset, long compressedSize, long rawSize) throws IOException {
            this.offsets.add(this.indexOut.size());
            new IndexEntry(key, value, offset, compressedSize, rawSize).write(this.indexOut);
        }

        int getSize() {
            return this.indexOut.size() + 4 * this.offsets.size();
        }

        public void write(DataOutput out) throws IOException {
            out.writeInt(this.level);
            out.writeInt(this.offset);
            out.writeBoolean(this.hasNext);
            out.writeInt(this.offsets.size());
            for (Integer offset : this.offsets) {
                out.writeInt(offset);
            }
            this.indexOut.close();
            byte[] indexData = this.indexBytes.toByteArray();
            out.writeInt(indexData.length);
            out.write(indexData);
        }

        public void readFields(DataInput in, int version) throws IOException {
            if (version == 6 || version == 7 || version == 8) {
                this.level = in.readInt();
                this.offset = in.readInt();
                this.hasNext = in.readBoolean();
                ABlockReader abr = (ABlockReader)in;
                if (abr.isIndexable()) {
                    this.data = abr.getBuffer();
                    this.numOffsets = abr.readInt();
                    this.offsetsOffset = abr.getPosition();
                    int skipped = abr.skipBytes(this.numOffsets * 4);
                    if (skipped != this.numOffsets * 4) {
                        throw new IOException("Skipped less than expected " + skipped + " " + this.numOffsets * 4);
                    }
                    this.indexSize = in.readInt();
                    this.indexOffset = abr.getPosition();
                    skipped = abr.skipBytes(this.indexSize);
                    if (skipped != this.indexSize) {
                        throw new IOException("Skipped less than expected " + skipped + " " + this.indexSize);
                    }
                } else {
                    this.numOffsets = in.readInt();
                    this.offsetsArray = new int[this.numOffsets];
                    for (int i = 0; i < this.numOffsets; ++i) {
                        this.offsetsArray[i] = in.readInt();
                    }
                    this.indexSize = in.readInt();
                    this.data = new byte[this.indexSize];
                    in.readFully(this.data);
                    this.newFormat = true;
                }
            } else if (version == 3) {
                this.level = 0;
                this.offset = 0;
                this.hasNext = false;
                int size = in.readInt();
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                DataOutputStream dos = new DataOutputStream(baos);
                ArrayList<Integer> oal = new ArrayList<Integer>();
                for (int i = 0; i < size; ++i) {
                    IndexEntry ie = new IndexEntry(false);
                    oal.add(dos.size());
                    ie.readFields(in);
                    ie.write(dos);
                }
                dos.close();
                int[] oia = new int[oal.size()];
                for (int i = 0; i < oal.size(); ++i) {
                    oia[i] = (Integer)oal.get(i);
                }
                this.data = baos.toByteArray();
                this.offsetsArray = oia;
                this.newFormat = false;
            } else if (version == 4) {
                this.level = 0;
                this.offset = 0;
                this.hasNext = false;
                int numIndexEntries = in.readInt();
                int[] offsets = new int[numIndexEntries];
                for (int i = 0; i < numIndexEntries; ++i) {
                    offsets[i] = in.readInt();
                }
                int size = in.readInt();
                byte[] indexData = new byte[size];
                in.readFully(indexData);
                this.data = indexData;
                this.offsetsArray = offsets;
                this.newFormat = false;
            } else {
                throw new RuntimeException("Unexpected version " + version);
            }
        }

        List<IndexEntry> getIndex() {
            if (this.offsetsArray == null) {
                return new SerializedIndex(this.data, this.offsetsOffset, this.numOffsets, this.indexOffset, this.indexSize);
            }
            return new SerializedIndex(this.offsetsArray, this.data, this.newFormat);
        }

        public List<Key> getKeyIndex() {
            if (this.offsetsArray == null) {
                return new KeyIndex(this.data, this.offsetsOffset, this.numOffsets, this.indexOffset, this.indexSize);
            }
            return new KeyIndex(this.offsetsArray, this.data);
        }

        int getLevel() {
            return this.level;
        }

        int getOffset() {
            return this.offset;
        }

        boolean hasNext() {
            return this.hasNext;
        }

        void setHasNext(boolean b) {
            this.hasNext = b;
        }
    }

    private static class KeyIndex
    extends SerializedIndexBase<Key> {
        KeyIndex(int[] offsets, byte[] data) {
            super(offsets, data);
        }

        KeyIndex(byte[] data, int offsetsOffset, int numOffsets, int indexOffset, int indexSize) {
            super(data, offsetsOffset, numOffsets, indexOffset, indexSize);
        }

        @Override
        protected Key newValue() throws IOException {
            Key key = new Key();
            key.readFields(this.dis);
            return key;
        }
    }

    private static class SerializedIndex
    extends SerializedIndexBase<IndexEntry> {
        private boolean newFormat;

        SerializedIndex(int[] offsets, byte[] data, boolean newFormat) {
            super(offsets, data);
            this.newFormat = newFormat;
        }

        SerializedIndex(byte[] data, int offsetsOffset, int numOffsets, int indexOffset, int indexSize) {
            super(data, offsetsOffset, numOffsets, indexOffset, indexSize);
            this.newFormat = true;
        }

        public long sizeInBytes() {
            if (this.offsets == null) {
                return this.indexSize + 4 * this.numOffsets;
            }
            return this.data.length + 4 * this.offsets.length;
        }

        @Override
        protected IndexEntry newValue() throws IOException {
            IndexEntry ie = new IndexEntry(this.newFormat);
            ie.readFields(this.dis);
            return ie;
        }
    }

    private static abstract class SerializedIndexBase<T>
    extends AbstractList<T>
    implements RandomAccess {
        protected int[] offsets;
        protected byte[] data;
        protected SeekableByteArrayInputStream sbais;
        protected DataInputStream dis;
        protected int offsetsOffset;
        protected int indexOffset;
        protected int numOffsets;
        protected int indexSize;

        SerializedIndexBase(int[] offsets, byte[] data) {
            Objects.requireNonNull(offsets, "offsets argument was null");
            Objects.requireNonNull(data, "data argument was null");
            this.offsets = offsets;
            this.data = data;
            this.sbais = new SeekableByteArrayInputStream(data);
            this.dis = new DataInputStream(this.sbais);
        }

        SerializedIndexBase(byte[] data, int offsetsOffset, int numOffsets, int indexOffset, int indexSize) {
            Objects.requireNonNull(data, "data argument was null");
            this.sbais = new SeekableByteArrayInputStream(data, indexOffset + indexSize);
            this.dis = new DataInputStream(this.sbais);
            this.offsetsOffset = offsetsOffset;
            this.indexOffset = indexOffset;
            this.numOffsets = numOffsets;
            this.indexSize = indexSize;
        }

        protected abstract T newValue() throws IOException;

        @Override
        public T get(int index) {
            try {
                int offset;
                if (this.offsets == null) {
                    if (index < 0 || index >= this.numOffsets) {
                        throw new IndexOutOfBoundsException("index:" + index + " numOffsets:" + this.numOffsets);
                    }
                    this.sbais.seek(this.offsetsOffset + index * 4);
                    offset = this.dis.readInt();
                } else {
                    offset = this.offsets[index];
                }
                this.sbais.seek(this.indexOffset + offset);
                return this.newValue();
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }

        @Override
        public int size() {
            if (this.offsets == null) {
                return this.numOffsets;
            }
            return this.offsets.length;
        }
    }

    public static class IndexEntry
    implements WritableComparable<IndexEntry> {
        private Key key;
        private int entries;
        private long offset;
        private long compressedSize;
        private long rawSize;
        private boolean newFormat;

        IndexEntry(Key k, int e, long offset, long compressedSize, long rawSize) {
            this.key = k;
            this.entries = e;
            this.offset = offset;
            this.compressedSize = compressedSize;
            this.rawSize = rawSize;
            this.newFormat = true;
        }

        public IndexEntry(boolean newFormat) {
            this.newFormat = newFormat;
        }

        public void readFields(DataInput in) throws IOException {
            this.key = new Key();
            this.key.readFields(in);
            this.entries = in.readInt();
            if (this.newFormat) {
                this.offset = Utils.readVLong(in);
                this.compressedSize = Utils.readVLong(in);
                this.rawSize = Utils.readVLong(in);
            } else {
                this.offset = -1L;
                this.compressedSize = -1L;
                this.rawSize = -1L;
            }
        }

        public void write(DataOutput out) throws IOException {
            this.key.write(out);
            out.writeInt(this.entries);
            if (this.newFormat) {
                Utils.writeVLong(out, this.offset);
                Utils.writeVLong(out, this.compressedSize);
                Utils.writeVLong(out, this.rawSize);
            }
        }

        public Key getKey() {
            return this.key;
        }

        public int getNumEntries() {
            return this.entries;
        }

        public long getOffset() {
            return this.offset;
        }

        public long getCompressedSize() {
            return this.compressedSize;
        }

        public long getRawSize() {
            return this.rawSize;
        }

        public int compareTo(IndexEntry o) {
            return this.key.compareTo(o.key);
        }

        public boolean equals(Object o) {
            if (o instanceof IndexEntry) {
                return this.compareTo((IndexEntry)o) == 0;
            }
            return false;
        }

        public int hashCode() {
            assert (false) : "hashCode not designed";
            return 42;
        }
    }
}

