/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.beeline.schematool;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaException;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.tools.schematool.HiveSchemaHelper;
import org.apache.hadoop.hive.metastore.tools.schematool.MetastoreSchemaTool;
import org.apache.hadoop.hive.metastore.utils.StringUtils;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hive.beeline.BeeLineDummyTerminal;
import org.apache.tez.dag.api.TezConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveSchemaTool
extends MetastoreSchemaTool {
    private static final Logger LOG = LoggerFactory.getLogger((String)HiveSchemaTool.class.getName());

    protected HiveSchemaHelper.NestedScriptParser getDbCommandParser(String dbType, String metaDbType) {
        return HiveSchemaHelper.getDbCommandParser((String)dbType, (String)this.dbOpts, (String)this.userName, (String)this.passWord, (Configuration)this.conf, (String)metaDbType, (boolean)false);
    }

    protected HiveSchemaHelper.MetaStoreConnectionInfo getConnectionInfo(boolean printInfo) {
        return new HiveSchemaHelper.MetaStoreConnectionInfo(this.userName, this.passWord, this.url, this.driver, printInfo, this.conf, this.dbType, this.metaDbType);
    }

    protected void execSql(String scriptDir, String scriptFile) throws IOException, HiveMetaException {
        HiveSchemaHelper.NestedScriptParser dbCommandParser = this.getDbCommandParser(this.dbType, this.metaDbType);
        String sqlCommands = dbCommandParser.buildCommand(scriptDir, scriptFile, this.metaDbType != null);
        File tmpFile = File.createTempFile("schematool", ".sql");
        tmpFile.deleteOnExit();
        FileWriter fstream = new FileWriter(tmpFile.getPath());
        BufferedWriter out = new BufferedWriter(fstream);
        if (!this.dbType.equalsIgnoreCase("hive")) {
            out.write("!autocommit off" + System.getProperty("line.separator"));
            out.write(sqlCommands);
            out.write("!commit" + System.getProperty("line.separator"));
        } else {
            out.write("!autocommit on" + System.getProperty("line.separator"));
            out.write(sqlCommands);
        }
        out.write("!closeall" + System.getProperty("line.separator"));
        out.close();
        this.execSql(tmpFile.getPath());
    }

    protected void execSql(String sqlScriptFile) throws IOException {
        this.replaceLocationForProtoLogTables(sqlScriptFile);
        HiveSchemaToolCommandBuilder builder = new HiveSchemaToolCommandBuilder(this.conf, this.url, this.driver, this.userName, this.passWord, sqlScriptFile);
        try (BeeLineDummyTerminal beeLine = new BeeLineDummyTerminal();){
            if (!this.verbose) {
                beeLine.setOutputStream(new PrintStream((OutputStream)new NullOutputStream()));
                beeLine.getOpts().setSilent(true);
            }
            beeLine.getOpts().setAllowMultiLineCommand(false);
            beeLine.getOpts().setIsolation("TRANSACTION_READ_COMMITTED");
            beeLine.getOpts().setEntireLineAsCommand(true);
            LOG.debug("Going to run command <" + builder.buildToLog() + ">");
            int status = beeLine.begin(builder.buildToRun(), null, false);
            if (status != 0) {
                throw new IOException("Schema script failed, errorcode " + status);
            }
        }
    }

    void replaceLocationForProtoLogTables(String sqlScriptFile) throws IOException {
        TezConfiguration tezConf = new TezConfiguration(true);
        boolean hiveProtoLoggingEnabled = true;
        boolean tezProtoLoggingEnabled = true;
        String hiveProtoBaseDir = HiveConf.getVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_PROTO_EVENTS_BASE_PATH);
        String tezProtoBaseDir = tezConf.get("tez.history.logging.proto-base-dir");
        String hiveLocation = "/tmp/query_data";
        String tezLocation = "/tmp";
        StringBuilder newLine = new StringBuilder();
        HashMap<String, Object> replacements = new HashMap<String, Object>();
        if (StringUtils.isEmpty((CharSequence)hiveProtoBaseDir)) {
            LOG.warn("Hive conf variable hive.hook.proto.base-directory is not set for creating protologging tables");
            hiveProtoLoggingEnabled = false;
        }
        if (StringUtils.isEmpty((CharSequence)tezProtoBaseDir)) {
            LOG.warn("Tez conf variable tez.history.logging.proto-base-dir is not set for creating protologging tables");
            tezProtoLoggingEnabled = false;
        }
        if (hiveProtoLoggingEnabled) {
            String hiveProtoScheme = new Path(hiveProtoBaseDir).getFileSystem(this.conf).getScheme() + ":///";
            String string = hiveLocation = new Path(hiveProtoBaseDir).getFileSystem(this.conf).getUri().isAbsolute() ? hiveProtoBaseDir : hiveProtoScheme + hiveProtoBaseDir;
        }
        if (tezProtoLoggingEnabled) {
            String tezProtoScheme = new Path(tezProtoBaseDir).getFileSystem((Configuration)tezConf).getScheme() + ":///";
            tezLocation = new Path(tezProtoBaseDir).getFileSystem((Configuration)tezConf).getUri().isAbsolute() ? tezProtoBaseDir : tezProtoScheme + tezProtoBaseDir;
        }
        replacements.put("_REPLACE_WITH_QUERY_DATA_LOCATION_", hiveLocation);
        replacements.put("_REPLACE_WITH_APP_DATA_LOCATION_", tezLocation + "/app_data");
        replacements.put("_REPLACE_WITH_DAG_DATA_LOCATION_", tezLocation + "/dag_data");
        replacements.put("_REPLACE_WITH_DAG_META_LOCATION_", tezLocation + "/dag_meta");
        try (BufferedReader reader = new BufferedReader(new FileReader(sqlScriptFile));){
            String line;
            while ((line = reader.readLine()) != null) {
                for (Map.Entry entry : replacements.entrySet()) {
                    if (!line.contains((CharSequence)entry.getKey())) continue;
                    line = line.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
                }
                newLine.append(line).append("\n");
            }
        }
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(sqlScriptFile));){
            writer.write(newLine.toString());
        }
    }

    public static void main(String[] args) {
        HiveSchemaTool tool = new HiveSchemaTool();
        OptionGroup additionalGroup = new OptionGroup();
        OptionBuilder.withArgName((String)"metaDatabaseType");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)"Used only if upgrading the system catalog for hive");
        Option metaDbTypeOpt = OptionBuilder.create((String)"metaDbType");
        additionalGroup.addOption(metaDbTypeOpt);
        System.setProperty(MetastoreConf.ConfVars.SCHEMA_VERIFICATION.getVarname(), "true");
        ExitUtil.terminate((int)tool.run(HiveSchemaTool.findHomeDir(), args, additionalGroup, MetastoreConf.newMetastoreConf()));
    }

    static class HiveSchemaToolCommandBuilder
    extends MetastoreSchemaTool.CommandBuilder {
        HiveSchemaToolCommandBuilder(Configuration conf, String url, String driver, String userName, String password, String sqlScriptFile) throws IOException {
            super(conf, url, driver, userName, password, sqlScriptFile);
        }

        protected String[] argsWith(String password) {
            return new String[]{"-u", this.url, "-d", this.driver, "-n", this.userName, "-p", password, "-f", this.sqlScriptFile};
        }
    }
}

