/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.start.classloader.vfs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.start.classloader.vfs.AccumuloVFSClassLoader;
import org.apache.accumulo.start.classloader.vfs.PostDelegatingVFSClassLoader;
import org.apache.accumulo.start.classloader.vfs.ReloadingClassLoader;
import org.apache.commons.vfs2.FileChangeEvent;
import org.apache.commons.vfs2.FileListener;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.impl.DefaultFileMonitor;
import org.apache.commons.vfs2.impl.VFSClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccumuloReloadingVFSClassLoader
implements FileListener,
ReloadingClassLoader {
    private static final Logger log = LoggerFactory.getLogger(AccumuloReloadingVFSClassLoader.class);
    private static final int DEFAULT_TIMEOUT = 300000;
    private FileObject[] files;
    private VFSClassLoader cl;
    private final ReloadingClassLoader parent;
    private final String uris;
    private final DefaultFileMonitor monitor;
    private final boolean preDelegate;
    private final ThreadPoolExecutor executor;
    private final Runnable refresher;

    public String stringify(FileObject[] files) {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        String delim = "";
        for (FileObject file : files) {
            sb.append(delim);
            delim = ", ";
            sb.append(file.getName());
        }
        sb.append(']');
        return sb.toString();
    }

    @Override
    public synchronized ClassLoader getClassLoader() {
        if (this.cl.getParent() != this.parent.getClassLoader()) {
            this.scheduleRefresh();
        }
        return this.cl;
    }

    private void scheduleRefresh() {
        try {
            this.executor.execute(this.refresher);
        }
        catch (RejectedExecutionException e) {
            log.trace("Ignoring refresh request (already refreshing)");
        }
    }

    private synchronized void updateClassloader(FileObject[] files, VFSClassLoader cl) {
        this.files = files;
        this.cl = cl;
    }

    public AccumuloReloadingVFSClassLoader(String uris, FileSystemManager vfs, ReloadingClassLoader parent, long monitorDelay, boolean preDelegate) throws FileSystemException {
        ArrayBlockingQueue<Runnable> queue = new ArrayBlockingQueue<Runnable>(2);
        ThreadFactory factory = new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setDaemon(true);
                return t;
            }
        };
        this.executor = new ThreadPoolExecutor(1, 1, 1L, TimeUnit.SECONDS, queue, factory);
        this.refresher = new Runnable(){

            @Override
            public void run() {
                while (!AccumuloReloadingVFSClassLoader.this.executor.isTerminating()) {
                    try {
                        FileSystemManager vfs = AccumuloVFSClassLoader.generateVfs();
                        FileObject[] files = AccumuloVFSClassLoader.resolve(vfs, AccumuloReloadingVFSClassLoader.this.uris);
                        log.debug("Rebuilding dynamic classloader using files- " + AccumuloReloadingVFSClassLoader.this.stringify(files));
                        Object cl = AccumuloReloadingVFSClassLoader.this.preDelegate ? new VFSClassLoader(files, vfs, AccumuloReloadingVFSClassLoader.this.parent.getClassLoader()) : new PostDelegatingVFSClassLoader(files, vfs, AccumuloReloadingVFSClassLoader.this.parent.getClassLoader());
                        AccumuloReloadingVFSClassLoader.this.updateClassloader(files, cl);
                        return;
                    }
                    catch (Exception e) {
                        log.error("{}", (Object)e.getMessage(), (Object)e);
                        try {
                            Thread.sleep(300000L);
                        }
                        catch (InterruptedException ie) {
                            log.error("{}", (Object)e.getMessage(), (Object)ie);
                        }
                    }
                }
            }
        };
        this.uris = uris;
        this.parent = parent;
        this.preDelegate = preDelegate;
        ArrayList<FileObject> pathsToMonitor = new ArrayList<FileObject>();
        this.files = AccumuloVFSClassLoader.resolve(vfs, uris, pathsToMonitor);
        this.cl = preDelegate ? new VFSClassLoader(this.files, vfs, parent.getClassLoader()) : new PostDelegatingVFSClassLoader(this.files, vfs, parent.getClassLoader());
        this.monitor = new DefaultFileMonitor((FileListener)this);
        this.monitor.setDelay(monitorDelay);
        this.monitor.setRecursive(false);
        for (FileObject file : pathsToMonitor) {
            this.monitor.addFile(file);
            log.debug("monitoring " + file);
        }
        this.monitor.start();
    }

    public AccumuloReloadingVFSClassLoader(String uris, FileSystemManager vfs, ReloadingClassLoader parent, boolean preDelegate) throws FileSystemException {
        this(uris, vfs, parent, 300000L, preDelegate);
    }

    public synchronized FileObject[] getFiles() {
        return Arrays.copyOf(this.files, this.files.length);
    }

    public void close() {
        this.executor.shutdownNow();
        this.monitor.stop();
    }

    public void fileCreated(FileChangeEvent event) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(event.getFile().getURL().toString() + " created, recreating classloader");
        }
        this.scheduleRefresh();
    }

    public void fileDeleted(FileChangeEvent event) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(event.getFile().getURL().toString() + " deleted, recreating classloader");
        }
        this.scheduleRefresh();
    }

    public void fileChanged(FileChangeEvent event) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(event.getFile().getURL().toString() + " changed, recreating classloader");
        }
        this.scheduleRefresh();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (FileObject f : this.files) {
            try {
                buf.append("\t").append(f.getURL().toString()).append("\n");
            }
            catch (FileSystemException e) {
                log.error("Error getting URL for file", (Throwable)e);
            }
        }
        return buf.toString();
    }
}

