/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.kudu.org.apache.kudu.client;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.apache.hive.kudu.org.apache.kudu.ColumnSchema;
import org.apache.hive.kudu.org.apache.kudu.Common;
import org.apache.hive.kudu.org.apache.kudu.Schema;
import org.apache.hive.kudu.org.apache.kudu.Type;
import org.apache.hive.kudu.org.apache.kudu.client.Operation;
import org.apache.hive.kudu.org.apache.kudu.client.PartialRow;
import org.apache.hive.kudu.org.apache.kudu.client.ProtobufHelper;
import org.apache.hive.kudu.org.apache.kudu.client.RangePartitionBound;
import org.apache.hive.kudu.org.apache.kudu.client.RangePartitionWithCustomHashSchema;
import org.apache.hive.kudu.org.apache.kudu.master.Master;
import org.apache.hive.kudu.org.apache.kudu.shaded.com.google.common.base.Preconditions;
import org.apache.hive.kudu.org.apache.kudu.shaded.com.google.protobuf.ByteString;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class AlterTableOptions {
    private final Master.AlterTableRequestPB.Builder pb = Master.AlterTableRequestPB.newBuilder();
    private boolean wait = true;
    private boolean isAddingRangeWithCustomHashSchema = false;

    public AlterTableOptions renameTable(String newName) {
        this.pb.setNewTableName(newName);
        return this;
    }

    public AlterTableOptions setOwner(String owner) {
        this.pb.setNewTableOwner(owner);
        return this;
    }

    public AlterTableOptions setComment(String comment) {
        this.pb.setNewTableComment(comment);
        return this;
    }

    public AlterTableOptions addColumn(ColumnSchema colSchema) {
        if (colSchema.getName().equalsIgnoreCase(Schema.getAutoIncrementingColumnName())) {
            throw new IllegalArgumentException("Column name " + Schema.getAutoIncrementingColumnName() + " is reserved by Kudu engine");
        }
        if (!colSchema.isNullable() && colSchema.getDefaultValue() == null) {
            throw new IllegalArgumentException("A new non-null column must have a default value");
        }
        if (colSchema.isKey()) {
            throw new IllegalArgumentException("Key columns cannot be added");
        }
        Master.AlterTableRequestPB.Step.Builder step = this.pb.addAlterSchemaStepsBuilder();
        step.setType(Master.AlterTableRequestPB.StepType.ADD_COLUMN);
        step.setAddColumn(Master.AlterTableRequestPB.AddColumn.newBuilder().setSchema(ProtobufHelper.columnToPb(colSchema)));
        return this;
    }

    public AlterTableOptions addColumn(String name, Type type, Object defaultVal) {
        return this.addColumn(new ColumnSchema.ColumnSchemaBuilder(name, type).defaultValue(defaultVal).build());
    }

    public AlterTableOptions addNullableColumn(String name, Type type) {
        return this.addNullableColumn(name, type, null);
    }

    public AlterTableOptions addNullableColumn(String name, Type type, Object defaultVal) {
        return this.addColumn(new ColumnSchema.ColumnSchemaBuilder(name, type).nullable(true).defaultValue(defaultVal).build());
    }

    public AlterTableOptions dropColumn(String name) {
        if (name.equalsIgnoreCase(Schema.getAutoIncrementingColumnName())) {
            throw new IllegalArgumentException("Cannot remove auto-incrementing column " + Schema.getAutoIncrementingColumnName());
        }
        Master.AlterTableRequestPB.Step.Builder step = this.pb.addAlterSchemaStepsBuilder();
        step.setType(Master.AlterTableRequestPB.StepType.DROP_COLUMN);
        step.setDropColumn(Master.AlterTableRequestPB.DropColumn.newBuilder().setName(name));
        return this;
    }

    public AlterTableOptions renameColumn(String oldName, String newName) {
        if (oldName.equalsIgnoreCase(Schema.getAutoIncrementingColumnName())) {
            throw new IllegalArgumentException("Cannot rename auto-incrementing column " + Schema.getAutoIncrementingColumnName());
        }
        Master.AlterTableRequestPB.Step.Builder step = this.pb.addAlterSchemaStepsBuilder();
        step.setType(Master.AlterTableRequestPB.StepType.RENAME_COLUMN);
        step.setRenameColumn(Master.AlterTableRequestPB.RenameColumn.newBuilder().setOldName(oldName).setNewName(newName));
        return this;
    }

    public AlterTableOptions removeDefault(String name) {
        if (name.equalsIgnoreCase(Schema.getAutoIncrementingColumnName())) {
            throw new IllegalArgumentException("Auto-incrementing column " + Schema.getAutoIncrementingColumnName() + " does not have default value");
        }
        Master.AlterTableRequestPB.Step.Builder step = this.pb.addAlterSchemaStepsBuilder();
        step.setType(Master.AlterTableRequestPB.StepType.ALTER_COLUMN);
        Master.AlterTableRequestPB.AlterColumn.Builder alterBuilder = Master.AlterTableRequestPB.AlterColumn.newBuilder();
        alterBuilder.setDelta(Common.ColumnSchemaDeltaPB.newBuilder().setName(name).setRemoveDefault(true));
        step.setAlterColumn(alterBuilder);
        return this;
    }

    public AlterTableOptions changeDefault(String name, Object newDefault) {
        if (name.equalsIgnoreCase(Schema.getAutoIncrementingColumnName())) {
            throw new IllegalArgumentException("Cannot set default value for auto-incrementing column " + Schema.getAutoIncrementingColumnName());
        }
        if (newDefault == null) {
            throw new IllegalArgumentException("newDefault cannot be null: use removeDefault to clear a default value");
        }
        ByteString defaultByteString = ProtobufHelper.objectToByteStringNoType(name, newDefault);
        Master.AlterTableRequestPB.Step.Builder step = this.pb.addAlterSchemaStepsBuilder();
        step.setType(Master.AlterTableRequestPB.StepType.ALTER_COLUMN);
        Master.AlterTableRequestPB.AlterColumn.Builder alterBuilder = Master.AlterTableRequestPB.AlterColumn.newBuilder();
        alterBuilder.setDelta(Common.ColumnSchemaDeltaPB.newBuilder().setName(name).setDefaultValue(defaultByteString));
        step.setAlterColumn(alterBuilder);
        return this;
    }

    public AlterTableOptions changeDesiredBlockSize(String name, int blockSize) {
        Master.AlterTableRequestPB.Step.Builder step = this.pb.addAlterSchemaStepsBuilder();
        step.setType(Master.AlterTableRequestPB.StepType.ALTER_COLUMN);
        Master.AlterTableRequestPB.AlterColumn.Builder alterBuilder = Master.AlterTableRequestPB.AlterColumn.newBuilder();
        alterBuilder.setDelta(Common.ColumnSchemaDeltaPB.newBuilder().setName(name).setBlockSize(blockSize));
        step.setAlterColumn(alterBuilder);
        return this;
    }

    public AlterTableOptions changeEncoding(String name, ColumnSchema.Encoding encoding) {
        Master.AlterTableRequestPB.Step.Builder step = this.pb.addAlterSchemaStepsBuilder();
        step.setType(Master.AlterTableRequestPB.StepType.ALTER_COLUMN);
        Master.AlterTableRequestPB.AlterColumn.Builder alterBuilder = Master.AlterTableRequestPB.AlterColumn.newBuilder();
        alterBuilder.setDelta(Common.ColumnSchemaDeltaPB.newBuilder().setName(name).setEncoding(encoding.getInternalPbType()));
        step.setAlterColumn(alterBuilder);
        return this;
    }

    public AlterTableOptions changeCompressionAlgorithm(String name, ColumnSchema.CompressionAlgorithm ca) {
        Master.AlterTableRequestPB.Step.Builder step = this.pb.addAlterSchemaStepsBuilder();
        step.setType(Master.AlterTableRequestPB.StepType.ALTER_COLUMN);
        Master.AlterTableRequestPB.AlterColumn.Builder alterBuilder = Master.AlterTableRequestPB.AlterColumn.newBuilder();
        alterBuilder.setDelta(Common.ColumnSchemaDeltaPB.newBuilder().setName(name).setCompression(ca.getInternalPbType()));
        step.setAlterColumn(alterBuilder);
        return this;
    }

    public AlterTableOptions addRangePartition(PartialRow lowerBound, PartialRow upperBound) {
        return this.addRangePartition(lowerBound, upperBound, RangePartitionBound.INCLUSIVE_BOUND, RangePartitionBound.EXCLUSIVE_BOUND);
    }

    public AlterTableOptions addRangePartition(PartialRow lowerBound, PartialRow upperBound, RangePartitionBound lowerBoundType, RangePartitionBound upperBoundType) {
        return this.addRangePartition(lowerBound, upperBound, null, lowerBoundType, upperBoundType);
    }

    public AlterTableOptions addRangePartition(PartialRow lowerBound, PartialRow upperBound, String dimensionLabel, RangePartitionBound lowerBoundType, RangePartitionBound upperBoundType) {
        Preconditions.checkNotNull(lowerBound);
        Preconditions.checkNotNull(upperBound);
        Preconditions.checkArgument(lowerBound.getSchema().equals(upperBound.getSchema()));
        Master.AlterTableRequestPB.Step.Builder step = this.pb.addAlterSchemaStepsBuilder();
        step.setType(Master.AlterTableRequestPB.StepType.ADD_RANGE_PARTITION);
        Master.AlterTableRequestPB.AddRangePartition.Builder builder = Master.AlterTableRequestPB.AddRangePartition.newBuilder();
        builder.setRangeBounds(new Operation.OperationsEncoder().encodeLowerAndUpperBounds(lowerBound, upperBound, lowerBoundType, upperBoundType));
        if (dimensionLabel != null) {
            builder.setDimensionLabel(dimensionLabel);
        }
        step.setAddRangePartition(builder);
        if (!this.pb.hasSchema()) {
            this.pb.setSchema(ProtobufHelper.schemaToPb(lowerBound.getSchema(), EnumSet.of(ProtobufHelper.SchemaPBConversionFlags.SCHEMA_PB_WITHOUT_COMMENT, ProtobufHelper.SchemaPBConversionFlags.SCHEMA_PB_WITHOUT_ID)));
        }
        return this;
    }

    public AlterTableOptions addRangePartition(RangePartitionWithCustomHashSchema range) {
        Preconditions.checkNotNull(range);
        Master.AlterTableRequestPB.Step.Builder step = this.pb.addAlterSchemaStepsBuilder();
        step.setType(Master.AlterTableRequestPB.StepType.ADD_RANGE_PARTITION);
        Master.AlterTableRequestPB.AddRangePartition.Builder rangeBuilder = Master.AlterTableRequestPB.AddRangePartition.newBuilder();
        rangeBuilder.setRangeBounds(new Operation.OperationsEncoder().encodeLowerAndUpperBounds(range.getLowerBound(), range.getUpperBound(), range.getLowerBoundType(), range.getUpperBoundType()));
        rangeBuilder.getCustomHashSchemaBuilder().addAllHashSchema(range.toPB().getHashSchemaList());
        step.setAddRangePartition(rangeBuilder);
        if (!this.pb.hasSchema()) {
            this.pb.setSchema(ProtobufHelper.schemaToPb(range.getLowerBound().getSchema(), EnumSet.of(ProtobufHelper.SchemaPBConversionFlags.SCHEMA_PB_WITHOUT_COMMENT, ProtobufHelper.SchemaPBConversionFlags.SCHEMA_PB_WITHOUT_ID)));
        }
        this.isAddingRangeWithCustomHashSchema = true;
        return this;
    }

    public AlterTableOptions dropRangePartition(PartialRow lowerBound, PartialRow upperBound) {
        return this.dropRangePartition(lowerBound, upperBound, RangePartitionBound.INCLUSIVE_BOUND, RangePartitionBound.EXCLUSIVE_BOUND);
    }

    public AlterTableOptions dropRangePartition(PartialRow lowerBound, PartialRow upperBound, RangePartitionBound lowerBoundType, RangePartitionBound upperBoundType) {
        Preconditions.checkNotNull(lowerBound);
        Preconditions.checkNotNull(upperBound);
        Preconditions.checkArgument(lowerBound.getSchema().equals(upperBound.getSchema()));
        Master.AlterTableRequestPB.Step.Builder step = this.pb.addAlterSchemaStepsBuilder();
        step.setType(Master.AlterTableRequestPB.StepType.DROP_RANGE_PARTITION);
        Master.AlterTableRequestPB.DropRangePartition.Builder builder = Master.AlterTableRequestPB.DropRangePartition.newBuilder();
        builder.setRangeBounds(new Operation.OperationsEncoder().encodeLowerAndUpperBounds(lowerBound, upperBound, lowerBoundType, upperBoundType));
        step.setDropRangePartition(builder);
        if (!this.pb.hasSchema()) {
            this.pb.setSchema(ProtobufHelper.schemaToPb(lowerBound.getSchema(), EnumSet.of(ProtobufHelper.SchemaPBConversionFlags.SCHEMA_PB_WITHOUT_COMMENT, ProtobufHelper.SchemaPBConversionFlags.SCHEMA_PB_WITHOUT_ID)));
        }
        return this;
    }

    public AlterTableOptions changeComment(String name, String comment) {
        Master.AlterTableRequestPB.Step.Builder step = this.pb.addAlterSchemaStepsBuilder();
        step.setType(Master.AlterTableRequestPB.StepType.ALTER_COLUMN);
        Master.AlterTableRequestPB.AlterColumn.Builder alterBuilder = Master.AlterTableRequestPB.AlterColumn.newBuilder();
        alterBuilder.setDelta(Common.ColumnSchemaDeltaPB.newBuilder().setName(name).setNewComment(comment));
        step.setAlterColumn(alterBuilder);
        return this;
    }

    public AlterTableOptions changeImmutable(String name, boolean immutable) {
        if (name.equalsIgnoreCase(Schema.getAutoIncrementingColumnName())) {
            throw new IllegalArgumentException("Cannot change immutable for auto-incrementing column " + Schema.getAutoIncrementingColumnName());
        }
        Master.AlterTableRequestPB.Step.Builder step = this.pb.addAlterSchemaStepsBuilder();
        step.setType(Master.AlterTableRequestPB.StepType.ALTER_COLUMN);
        Master.AlterTableRequestPB.AlterColumn.Builder alterBuilder = Master.AlterTableRequestPB.AlterColumn.newBuilder();
        alterBuilder.setDelta(Common.ColumnSchemaDeltaPB.newBuilder().setName(name).setImmutable(immutable));
        step.setAlterColumn(alterBuilder);
        return this;
    }

    public AlterTableOptions alterExtraConfigs(Map<String, String> extraConfig) {
        this.pb.putAllNewExtraConfigs(extraConfig);
        return this;
    }

    public AlterTableOptions setWait(boolean wait) {
        this.wait = wait;
        return this;
    }

    @InterfaceAudience.Private
    boolean hasAddDropRangePartitions() {
        return this.pb.hasSchema();
    }

    Master.AlterTableRequestPB.Builder getProtobuf() {
        return this.pb;
    }

    boolean shouldWait() {
        return this.wait;
    }

    List<Integer> getRequiredFeatureFlags() {
        boolean hasImmutables = false;
        for (Master.AlterTableRequestPB.Step.Builder step : this.pb.getAlterSchemaStepsBuilderList()) {
            if ((step.getType() != Master.AlterTableRequestPB.StepType.ADD_COLUMN || !step.getAddColumn().getSchema().hasImmutable()) && (step.getType() != Master.AlterTableRequestPB.StepType.ALTER_COLUMN || !step.getAlterColumn().getDelta().hasImmutable())) continue;
            hasImmutables = true;
            break;
        }
        ArrayList<Integer> requiredFeatureFlags = new ArrayList<Integer>();
        if (hasImmutables) {
            requiredFeatureFlags.add(10);
        }
        if (this.hasAddDropRangePartitions()) {
            requiredFeatureFlags.add(1);
            if (this.isAddingRangeWithCustomHashSchema) {
                requiredFeatureFlags.add(8);
            }
        }
        return requiredFeatureFlags;
    }
}

