/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.common.counters;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.tez.common.counters.AbstractCounter;
import org.apache.tez.common.counters.AggregateTezCounter;
import org.apache.tez.common.counters.TezCounter;

public class AggregateTezCounterDelegate<T extends TezCounter>
extends AbstractCounter
implements AggregateTezCounter {
    private final T child;
    private long min = Long.MAX_VALUE;
    private long max = Long.MIN_VALUE;
    private long count = 0L;

    public AggregateTezCounterDelegate(T child) {
        this.child = child;
    }

    @Override
    public String getName() {
        return this.child.getName();
    }

    @Override
    public String getDisplayName() {
        return this.child.getDisplayName();
    }

    @Override
    public long getValue() {
        return this.child.getValue();
    }

    @Override
    public void setValue(long value) {
        this.child.setValue(value);
    }

    @Override
    public void increment(long incr) {
        throw new UnsupportedOperationException("Cannot increment an aggregate counter");
    }

    @Override
    public void aggregate(TezCounter other) {
        long othercount;
        long othermin;
        long othermax;
        long val = other.getValue();
        if (other instanceof AggregateTezCounter) {
            othermax = ((AggregateTezCounter)((Object)other)).getMax();
            othermin = ((AggregateTezCounter)((Object)other)).getMin();
            othercount = ((AggregateTezCounter)((Object)other)).getCount();
        } else {
            othermin = othermax = val;
            othercount = 1L;
        }
        this.count += othercount;
        this.child.increment(val);
        if (this.min == Long.MAX_VALUE) {
            this.min = othermin;
            this.max = othermax;
            return;
        }
        this.min = Math.min(this.min, othermin);
        this.max = Math.max(this.max, othermax);
    }

    @Override
    public TezCounter getUnderlyingCounter() {
        return this.child;
    }

    public void readFields(DataInput arg0) throws IOException {
        throw new UnsupportedOperationException("Cannot deserialize an aggregate counter");
    }

    public void write(DataOutput arg0) throws IOException {
        throw new UnsupportedOperationException("Cannot deserialize an aggregate counter");
    }

    @Override
    public long getMin() {
        return this.min;
    }

    @Override
    public long getMax() {
        return this.max;
    }

    @Override
    public long getCount() {
        return this.count;
    }
}

