/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules.views;

import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.rel.RelNode;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.calcite.RelOptHiveTable;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveTableScan;

public class HiveInsertOnlyScanWriteIdRule
extends RelOptRule {
    public static final HiveInsertOnlyScanWriteIdRule INSTANCE = new HiveInsertOnlyScanWriteIdRule();

    private HiveInsertOnlyScanWriteIdRule() {
        super(HiveInsertOnlyScanWriteIdRule.operand(HiveTableScan.class, (RelOptRuleOperandChildren)HiveInsertOnlyScanWriteIdRule.none()));
    }

    public boolean matches(RelOptRuleCall call) {
        HiveTableScan tableScan = (HiveTableScan)call.rel(0);
        Table tableMD = ((RelOptHiveTable)tableScan.getTable()).getHiveTableMD();
        return !tableMD.isMaterializedView() && AcidUtils.isInsertOnlyTable(tableMD);
    }

    public void onMatch(RelOptRuleCall call) {
        HiveTableScan tableScan = (HiveTableScan)call.rel(0);
        RelNode newTableScan = call.builder().push((RelNode)tableScan.setTableScanTrait(HiveTableScan.HiveTableScanTrait.FetchInsertOnlyBucketIds)).build();
        call.transformTo(newTableScan);
    }
}

