/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.healthcare;

import com.google.api.services.healthcare.v1.model.Message;
import com.google.auto.value.AutoValue;
import java.io.IOException;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.coders.ListCoder;
import org.apache.beam.sdk.coders.SerializableCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.io.gcp.healthcare.AutoValue_HL7v2IO_Write;
import org.apache.beam.sdk.io.gcp.healthcare.HL7v2Message;
import org.apache.beam.sdk.io.gcp.healthcare.HL7v2MessageCoder;
import org.apache.beam.sdk.io.gcp.healthcare.HL7v2ReadParameter;
import org.apache.beam.sdk.io.gcp.healthcare.HL7v2ReadResponse;
import org.apache.beam.sdk.io.gcp.healthcare.HL7v2ReadResponseCoder;
import org.apache.beam.sdk.io.gcp.healthcare.HealthcareApiClient;
import org.apache.beam.sdk.io.gcp.healthcare.HealthcareIOError;
import org.apache.beam.sdk.io.gcp.healthcare.HealthcareIOErrorCoder;
import org.apache.beam.sdk.io.gcp.healthcare.HttpHealthcareApiClient;
import org.apache.beam.sdk.io.range.OffsetRange;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Distribution;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.FlatMapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.Reshuffle;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Throwables;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.FluentIterable;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HL7v2IO {
    private static @UnknownKeyFor @NonNull @Initialized Write.Builder write(@UnknownKeyFor @NonNull @Initialized String hl7v2Store) {
        return new AutoValue_HL7v2IO_Write.Builder().setHL7v2Store((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)hl7v2Store));
    }

    public static @UnknownKeyFor @NonNull @Initialized Read getAll() {
        return new Read();
    }

    public static @UnknownKeyFor @NonNull @Initialized HL7v2Read readAllRequests() {
        return new HL7v2Read();
    }

    public static @UnknownKeyFor @NonNull @Initialized ListHL7v2Messages readAll(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> hl7v2Stores) {
        return new ListHL7v2Messages((ValueProvider<List<String>>)ValueProvider.StaticValueProvider.of(hl7v2Stores), (ValueProvider<String>)ValueProvider.StaticValueProvider.of(null));
    }

    public static @UnknownKeyFor @NonNull @Initialized ListHL7v2Messages readAll(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String>> hl7v2Stores) {
        return new ListHL7v2Messages(hl7v2Stores, (ValueProvider<String>)ValueProvider.StaticValueProvider.of(null));
    }

    public static @UnknownKeyFor @NonNull @Initialized ListHL7v2Messages read(@UnknownKeyFor @NonNull @Initialized String hl7v2Store) {
        return new ListHL7v2Messages((ValueProvider<List<String>>)ValueProvider.StaticValueProvider.of(Collections.singletonList(hl7v2Store)), (ValueProvider<String>)ValueProvider.StaticValueProvider.of(null));
    }

    public static @UnknownKeyFor @NonNull @Initialized ListHL7v2Messages read(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> hl7v2Store) {
        return new ListHL7v2Messages((ValueProvider<List<String>>)ValueProvider.StaticValueProvider.of(Collections.singletonList((String)hl7v2Store.get())), (ValueProvider<String>)ValueProvider.StaticValueProvider.of(null));
    }

    public static @UnknownKeyFor @NonNull @Initialized ListHL7v2Messages readWithFilter(@UnknownKeyFor @NonNull @Initialized String hl7v2Store, @UnknownKeyFor @NonNull @Initialized String filter) {
        return new ListHL7v2Messages((ValueProvider<List<String>>)ValueProvider.StaticValueProvider.of(Collections.singletonList(hl7v2Store)), (ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)filter));
    }

    public static @UnknownKeyFor @NonNull @Initialized ListHL7v2Messages readWithFilter(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> hl7v2Store, @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> filter) {
        return new ListHL7v2Messages((ValueProvider<List<String>>)ValueProvider.StaticValueProvider.of(Collections.singletonList((String)hl7v2Store.get())), filter);
    }

    public static @UnknownKeyFor @NonNull @Initialized ListHL7v2Messages readAllWithFilter(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> hl7v2Stores, @UnknownKeyFor @NonNull @Initialized String filter) {
        return new ListHL7v2Messages((ValueProvider<List<String>>)ValueProvider.StaticValueProvider.of(hl7v2Stores), (ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)filter));
    }

    public static @UnknownKeyFor @NonNull @Initialized ListHL7v2Messages readAllWithFilter(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String>> hl7v2Stores, @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> filter) {
        return new ListHL7v2Messages(hl7v2Stores, filter);
    }

    public static @UnknownKeyFor @NonNull @Initialized Write ingestMessages(@UnknownKeyFor @NonNull @Initialized String hl7v2Store) {
        return HL7v2IO.write(hl7v2Store).setWriteMethod(Write.WriteMethod.INGEST).build();
    }

    static class WriteHL7v2
    extends PTransform<PCollection<HL7v2Message>, Write.Result> {
        private final @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> hl7v2Store;
        private final @UnknownKeyFor @NonNull @Initialized Write.WriteMethod writeMethod;

        WriteHL7v2(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> hl7v2Store, @UnknownKeyFor @NonNull @Initialized Write.WriteMethod writeMethod) {
            this.hl7v2Store = hl7v2Store;
            this.writeMethod = writeMethod;
        }

        public @UnknownKeyFor @NonNull @Initialized Write.Result expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized HL7v2Message> input) {
            PCollection failedInserts = ((PCollection)input.apply((PTransform)ParDo.of((DoFn)new WriteHL7v2Fn(this.hl7v2Store, this.writeMethod)))).setCoder(HealthcareIOErrorCoder.of(HL7v2MessageCoder.of()));
            return Write.Result.in(input.getPipeline(), (PCollection<HealthcareIOError<HL7v2Message>>)failedInserts);
        }

        static class WriteHL7v2Fn
        extends DoFn<HL7v2Message, HealthcareIOError<HL7v2Message>> {
            private @UnknownKeyFor @NonNull @Initialized Distribution messageIngestLatencyMs = Metrics.distribution(WriteHL7v2Fn.class, (String)"hl7v2-message-ingest-latency-ms");
            private @UnknownKeyFor @NonNull @Initialized Counter failedMessageWrites = Metrics.counter(WriteHL7v2Fn.class, (String)"failed-hl7v2-message-writes");
            private final @UnknownKeyFor @NonNull @Initialized Counter successfulHL7v2MessageWrites = Metrics.counter(WriteHL7v2Fn.class, (String)"successful-hl7v2-message-writes");
            private final @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> hl7v2Store;
            private final @UnknownKeyFor @NonNull @Initialized Write.WriteMethod writeMethod;
            private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(WriteHL7v2Fn.class);
            private transient @UnknownKeyFor @NonNull @Initialized HealthcareApiClient client;

            WriteHL7v2Fn(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> hl7v2Store, @UnknownKeyFor @NonNull @Initialized Write.WriteMethod writeMethod) {
                this.hl7v2Store = hl7v2Store;
                this.writeMethod = writeMethod;
            }

            @DoFn.Setup
            public void initClient() throws @UnknownKeyFor @NonNull @Initialized IOException {
                this.client = new HttpHealthcareApiClient();
            }

            @DoFn.ProcessElement
            public void writeMessages(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext context) {
                HL7v2Message msg = (HL7v2Message)context.element();
                Message model = new Message();
                model.setData(msg.getData());
                model.setLabels(msg.getLabels());
                switch (this.writeMethod) {
                    case BATCH_IMPORT: {
                        throw new UnsupportedOperationException("The batch import API is not supported yet");
                    }
                }
                try {
                    long requestTimestamp = Instant.now().getMillis();
                    this.client.ingestHL7v2Message((String)this.hl7v2Store.get(), model);
                    this.successfulHL7v2MessageWrites.inc();
                    this.messageIngestLatencyMs.update(Instant.now().getMillis() - requestTimestamp);
                }
                catch (Exception e) {
                    this.failedMessageWrites.inc();
                    LOG.warn(String.format("Failed to ingest message Error: %s Stacktrace: %s", e.getMessage(), Throwables.getStackTraceAsString((Throwable)e)));
                    HealthcareIOError<HL7v2Message> err = HealthcareIOError.of(msg, e);
                    LOG.warn(String.format("%s %s", err.getErrorMessage(), err.getStackTrace()));
                    context.output(err);
                }
            }
        }
    }

    @AutoValue
    public static abstract class Write
    extends PTransform<PCollection<HL7v2Message>, Result> {
        public static final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized HealthcareIOError<@UnknownKeyFor @NonNull @Initialized HL7v2Message>> SUCCESS = new TupleTag<HealthcareIOError<HL7v2Message>>(){};
        public static final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized HealthcareIOError<@UnknownKeyFor @NonNull @Initialized HL7v2Message>> FAILED = new TupleTag<HealthcareIOError<HL7v2Message>>(){};

        abstract @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> getHL7v2Store();

        abstract @UnknownKeyFor @NonNull @Initialized WriteMethod getWriteMethod();

        public @UnknownKeyFor @NonNull @Initialized Result expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized HL7v2Message> messages) {
            CoderRegistry coderRegistry = messages.getPipeline().getCoderRegistry();
            coderRegistry.registerCoderForClass(HL7v2Message.class, (Coder)HL7v2MessageCoder.of());
            return (Result)messages.apply((PTransform)new WriteHL7v2(this.getHL7v2Store(), this.getWriteMethod()));
        }

        public static class Result
        implements POutput {
            private final @UnknownKeyFor @NonNull @Initialized Pipeline pipeline;
            private final @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized HealthcareIOError<@UnknownKeyFor @NonNull @Initialized HL7v2Message>> failedInsertsWithErr;

            static @UnknownKeyFor @NonNull @Initialized Result in(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized HealthcareIOError<@UnknownKeyFor @NonNull @Initialized HL7v2Message>> failedInserts) {
                return new Result(pipeline, failedInserts);
            }

            public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized HealthcareIOError<@UnknownKeyFor @NonNull @Initialized HL7v2Message>> getFailedInsertsWithErr() {
                return this.failedInsertsWithErr;
            }

            public @UnknownKeyFor @NonNull @Initialized Pipeline getPipeline() {
                return this.pipeline;
            }

            public /*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PValue> expand() {
                this.failedInsertsWithErr.setCoder(HealthcareIOErrorCoder.of(HL7v2MessageCoder.of()));
                return ImmutableMap.of(FAILED, this.failedInsertsWithErr);
            }

            public void finishSpecifyingOutput(@UnknownKeyFor @NonNull @Initialized String transformName, @UnknownKeyFor @NonNull @Initialized PInput input, /*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> transform) {
            }

            private Result(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized HealthcareIOError<@UnknownKeyFor @NonNull @Initialized HL7v2Message>> failedInsertsWithErr) {
                this.pipeline = pipeline;
                this.failedInsertsWithErr = failedInsertsWithErr;
            }
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder setHL7v2Store(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setWriteMethod(@UnknownKeyFor @NonNull @Initialized WriteMethod var1);

            abstract @UnknownKeyFor @NonNull @Initialized Write build();
        }

        public static enum WriteMethod {
            INGEST,
            BATCH_IMPORT;

        }
    }

    @DoFn.BoundedPerElement
    @VisibleForTesting
    static class ListHL7v2MessagesFn
    extends DoFn<String, HL7v2Message> {
        private static final @UnknownKeyFor @NonNull @Initialized Duration DEFAULT_DESIRED_SPLIT_DURATION = Duration.standardDays((long)1L);
        private static final @UnknownKeyFor @NonNull @Initialized Duration DEFAULT_MIN_SPLIT_DURATION = Duration.standardHours((long)1L);
        private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(ListHL7v2MessagesFn.class);
        private @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> filter;
        private @UnknownKeyFor @NonNull @Initialized Duration initialSplitDuration;
        private transient @UnknownKeyFor @NonNull @Initialized HealthcareApiClient client;

        ListHL7v2MessagesFn(@UnknownKeyFor @NonNull @Initialized String filter) {
            this((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)filter), null);
        }

        ListHL7v2MessagesFn(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> filter, @Nullable @UnknownKeyFor @Initialized Duration initialSplitDuration) {
            this.filter = filter;
            this.initialSplitDuration = initialSplitDuration == null ? DEFAULT_DESIRED_SPLIT_DURATION : initialSplitDuration;
        }

        @DoFn.Setup
        public void initClient() throws @UnknownKeyFor @NonNull @Initialized IOException {
            this.client = new HttpHealthcareApiClient();
        }

        @DoFn.GetInitialRestriction
        public @UnknownKeyFor @NonNull @Initialized OffsetRange getEarliestToLatestRestriction(@DoFn.Element @UnknownKeyFor @NonNull @Initialized String hl7v2Store) throws @UnknownKeyFor @NonNull @Initialized IOException {
            Instant from = this.client.getEarliestHL7v2SendTime(hl7v2Store, (String)this.filter.get());
            Instant to = this.client.getLatestHL7v2SendTime(hl7v2Store, (String)this.filter.get()).plus((ReadableDuration)Duration.millis((long)1L));
            return new OffsetRange(from.getMillis(), to.getMillis());
        }

        @DoFn.SplitRestriction
        public void split(@DoFn.Restriction @UnknownKeyFor @NonNull @Initialized OffsetRange timeRange, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized OffsetRange> out) {
            List splits = timeRange.split(this.initialSplitDuration.getMillis(), DEFAULT_MIN_SPLIT_DURATION.getMillis());
            Instant from = Instant.ofEpochMilli((long)timeRange.getFrom());
            Instant to = Instant.ofEpochMilli((long)timeRange.getTo());
            Duration totalDuration = new Duration((ReadableInstant)from, (ReadableInstant)to);
            LOG.info(String.format("splitting initial sendTime restriction of [minSendTime, now): [%s,%s), or [%s, %s). \ntotal days: %s \ninto %s splits. \nLast split: %s", from, to, timeRange.getFrom(), timeRange.getTo(), totalDuration.getStandardDays(), splits.size(), ((OffsetRange)splits.get(splits.size() - 1)).toString()));
            for (OffsetRange s : splits) {
                out.output((Object)s);
            }
        }

        @DoFn.ProcessElement
        public void listMessages(@DoFn.Element @UnknownKeyFor @NonNull @Initialized String hl7v2Store, @UnknownKeyFor @NonNull @Initialized RestrictionTracker<@UnknownKeyFor @NonNull @Initialized OffsetRange, @UnknownKeyFor @NonNull @Initialized Long> tracker, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized HL7v2Message> outputReceiver) throws @UnknownKeyFor @NonNull @Initialized IOException {
            OffsetRange currentRestriction = (OffsetRange)tracker.currentRestriction();
            Instant startRestriction = Instant.ofEpochMilli((long)currentRestriction.getFrom());
            Instant endRestriction = Instant.ofEpochMilli((long)currentRestriction.getTo());
            HttpHealthcareApiClient.HL7v2MessagePages pages = new HttpHealthcareApiClient.HL7v2MessagePages(this.client, hl7v2Store, startRestriction, endRestriction, (String)this.filter.get(), "sendTime");
            long lastClaimedMilliSecond = startRestriction.getMillis() - 1L;
            for (HL7v2Message msg : FluentIterable.concat((Iterable)pages)) {
                Instant cursor = Instant.parse((String)msg.getSendTime());
                if (cursor.getMillis() > lastClaimedMilliSecond) {
                    if (!tracker.tryClaim((Object)cursor.getMillis())) {
                        return;
                    }
                    lastClaimedMilliSecond = cursor.getMillis();
                }
                outputReceiver.output((Object)msg);
            }
            tracker.tryClaim((Object)currentRestriction.getTo());
        }
    }

    public static class ListHL7v2Messages
    extends PTransform<PBegin, PCollection<HL7v2Message>> {
        private final @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String>> hl7v2Stores;
        private final @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> filter;
        private @UnknownKeyFor @NonNull @Initialized Duration initialSplitDuration;

        ListHL7v2Messages(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String>> hl7v2Stores, @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> filter) {
            this.hl7v2Stores = hl7v2Stores;
            this.filter = filter;
            this.initialSplitDuration = null;
        }

        public @UnknownKeyFor @NonNull @Initialized ListHL7v2Messages withInitialSplitDuration(@UnknownKeyFor @NonNull @Initialized Duration initialSplitDuration) {
            this.initialSplitDuration = initialSplitDuration;
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized HL7v2Message> expand(@UnknownKeyFor @NonNull @Initialized PBegin input) {
            CoderRegistry coderRegistry = input.getPipeline().getCoderRegistry();
            coderRegistry.registerCoderForClass(HL7v2Message.class, (Coder)HL7v2MessageCoder.of());
            return (PCollection)((PCollection)((PCollection)((PCollection)input.apply((PTransform)Create.ofProvider(this.hl7v2Stores, (Coder)ListCoder.of((Coder)StringUtf8Coder.of())))).apply((PTransform)FlatMapElements.into((TypeDescriptor)TypeDescriptors.strings()).via((SerializableFunction & Serializable)x -> x))).apply((PTransform)ParDo.of((DoFn)new ListHL7v2MessagesFn(this.filter, this.initialSplitDuration)))).setCoder((Coder)HL7v2MessageCoder.of()).apply((PTransform)Reshuffle.viaRandomKey());
        }
    }

    private static class HL7v2MessageClient {
        private final @UnknownKeyFor @NonNull @Initialized Counter failedMessageGets = Metrics.counter(HL7v2MessageClient.class, (String)"failed-message-reads");
        private final @UnknownKeyFor @NonNull @Initialized Counter successfulHL7v2MessageGets = Metrics.counter(HL7v2MessageClient.class, (String)"successful-hl7v2-message-gets");
        private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(HL7v2MessageClient.class);
        private final @UnknownKeyFor @NonNull @Initialized HealthcareApiClient client;

        HL7v2MessageClient(@UnknownKeyFor @NonNull @Initialized HealthcareApiClient client) {
            this.client = client;
        }

        private @UnknownKeyFor @NonNull @Initialized HL7v2Message fetchMessage(@UnknownKeyFor @NonNull @Initialized String msgId) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized ParseException, @UnknownKeyFor @NonNull @Initialized IllegalArgumentException {
            try {
                Message msg = this.client.getHL7v2Message(msgId);
                if (msg == null) {
                    throw new IOException(String.format("GET request for %s returned null", msgId));
                }
                this.successfulHL7v2MessageGets.inc();
                return HL7v2Message.fromModel(msg);
            }
            catch (Exception e) {
                this.failedMessageGets.inc();
                LOG.warn(String.format("Error fetching HL7v2 message with ID %s writing to Dead Letter Queue. Cause: %s Stack Trace: %s", msgId, e.getMessage(), Throwables.getStackTraceAsString((Throwable)e)));
                throw e;
            }
        }
    }

    private static abstract class HL7v2ReadResult<@UnknownKeyFor T, @UnknownKeyFor K>
    implements POutput,
    PInput {
        @UnknownKeyFor @NonNull @Initialized PCollection<K> messages;
        @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized HealthcareIOError<T>> failedReads;
        @UnknownKeyFor @NonNull @Initialized TupleTag<K> out;
        private final @UnknownKeyFor @NonNull @Initialized PCollectionTuple pct;

        private HL7v2ReadResult(@UnknownKeyFor @NonNull @Initialized PCollectionTuple pct) {
            this.pct = pct;
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized HealthcareIOError<T>> getFailedReads() {
            return this.failedReads;
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<K> getMessages() {
            return this.messages;
        }

        public @UnknownKeyFor @NonNull @Initialized Pipeline getPipeline() {
            return this.pct.getPipeline();
        }

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PValue> expand() {
            return ImmutableMap.of(this.out, this.messages);
        }

        public void finishSpecifyingOutput(@UnknownKeyFor @NonNull @Initialized String transformName, @UnknownKeyFor @NonNull @Initialized PInput input, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> transform) {
        }
    }

    public static class HL7v2Read
    extends PTransform<PCollection<HL7v2ReadParameter>, Result> {
        public static final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized HL7v2ReadResponse> OUT = new TupleTag<HL7v2ReadResponse>(){};
        public static final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized HealthcareIOError<@UnknownKeyFor @NonNull @Initialized HL7v2ReadParameter>> DEAD_LETTER = new TupleTag<HealthcareIOError<HL7v2ReadParameter>>(){};

        public @UnknownKeyFor @NonNull @Initialized Result expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized HL7v2ReadParameter> input) {
            CoderRegistry coderRegistry = input.getPipeline().getCoderRegistry();
            coderRegistry.registerCoderForClass(HL7v2ReadResponse.class, (Coder)HL7v2ReadResponseCoder.of());
            return (Result)input.apply("Fetch HL7v2 messages", (PTransform)new FetchHL7v2Message());
        }

        public static class FetchHL7v2Message
        extends PTransform<PCollection<HL7v2ReadParameter>, Result> {
            public @UnknownKeyFor @NonNull @Initialized Result expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized HL7v2ReadParameter> input) {
                CoderRegistry coderRegistry = input.getPipeline().getCoderRegistry();
                coderRegistry.registerCoderForClass(HL7v2ReadResponse.class, (Coder)HL7v2ReadResponseCoder.of());
                return Result.of((PCollectionTuple)input.apply((PTransform)ParDo.of((DoFn)new HL7v2MessageGetFn()).withOutputTags(OUT, TupleTagList.of(DEAD_LETTER))));
            }

            public static class HL7v2MessageGetFn
            extends DoFn<HL7v2ReadParameter, HL7v2ReadResponse> {
                private @UnknownKeyFor @NonNull @Initialized HL7v2MessageClient client;

                @DoFn.Setup
                public void instantiateHealthcareClient() throws @UnknownKeyFor @NonNull @Initialized IOException {
                    this.client = new HL7v2MessageClient(new HttpHealthcareApiClient());
                }

                @DoFn.ProcessElement
                public void processElement(/*
                 * Issues handling annotations - annotations may be inaccurate
                 */
                // Could not load outer class - annotation placement on inner may be incorrect
                @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext context) {
                    String msgId = ((HL7v2ReadParameter)context.element()).getHl7v2MessageId();
                    try {
                        HL7v2ReadResponse response = HL7v2ReadResponse.of(((HL7v2ReadParameter)context.element()).getMetadata(), this.client.fetchMessage(msgId));
                        context.output((Object)response);
                    }
                    catch (Exception e) {
                        HealthcareIOError<HL7v2ReadParameter> error = HealthcareIOError.of((HL7v2ReadParameter)context.element(), e);
                        context.output(DEAD_LETTER, error);
                    }
                }
            }
        }

        public static class Result
        extends HL7v2ReadResult<HL7v2ReadParameter, HL7v2ReadResponse> {
            public static @UnknownKeyFor @NonNull @Initialized Result of(@UnknownKeyFor @NonNull @Initialized PCollectionTuple pct) throws @UnknownKeyFor @NonNull @Initialized IllegalArgumentException {
                if (pct.getAll().keySet().containsAll(TupleTagList.of(OUT).and(DEAD_LETTER).getAll())) {
                    return new Result(pct);
                }
                throw new IllegalArgumentException("The PCollection tuple must have the HL7v2IO.HL7v2Read.OUT and HL7v2IO.HL7v2Read.DEAD_LETTER tuple tags");
            }

            private Result(@UnknownKeyFor @NonNull @Initialized PCollectionTuple pct) {
                super(pct);
                this.out = OUT;
                this.messages = pct.get(OUT).setCoder((Coder)HL7v2ReadResponseCoder.of());
                this.failedReads = pct.get(DEAD_LETTER).setCoder(HealthcareIOErrorCoder.of(SerializableCoder.of(HL7v2ReadParameter.class)));
            }
        }
    }

    public static class Read
    extends PTransform<PCollection<String>, Result> {
        public static final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized HL7v2Message> OUT = new TupleTag<HL7v2Message>(){};
        public static final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized HealthcareIOError<@UnknownKeyFor @NonNull @Initialized String>> DEAD_LETTER = new TupleTag<HealthcareIOError<String>>(){};

        public @UnknownKeyFor @NonNull @Initialized Result expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized String> input) {
            CoderRegistry coderRegistry = input.getPipeline().getCoderRegistry();
            coderRegistry.registerCoderForClass(HL7v2Message.class, (Coder)HL7v2MessageCoder.of());
            return (Result)input.apply("Fetch HL7v2 messages", (PTransform)new FetchHL7v2Message());
        }

        public static class FetchHL7v2Message
        extends PTransform<PCollection<String>, Result> {
            public @UnknownKeyFor @NonNull @Initialized Result expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized String> msgIds) {
                CoderRegistry coderRegistry = msgIds.getPipeline().getCoderRegistry();
                coderRegistry.registerCoderForClass(HL7v2Message.class, (Coder)HL7v2MessageCoder.of());
                return new Result((PCollectionTuple)msgIds.apply((PTransform)ParDo.of((DoFn)new HL7v2MessageGetFn()).withOutputTags(OUT, TupleTagList.of(DEAD_LETTER))));
            }

            public static class HL7v2MessageGetFn
            extends DoFn<String, HL7v2Message> {
                private @UnknownKeyFor @NonNull @Initialized HL7v2MessageClient client;

                HL7v2MessageGetFn() {
                }

                @DoFn.Setup
                public void instantiateHealthcareClient() throws @UnknownKeyFor @NonNull @Initialized IOException {
                    this.client = new HL7v2MessageClient(new HttpHealthcareApiClient());
                }

                @DoFn.ProcessElement
                public void processElement(/*
                 * Issues handling annotations - annotations may be inaccurate
                 */
                // Could not load outer class - annotation placement on inner may be incorrect
                @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext context) {
                    String msgId = (String)context.element();
                    try {
                        context.output((Object)this.client.fetchMessage(msgId));
                    }
                    catch (Exception e) {
                        context.output(DEAD_LETTER, HealthcareIOError.of(msgId, e));
                    }
                }
            }
        }

        public static class Result
        extends HL7v2ReadResult<String, HL7v2Message> {
            public static @UnknownKeyFor @NonNull @Initialized Result of(@UnknownKeyFor @NonNull @Initialized PCollectionTuple pct) throws @UnknownKeyFor @NonNull @Initialized IllegalArgumentException {
                if (pct.getAll().keySet().containsAll(TupleTagList.of(OUT).and(DEAD_LETTER).getAll())) {
                    return new Result(pct);
                }
                throw new IllegalArgumentException("The PCollection tuple must have the HL7v2IO.Read.OUT and HL7v2IO.Read.DEAD_LETTER tuple tags");
            }

            private Result(@UnknownKeyFor @NonNull @Initialized PCollectionTuple pct) {
                super(pct);
                this.out = OUT;
                this.messages = pct.get(OUT).setCoder((Coder)HL7v2MessageCoder.of());
                this.failedReads = pct.get(DEAD_LETTER).setCoder(HealthcareIOErrorCoder.of(StringUtf8Coder.of()));
            }
        }
    }
}

