/*
 * Decompiled with CFR 0.152.
 */
package dev.ai4j.openai4j;

import dev.ai4j.openai4j.AsyncResponseHandling;
import dev.ai4j.openai4j.ErrorHandling;
import dev.ai4j.openai4j.ResponseHandle;
import dev.ai4j.openai4j.Utils;
import java.io.IOException;
import java.util.function.Consumer;
import java.util.function.Function;
import retrofit2.Call;
import retrofit2.Response;

class AsyncRequestExecutor<Response, ResponseContent> {
    private final Call<Response> call;
    private final Function<Response, ResponseContent> responseContentExtractor;

    AsyncRequestExecutor(Call<Response> call, Function<Response, ResponseContent> responseContentExtractor) {
        this.call = call;
        this.responseContentExtractor = responseContentExtractor;
    }

    AsyncResponseHandling onResponse(final Consumer<ResponseContent> responseHandler) {
        return new AsyncResponseHandling(){

            @Override
            public ErrorHandling onError(final Consumer<Throwable> errorHandler) {
                return new ErrorHandling(){

                    @Override
                    public ResponseHandle execute() {
                        try {
                            Response retrofitResponse = AsyncRequestExecutor.this.call.execute();
                            if (retrofitResponse.isSuccessful()) {
                                Object response = retrofitResponse.body();
                                Object responseContent = AsyncRequestExecutor.this.responseContentExtractor.apply(response);
                                responseHandler.accept(responseContent);
                            } else {
                                errorHandler.accept(Utils.toException(retrofitResponse));
                            }
                        }
                        catch (IOException e) {
                            errorHandler.accept(e);
                        }
                        return new ResponseHandle();
                    }
                };
            }

            @Override
            public ErrorHandling ignoreErrors() {
                return new ErrorHandling(){

                    @Override
                    public ResponseHandle execute() {
                        try {
                            Response retrofitResponse = AsyncRequestExecutor.this.call.execute();
                            if (retrofitResponse.isSuccessful()) {
                                Object response = retrofitResponse.body();
                                Object responseContent = AsyncRequestExecutor.this.responseContentExtractor.apply(response);
                                responseHandler.accept(responseContent);
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        return new ResponseHandle();
                    }
                };
            }
        };
    }
}

