/*
 * Decompiled with CFR 0.152.
 */
package dev.ai4j.openai4j.embedding;

import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class Embedding {
    private final List<Float> embedding;
    private final Integer index;

    private Embedding(Builder builder) {
        this.embedding = builder.embedding;
        this.index = builder.index;
    }

    public List<Float> embedding() {
        return this.embedding;
    }

    public Integer index() {
        return this.index;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Embedding && this.equalTo((Embedding)another);
    }

    private boolean equalTo(Embedding another) {
        return Objects.equals(this.embedding, another.embedding) && Objects.equals(this.index, another.index);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.embedding);
        h += (h << 5) + Objects.hashCode(this.index);
        return h;
    }

    public String toString() {
        return "Embedding{embedding=" + this.embedding + ", index=" + this.index + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<Float> embedding;
        private Integer index;

        private Builder() {
        }

        public Builder embedding(List<Float> embedding) {
            if (embedding != null) {
                this.embedding = Collections.unmodifiableList(embedding);
            }
            return this;
        }

        public Builder index(Integer index) {
            this.index = index;
            return this;
        }

        public Embedding build() {
            return new Embedding(this);
        }
    }
}

