/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.opentelemetry.sdk.logs;

import java.io.Closeable;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.logging.Level;
import net.snowflake.client.jdbc.internal.javax.annotation.Nullable;
import net.snowflake.client.jdbc.internal.opentelemetry.api.common.Attributes;
import net.snowflake.client.jdbc.internal.opentelemetry.api.logs.Logger;
import net.snowflake.client.jdbc.internal.opentelemetry.api.logs.LoggerBuilder;
import net.snowflake.client.jdbc.internal.opentelemetry.api.logs.LoggerProvider;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.common.Clock;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.common.CompletableResultCode;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.common.InstrumentationScopeInfo;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.internal.ComponentRegistry;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.internal.ScopeConfigurator;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.logs.LogLimits;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.logs.LogRecordProcessor;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.logs.LoggerSharedState;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.logs.NoopLogRecordProcessor;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.logs.SdkLogger;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.logs.SdkLoggerBuilder;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.logs.SdkLoggerProviderBuilder;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.logs.internal.LoggerConfig;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.resources.Resource;

public final class SdkLoggerProvider
implements LoggerProvider,
Closeable {
    static final String DEFAULT_LOGGER_NAME = "unknown";
    private static final java.util.logging.Logger LOGGER = java.util.logging.Logger.getLogger(SdkLoggerProvider.class.getName());
    private final LoggerSharedState sharedState;
    private final ComponentRegistry<SdkLogger> loggerComponentRegistry;
    private final ScopeConfigurator<LoggerConfig> loggerConfigurator;
    private final boolean isNoopLogRecordProcessor;

    public static SdkLoggerProviderBuilder builder() {
        return new SdkLoggerProviderBuilder();
    }

    SdkLoggerProvider(Resource resource, Supplier<LogLimits> logLimitsSupplier, List<LogRecordProcessor> processors, Clock clock, ScopeConfigurator<LoggerConfig> loggerConfigurator) {
        LogRecordProcessor logRecordProcessor = LogRecordProcessor.composite(processors);
        this.sharedState = new LoggerSharedState(resource, logLimitsSupplier, logRecordProcessor, clock);
        this.loggerComponentRegistry = new ComponentRegistry<SdkLogger>(instrumentationScopeInfo -> new SdkLogger(this.sharedState, (InstrumentationScopeInfo)instrumentationScopeInfo, this.getLoggerConfig((InstrumentationScopeInfo)instrumentationScopeInfo)));
        this.loggerConfigurator = loggerConfigurator;
        this.isNoopLogRecordProcessor = logRecordProcessor instanceof NoopLogRecordProcessor;
    }

    private LoggerConfig getLoggerConfig(InstrumentationScopeInfo instrumentationScopeInfo) {
        LoggerConfig loggerConfig = (LoggerConfig)this.loggerConfigurator.apply((LoggerConfig)((Object)instrumentationScopeInfo));
        return loggerConfig == null ? LoggerConfig.defaultConfig() : loggerConfig;
    }

    @Override
    public Logger get(String instrumentationScopeName) {
        return this.loggerComponentRegistry.get(SdkLoggerProvider.instrumentationNameOrDefault(instrumentationScopeName), null, null, Attributes.empty());
    }

    @Override
    public LoggerBuilder loggerBuilder(String instrumentationScopeName) {
        if (this.isNoopLogRecordProcessor) {
            return LoggerProvider.noop().loggerBuilder(instrumentationScopeName);
        }
        return new SdkLoggerBuilder(this.loggerComponentRegistry, SdkLoggerProvider.instrumentationNameOrDefault(instrumentationScopeName));
    }

    private static String instrumentationNameOrDefault(@Nullable String instrumentationScopeName) {
        if (instrumentationScopeName == null || instrumentationScopeName.isEmpty()) {
            LOGGER.fine("Logger requested without instrumentation scope name.");
            return DEFAULT_LOGGER_NAME;
        }
        return instrumentationScopeName;
    }

    public CompletableResultCode forceFlush() {
        return this.sharedState.getLogRecordProcessor().forceFlush();
    }

    public CompletableResultCode shutdown() {
        if (this.sharedState.hasBeenShutdown()) {
            LOGGER.log(Level.INFO, "Calling shutdown() multiple times.");
            return CompletableResultCode.ofSuccess();
        }
        return this.sharedState.shutdown();
    }

    @Override
    public void close() {
        this.shutdown().join(10L, TimeUnit.SECONDS);
    }

    public String toString() {
        return "SdkLoggerProvider{clock=" + this.sharedState.getClock() + ", resource=" + this.sharedState.getResource() + ", logLimits=" + this.sharedState.getLogLimits() + ", logRecordProcessor=" + this.sharedState.getLogRecordProcessor() + '}';
    }
}

