/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui.perspective.configuration.tabs;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.config.HopConfig;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.gui.plugin.tab.GuiTab;
import org.apache.hop.core.variables.DescribedVariable;
import org.apache.hop.core.variables.Variables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

@GuiPlugin
public class ConfigVariablesTab {
    private static final Class<?> PKG = BaseDialog.class;
    private TableView wFields;

    @GuiTab(id="10200-config-perspective-variables-tab", parentId="ConfigurationPerspective.Tabs.ID", description="System variables")
    public void addConfigVariablesTab(CTabFolder wTabFolder) {
        int margin = PropsUi.getMargin();
        CTabItem wVarsTab = new CTabItem(wTabFolder, 0);
        wVarsTab.setFont(GuiResource.getInstance().getFontDefault());
        wVarsTab.setText(BaseMessages.getString(PKG, (String)"HopSystemVariablesDialog.Title", (String[])new String[0]));
        wVarsTab.setImage(GuiResource.getInstance().getImageVariable());
        Composite wVarsTabComp = new Composite((Composite)wTabFolder, 0);
        PropsUi.setLook((Widget)wVarsTabComp);
        FormLayout varsCompLayout = new FormLayout();
        varsCompLayout.marginWidth = PropsUi.getFormMargin();
        varsCompLayout.marginHeight = PropsUi.getFormMargin();
        wVarsTabComp.setLayout((Layout)varsCompLayout);
        Button wbSave = new Button(wVarsTabComp, 8);
        wbSave.setText(BaseMessages.getString(PKG, (String)"System.Button.Save", (String[])new String[0]));
        PropsUi.setLook((Widget)wbSave);
        wbSave.addListener(13, this::save);
        BaseTransformDialog.positionBottomButtons(wVarsTabComp, new Button[]{wbSave}, margin, null);
        ColumnInfo[] columns = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"HopPropertiesFileDialog.Name.Label", (String[])new String[0]), 1, false, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"HopPropertiesFileDialog.Value.Label", (String[])new String[0]), 1, false, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"HopPropertiesFileDialog.Description.Label", (String[])new String[0]), 1, false, false)};
        columns[2].setDisabledListener(rowNr -> false);
        this.wFields = new TableView(Variables.getADefaultVariableSpace(), wVarsTabComp, 68354, columns, 0, null, PropsUi.getInstance());
        this.wFields.setReadonly(false);
        FormData fdFields = new FormData();
        fdFields.left = new FormAttachment(0, 0);
        fdFields.top = new FormAttachment(0, 0);
        fdFields.right = new FormAttachment(100, 0);
        fdFields.bottom = new FormAttachment((Control)wbSave, -2 * margin);
        this.wFields.setLayoutData(fdFields);
        List describedVariables = HopConfig.getInstance().getDescribedVariables();
        for (DescribedVariable describedVariable : describedVariables) {
            TableItem item = new TableItem(this.wFields.table, 0);
            int col = 1;
            item.setText(col++, Const.NVL((String)describedVariable.getName(), (String)""));
            item.setText(col++, Const.NVL((String)describedVariable.getValue(), (String)""));
            item.setText(col, Const.NVL((String)describedVariable.getDescription(), (String)""));
        }
        this.wFields.optimizeTableView();
        wVarsTab.setControl((Control)wVarsTabComp);
    }

    private void save(Event event) {
        try {
            ArrayList<DescribedVariable> variables = new ArrayList<DescribedVariable>();
            for (int i = 0; i < this.wFields.nrNonEmpty(); ++i) {
                TableItem item = this.wFields.getNonEmpty(i);
                String name = item.getText(1);
                String value = item.getText(2);
                String description = item.getText(3);
                variables.add(new DescribedVariable(name, value, description));
            }
            HopConfig.getInstance().setDescribedVariables(variables);
            HopConfig.getInstance().saveToFile();
        }
        catch (Exception e) {
            new ErrorDialog(HopGui.getInstance().getShell(), "Error", "Error saving described variables to the Hop configuration file: " + HopConfig.getInstance().getConfigFilename(), e);
        }
    }

    private void saveValues() {
        try {
            HopConfig.getInstance().saveToFile();
        }
        catch (Exception e) {
            new ErrorDialog(HopGui.getInstance().getShell(), "Error", "Error saving configuration to file", e);
        }
    }
}

