/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.row;

import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class JsonRowMeta {
    public static String toJson(IRowMeta rowMeta) {
        try {
            JSONObject jRowMeta = new JSONObject();
            JSONArray jValues = new JSONArray();
            jRowMeta.put((Object)"values", (Object)jValues);
            for (int v = 0; v < rowMeta.size(); ++v) {
                IValueMeta valueMeta = rowMeta.getValueMeta(v);
                JSONObject jValue = new JSONObject();
                valueMeta.storeMetaInJson(jValue);
                jValues.add((Object)jValue);
            }
            return jRowMeta.toJSONString();
        }
        catch (Exception e) {
            throw new RuntimeException("Error converting row metadata to JSON", e);
        }
    }

    public static IRowMeta fromJson(String rowMetaJson) {
        try {
            JSONParser parser = new JSONParser();
            JSONObject jRowMeta = (JSONObject)parser.parse(rowMetaJson);
            RowMeta rowMeta = new RowMeta();
            JSONArray jValues = (JSONArray)jRowMeta.get((Object)"values");
            for (Object value : jValues) {
                JSONObject jValue = (JSONObject)value;
                IValueMeta valueMeta = ValueMetaFactory.loadValueMetaFromJson(jValue);
                rowMeta.addValueMeta(valueMeta);
            }
            return rowMeta;
        }
        catch (Exception e) {
            throw new RuntimeException("Error converting row metadata JSON to row metadata", e);
        }
    }
}

