/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.translation;

import java.io.Closeable;
import java.io.IOException;
import org.apache.beam.runners.core.DoFnRunner;
import org.apache.beam.runners.spark.metrics.MetricsContainerStepMapAccumulator;
import org.apache.beam.sdk.metrics.MetricsContainer;
import org.apache.beam.sdk.metrics.MetricsEnvironment;
import org.apache.beam.sdk.state.TimeDomain;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.WindowedValue;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;

public class DoFnRunnerWithMetrics<@UnknownKeyFor InputT, @UnknownKeyFor OutputT>
implements DoFnRunner<InputT, OutputT> {
    private final @UnknownKeyFor @NonNull @Initialized DoFnRunner<InputT, OutputT> delegate;
    private final @UnknownKeyFor @NonNull @Initialized String stepName;
    private final @UnknownKeyFor @NonNull @Initialized MetricsContainerStepMapAccumulator metricsAccum;

    public DoFnRunnerWithMetrics(@UnknownKeyFor @NonNull @Initialized String stepName, @UnknownKeyFor @NonNull @Initialized DoFnRunner<InputT, OutputT> delegate, @UnknownKeyFor @NonNull @Initialized MetricsContainerStepMapAccumulator metricsAccum) {
        this.delegate = delegate;
        this.stepName = stepName;
        this.metricsAccum = metricsAccum;
    }

    public @UnknownKeyFor @NonNull @Initialized DoFn<InputT, OutputT> getFn() {
        return this.delegate.getFn();
    }

    public void startBundle() {
        try (Closeable ignored = MetricsEnvironment.scopedMetricsContainer((MetricsContainer)this.metricsContainer());){
            this.delegate.startBundle();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void processElement(@UnknownKeyFor @NonNull @Initialized WindowedValue<InputT> elem) {
        try (Closeable ignored = MetricsEnvironment.scopedMetricsContainer((MetricsContainer)this.metricsContainer());){
            this.delegate.processElement(elem);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public <KeyT> void onTimer(@UnknownKeyFor @NonNull @Initialized String timerId, @UnknownKeyFor @NonNull @Initialized String timerFamilyId, KeyT key, @UnknownKeyFor @NonNull @Initialized BoundedWindow window, @UnknownKeyFor @NonNull @Initialized Instant timestamp, @UnknownKeyFor @NonNull @Initialized Instant outputTimestamp, @UnknownKeyFor @NonNull @Initialized TimeDomain timeDomain) {
        try (Closeable ignored = MetricsEnvironment.scopedMetricsContainer((MetricsContainer)this.metricsContainer());){
            this.delegate.onTimer(timerId, timerFamilyId, key, window, timestamp, outputTimestamp, timeDomain);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void finishBundle() {
        try (Closeable ignored = MetricsEnvironment.scopedMetricsContainer((MetricsContainer)this.metricsContainer());){
            this.delegate.finishBundle();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public <KeyT> void onWindowExpiration(@UnknownKeyFor @NonNull @Initialized BoundedWindow window, @UnknownKeyFor @NonNull @Initialized Instant timestamp, KeyT key) {
        this.delegate.onWindowExpiration(window, timestamp, key);
    }

    private @UnknownKeyFor @NonNull @Initialized MetricsContainer metricsContainer() {
        return this.metricsAccum.value().getContainer(this.stepName);
    }
}

