/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.translation;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.beam.runners.core.InMemoryStateInternals;
import org.apache.beam.runners.core.StateInternals;
import org.apache.beam.runners.core.StateInternalsFactory;
import org.apache.beam.runners.core.construction.SerializablePipelineOptions;
import org.apache.beam.runners.spark.SparkPipelineOptions;
import org.apache.beam.runners.spark.SparkRunner;
import org.apache.beam.runners.spark.coders.CoderHelpers;
import org.apache.beam.runners.spark.translation.EvaluationContext;
import org.apache.beam.runners.spark.translation.SparkCombineFn;
import org.apache.beam.runners.spark.translation.SparkPCollectionView;
import org.apache.beam.runners.spark.translation.ValueAndCoderLazySerializable;
import org.apache.beam.runners.spark.util.ByteArray;
import org.apache.beam.runners.spark.util.SideInputBroadcast;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.transforms.CombineWithContext;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.reflect.DoFnSignature;
import org.apache.beam.sdk.transforms.reflect.DoFnSignatures;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindows;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterators;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Maps;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.PairFlatMapFunction;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.api.java.function.VoidFunction;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.api.java.JavaDStream;
import org.apache.spark.streaming.api.java.JavaPairDStream;
import org.apache.spark.streaming.dstream.DStream;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;
import scala.Tuple2;

public final class TranslationUtils {
    private TranslationUtils() {
    }

    public static <T, W extends BoundedWindow> @UnknownKeyFor @NonNull @Initialized boolean skipAssignWindows(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Window.Assign<T> transform, @UnknownKeyFor @NonNull @Initialized EvaluationContext context) {
        WindowFn windowFn = transform.getWindowFn();
        return windowFn == null || ((PCollection)context.getInput(transform)).getWindowingStrategy().getWindowFn() instanceof GlobalWindows && windowFn instanceof GlobalWindows;
    }

    public static <T1, T2> @UnknownKeyFor @NonNull @Initialized JavaDStream<T2> dStreamValues(@UnknownKeyFor @NonNull @Initialized JavaPairDStream<T1, T2> pairDStream) {
        return pairDStream.map(Tuple2::_2);
    }

    public static <K, V> @UnknownKeyFor @NonNull @Initialized PairFunction<@UnknownKeyFor @NonNull @Initialized KV<K, V>, K, V> toPairFunction() {
        return (PairFunction & Serializable)kv -> new Tuple2(kv.getKey(), kv.getValue());
    }

    public static <K, V> @UnknownKeyFor @NonNull @Initialized PairFlatMapFunction<@UnknownKeyFor @NonNull @Initialized Iterator<@UnknownKeyFor @NonNull @Initialized KV<K, V>>, K, V> toPairFlatMapFunction() {
        return (PairFlatMapFunction & Serializable)itr -> Iterators.transform((Iterator)itr, kv -> new Tuple2(kv.getKey(), kv.getValue()));
    }

    static <K, V> @UnknownKeyFor @NonNull @Initialized FlatMapFunction<@UnknownKeyFor @NonNull @Initialized Iterator<@UnknownKeyFor @NonNull @Initialized Tuple2<K, V>>, @UnknownKeyFor @NonNull @Initialized KV<K, V>> fromPairFlatMapFunction() {
        return (FlatMapFunction & Serializable)itr -> Iterators.transform((Iterator)itr, t2 -> KV.of((Object)t2._1(), (Object)t2._2()));
    }

    public static <K, V> @UnknownKeyFor @NonNull @Initialized PairFunction<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized KV<K, V>>, @UnknownKeyFor @NonNull @Initialized ByteArray, @UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized KV<K, V>>> toPairByKeyInWindowedValue(@UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder) {
        return (PairFunction & Serializable)windowedKv -> new Tuple2((Object)new ByteArray(CoderHelpers.toByteArray(((KV)windowedKv.getValue()).getKey(), keyCoder)), windowedKv);
    }

    static /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized SideInputBroadcast<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>>> getSideInputs(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> views, @UnknownKeyFor @NonNull @Initialized EvaluationContext context) {
        return TranslationUtils.getSideInputs(views, context.getSparkContext(), context.getPViews());
    }

    public static /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized SideInputBroadcast<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>>> getSideInputs(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> views, @UnknownKeyFor @NonNull @Initialized JavaSparkContext context, @UnknownKeyFor @NonNull @Initialized SparkPCollectionView pviews) {
        if (views == null) {
            return ImmutableMap.of();
        }
        HashMap sideInputs = Maps.newHashMap();
        for (PCollectionView<?> view : views) {
            SideInputBroadcast helper = pviews.getPCollectionView(view, context);
            WindowingStrategy windowingStrategy = view.getWindowingStrategyInternal();
            sideInputs.put(view.getTagInternal(), KV.of((Object)windowingStrategy, (Object)helper));
        }
        return sideInputs;
    }

    public static @UnknownKeyFor @NonNull @Initialized Long getBatchDuration(@UnknownKeyFor @NonNull @Initialized SerializablePipelineOptions options) {
        return ((SparkPipelineOptions)options.get().as(SparkPipelineOptions.class)).getCheckpointDurationMillis();
    }

    public static void rejectTimers(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized DoFn<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> doFn) {
        DoFnSignature signature = DoFnSignatures.getSignature(doFn.getClass());
        if (signature.timerDeclarations().size() > 0 || signature.timerFamilyDeclarations().size() > 0) {
            throw new UnsupportedOperationException(String.format("Found %s annotations on %s, but %s cannot yet be used with timers in the %s.", DoFn.TimerId.class.getSimpleName(), doFn.getClass().getName(), DoFn.class.getSimpleName(), SparkRunner.class.getSimpleName()));
        }
    }

    public static void checkpointIfNeeded(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized DStream<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> dStream, @UnknownKeyFor @NonNull @Initialized SerializablePipelineOptions options) {
        Long checkpointDurationMillis = TranslationUtils.getBatchDuration(options);
        if (checkpointDurationMillis > 0L) {
            dStream.checkpoint(new Duration(checkpointDurationMillis.longValue()));
        }
    }

    public static void rejectStateAndTimers(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized DoFn<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> doFn) {
        DoFnSignature signature = DoFnSignatures.getSignature(doFn.getClass());
        if (signature.stateDeclarations().size() > 0) {
            throw new UnsupportedOperationException(String.format("Found %s annotations on %s, but %s cannot yet be used with state in the %s.", DoFn.StateId.class.getSimpleName(), doFn.getClass().getName(), DoFn.class.getSimpleName(), SparkRunner.class.getSimpleName()));
        }
        if (signature.timerDeclarations().size() > 0 || signature.timerFamilyDeclarations().size() > 0) {
            throw new UnsupportedOperationException(String.format("Found %s annotations on %s, but %s cannot yet be used with timers in the %s.", DoFn.TimerId.class.getSimpleName(), doFn.getClass().getName(), DoFn.class.getSimpleName(), SparkRunner.class.getSimpleName()));
        }
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized VoidFunction<T> emptyVoidFunction() {
        return (VoidFunction & Serializable)t -> {};
    }

    public static <T, K, V> @UnknownKeyFor @NonNull @Initialized PairFlatMapFunction<@UnknownKeyFor @NonNull @Initialized Iterator<T>, K, V> pairFunctionToPairFlatMapFunction(@UnknownKeyFor @NonNull @Initialized PairFunction<T, K, V> pairFunction) {
        return (PairFlatMapFunction & Serializable)itr -> Iterators.transform((Iterator)itr, t -> {
            try {
                return pairFunction.call(t);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    public static <InputT, OutputT> @UnknownKeyFor @NonNull @Initialized FlatMapFunction<@UnknownKeyFor @NonNull @Initialized Iterator<InputT>, OutputT> functionToFlatMapFunction(@UnknownKeyFor @NonNull @Initialized Function<InputT, OutputT> func) {
        return (FlatMapFunction & Serializable)itr -> Iterators.transform((Iterator)itr, t -> {
            try {
                return func.call(t);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    public static /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>>> getTupleTagCoders(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> outputs) {
        HashMap coderMap = new HashMap(outputs.size());
        for (Map.Entry<TupleTag<?>, PCollection<?>> output : outputs.entrySet()) {
            PCollection<?> pCollection = output.getValue();
            Coder coder = pCollection.getCoder();
            Coder wCoder = pCollection.getWindowingStrategy().getWindowFn().windowCoder();
            WindowedValue.FullWindowedValueCoder windowedValueCoder = WindowedValue.getFullCoder((Coder)coder, (Coder)wCoder);
            coderMap.put(output.getKey(), (Coder<WindowedValue<?>>)windowedValueCoder);
        }
        return coderMap;
    }

    public static /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized PairFunction<@UnknownKeyFor @NonNull @Initialized Tuple2<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>>, @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized ValueAndCoderLazySerializable<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>>> getTupleTagEncodeFunction(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>>> coderMap) {
        return (PairFunction & Serializable)tuple2 -> {
            TupleTag tupleTag = (TupleTag)tuple2._1;
            WindowedValue windowedValue = (WindowedValue)tuple2._2;
            return new Tuple2((Object)tupleTag, ValueAndCoderLazySerializable.of(windowedValue, (Coder)coderMap.get(tupleTag)));
        };
    }

    public static /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized PairFunction<@UnknownKeyFor @NonNull @Initialized Tuple2<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized ValueAndCoderLazySerializable<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>>>, @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getTupleTagDecodeFunction(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>>> coderMap) {
        return (PairFunction & Serializable)tuple2 -> {
            TupleTag tupleTag = (TupleTag)tuple2._1;
            ValueAndCoderLazySerializable windowedByteValue = (ValueAndCoderLazySerializable)tuple2._2;
            return new Tuple2((Object)tupleTag, (Object)((WindowedValue)windowedByteValue.getOrDecode((Coder)coderMap.get(tupleTag))));
        };
    }

    static @UnknownKeyFor @NonNull @Initialized boolean canAvoidRddSerialization(@UnknownKeyFor @NonNull @Initialized StorageLevel level) {
        return level.equals((Object)StorageLevel.MEMORY_ONLY());
    }

    public static final class TupleTagFilter<@UnknownKeyFor V>
    implements Function<Tuple2<TupleTag<V>, WindowedValue<?>>, Boolean> {
        private final @UnknownKeyFor @NonNull @Initialized TupleTag<V> tag;

        public TupleTagFilter(@UnknownKeyFor @NonNull @Initialized TupleTag<V> tag) {
            this.tag = tag;
        }

        public @UnknownKeyFor @NonNull @Initialized Boolean call(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Tuple2<@UnknownKeyFor @NonNull @Initialized TupleTag<V>, @UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> input) {
            return this.tag.equals(input._1());
        }
    }

    static class ToKVByWindowInValueFunction<@UnknownKeyFor K, @UnknownKeyFor V>
    implements Function<KV<K, WindowedValue<V>>, WindowedValue<KV<K, V>>>,
    org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Function<KV<K, WindowedValue<V>>, WindowedValue<KV<K, V>>> {
        ToKVByWindowInValueFunction() {
        }

        public @UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized KV<K, V>> call(@UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized WindowedValue<V>> kv) {
            WindowedValue wv = (WindowedValue)kv.getValue();
            return wv.withValue((Object)KV.of((Object)kv.getKey(), (Object)wv.getValue()));
        }

        @SuppressFBWarnings(value={"NP_METHOD_PARAMETER_TIGHTENS_ANNOTATION"}, justification="https://github.com/google/guava/issues/920")
        public @UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized KV<K, V>> apply(@Nonnull @UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized WindowedValue<V>> kv) {
            return this.call(kv);
        }
    }

    static class FromPairFunction<@UnknownKeyFor K, @UnknownKeyFor V>
    implements Function<Tuple2<K, V>, KV<K, V>>,
    org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Function<Tuple2<K, V>, KV<K, V>> {
        FromPairFunction() {
        }

        public @UnknownKeyFor @NonNull @Initialized KV<K, V> call(@UnknownKeyFor @NonNull @Initialized Tuple2<K, V> t2) {
            return KV.of((Object)t2._1(), (Object)t2._2());
        }

        @SuppressFBWarnings(value={"NP_METHOD_PARAMETER_TIGHTENS_ANNOTATION"}, justification="https://github.com/google/guava/issues/920")
        public @UnknownKeyFor @NonNull @Initialized KV<K, V> apply(@Nonnull @UnknownKeyFor @NonNull @Initialized Tuple2<K, V> t2) {
            return this.call(t2);
        }
    }

    public static class CombineGroupedValues<@UnknownKeyFor K, @UnknownKeyFor InputT, @UnknownKeyFor OutputT>
    implements Function<WindowedValue<KV<K, Iterable<InputT>>>, WindowedValue<KV<K, OutputT>>> {
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized SparkCombineFn<@UnknownKeyFor @NonNull @Initialized KV<K, InputT>, InputT, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, OutputT> fn;

        public CombineGroupedValues(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized SparkCombineFn<@UnknownKeyFor @NonNull @Initialized KV<K, InputT>, InputT, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, OutputT> fn) {
            this.fn = fn;
        }

        public @UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized KV<K, OutputT>> call(@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized Iterable<InputT>>> windowedKv) throws @UnknownKeyFor @NonNull @Initialized Exception {
            return WindowedValue.of((Object)KV.of((Object)((KV)windowedKv.getValue()).getKey(), (Object)this.fn.getCombineFn().apply((Iterable)((KV)windowedKv.getValue()).getValue(), (CombineWithContext.Context)this.fn.ctxtForValue(windowedKv))), (Instant)windowedKv.getTimestamp(), (Collection)windowedKv.getWindows(), (PaneInfo)windowedKv.getPane());
        }
    }

    static class InMemoryStateInternalsFactory<@UnknownKeyFor K>
    implements StateInternalsFactory<K>,
    Serializable {
        InMemoryStateInternalsFactory() {
        }

        public @UnknownKeyFor @NonNull @Initialized StateInternals stateInternalsForKey(K key) {
            return InMemoryStateInternals.forKey(key);
        }
    }
}

