/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.setvariables;

import java.util.ArrayList;
import org.apache.hop.core.Const;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.workflow.action.ActionDialog;
import org.apache.hop.ui.workflow.dialog.WorkflowDialog;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.actions.setvariables.ActionSetVariables;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ActionSetVariablesDialog
extends ActionDialog {
    private static final Class<?> PKG = ActionSetVariables.class;
    private Text wName;
    private Button wVarSubs;
    private ActionSetVariables action;
    private TableView wFields;
    private TextVar wFilename;
    private CCombo wFileVariableType;
    private boolean changed;

    public ActionSetVariablesDialog(Shell parent, ActionSetVariables action, WorkflowMeta workflowMeta, IVariables variables) {
        super(parent, workflowMeta, variables);
        this.action = action;
        if (this.action.getName() == null) {
            this.action.setName(BaseMessages.getString(PKG, (String)"ActionSetVariables.Name.Default", (String[])new String[0]));
        }
    }

    public IAction open() {
        int rows;
        this.shell = new Shell(this.getParent(), 3312);
        PropsUi.setLook((Widget)this.shell);
        WorkflowDialog.setShellImage((Shell)this.shell, (IAction)this.action);
        ModifyListener lsMod = e -> this.action.setChanged();
        this.changed = this.action.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"ActionSetVariables.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        Button wOk = new Button((Composite)this.shell, 8);
        wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        wOk.addListener(13, e -> this.ok());
        Button wCancel = new Button((Composite)this.shell, 8);
        wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        wCancel.addListener(13, e -> this.cancel());
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, (Button[])new Button[]{wOk, wCancel}, (int)margin, null);
        Label wlName = new Label((Composite)this.shell, 131072);
        wlName.setText(BaseMessages.getString(PKG, (String)"ActionSetVariables.Name.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlName);
        FormData fdlName = new FormData();
        fdlName.left = new FormAttachment(0, 0);
        fdlName.right = new FormAttachment(middle, -margin);
        fdlName.top = new FormAttachment(0, margin);
        wlName.setLayoutData((Object)fdlName);
        this.wName = new Text((Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wName);
        this.wName.addModifyListener(lsMod);
        FormData fdName = new FormData();
        fdName.left = new FormAttachment(middle, 0);
        fdName.top = new FormAttachment(0, margin);
        fdName.right = new FormAttachment(100, 0);
        this.wName.setLayoutData((Object)fdName);
        Group gFilename = new Group((Composite)this.shell, 32);
        PropsUi.setLook((Widget)gFilename);
        gFilename.setText(BaseMessages.getString(PKG, (String)"ActionSetVariables.FilenameGroup.Label", (String[])new String[0]));
        FormLayout groupFilenameLayout = new FormLayout();
        groupFilenameLayout.marginWidth = 10;
        groupFilenameLayout.marginHeight = 10;
        gFilename.setLayout((Layout)groupFilenameLayout);
        Label wlFilename = new Label((Composite)gFilename, 131072);
        wlFilename.setText(BaseMessages.getString(PKG, (String)"ActionSetVariables.Filename.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFilename);
        FormData fdlFilename = new FormData();
        fdlFilename.left = new FormAttachment(0, 0);
        fdlFilename.right = new FormAttachment(middle, -margin);
        fdlFilename.top = new FormAttachment(0, margin);
        wlFilename.setLayoutData((Object)fdlFilename);
        this.wFilename = new TextVar(this.variables, (Composite)gFilename, 18436);
        PropsUi.setLook((Widget)this.wFilename);
        this.wFilename.addModifyListener(lsMod);
        FormData fdFilename = new FormData();
        fdFilename.left = new FormAttachment(middle, 0);
        fdFilename.top = new FormAttachment(0, margin);
        fdFilename.right = new FormAttachment(100, 0);
        this.wFilename.setLayoutData((Object)fdFilename);
        Label wlFileVariableType = new Label((Composite)gFilename, 131072);
        wlFileVariableType.setText(BaseMessages.getString(PKG, (String)"ActionSetVariables.FileVariableType.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFileVariableType);
        FormData fdlFileVariableType = new FormData();
        fdlFileVariableType.left = new FormAttachment(0, 0);
        fdlFileVariableType.right = new FormAttachment(middle, -margin);
        fdlFileVariableType.top = new FormAttachment((Control)this.wFilename, margin);
        wlFileVariableType.setLayoutData((Object)fdlFileVariableType);
        this.wFileVariableType = new CCombo((Composite)gFilename, 18444);
        PropsUi.setLook((Widget)this.wFileVariableType);
        this.wFileVariableType.addModifyListener(lsMod);
        FormData fdFileVariableType = new FormData();
        fdFileVariableType.left = new FormAttachment(middle, 0);
        fdFileVariableType.top = new FormAttachment((Control)this.wFilename, margin);
        fdFileVariableType.right = new FormAttachment(100, 0);
        this.wFileVariableType.setLayoutData((Object)fdFileVariableType);
        this.wFileVariableType.setItems(ActionSetVariables.VariableType.getDescriptions());
        FormData fdgFilename = new FormData();
        fdgFilename.left = new FormAttachment(0, margin);
        fdgFilename.top = new FormAttachment((Control)this.wName, margin);
        fdgFilename.right = new FormAttachment(100, -margin);
        gFilename.setLayoutData((Object)fdgFilename);
        Group gSettings = new Group((Composite)this.shell, 32);
        PropsUi.setLook((Widget)gSettings);
        gSettings.setText(BaseMessages.getString(PKG, (String)"ActionSetVariables.Settings.Label", (String[])new String[0]));
        FormLayout groupLayout = new FormLayout();
        groupLayout.marginWidth = 10;
        groupLayout.marginHeight = 10;
        gSettings.setLayout((Layout)groupLayout);
        Label wlVarSubs = new Label((Composite)gSettings, 131072);
        wlVarSubs.setText(BaseMessages.getString(PKG, (String)"ActionSetVariables.VarsReplace.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlVarSubs);
        FormData fdlVarSubs = new FormData();
        fdlVarSubs.left = new FormAttachment(0, 0);
        fdlVarSubs.top = new FormAttachment((Control)this.wName, margin);
        fdlVarSubs.right = new FormAttachment(middle, -margin);
        wlVarSubs.setLayoutData((Object)fdlVarSubs);
        this.wVarSubs = new Button((Composite)gSettings, 32);
        PropsUi.setLook((Widget)this.wVarSubs);
        this.wVarSubs.setToolTipText(BaseMessages.getString(PKG, (String)"ActionSetVariables.VarsReplace.Tooltip", (String[])new String[0]));
        FormData fdVarSubs = new FormData();
        fdVarSubs.left = new FormAttachment(middle, 0);
        fdVarSubs.top = new FormAttachment((Control)wlVarSubs, 0, 0x1000000);
        fdVarSubs.right = new FormAttachment(100, 0);
        this.wVarSubs.setLayoutData((Object)fdVarSubs);
        this.wVarSubs.addListener(13, e -> this.action.setChanged());
        FormData fdgSettings = new FormData();
        fdgSettings.left = new FormAttachment(0, margin);
        fdgSettings.top = new FormAttachment((Control)gFilename, margin);
        fdgSettings.right = new FormAttachment(100, -margin);
        gSettings.setLayoutData((Object)fdgSettings);
        Label wlFields = new Label((Composite)this.shell, 0);
        wlFields.setText(BaseMessages.getString(PKG, (String)"ActionSetVariables.Variables.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFields);
        FormData fdlFields = new FormData();
        fdlFields.left = new FormAttachment(0, 0);
        fdlFields.top = new FormAttachment((Control)gSettings, margin);
        wlFields.setLayoutData((Object)fdlFields);
        int FieldsRows = rows = this.action.getVariableDefinitions().size();
        ColumnInfo[] colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"ActionSetVariables.Fields.Column.VariableName", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"ActionSetVariables.Fields.Column.Value", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"ActionSetVariables.Fields.Column.VariableType", (String[])new String[0]), 2, ActionSetVariables.VariableType.getDescriptions(), false)};
        colinf[0].setUsingVariables(true);
        colinf[1].setUsingVariables(true);
        this.wFields = new TableView(this.variables, (Composite)this.shell, 67586, colinf, FieldsRows, lsMod, this.props);
        FormData fdFields = new FormData();
        fdFields.left = new FormAttachment(0, 0);
        fdFields.top = new FormAttachment((Control)wlFields, margin);
        fdFields.right = new FormAttachment(100, 0);
        fdFields.bottom = new FormAttachment((Control)wOk, -2 * margin);
        this.wFields.setLayoutData((Object)fdFields);
        this.getData();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.action;
    }

    public void getData() {
        this.wName.setText(Const.nullToEmpty((String)this.action.getName()));
        this.wFilename.setText(Const.NVL((String)this.action.getFilename(), (String)""));
        this.wFileVariableType.setText(this.action.getFileVariableType().getDescription());
        this.wVarSubs.setSelection(this.action.isReplaceVars());
        if (this.action.getVariableDefinitions() != null) {
            int i = 0;
            for (ActionSetVariables.VariableDefinition definition : this.action.getVariableDefinitions()) {
                TableItem item = this.wFields.table.getItem(i++);
                item.setText(1, Const.nullToEmpty((String)definition.getName()));
                item.setText(2, Const.nullToEmpty((String)definition.getValue()));
                item.setText(3, definition.getType().getDescription());
            }
            this.wFields.setRowNums();
            this.wFields.optWidth(true);
        }
        this.wName.selectAll();
        this.wName.setFocus();
    }

    private void cancel() {
        this.action.setChanged(this.changed);
        this.action = null;
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wName.getText())) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setText(BaseMessages.getString(PKG, (String)"System.TransformActionNameMissing.Title", (String[])new String[0]));
            mb.setMessage(BaseMessages.getString(PKG, (String)"System.ActionNameMissing.Msg", (String[])new String[0]));
            mb.open();
            return;
        }
        this.action.setName(this.wName.getText());
        this.action.setFilename(this.wFilename.getText());
        this.action.setFileVariableType(ActionSetVariables.VariableType.lookupDescription(this.wFileVariableType.getText()));
        this.action.setReplaceVars(this.wVarSubs.getSelection());
        int nrItems = this.wFields.nrNonEmpty();
        ArrayList<ActionSetVariables.VariableDefinition> list = new ArrayList<ActionSetVariables.VariableDefinition>();
        for (int i = 0; i < nrItems; ++i) {
            String name = this.wFields.getNonEmpty(i).getText(1);
            if (name == null || name.length() == 0) continue;
            String value = this.wFields.getNonEmpty(i).getText(2);
            ActionSetVariables.VariableType scope = ActionSetVariables.VariableType.lookupDescription(this.wFields.getNonEmpty(i).getText(3));
            list.add(new ActionSetVariables.VariableDefinition(name, value, scope));
        }
        this.action.setVariableDefinitions(list);
        this.dispose();
    }
}

