/*
 * Decompiled with CFR 0.152.
 */
package com.sforce.ws.transport;

import com.sforce.ws.ConnectorConfig;
import com.sforce.ws.MessageHandler;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Iterator;

public class MessageHandlerOutputStream
extends OutputStream {
    private final ByteArrayOutputStream bout = new ByteArrayOutputStream();
    private final OutputStream output;
    private final URL url;
    private final ConnectorConfig config;

    public MessageHandlerOutputStream(ConnectorConfig config, URL url, OutputStream output) {
        this.url = url;
        this.output = output;
        this.config = config;
    }

    @Override
    public void write(int b) throws IOException {
        this.bout.write((char)b);
        this.output.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.bout.write(b);
        this.output.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.bout.write(b, off, len);
        this.output.write(b, off, len);
    }

    @Override
    public void close() throws IOException {
        this.bout.close();
        this.output.close();
        Iterator<MessageHandler> it = this.config.getMessagerHandlers();
        while (it.hasNext()) {
            MessageHandler handler = it.next();
            handler.handleRequest(this.url, this.bout.toByteArray());
        }
    }
}

