/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct;

import org.apache.beam.runners.direct.DoFnLifecycleManager;
import org.apache.beam.runners.direct.ParDoEvaluator;
import org.apache.beam.runners.direct.TransformEvaluator;
import org.apache.beam.runners.direct.TransformResult;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.WindowedValue;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DoFnLifecycleManagerRemovingTransformEvaluator<@UnknownKeyFor InputT>
implements TransformEvaluator<InputT> {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(DoFnLifecycleManagerRemovingTransformEvaluator.class);
    private final @UnknownKeyFor @NonNull @Initialized ParDoEvaluator<InputT> underlying;
    private final @UnknownKeyFor @NonNull @Initialized DoFnLifecycleManager lifecycleManager;

    public static <InputT> @UnknownKeyFor @NonNull @Initialized DoFnLifecycleManagerRemovingTransformEvaluator<InputT> wrapping(@UnknownKeyFor @NonNull @Initialized ParDoEvaluator<InputT> underlying, @UnknownKeyFor @NonNull @Initialized DoFnLifecycleManager lifecycleManager) {
        return new DoFnLifecycleManagerRemovingTransformEvaluator<InputT>(underlying, lifecycleManager);
    }

    private DoFnLifecycleManagerRemovingTransformEvaluator(@UnknownKeyFor @NonNull @Initialized ParDoEvaluator<InputT> underlying, @UnknownKeyFor @NonNull @Initialized DoFnLifecycleManager lifecycleManager) {
        this.underlying = underlying;
        this.lifecycleManager = lifecycleManager;
    }

    public @UnknownKeyFor @NonNull @Initialized ParDoEvaluator<InputT> getParDoEvaluator() {
        return this.underlying;
    }

    @Override
    public void processElement(@UnknownKeyFor @NonNull @Initialized WindowedValue<InputT> element) throws @UnknownKeyFor @NonNull @Initialized Exception {
        try {
            this.underlying.processElement(element);
        }
        catch (Exception e) {
            this.onException(e, "Exception encountered while cleaning up after processing an element");
            throw e;
        }
    }

    public <KeyT> void onTimer( @UnknownKeyFor @NonNull @Initialized TimerInternals.TimerData timer, KeyT key, @UnknownKeyFor @NonNull @Initialized BoundedWindow window) throws @UnknownKeyFor @NonNull @Initialized Exception {
        try {
            this.underlying.onTimer(timer, key, window);
        }
        catch (Exception e) {
            this.onException(e, "Exception encountered while cleaning up after processing a timer");
            throw e;
        }
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized TransformResult<InputT> finishBundle() throws @UnknownKeyFor @NonNull @Initialized Exception {
        try {
            return this.underlying.finishBundle();
        }
        catch (Exception e) {
            this.onException(e, "Exception encountered while cleaning up after finishing a bundle");
            throw e;
        }
    }

    private void onException(@UnknownKeyFor @NonNull @Initialized Exception e, @UnknownKeyFor @NonNull @Initialized String msg) {
        try {
            this.lifecycleManager.remove();
        }
        catch (Exception removalException) {
            if (removalException instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            LOG.error(msg, (Throwable)removalException);
            e.addSuppressed(removalException);
        }
    }
}

