/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.abort;

import java.util.List;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.Result;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.validator.ActionValidatorUtils;

@Action(id="ABORT", name="i18n::ActionAbort.Name", description="i18n::ActionAbort.Description", image="Abort.svg", categoryDescription="i18n:org.apache.hop.workflow:ActionCategory.Category.Utility", keywords={"i18n::ActionAbort.keyword"}, documentationUrl="/workflow/actions/abort.html")
public class ActionAbort
extends ActionBase
implements Cloneable,
IAction {
    private static final Class<?> PKG = ActionAbort.class;
    @HopMetadataProperty(key="message")
    private String messageAbort;
    @HopMetadataProperty(key="always_log_rows")
    private boolean alwaysLogRows;

    public ActionAbort(String name, String description) {
        super(name, description);
        this.messageAbort = null;
    }

    public ActionAbort() {
        this("", "");
    }

    public ActionAbort(ActionAbort other) {
        super(other.getName(), other.getDescription(), other.getPluginId());
        this.messageAbort = other.messageAbort;
        this.alwaysLogRows = other.alwaysLogRows;
    }

    public Object clone() {
        return new ActionAbort(this);
    }

    public Result execute(Result result, int nr) {
        try {
            String msg = this.resolve(this.getMessageAbort());
            if (msg == null) {
                msg = BaseMessages.getString(PKG, (String)"ActionAbort.Meta.CheckResult.Label", (String[])new String[0]);
            }
            if (this.isAlwaysLogRows()) {
                this.logMinimal(BaseMessages.getString(PKG, (String)"ActionAbort.Log.Wrote.Row", (Object[])new Object[]{nr, msg}));
            } else {
                this.logError(BaseMessages.getString(PKG, (String)"ActionAbort.Log.Wrote.Row", (Object[])new Object[]{nr, msg}));
                result.setNrErrors(1L);
                result.setResult(false);
            }
        }
        catch (Exception e) {
            result.setNrErrors(1L);
            result.setResult(false);
            this.logError(BaseMessages.getString(PKG, (String)"ActionAbort.Meta.CheckResult.CouldNotExecute", (String[])new String[0]) + String.valueOf(e));
        }
        this.parentWorkflow.stopExecution();
        return result;
    }

    public boolean resetErrorsBeforeExecution() {
        return false;
    }

    public boolean isEvaluation() {
        return true;
    }

    public boolean isUnconditional() {
        return false;
    }

    public void setMessageAbort(String message) {
        this.messageAbort = message;
    }

    public String getMessageAbort() {
        return this.messageAbort;
    }

    public boolean isAlwaysLogRows() {
        return this.alwaysLogRows;
    }

    public void setAlwaysLogRows(boolean alwaysLogRows) {
        this.alwaysLogRows = alwaysLogRows;
    }

    public void check(List<ICheckResult> remarks, WorkflowMeta workflowMeta, IVariables variables, IHopMetadataProvider metadataProvider) {
        ActionValidatorUtils.addOkRemark((ICheckResultSource)this, (String)"messageAbort", remarks);
    }
}

