/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.BlockingBatchingRowSet;
import org.apache.hop.core.BlockingRowSet;
import org.apache.hop.core.Const;
import org.apache.hop.core.IExecutor;
import org.apache.hop.core.IExtensionData;
import org.apache.hop.core.IRowSet;
import org.apache.hop.core.QueueRowSet;
import org.apache.hop.core.Result;
import org.apache.hop.core.ResultFile;
import org.apache.hop.core.RowMetaAndData;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopFileException;
import org.apache.hop.core.exception.HopPipelineException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.extension.ExtensionPointHandler;
import org.apache.hop.core.extension.HopExtensionPoint;
import org.apache.hop.core.logging.HopLogStore;
import org.apache.hop.core.logging.IHasLogChannel;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.logging.IMetrics;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.logging.LogLevel;
import org.apache.hop.core.logging.LoggingHierarchy;
import org.apache.hop.core.logging.LoggingObjectType;
import org.apache.hop.core.logging.LoggingRegistry;
import org.apache.hop.core.logging.Metrics;
import org.apache.hop.core.parameters.DuplicateParamException;
import org.apache.hop.core.parameters.INamedParameterDefinitions;
import org.apache.hop.core.parameters.INamedParameters;
import org.apache.hop.core.parameters.NamedParameters;
import org.apache.hop.core.parameters.UnknownParamException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.RowBuffer;
import org.apache.hop.core.row.value.ValueMetaBase;
import org.apache.hop.core.util.EnvUtil;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.variables.Variables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.execution.sampler.IExecutionDataSampler;
import org.apache.hop.execution.sampler.IExecutionDataSamplerStore;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.partition.PartitionSchema;
import org.apache.hop.pipeline.IExecutionFinishedListener;
import org.apache.hop.pipeline.IExecutionStartedListener;
import org.apache.hop.pipeline.IExecutionStoppedListener;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.RowProducer;
import org.apache.hop.pipeline.config.IPipelineEngineRunConfiguration;
import org.apache.hop.pipeline.config.PipelineRunConfiguration;
import org.apache.hop.pipeline.engine.EngineComponent;
import org.apache.hop.pipeline.engine.EngineMetric;
import org.apache.hop.pipeline.engine.EngineMetrics;
import org.apache.hop.pipeline.engine.IEngineComponent;
import org.apache.hop.pipeline.engine.IEngineMetric;
import org.apache.hop.pipeline.engine.IPipelineComponentRowsReceived;
import org.apache.hop.pipeline.engine.IPipelineEngine;
import org.apache.hop.pipeline.engines.EmptyPipelineRunConfiguration;
import org.apache.hop.pipeline.performance.PerformanceSnapShot;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformFinishedListener;
import org.apache.hop.pipeline.transform.RowAdapter;
import org.apache.hop.pipeline.transform.RunThread;
import org.apache.hop.pipeline.transform.TransformInitThread;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transform.TransformMetaDataCombi;
import org.apache.hop.pipeline.transform.TransformPartitioningMeta;
import org.apache.hop.pipeline.transform.TransformStatus;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.engine.IWorkflowEngine;

public abstract class Pipeline
implements IVariables,
INamedParameters,
IHasLogChannel,
ILoggingObject,
IExecutor,
IExtensionData,
IPipelineEngine<PipelineMeta> {
    public static final String METRIC_NAME_INPUT = "input";
    public static final String METRIC_NAME_OUTPUT = "output";
    public static final String METRIC_NAME_ERROR = "error";
    public static final String METRIC_NAME_READ = "read";
    public static final String METRIC_NAME_WRITTEN = "written";
    public static final String METRIC_NAME_UPDATED = "updated";
    public static final String METRIC_NAME_REJECTED = "rejected";
    public static final String METRIC_NAME_BUFFER_IN = "buffer_in";
    public static final String METRIC_NAME_BUFFER_OUT = "buffer_out";
    public static final String METRIC_NAME_FLUSH_BUFFER = "flush_buffer";
    public static final String METRIC_NAME_INIT = "init";
    private static final Class<?> PKG = Pipeline.class;
    protected String pluginId;
    protected PipelineRunConfiguration pipelineRunConfiguration;
    protected ILogChannel log;
    protected LogLevel logLevel = LogLevel.BASIC;
    protected String containerObjectId;
    protected int logCommitSize = 10;
    protected PipelineMeta pipelineMeta;
    protected IHopMetadataProvider metadataProvider;
    private IWorkflowEngine<WorkflowMeta> parentWorkflow;
    private IPipelineEngine<PipelineMeta> parentPipeline;
    private ILoggingObject parent;
    private boolean sortingTransformsTopologically;
    private boolean preview;
    private Date executionStartDate;
    private Date executionEndDate;
    private IVariables variables = new Variables();
    public List<IRowSet> rowsets;
    private List<TransformMetaDataCombi> transforms;
    public static final int TYPE_DISP_1_1 = 1;
    public static final int TYPE_DISP_1_N = 2;
    public static final int TYPE_DISP_N_1 = 3;
    public static final int TYPE_DISP_N_N = 4;
    public static final int TYPE_DISP_N_M = 5;
    public static final String STRING_FINISHED = "Finished";
    public static final String STRING_FINISHED_WITH_ERRORS = "Finished (with errors)";
    public static final String STRING_RUNNING = "Running";
    public static final String STRING_PAUSED = "Paused";
    public static final String STRING_PREPARING = "Preparing executing";
    public static final String STRING_INITIALIZING = "Initializing";
    public static final String STRING_WAITING = "Waiting";
    public static final String STRING_STOPPED = "Stopped";
    public static final String STRING_STOPPED_WITH_ERRORS = "Stopped (with errors)";
    public static final String STRING_HALTING = "Halting";
    public static final String CONFIGURATION_IN_EXPORT_FILENAME = "__pipeline_execution_configuration__.xml";
    private boolean safeModeEnabled;
    private final AtomicInteger status;
    private final AtomicBoolean isAlreadyStopped = new AtomicBoolean(false);
    protected List<IExecutionDataSampler<? extends IExecutionDataSamplerStore>> dataSamplers;
    private final AtomicInteger errors;
    private boolean readyToStart;
    private Map<String, List<PerformanceSnapShot>> transformPerformanceSnapShots;
    private Timer transformPerformanceSnapShotTimer;
    private List<IExecutionStartedListener<IPipelineEngine<PipelineMeta>>> executionStartedListeners;
    private List<IExecutionFinishedListener<IPipelineEngine<PipelineMeta>>> executionFinishedListeners;
    private List<IExecutionStoppedListener<IPipelineEngine<PipelineMeta>>> executionStoppedListeners;
    private int nrOfFinishedTransforms;
    private final INamedParameters namedParams = new NamedParameters();
    private Database pipelineLogTableDatabaseConnection;
    private AtomicInteger transformPerformanceSnapshotSeqNr;
    private final int lastWrittenTransformPerformanceSequenceNr;
    private int lastTransformPerformanceSnapshotSeqNrAdded;
    private Map<String, IPipelineEngine> activeSubPipelines;
    private Map<String, IWorkflowEngine<WorkflowMeta>> activeSubWorkflows;
    private int transformPerformanceSnapshotSizeLimit;
    private ArrayBlockingQueue<Object> pipelineWaitUntilFinishedBlockingQueue;
    private String executingServer;
    private String executingUser;
    private Result previousResult;
    protected List<RowMetaAndData> resultRows;
    protected List<ResultFile> resultFiles;
    protected String[] arguments;
    private HttpServletResponse servletResponse;
    private HttpServletRequest servletRequest;
    private final Map<String, Object> extensionDataMap;
    protected int rowSetSize = 10000;
    protected boolean feedbackShown;
    protected int feedbackSize;
    public static final IEngineMetric METRIC_INPUT = new EngineMetric("input", "Input", "The number of rows read from physical I/O", "010", true);
    public static final IEngineMetric METRIC_READ = new EngineMetric("read", "Read", "The number of rows read from other transforms", "020", true);
    public static final IEngineMetric METRIC_WRITTEN = new EngineMetric("written", "Written", "The number of rows written to other transforms", "030", true);
    public static final IEngineMetric METRIC_OUTPUT = new EngineMetric("output", "Output", "The number of rows written to physical I/O", "040", true);
    public static final IEngineMetric METRIC_UPDATED = new EngineMetric("updated", "Updated", "The number of rows updated", "050", true);
    public static final IEngineMetric METRIC_REJECTED = new EngineMetric("rejected", "Rejected", "The number of rows rejected by a transform", "060", true);
    public static final IEngineMetric METRIC_ERROR = new EngineMetric("error", "Errors", "The number of errors", "070", true);
    public static final IEngineMetric METRIC_BUFFER_IN = new EngineMetric("buffer_in", "Buffers Input", "The number of rows in the transforms input buffers", "080", true);
    public static final IEngineMetric METRIC_BUFFER_OUT = new EngineMetric("buffer_out", "Buffers Output", "The number of rows in the transforms output buffers", "090", true);
    public static final IEngineMetric METRIC_INIT = new EngineMetric("init", "Inits", "The number of times the transform was initialised", "000", true);
    public static final IEngineMetric METRIC_FLUSH_BUFFER = new EngineMetric("flush_buffer", "Flushes", "The number of times a buffer flush occurred on a ", "100", true);

    public Pipeline() {
        this.log = LogChannel.GENERAL;
        this.status = new AtomicInteger();
        this.executionStartedListeners = Collections.synchronizedList(new ArrayList());
        this.executionFinishedListeners = Collections.synchronizedList(new ArrayList());
        this.executionStoppedListeners = Collections.synchronizedList(new ArrayList());
        this.errors = new AtomicInteger(0);
        this.transformPerformanceSnapshotSeqNr = new AtomicInteger(0);
        this.lastWrittenTransformPerformanceSequenceNr = 0;
        this.activeSubPipelines = new ConcurrentHashMap<String, IPipelineEngine>();
        this.activeSubWorkflows = new HashMap<String, IWorkflowEngine<WorkflowMeta>>();
        this.resultRows = new ArrayList<RowMetaAndData>();
        this.resultFiles = new ArrayList<ResultFile>();
        this.extensionDataMap = new HashMap<String, Object>();
        this.dataSamplers = Collections.synchronizedList(new ArrayList());
    }

    public Pipeline(PipelineMeta pipelineMeta) {
        this(pipelineMeta, (IVariables)new Variables(), null);
    }

    public Pipeline(PipelineMeta pipelineMeta, IVariables variables, ILoggingObject parent) {
        this();
        this.pipelineMeta = pipelineMeta;
        this.metadataProvider = pipelineMeta.getMetadataProvider();
        this.setParent(parent);
        this.initializeFrom(variables);
        this.log = new LogChannel((Object)this, parent);
        this.logLevel = this.log.getLogLevel();
        this.containerObjectId = UUID.randomUUID().toString();
    }

    @Override
    public void setParent(ILoggingObject parent) {
        this.parent = parent;
    }

    private void setDefaultLogCommitSize() {
        String propLogCommitSize = this.getVariable("hop.log.commit.size");
        if (propLogCommitSize != null) {
            try {
                this.logCommitSize = Integer.parseInt(propLogCommitSize);
            }
            catch (Exception ignored) {
                this.logCommitSize = 10;
            }
        }
    }

    @Override
    public ILogChannel getLogChannel() {
        return this.log;
    }

    @Override
    public void setLogChannel(ILogChannel log) {
        this.log = log;
    }

    public String getName() {
        if (this.pipelineMeta == null) {
            return null;
        }
        return this.pipelineMeta.getName();
    }

    public <Parent extends IVariables & INamedParameters> Pipeline(Parent parent, String name, String filename, IHopMetadataProvider metadataProvider) throws HopException {
        this();
        this.metadataProvider = metadataProvider;
        try {
            this.pipelineMeta = new PipelineMeta(filename, metadataProvider, (IVariables)this);
            this.log = new LogChannel((Object)this.pipelineMeta);
            this.initializeFrom(parent);
            this.activateParameters(this);
            this.setDefaultLogCommitSize();
        }
        catch (HopException e) {
            throw new HopException(BaseMessages.getString(PKG, (String)"Pipeline.Exception.UnableToOpenPipeline", (String[])new String[]{name}), (Throwable)e);
        }
    }

    @Override
    public void execute() throws HopException {
        this.prepareExecution();
        this.startThreads();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepareExecution() throws HopException {
        int i;
        this.setPreparing(true);
        this.executionStartDate = new Date();
        this.setRunning(false);
        this.log = new LogChannel((Object)this, this.parent, this.isGatheringMetrics(), true);
        this.log.setLogLevel(this.logLevel);
        if (this.containerObjectId == null) {
            this.containerObjectId = this.log.getContainerObjectId();
        }
        if (this.log.isDebug()) {
            this.log.logDebug(BaseMessages.getString(PKG, (String)"Pipeline.Log.NumberOfTransformsToRun", (String[])new String[]{String.valueOf(this.pipelineMeta.nrTransforms()), String.valueOf(this.pipelineMeta.nrPipelineHops())}));
        }
        this.log.snap((IMetrics)Metrics.METRIC_PIPELINE_EXECUTION_START, new long[0]);
        this.log.snap((IMetrics)Metrics.METRIC_PIPELINE_INIT_START, new long[0]);
        this.log.logBasic("Executing this pipeline using the Local Pipeline Engine with run configuration '" + this.pipelineRunConfiguration.getName() + "'");
        ExtensionPointHandler.callExtensionPoint((ILogChannel)this.log, (IVariables)this, (String)HopExtensionPoint.PipelinePrepareExecution.id, (Object)this);
        this.activateParameters(this);
        if (this.pipelineMeta.getName() == null) {
            if (this.pipelineMeta.getFilename() != null) {
                this.log.logBasic(BaseMessages.getString(PKG, (String)"Pipeline.Log.ExecutionStartedForFilename", (String[])new String[]{this.pipelineMeta.getFilename()}));
            }
        } else {
            this.log.logBasic(BaseMessages.getString(PKG, (String)"Pipeline.Log.ExecutionStartedForPipeline", (String[])new String[]{this.pipelineMeta.getName()}));
        }
        if (this.isSafeModeEnabled() && this.log.isDetailed()) {
            this.log.logDetailed(BaseMessages.getString(PKG, (String)"Pipeline.Log.SafeModeIsEnabled", (String[])new String[]{this.pipelineMeta.getName()}));
        }
        this.transforms = Collections.synchronizedList(new ArrayList());
        this.rowsets = new ArrayList<IRowSet>();
        List<TransformMeta> hopTransforms = this.pipelineMeta.getPipelineHopTransforms(false);
        if (this.log.isDetailed()) {
            this.log.logDetailed(BaseMessages.getString(PKG, (String)"Pipeline.Log.FoundDefferentTransforms", (String[])new String[]{String.valueOf(hopTransforms.size())}));
            this.log.logDetailed(BaseMessages.getString(PKG, (String)"Pipeline.Log.AllocatingRowsets", (String[])new String[0]));
        }
        for (int i2 = 0; i2 < hopTransforms.size(); ++i2) {
            TransformMeta transformMeta = hopTransforms.get(i2);
            if (transformMeta.isMapping()) continue;
            if (this.log.isDetailed()) {
                this.log.logDetailed(BaseMessages.getString(PKG, (String)"Pipeline.Log.AllocateingRowsetsForTransform", (String[])new String[]{String.valueOf(i2), transformMeta.getName()}));
            }
            List<TransformMeta> nextTransforms = this.pipelineMeta.findNextTransforms(transformMeta);
            for (TransformMeta nextTransform : nextTransforms) {
                int nrCopies;
                int dispatchType;
                if (nextTransform.isMapping()) continue;
                int thisCopies = transformMeta.getCopies(this);
                if (thisCopies < 0) {
                    throw new HopException(BaseMessages.getString(PKG, (String)"Pipeline.Log.TransformCopiesNotCorrectlyDefined", (String[])new String[]{transformMeta.getName()}));
                }
                int nextCopies = nextTransform.getCopies(this);
                boolean repartitioning = transformMeta.isPartitioned() ? !transformMeta.getTransformPartitioningMeta().equals(nextTransform.getTransformPartitioningMeta()) : nextTransform.isPartitioned();
                if (this.log.isDetailed()) {
                    this.log.logDetailed(BaseMessages.getString(PKG, (String)"Pipeline.Log.copiesInfo", (String[])new String[]{String.valueOf(thisCopies), String.valueOf(nextCopies)}));
                }
                if (thisCopies == 1 && nextCopies == 1) {
                    dispatchType = 1;
                    nrCopies = 1;
                } else if (thisCopies == 1 && nextCopies > 1) {
                    dispatchType = 2;
                    nrCopies = nextCopies;
                } else if (thisCopies > 1 && nextCopies == 1) {
                    dispatchType = 3;
                    nrCopies = thisCopies;
                } else if (thisCopies == nextCopies && !repartitioning) {
                    dispatchType = 4;
                    nrCopies = nextCopies;
                } else {
                    dispatchType = 5;
                    nrCopies = nextCopies;
                }
                if (dispatchType != 5) {
                    for (int c = 0; c < nrCopies; ++c) {
                        QueueRowSet rowSet = switch (this.pipelineMeta.getPipelineType()) {
                            case PipelineMeta.PipelineType.Normal -> {
                                Boolean batchingRowSet = ValueMetaBase.convertStringToBoolean((String)System.getProperty("HOP_BATCHING_ROWSET"));
                                if (batchingRowSet != null && batchingRowSet.booleanValue()) {
                                    yield new BlockingBatchingRowSet(this.rowSetSize);
                                }
                                yield new BlockingRowSet(this.rowSetSize);
                            }
                            case PipelineMeta.PipelineType.SingleThreaded -> new QueueRowSet();
                            default -> throw new HopException("Unhandled pipeline type: " + String.valueOf((Object)this.pipelineMeta.getPipelineType()));
                        };
                        switch (dispatchType) {
                            case 1: {
                                rowSet.setThreadNameFromToCopy(transformMeta.getName(), 0, nextTransform.getName(), 0);
                                break;
                            }
                            case 2: {
                                rowSet.setThreadNameFromToCopy(transformMeta.getName(), 0, nextTransform.getName(), c);
                                break;
                            }
                            case 3: {
                                rowSet.setThreadNameFromToCopy(transformMeta.getName(), c, nextTransform.getName(), 0);
                                break;
                            }
                            case 4: {
                                rowSet.setThreadNameFromToCopy(transformMeta.getName(), c, nextTransform.getName(), c);
                                break;
                            }
                        }
                        this.rowsets.add((IRowSet)rowSet);
                        if (!this.log.isDetailed()) continue;
                        this.log.logDetailed(BaseMessages.getString(PKG, (String)"Pipeline.PipelineAllocatedNewRowset", (String[])new String[]{rowSet.toString()}));
                    }
                    continue;
                }
                for (int s = 0; s < thisCopies; ++s) {
                    for (int t = 0; t < nextCopies; ++t) {
                        BlockingRowSet rowSet = new BlockingRowSet(this.rowSetSize);
                        rowSet.setThreadNameFromToCopy(transformMeta.getName(), s, nextTransform.getName(), t);
                        this.rowsets.add((IRowSet)rowSet);
                        if (!this.log.isDetailed()) continue;
                        this.log.logDetailed(BaseMessages.getString(PKG, (String)"Pipeline.PipelineAllocatedNewRowset", (String[])new String[]{rowSet.toString()}));
                    }
                }
            }
            this.log.logDetailed(BaseMessages.getString(PKG, (String)"Pipeline.Log.AllocatedRowsets", (String[])new String[]{String.valueOf(this.rowsets.size()), String.valueOf(i2), transformMeta.getName()}) + " ");
        }
        if (this.log.isDetailed()) {
            this.log.logDetailed(BaseMessages.getString(PKG, (String)"Pipeline.Log.AllocatingTransformsAndTransformData", (String[])new String[0]));
        }
        for (TransformMeta transformMeta : hopTransforms) {
            String transformid = transformMeta.getTransformPluginId();
            if (this.log.isDetailed()) {
                this.log.logDetailed(BaseMessages.getString(PKG, (String)"Pipeline.Log.PipelineIsToAllocateTransform", (String[])new String[]{transformMeta.getName(), transformid}));
            }
            int nrCopies = transformMeta.getCopies(this);
            if (this.log.isDebug()) {
                this.log.logDebug(BaseMessages.getString(PKG, (String)"Pipeline.Log.TransformHasNumberRowCopies", (String[])new String[]{String.valueOf(nrCopies)}));
            }
            for (int c = 0; c < nrCopies; ++c) {
                List<String> partitionIDs;
                ITransformData data;
                if (this.hasTransformStarted(transformMeta.getName(), c)) continue;
                TransformMetaDataCombi combi2 = new TransformMetaDataCombi();
                combi2.transformName = transformMeta.getName();
                combi2.copy = c;
                combi2.transformMeta = transformMeta;
                combi2.meta = transformMeta.getTransform();
                combi2.data = data = combi2.meta.createTransformData();
                ITransform transform = combi2.meta.createTransform(transformMeta, data, c, this.pipelineMeta, this);
                transform.initializeFrom(this);
                transform.setMetadataProvider(this.metadataProvider);
                if (transformMeta.isPartitioned() && (partitionIDs = transformMeta.getTransformPartitioningMeta().getPartitionSchema().calculatePartitionIds(this)) != null && !partitionIDs.isEmpty()) {
                    transform.setPartitionId(partitionIDs.get(c));
                }
                combi2.transform = transform;
                if (combi2.transform instanceof ILoggingObject) {
                    ILogChannel logChannel = combi2.transform.getLogChannel();
                    logChannel.setLogLevel(this.logLevel);
                    logChannel.setGatheringMetrics(this.log.isGatheringMetrics());
                }
                this.transforms.add(combi2);
                if (!this.log.isDetailed()) continue;
                this.log.logDetailed(BaseMessages.getString(PKG, (String)"Pipeline.Log.PipelineHasAllocatedANewTransform", (String[])new String[]{transformMeta.getName(), String.valueOf(c)}));
            }
        }
        for (TransformMetaDataCombi transformMetaDataCombi : this.transforms) {
            if (!transformMetaDataCombi.transformMeta.isDoingErrorHandling()) continue;
            transformMetaDataCombi.transform.identifyErrorOutput();
        }
        INamedParameters syncObject = this;
        if (this.parentWorkflow != null) {
            syncObject = this.parentWorkflow;
        }
        if (this.parentPipeline != null) {
            syncObject = this.parentPipeline;
        }
        INamedParameters iNamedParameters = syncObject;
        synchronized (iNamedParameters) {
            this.calculateBatchIdAndDateRange();
            this.beginProcessing();
        }
        for (TransformMetaDataCombi sid : this.transforms) {
            TransformPartitioningMeta targetTransformPartitioningMeta;
            TransformMeta transformMeta = sid.transformMeta;
            ITransform baseTransform = sid.transform;
            baseTransform.setPartitioned(transformMeta.isPartitioned());
            boolean isThisPartitioned = transformMeta.isPartitioned();
            PartitionSchema thisPartitionSchema = null;
            if (isThisPartitioned) {
                thisPartitionSchema = transformMeta.getTransformPartitioningMeta().getPartitionSchema();
            }
            boolean isNextPartitioned = false;
            TransformPartitioningMeta nextTransformPartitioningMeta = null;
            PartitionSchema nextPartitionSchema = null;
            List<TransformMeta> nextTransforms = this.pipelineMeta.findNextTransforms(transformMeta);
            for (TransformMeta nextTransform : nextTransforms) {
                if (!nextTransform.isPartitioned()) continue;
                isNextPartitioned = true;
                nextTransformPartitioningMeta = nextTransform.getTransformPartitioningMeta();
                nextPartitionSchema = nextTransformPartitioningMeta.getPartitionSchema();
            }
            baseTransform.setRepartitioning(0);
            if (!isThisPartitioned && isNextPartitioned || isThisPartitioned && isNextPartitioned && !thisPartitionSchema.equals(nextPartitionSchema)) {
                baseTransform.setRepartitioning(nextTransformPartitioningMeta.getMethodType());
            }
            if ((targetTransformPartitioningMeta = baseTransform.getTransformMeta().getTargetTransformPartitioningMeta()) == null) continue;
            baseTransform.setRepartitioning(targetTransformPartitioningMeta.getMethodType());
        }
        this.setPreparing(false);
        this.setInitializing(true);
        if (this.isSortingTransformsTopologically() && this.transforms.size() < 150) {
            this.doTopologySortOfTransforms();
        }
        if (this.log.isDetailed()) {
            this.log.logDetailed(BaseMessages.getString(PKG, (String)"Pipeline.Log.InitialisingTransforms", (String[])new String[]{String.valueOf(this.transforms.size())}));
        }
        TransformInitThread[] transformInitThreadArray = new TransformInitThread[this.transforms.size()];
        Thread[] threads = new Thread[this.transforms.size()];
        for (i = 0; i < this.transforms.size(); ++i) {
            TransformMetaDataCombi sid = this.transforms.get(i);
            transformInitThreadArray[i] = new TransformInitThread(sid, this, this.log);
            threads[i] = new Thread(transformInitThreadArray[i]);
            threads[i].setName("init of " + sid.transformName + "." + sid.copy + " (" + threads[i].getName() + ")");
            ExtensionPointHandler.callExtensionPoint((ILogChannel)this.log, (IVariables)this, (String)HopExtensionPoint.TransformBeforeInitialize.id, (Object)transformInitThreadArray[i]);
            threads[i].start();
        }
        for (i = 0; i < threads.length; ++i) {
            try {
                threads[i].join();
                ExtensionPointHandler.callExtensionPoint((ILogChannel)this.log, (IVariables)this, (String)HopExtensionPoint.TransformAfterInitialize.id, (Object)transformInitThreadArray[i]);
                continue;
            }
            catch (Exception ex) {
                this.log.logError("Error with init thread: " + ex.getMessage(), new Object[]{ex.getMessage()});
                this.log.logError(Const.getStackTracker((Throwable)ex));
            }
        }
        this.setInitializing(false);
        boolean ok = true;
        for (TransformInitThread thread : transformInitThreadArray) {
            TransformMetaDataCombi combi4 = thread.getCombi();
            if (!thread.isOk()) {
                this.log.logError(BaseMessages.getString(PKG, (String)"Pipeline.Log.TransformFailedToInit", (String[])new String[]{combi4.transformName + "." + combi4.copy}));
                combi4.data.setStatus(EngineComponent.ComponentExecutionStatus.STATUS_STOPPED);
                ok = false;
                continue;
            }
            combi4.data.setStatus(EngineComponent.ComponentExecutionStatus.STATUS_IDLE);
            if (!this.log.isDetailed()) continue;
            this.log.logDetailed(BaseMessages.getString(PKG, (String)"Pipeline.Log.TransformInitialized", (String[])new String[]{combi4.transformName + "." + combi4.copy}));
        }
        if (!ok) {
            for (TransformInitThread initThread : transformInitThreadArray) {
                TransformMetaDataCombi combi5 = initThread.getCombi();
                combi5.transform.dispose();
                if (initThread.isOk()) {
                    combi5.data.setStatus(EngineComponent.ComponentExecutionStatus.STATUS_HALTED);
                    continue;
                }
                combi5.data.setStatus(EngineComponent.ComponentExecutionStatus.STATUS_STOPPED);
            }
            try {
                this.fireExecutionFinishedListeners();
            }
            catch (HopException e) {
                this.log.logError(BaseMessages.getString(PKG, (String)"Pipeline.FinishListeners.Exception", (String[])new String[0]));
            }
            finally {
                this.setFinished(true);
            }
            if (this.preview) {
                String logText = HopLogStore.getAppender().getBuffer(this.getLogChannelId(), true).toString();
                throw new HopException(BaseMessages.getString(PKG, (String)"Pipeline.Log.FailToInitializeAtLeastOneTransform", (String[])new String[0]) + Const.CR + logText);
            }
            throw new HopException(BaseMessages.getString(PKG, (String)"Pipeline.Log.FailToInitializeAtLeastOneTransform", (String[])new String[0]) + Const.CR);
        }
        this.log.snap((IMetrics)Metrics.METRIC_PIPELINE_INIT_STOP, new long[0]);
        this.setReadyToStart(true);
    }

    @Override
    public void startThreads() throws HopException {
        this.nrOfFinishedTransforms = 0;
        ExtensionPointHandler.callExtensionPoint((ILogChannel)this.log, (IVariables)this, (String)HopExtensionPoint.PipelineStartThreads.id, (Object)this);
        this.fireExecutionStartedListeners();
        for (int i = 0; i < this.transforms.size(); ++i) {
            TransformMetaDataCombi sid = this.transforms.get(i);
            sid.transform.markStart();
            sid.transform.initBeforeStart();
            ITransformFinishedListener finishedListener = (pipeline, transformMeta, transform) -> {
                Pipeline pipeline2 = this;
                synchronized (pipeline2) {
                    ++this.nrOfFinishedTransforms;
                    if (this.nrOfFinishedTransforms >= this.transforms.size()) {
                        this.setFinished(true);
                        this.addTransformPerformanceSnapShot();
                        this.executionEndDate = new Date();
                        try {
                            this.fireExecutionFinishedListeners();
                        }
                        catch (Exception e) {
                            transform.setErrors(transform.getErrors() + 1L);
                            this.log.logError(this.getName() + " : " + BaseMessages.getString(PKG, (String)"Pipeline.Log.UnexpectedErrorAtPipelineEnd", (String[])new String[0]), (Throwable)e);
                        }
                        this.log.logBasic("Execution finished on a local pipeline engine with run configuration '" + this.pipelineRunConfiguration.getName() + "'");
                    }
                    if (transform.getErrors() > 0L) {
                        this.log.logMinimal(BaseMessages.getString(PKG, (String)"Pipeline.Log.PipelineDetectedErrors", (String[])new String[0]));
                        this.log.logMinimal(BaseMessages.getString(PKG, (String)"Pipeline.Log.PipelineIsKillingTheOtherTransforms", (String[])new String[0]));
                        this.killAllNoWait();
                    }
                }
            };
            ITransform iTransform = sid.transform;
            if (iTransform instanceof BaseTransform) {
                BaseTransform baseTransform = (BaseTransform)iTransform;
                baseTransform.getTransformFinishedListeners().add(0, finishedListener);
                continue;
            }
            sid.transform.addTransformFinishedListener(finishedListener);
        }
        if (this.pipelineMeta.isCapturingTransformPerformanceSnapShots()) {
            this.transformPerformanceSnapshotSeqNr = new AtomicInteger(0);
            this.transformPerformanceSnapShots = new ConcurrentHashMap<String, List<PerformanceSnapShot>>();
            String limitString = this.resolve(this.pipelineMeta.getTransformPerformanceCapturingSizeLimit());
            if (Utils.isEmpty((CharSequence)limitString)) {
                limitString = EnvUtil.getSystemProperty((String)"HOP_TRANSFORM_PERFORMANCE_SNAPSHOT_LIMIT");
            }
            this.transformPerformanceSnapshotSizeLimit = Const.toInt((String)limitString, (int)0);
            this.transformPerformanceSnapShotTimer = new Timer("transformPerformanceSnapShot Timer: " + this.pipelineMeta.getName());
            TimerTask timerTask = new TimerTask(){

                @Override
                public void run() {
                    if (!Pipeline.this.isFinished()) {
                        Pipeline.this.addTransformPerformanceSnapShot();
                    }
                }
            };
            this.transformPerformanceSnapShotTimer.schedule(timerTask, 100L, this.pipelineMeta.getTransformPerformanceCapturingDelay());
        }
        this.setFinished(false);
        this.setPaused(false);
        this.setStopped(false);
        this.pipelineWaitUntilFinishedBlockingQueue = new ArrayBlockingQueue(10);
        IExecutionFinishedListener<IPipelineEngine> executionListener = pipeline -> {
            try {
                ExtensionPointHandler.callExtensionPoint((ILogChannel)this.log, (IVariables)this, (String)HopExtensionPoint.PipelineFinish.id, (Object)pipeline);
            }
            catch (HopException e) {
                throw new RuntimeException("Error calling extension point at end of pipeline", e);
            }
            if (this.pipelineMeta.isCapturingTransformPerformanceSnapShots() && this.transformPerformanceSnapShotTimer != null) {
                this.transformPerformanceSnapShotTimer.cancel();
            }
            this.setFinished(true);
            this.setRunning(false);
            this.log.snap((IMetrics)Metrics.METRIC_PIPELINE_EXECUTION_STOP, new long[0]);
            HopVfs.freeUnusedResources();
        };
        this.executionFinishedListeners.add(0, executionListener);
        this.setRunning(true);
        switch (this.pipelineMeta.getPipelineType()) {
            case Normal: {
                for (TransformMetaDataCombi combi : this.transforms) {
                    RunThread runThread = new RunThread(combi);
                    Thread thread = new Thread(runThread);
                    thread.setName(this.getName() + " - " + combi.transformName);
                    ExtensionPointHandler.callExtensionPoint((ILogChannel)this.log, (IVariables)this, (String)HopExtensionPoint.TransformBeforeStart.id, (Object)combi);
                    combi.transform.addTransformFinishedListener((pipeline, transformMeta, transform) -> {
                        try {
                            ExtensionPointHandler.callExtensionPoint((ILogChannel)this.log, (IVariables)this, (String)HopExtensionPoint.TransformFinished.id, (Object)combi);
                        }
                        catch (HopException e) {
                            throw new RuntimeException("Unexpected error in calling extension point upon transform finish", e);
                        }
                    });
                    thread.start();
                }
                break;
            }
            case SingleThreaded: {
                break;
            }
        }
        ExtensionPointHandler.callExtensionPoint((ILogChannel)this.log, (IVariables)this, (String)HopExtensionPoint.PipelineStart.id, (Object)this);
        if (this.transforms.isEmpty()) {
            this.fireExecutionFinishedListeners();
        }
        if (this.log.isDetailed()) {
            this.log.logDetailed(BaseMessages.getString(PKG, (String)"Pipeline.Log.PipelineHasAllocated", (String[])new String[]{String.valueOf(this.transforms.size()), String.valueOf(this.rowsets.size())}));
        }
    }

    @Override
    @Deprecated(since="2.9", forRemoval=true)
    public void firePipelineExecutionFinishedListeners() throws HopException {
        this.fireExecutionFinishedListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fireExecutionFinishedListeners() throws HopException {
        List<IExecutionFinishedListener<IPipelineEngine<PipelineMeta>>> list = this.executionFinishedListeners;
        synchronized (list) {
            if (this.executionFinishedListeners.isEmpty()) {
                return;
            }
            ArrayList<HopException> badGuys = new ArrayList<HopException>(this.executionFinishedListeners.size());
            for (IExecutionFinishedListener<IPipelineEngine<PipelineMeta>> listener : this.executionFinishedListeners) {
                try {
                    listener.finished(this);
                }
                catch (HopException e) {
                    badGuys.add(e);
                }
            }
            if (!badGuys.isEmpty()) {
                throw new HopException((Throwable)badGuys.get(0));
            }
        }
        this.pipelineCompleted();
        ExtensionPointHandler.callExtensionPoint((ILogChannel)this.log, (IVariables)this, (String)HopExtensionPoint.PipelineCompleted.id, (Object)this);
    }

    @Override
    public void pipelineCompleted() throws HopException {
        if (this.pipelineWaitUntilFinishedBlockingQueue != null) {
            this.pipelineWaitUntilFinishedBlockingQueue.add(new Object());
        }
    }

    @Override
    @Deprecated(since="2.9", forRemoval=true)
    public void firePipelineExecutionStartedListeners() throws HopException {
        this.fireExecutionStartedListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fireExecutionStartedListeners() throws HopException {
        List<IExecutionStartedListener<IPipelineEngine<PipelineMeta>>> list = this.executionStartedListeners;
        synchronized (list) {
            for (IExecutionStartedListener<IPipelineEngine<PipelineMeta>> listener : this.executionStartedListeners) {
                listener.started(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addTransformPerformanceSnapShot() {
        boolean stoppedAndNotEmpty;
        if (this.transformPerformanceSnapShots == null) {
            return;
        }
        boolean pausedAndNotEmpty = this.isPaused() && !this.transformPerformanceSnapShots.isEmpty();
        boolean bl = stoppedAndNotEmpty = this.isStopped() && !this.transformPerformanceSnapShots.isEmpty();
        if (this.pipelineMeta.isCapturingTransformPerformanceSnapShots() && !pausedAndNotEmpty && !stoppedAndNotEmpty) {
            int seqNr = this.transformPerformanceSnapshotSeqNr.incrementAndGet();
            for (TransformMetaDataCombi iTransformITransformMetaITransformDataTransformMetaDataCombi : this.transforms) {
                TransformMeta transformMeta = iTransformITransformMetaITransformDataTransformMetaDataCombi.transformMeta;
                ITransform transform = iTransformITransformMetaITransformDataTransformMetaDataCombi.transform;
                PerformanceSnapShot snapShot = new PerformanceSnapShot(seqNr, new Date(), this.getName(), transformMeta.getName(), transform.getCopy(), transform.getLinesRead(), transform.getLinesWritten(), transform.getLinesInput(), transform.getLinesOutput(), transform.getLinesUpdated(), transform.getLinesRejected(), transform.getErrors());
                Map<String, List<PerformanceSnapShot>> map = this.transformPerformanceSnapShots;
                synchronized (map) {
                    PerformanceSnapShot previous;
                    List<PerformanceSnapShot> snapShotList = this.transformPerformanceSnapShots.get(transform.toString());
                    if (snapShotList == null) {
                        snapShotList = new ArrayList<PerformanceSnapShot>();
                        this.transformPerformanceSnapShots.put(transform.toString(), snapShotList);
                        previous = null;
                    } else {
                        previous = snapShotList.get(snapShotList.size() - 1);
                    }
                    snapShot.diff(previous, transform.rowsetInputSize(), transform.rowsetOutputSize());
                    snapShotList.add(snapShot);
                    if (this.transformPerformanceSnapshotSizeLimit > 0 && snapShotList.size() > this.transformPerformanceSnapshotSizeLimit) {
                        snapShotList.remove(0);
                    }
                }
            }
            this.lastTransformPerformanceSnapshotSeqNrAdded = this.transformPerformanceSnapshotSeqNr.get();
        }
    }

    @Override
    public void cleanup() {
        if (this.transforms == null) {
            return;
        }
        for (TransformMetaDataCombi combi : this.transforms) {
            combi.transform.cleanup();
        }
    }

    @Override
    public void waitUntilFinished() {
        try {
            if (this.pipelineWaitUntilFinishedBlockingQueue == null) {
                return;
            }
            boolean wait = true;
            while (wait) {
                wait = this.pipelineWaitUntilFinishedBlockingQueue.poll(50L, TimeUnit.MILLISECONDS) == null;
                if (!wait) continue;
                Thread.sleep(1L);
                if (this.parentWorkflow != null && this.parentWorkflow.isStopped() && !this.isStopped()) {
                    this.stopAll();
                }
                if (this.parentPipeline == null || !this.parentPipeline.isStopped() || this.isStopped()) continue;
                this.stopAll();
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Waiting for pipeline to be finished interrupted!", e);
        }
    }

    @Override
    public int getErrors() {
        int nrErrors = this.errors.get();
        if (this.transforms == null) {
            return nrErrors;
        }
        for (TransformMetaDataCombi sid : this.transforms) {
            if (sid.transform.getErrors() == 0L) continue;
            nrErrors = (int)((long)nrErrors + sid.transform.getErrors());
        }
        return nrErrors;
    }

    @Override
    public boolean isFinished() {
        int exist = this.status.get() & BitMaskStatus.FINISHED.mask;
        return exist != 0;
    }

    protected void setFinished(boolean finished) {
        this.status.updateAndGet(v -> finished ? v | BitMaskStatus.FINISHED.mask : (0x3F ^ BitMaskStatus.FINISHED.mask) & v);
    }

    public boolean isFinishedOrStopped() {
        return this.isFinished() || this.isStopped();
    }

    private void killAllNoWait() {
        if (this.transforms == null) {
            return;
        }
        for (TransformMetaDataCombi sid : this.transforms) {
            ITransform transform = sid.transform;
            if (this.log.isDebug()) {
                this.log.logDebug(BaseMessages.getString(PKG, (String)"Pipeline.Log.LookingAtTransform", (String[])new String[0]) + transform.getTransformName());
            }
            transform.stopAll();
        }
    }

    @Override
    public IRowSet findRowSet(String from, int fromcopy, String to, int tocopy) {
        for (IRowSet rs : this.rowsets) {
            if (!rs.getOriginTransformName().equalsIgnoreCase(from) || !rs.getDestinationTransformName().equalsIgnoreCase(to) || rs.getOriginTransformCopy() != fromcopy || rs.getDestinationTransformCopy() != tocopy) continue;
            return rs;
        }
        return null;
    }

    public boolean hasTransformStarted(String sname, int copy) {
        for (TransformMetaDataCombi sid : this.transforms) {
            boolean started = sid.transformName != null && sid.transformName.equalsIgnoreCase(sname) && sid.copy == copy;
            if (!started) continue;
            return true;
        }
        return false;
    }

    public void safeStop() {
        if (this.transforms == null) {
            return;
        }
        this.transforms.stream().filter(this::isInputTransform).forEach(combi -> this.stopTransform((TransformMetaDataCombi)combi, true));
        this.fireExecutionStoppedListeners();
    }

    private boolean isInputTransform(TransformMetaDataCombi combi) {
        Preconditions.checkNotNull((Object)combi);
        return this.pipelineMeta.findPreviousTransforms(combi.transformMeta, true).isEmpty();
    }

    @Override
    public void stopAll() {
        if (this.transforms == null || this.isAlreadyStopped.get()) {
            return;
        }
        this.transforms.forEach(combi -> this.stopTransform((TransformMetaDataCombi)combi, false));
        this.setPaused(false);
        this.setStopped(true);
        this.isAlreadyStopped.set(true);
        this.fireExecutionStoppedListeners();
    }

    public void stopTransform(TransformMetaDataCombi combi, boolean safeStop) {
        ITransform rt = combi.transform;
        rt.setStopped(true);
        rt.setSafeStopped(safeStop);
        rt.resumeRunning();
        try {
            rt.stopRunning();
        }
        catch (Exception e) {
            this.log.logError("Something went wrong while trying to safe stop the pipeline: ", (Throwable)e);
        }
        combi.data.setStatus(EngineComponent.ComponentExecutionStatus.STATUS_STOPPED);
        if (safeStop) {
            rt.setOutputDone();
        }
    }

    @Override
    @Deprecated(since="2.9", forRemoval=true)
    public void firePipelineExecutionStoppedListeners() {
        this.fireExecutionStoppedListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fireExecutionStoppedListeners() {
        List<IExecutionStoppedListener<IPipelineEngine<PipelineMeta>>> list = this.executionStoppedListeners;
        synchronized (list) {
            for (IExecutionStoppedListener<IPipelineEngine<PipelineMeta>> listener : this.executionStoppedListeners) {
                listener.stopped(this);
            }
        }
    }

    public int nrTransforms() {
        if (this.transforms == null) {
            return 0;
        }
        return this.transforms.size();
    }

    public boolean[] getPipelineTransformIsRunningLookup() {
        if (this.transforms == null) {
            return null;
        }
        boolean[] tResult = new boolean[this.transforms.size()];
        for (int i = 0; i < this.transforms.size(); ++i) {
            TransformMetaDataCombi sid = this.transforms.get(i);
            tResult[i] = sid.transform.isRunning() || sid.transform.getStatus() != EngineComponent.ComponentExecutionStatus.STATUS_FINISHED;
        }
        return tResult;
    }

    public EngineComponent.ComponentExecutionStatus[] getPipelineTransformExecutionStatusLookup() {
        if (this.transforms == null) {
            return null;
        }
        int totalTransforms = this.transforms.size();
        EngineComponent.ComponentExecutionStatus[] tList = new EngineComponent.ComponentExecutionStatus[totalTransforms];
        for (int i = 0; i < totalTransforms; ++i) {
            TransformMetaDataCombi sid = this.transforms.get(i);
            tList[i] = sid.transform.getStatus();
        }
        return tList;
    }

    public ITransform getRunThread(int i) {
        if (this.transforms == null) {
            return null;
        }
        return this.transforms.get((int)i).transform;
    }

    public ITransform getRunThread(String name, int copy) {
        if (this.transforms == null) {
            return null;
        }
        for (TransformMetaDataCombi sid : this.transforms) {
            ITransform transform = sid.transform;
            if (!transform.getTransformName().equalsIgnoreCase(name) || transform.getCopy() != copy) continue;
            return transform;
        }
        return null;
    }

    public void calculateBatchIdAndDateRange() throws HopPipelineException {
    }

    public void beginProcessing() throws HopPipelineException {
    }

    @Override
    public Result getResult() {
        if (this.transforms == null) {
            return null;
        }
        Result result = new Result();
        result.setNrErrors(this.errors.longValue());
        result.setResult(this.errors.longValue() == 0L);
        for (TransformMetaDataCombi sid : this.transforms) {
            ITransform transform = sid.transform;
            result.setNrErrors(result.getNrErrors() + sid.transform.getErrors());
            result.getResultFiles().putAll(transform.getResultFiles());
            result.setNrLinesRead(Math.max(result.getNrLinesRead(), transform.getLinesRead()));
            result.setNrLinesWritten(Math.max(result.getNrLinesWritten(), transform.getLinesWritten()));
            result.setNrLinesInput(Math.max(result.getNrLinesInput(), transform.getLinesInput()));
            result.setNrLinesOutput(Math.max(result.getNrLinesOutput(), transform.getLinesOutput()));
            result.setNrLinesUpdated(Math.max(result.getNrLinesUpdated(), transform.getLinesUpdated()));
            result.setNrLinesRejected(Math.max(result.getNrLinesRejected(), transform.getLinesRejected()));
        }
        result.setRows(this.resultRows);
        if (!Utils.isEmpty(this.resultFiles)) {
            result.setResultFiles(new HashMap());
            for (ResultFile resultFile : this.resultFiles) {
                result.getResultFiles().put(resultFile.toString(), resultFile);
            }
        }
        result.setStopped(this.isStopped());
        result.setLogChannelId(this.log.getLogChannelId());
        return result;
    }

    public ITransform findRunThread(String transformName) {
        if (this.transforms == null) {
            return null;
        }
        for (TransformMetaDataCombi sid : this.transforms) {
            ITransform transform = sid.transform;
            if (!transform.getTransformName().equalsIgnoreCase(transformName)) continue;
            return transform;
        }
        return null;
    }

    public boolean isSortingTransformsTopologically() {
        return this.sortingTransformsTopologically;
    }

    public void setSortingTransformsTopologically(boolean sortingTransformsTopologically) {
        this.sortingTransformsTopologically = sortingTransformsTopologically;
    }

    @Override
    public PipelineMeta getPipelineMeta() {
        return this.pipelineMeta;
    }

    @Override
    public void setPipelineMeta(PipelineMeta pipelineMeta) {
        this.pipelineMeta = pipelineMeta;
    }

    public List<IRowSet> getRowsets() {
        return this.rowsets;
    }

    public List<TransformMetaDataCombi> getTransforms() {
        return this.transforms;
    }

    protected void setTransforms(List<TransformMetaDataCombi> transforms) {
        this.transforms = transforms;
    }

    public String toString() {
        if (this.pipelineMeta == null || this.pipelineMeta.getName() == null) {
            return this.getClass().getSimpleName();
        }
        StringBuilder string = new StringBuilder(50);
        if (this.getParentPipeline() != null) {
            string.append('[').append(this.getParentPipeline().toString()).append(']').append('.');
        }
        string.append(this.pipelineMeta.getName());
        return string.toString();
    }

    public ITransform getTransform(String name, int copyNr) {
        if (this.transforms == null) {
            return null;
        }
        for (TransformMetaDataCombi sid : this.transforms) {
            ITransform transform = sid.transform;
            if (!transform.getTransformName().equalsIgnoreCase(name) || sid.copy != copyNr) continue;
            return transform;
        }
        return null;
    }

    public List<ITransform> getTransforms(String name) {
        if (this.transforms == null) {
            return null;
        }
        ArrayList<ITransform> list = new ArrayList<ITransform>();
        for (TransformMetaDataCombi sid : this.transforms) {
            ITransform transform = sid.transform;
            if (!transform.getTransformName().equalsIgnoreCase(name)) continue;
            list.add(transform);
        }
        return list;
    }

    public void setSafeModeEnabled(boolean safeModeEnabled) {
        this.safeModeEnabled = safeModeEnabled;
    }

    @Override
    public boolean isSafeModeEnabled() {
        return this.safeModeEnabled;
    }

    public RowProducer addRowProducer(String transformName, int copynr) throws HopException {
        ITransform transform = this.getTransform(transformName, copynr);
        if (transform == null) {
            throw new HopException("Unable to find thread with name " + transformName + " and copy number " + copynr);
        }
        QueueRowSet rowSet = switch (this.pipelineMeta.getPipelineType()) {
            case PipelineMeta.PipelineType.Normal -> new BlockingRowSet(this.rowSetSize);
            case PipelineMeta.PipelineType.SingleThreaded -> new QueueRowSet();
            default -> throw new HopException("Unhandled pipeline type: " + String.valueOf((Object)this.pipelineMeta.getPipelineType()));
        };
        transform.addRowSetToInputRowSets((IRowSet)rowSet);
        return new RowProducer(transform, (IRowSet)rowSet);
    }

    @Override
    public IWorkflowEngine<WorkflowMeta> getParentWorkflow() {
        return this.parentWorkflow;
    }

    @Override
    public void setParentWorkflow(IWorkflowEngine<WorkflowMeta> parentWorkflow) {
        this.parentWorkflow = parentWorkflow;
    }

    public ITransformData getTransformData(String name, int copyNr) {
        if (this.transforms == null) {
            return null;
        }
        for (TransformMetaDataCombi sid : this.transforms) {
            ITransform transform = sid.transform;
            if (!transform.getTransformName().equalsIgnoreCase(name) || sid.copy != copyNr) continue;
            return sid.data;
        }
        return null;
    }

    @Override
    public boolean hasHaltedComponents() {
        if (this.transforms == null) {
            return false;
        }
        for (TransformMetaDataCombi sid : this.transforms) {
            if (sid.data.getStatus() != EngineComponent.ComponentExecutionStatus.STATUS_HALTED) continue;
            return true;
        }
        return false;
    }

    public String getStatus() {
        Object message;
        if (this.isRunning()) {
            message = this.isStopped() ? STRING_HALTING : (this.isPaused() ? STRING_PAUSED : STRING_RUNNING);
        } else if (this.isFinished()) {
            message = STRING_FINISHED;
            if (this.getResult().getNrErrors() > 0L) {
                message = (String)message + " (with errors)";
            }
        } else {
            message = this.isStopped() ? STRING_STOPPED : (this.isPreparing() ? STRING_PREPARING : (this.isInitializing() ? STRING_INITIALIZING : STRING_WAITING));
        }
        return message;
    }

    public boolean isInitializing() {
        int exist = this.status.get() & BitMaskStatus.INITIALIZING.mask;
        return exist != 0;
    }

    public void setInitializing(boolean initializing) {
        this.status.updateAndGet(v -> initializing ? v | BitMaskStatus.INITIALIZING.mask : (0x3F ^ BitMaskStatus.INITIALIZING.mask) & v);
    }

    @Override
    public boolean isPreparing() {
        int exist = this.status.get() & BitMaskStatus.PREPARING.mask;
        return exist != 0;
    }

    public void setPreparing(boolean preparing) {
        this.status.updateAndGet(v -> preparing ? v | BitMaskStatus.PREPARING.mask : (0x3F ^ BitMaskStatus.PREPARING.mask) & v);
    }

    @Override
    public boolean isRunning() {
        int exist = this.status.get() & BitMaskStatus.RUNNING.mask;
        return exist != 0;
    }

    public void setRunning(boolean running) {
        this.status.updateAndGet(v -> running ? v | BitMaskStatus.RUNNING.mask : (0x3F ^ BitMaskStatus.RUNNING.mask) & v);
    }

    @Override
    public boolean isReadyToStart() {
        return this.readyToStart;
    }

    protected void setReadyToStart(boolean ready) {
        this.readyToStart = ready;
    }

    @Override
    public void setInternalHopVariables(IVariables var) {
        boolean hasFilename;
        boolean bl = hasFilename = this.pipelineMeta != null && !Utils.isEmpty((CharSequence)this.pipelineMeta.getFilename());
        if (hasFilename) {
            try {
                FileObject fileObject = HopVfs.getFileObject((String)this.pipelineMeta.getFilename());
                FileName fileName = fileObject.getName();
                this.variables.setVariable("Internal.Pipeline.Filename.Name", fileName.getBaseName());
                FileName fileDir = fileName.getParent();
                this.variables.setVariable("Internal.Pipeline.Filename.Directory", fileDir.getURI());
            }
            catch (HopFileException e) {
                this.variables.setVariable("Internal.Pipeline.Filename.Directory", "");
                this.variables.setVariable("Internal.Pipeline.Filename.Name", "");
            }
        } else {
            this.variables.setVariable("Internal.Pipeline.Filename.Directory", "");
            this.variables.setVariable("Internal.Pipeline.Filename.Name", "");
        }
        this.variables.setVariable("Internal.Pipeline.Name", Const.NVL((String)this.pipelineMeta.getName(), (String)""));
        this.variables.setVariable("Internal.Pipeline.ID", this.log != null ? this.log.getLogChannelId() : "");
        if (this.parent != null) {
            this.setVariable("Internal.Pipeline.ParentID", this.parent.getLogChannelId());
        } else {
            this.setVariable("Internal.Pipeline.ParentID", null);
        }
        this.setInternalEntryCurrentDirectory(hasFilename);
    }

    protected void setInternalEntryCurrentDirectory(boolean hasFilename) {
        this.variables.setVariable("Internal.Entry.Current.Folder", this.variables.getVariable(hasFilename ? "Internal.Pipeline.Filename.Directory" : "Internal.Entry.Current.Folder"));
    }

    public void copyFrom(IVariables variables) {
        this.variables.copyFrom(variables);
    }

    public String resolve(String aString) {
        return this.variables.resolve(aString);
    }

    public String[] resolve(String[] aString) {
        return this.variables.resolve(aString);
    }

    public String resolve(String aString, IRowMeta rowMeta, Object[] rowData) throws HopValueException {
        return this.variables.resolve(aString, rowMeta, rowData);
    }

    public IVariables getParentVariables() {
        if (this.getParentPipeline() != null) {
            return this.getParentPipeline();
        }
        if (this.getParentWorkflow() != null) {
            return this.getParentWorkflow();
        }
        return this.variables.getParentVariables();
    }

    public void setParentVariables(IVariables parent) {
        this.variables.setParentVariables(parent);
    }

    public String getVariable(String variableName, String defaultValue) {
        return this.variables.getVariable(variableName, defaultValue);
    }

    public String getVariable(String variableName) {
        return this.variables.getVariable(variableName);
    }

    public boolean getVariableBoolean(String variableName, boolean defaultValue) {
        String value;
        if (!Utils.isEmpty((CharSequence)variableName) && !Utils.isEmpty((CharSequence)(value = this.resolve(variableName)))) {
            return ValueMetaBase.convertStringToBoolean((String)value);
        }
        return defaultValue;
    }

    public void initializeFrom(IVariables parent) {
        this.variables.initializeFrom(parent);
    }

    public String[] getVariableNames() {
        return this.variables.getVariableNames();
    }

    public void setVariable(String variableName, String variableValue) {
        this.variables.setVariable(variableName, variableValue);
    }

    public void shareWith(IVariables variables) {
        this.variables = variables;
    }

    public void setVariables(Map<String, String> map) {
        this.variables.setVariables(map);
    }

    @Override
    public void pauseExecution() {
        this.setPaused(true);
        for (TransformMetaDataCombi combi : this.transforms) {
            combi.transform.pauseRunning();
        }
    }

    @Override
    public void resumeExecution() {
        for (TransformMetaDataCombi combi : this.transforms) {
            combi.transform.resumeRunning();
        }
        this.setPaused(false);
    }

    @Override
    @Deprecated(since="2.10")
    public boolean isPreview() {
        return this.preview;
    }

    @Override
    @Deprecated(since="2.10")
    public void setPreview(boolean preview) {
        this.preview = preview;
    }

    public Map<String, List<PerformanceSnapShot>> getTransformPerformanceSnapShots() {
        return this.transformPerformanceSnapShots;
    }

    public void setTransformPerformanceSnapShots(Map<String, List<PerformanceSnapShot>> transformPerformanceSnapShots) {
        this.transformPerformanceSnapShots = transformPerformanceSnapShots;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addExecutionStartedListener(IExecutionStartedListener<IPipelineEngine<PipelineMeta>> listener) {
        List<IExecutionStartedListener<IPipelineEngine<PipelineMeta>>> list = this.executionStartedListeners;
        synchronized (list) {
            this.executionStartedListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeExecutionStartedListener(IExecutionStartedListener<IPipelineEngine<PipelineMeta>> listener) {
        List<IExecutionStartedListener<IPipelineEngine<PipelineMeta>>> list = this.executionStartedListeners;
        synchronized (list) {
            this.executionStartedListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addExecutionFinishedListener(IExecutionFinishedListener<IPipelineEngine<PipelineMeta>> listener) {
        List<IExecutionFinishedListener<IPipelineEngine<PipelineMeta>>> list = this.executionFinishedListeners;
        synchronized (list) {
            this.executionFinishedListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeExecutionFinishedListener(IExecutionFinishedListener<IPipelineEngine<PipelineMeta>> listener) {
        List<IExecutionFinishedListener<IPipelineEngine<PipelineMeta>>> list = this.executionFinishedListeners;
        synchronized (list) {
            this.executionFinishedListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addExecutionStoppedListener(IExecutionStoppedListener<IPipelineEngine<PipelineMeta>> listener) {
        List<IExecutionStoppedListener<IPipelineEngine<PipelineMeta>>> list = this.executionStoppedListeners;
        synchronized (list) {
            this.executionStoppedListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeExecutionStoppedListener(IExecutionStoppedListener<IPipelineEngine<PipelineMeta>> listener) {
        List<IExecutionStoppedListener<IPipelineEngine<PipelineMeta>>> list = this.executionStoppedListeners;
        synchronized (list) {
            this.executionStoppedListeners.remove(listener);
        }
    }

    @Deprecated(since="2.9", forRemoval=true)
    public void setExecutionStoppedListeners(List<IExecutionStoppedListener<IPipelineEngine<PipelineMeta>>> executionStoppedListeners) {
        this.executionStoppedListeners = Collections.synchronizedList(executionStoppedListeners);
    }

    @Deprecated(since="2.9", forRemoval=true)
    public List<IExecutionStoppedListener<IPipelineEngine<PipelineMeta>>> getExecutionStoppedListeners() {
        return this.executionStoppedListeners;
    }

    public void addPipelineStoppedListener(IExecutionStoppedListener<IPipelineEngine<PipelineMeta>> pipelineStoppedListener) {
        this.executionStoppedListeners.add(pipelineStoppedListener);
    }

    @Override
    public boolean isPaused() {
        int exist = this.status.get() & BitMaskStatus.PAUSED.mask;
        return exist != 0;
    }

    public void setPaused(boolean paused) {
        this.status.updateAndGet(v -> paused ? v | BitMaskStatus.PAUSED.mask : (0x3F ^ BitMaskStatus.PAUSED.mask) & v);
    }

    @Override
    public boolean isStopped() {
        int exist = this.status.get() & BitMaskStatus.STOPPED.mask;
        return exist != 0;
    }

    public void setStopped(boolean stopped) {
        this.status.updateAndGet(v -> stopped ? v | BitMaskStatus.STOPPED.mask : (0x3F ^ BitMaskStatus.STOPPED.mask) & v);
    }

    public void addParameterDefinition(String key, String defValue, String description) throws DuplicateParamException {
        this.namedParams.addParameterDefinition(key, defValue, description);
    }

    public String getParameterDefault(String key) throws UnknownParamException {
        return this.namedParams.getParameterDefault(key);
    }

    public String getParameterDescription(String key) throws UnknownParamException {
        return this.namedParams.getParameterDescription(key);
    }

    public String getParameterValue(String key) throws UnknownParamException {
        return this.namedParams.getParameterValue(key);
    }

    public String[] listParameters() {
        return this.namedParams.listParameters();
    }

    public void setParameterValue(String key, String value) throws UnknownParamException {
        this.namedParams.setParameterValue(key, value);
    }

    public void removeAllParameters() {
        this.namedParams.removeAllParameters();
    }

    public void clearParameterValues() {
        this.namedParams.clearParameterValues();
    }

    public void activateParameters(IVariables variables) {
        this.namedParams.activateParameters(variables);
    }

    public void copyParametersFromDefinitions(INamedParameterDefinitions definitions) {
        this.namedParams.copyParametersFromDefinitions(definitions);
    }

    @Override
    public IPipelineEngine getParentPipeline() {
        return this.parentPipeline;
    }

    @Override
    public void setParentPipeline(IPipelineEngine parentPipeline) {
        this.parentPipeline = parentPipeline;
    }

    public String getObjectName() {
        return this.getName();
    }

    public String getObjectCopy() {
        return null;
    }

    public String getFilename() {
        if (this.pipelineMeta == null) {
            return null;
        }
        return this.pipelineMeta.getFilename();
    }

    @Override
    public String getLogChannelId() {
        return this.log.getLogChannelId();
    }

    public LoggingObjectType getObjectType() {
        return LoggingObjectType.PIPELINE;
    }

    public ILoggingObject getParent() {
        return this.parent;
    }

    @Override
    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    @Override
    public void setLogLevel(LogLevel logLevel) {
        this.logLevel = logLevel;
        this.log.setLogLevel(logLevel);
    }

    public List<LoggingHierarchy> getLoggingHierarchy() {
        ArrayList<LoggingHierarchy> hierarchy = new ArrayList<LoggingHierarchy>();
        List childIds = LoggingRegistry.getInstance().getLogChannelChildren(this.getLogChannelId());
        for (String childId : childIds) {
            ILoggingObject loggingObject = LoggingRegistry.getInstance().getLoggingObject(childId);
            if (loggingObject == null) continue;
            hierarchy.add(new LoggingHierarchy(this.getLogChannelId(), loggingObject));
        }
        return hierarchy;
    }

    @Override
    public void addActiveSubPipeline(String subPipelineName, IPipelineEngine subPipeline) {
        this.activeSubPipelines.put(subPipelineName, subPipeline);
    }

    @Override
    public IPipelineEngine getActiveSubPipeline(String subPipelineName) {
        return this.activeSubPipelines.get(subPipelineName);
    }

    @Override
    public void addActiveSubWorkflow(String subWorkflowName, IWorkflowEngine<WorkflowMeta> subWorkflow) {
        this.activeSubWorkflows.put(subWorkflowName, subWorkflow);
    }

    @Override
    public IWorkflowEngine<WorkflowMeta> getActiveSubWorkflow(String subWorkflowName) {
        return this.activeSubWorkflows.get(subWorkflowName);
    }

    public Map<String, IWorkflowEngine<WorkflowMeta>> getActiveSubWorkflows() {
        return this.activeSubWorkflows;
    }

    public String getContainerId() {
        return this.containerObjectId;
    }

    @Override
    public void setContainerId(String containerId) {
        this.containerObjectId = containerId;
    }

    public Date getRegistrationDate() {
        return null;
    }

    @Override
    public String getExecutingServer() {
        if (this.executingServer == null) {
            this.setExecutingServer(Const.getHostname());
        }
        return this.executingServer;
    }

    @Override
    public void setExecutingServer(String executingServer) {
        this.executingServer = executingServer;
    }

    @Override
    public String getExecutingUser() {
        return this.executingUser;
    }

    @Override
    public void setExecutingUser(String executingUser) {
        this.executingUser = executingUser;
    }

    public boolean isGatheringMetrics() {
        return this.log != null && this.log.isGatheringMetrics();
    }

    public void setGatheringMetrics(boolean gatheringMetrics) {
        if (this.log != null) {
            this.log.setGatheringMetrics(gatheringMetrics);
        }
    }

    public boolean isForcingSeparateLogging() {
        return this.log != null && this.log.isForcingSeparateLogging();
    }

    public void setForcingSeparateLogging(boolean forcingSeparateLogging) {
        if (this.log != null) {
            this.log.setForcingSeparateLogging(forcingSeparateLogging);
        }
    }

    public List<ResultFile> getResultFiles() {
        return this.resultFiles;
    }

    public void setResultFiles(List<ResultFile> resultFiles) {
        this.resultFiles = resultFiles;
    }

    public List<RowMetaAndData> getResultRows() {
        return this.resultRows;
    }

    public void setResultRows(List<RowMetaAndData> resultRows) {
        this.resultRows = resultRows;
    }

    @Override
    public Result getPreviousResult() {
        return this.previousResult;
    }

    @Override
    public void setPreviousResult(Result previousResult) {
        this.previousResult = previousResult;
    }

    public void clearError() {
        this.setStopped(false);
        this.errors.set(0);
        this.setFinished(false);
        for (TransformMetaDataCombi combi : this.transforms) {
            ITransform transform = combi.transform;
            for (IRowSet rowSet : transform.getInputRowSets()) {
                rowSet.clear();
            }
            transform.setStopped(false);
        }
    }

    @Override
    public IHopMetadataProvider getMetadataProvider() {
        return this.metadataProvider;
    }

    @Override
    public void setMetadataProvider(IHopMetadataProvider metadataProvider) {
        this.metadataProvider = metadataProvider;
        if (this.pipelineMeta != null) {
            this.pipelineMeta.setMetadataProvider(metadataProvider);
        }
    }

    public void setServletReponse(HttpServletResponse response) {
        if (response == null) {
            throw new IllegalArgumentException("HttpServletResponse cannot be null ");
        }
        String encoding = System.getProperty("HOP_DEFAULT_SERVLET_ENCODING", null);
        if (!StringUtils.isBlank((String)encoding)) {
            try {
                response.setCharacterEncoding(encoding.trim());
                response.setContentType("text/html; charset=" + encoding);
            }
            catch (Exception ex) {
                LogChannel.GENERAL.logError("Unable to encode data with encoding : '" + encoding + "'", (Throwable)ex);
            }
        }
        this.servletResponse = response;
    }

    public HttpServletResponse getServletResponse() {
        return this.servletResponse;
    }

    public void setServletRequest(HttpServletRequest request) {
        this.servletRequest = request;
    }

    public HttpServletRequest getServletRequest() {
        return this.servletRequest;
    }

    public synchronized void doTopologySortOfTransforms() {
        this.pipelineMeta.clearCaches();
        int transformsMinSize = 0;
        int transformsSize = this.transforms.size();
        int windowShrinkThreshold = (int)Math.round((double)transformsSize * 0.75);
        int totalIterations = transformsSize * 2;
        boolean isBefore = false;
        boolean forwardChange = false;
        boolean backwardChange = false;
        boolean lastForwardChange = true;
        boolean keepSortingForward = true;
        TransformMetaDataCombi one = null;
        TransformMetaDataCombi two = null;
        for (int x = 0; x < totalIterations; ++x) {
            if (keepSortingForward) {
                for (int y = transformsMinSize; y < transformsSize - 1; ++y) {
                    one = this.transforms.get(y);
                    two = this.transforms.get(y + 1);
                    isBefore = one.transformMeta.equals(two.transformMeta) ? one.copy > two.copy : this.pipelineMeta.findPrevious(one.transformMeta, two.transformMeta);
                    if (!isBefore) continue;
                    this.transforms.set(y, two);
                    this.transforms.set(y + 1, one);
                    forwardChange = true;
                }
            }
            for (int z = transformsSize - 1; z > transformsMinSize; --z) {
                one = this.transforms.get(z);
                two = this.transforms.get(z - 1);
                isBefore = one.transformMeta.equals(two.transformMeta) ? one.copy > two.copy : this.pipelineMeta.findPrevious(one.transformMeta, two.transformMeta);
                if (isBefore) continue;
                this.transforms.set(z, two);
                this.transforms.set(z - 1, one);
                backwardChange = true;
            }
            if (x > windowShrinkThreshold && !forwardChange && --transformsSize <= transformsMinSize || x > windowShrinkThreshold && !backwardChange && ++transformsMinSize >= transformsSize || !forwardChange && !backwardChange) break;
            if (keepSortingForward && x > 0 && !lastForwardChange && !forwardChange) {
                keepSortingForward = false;
            }
            lastForwardChange = forwardChange;
            forwardChange = false;
            backwardChange = false;
        }
    }

    @Override
    public Date getExecutionStartDate() {
        return this.executionStartDate;
    }

    public void setExecutionStartDate(Date executionStartDate) {
        this.executionStartDate = executionStartDate;
    }

    @Override
    public Date getExecutionEndDate() {
        return this.executionEndDate;
    }

    public void setExecutionEndDate(Date executionEndDate) {
        this.executionEndDate = executionEndDate;
    }

    @Override
    public Map<String, Object> getExtensionDataMap() {
        return this.extensionDataMap;
    }

    @Override
    public EngineMetrics getEngineMetrics() {
        return this.getEngineMetrics(null, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EngineMetrics getEngineMetrics(String componentName, int copyNr) {
        Object object;
        EngineMetrics metrics = new EngineMetrics();
        metrics.setStartDate(this.getExecutionStartDate());
        metrics.setEndDate(this.getExecutionEndDate());
        if (this.transforms != null) {
            object = this.transforms;
            synchronized (object) {
                for (TransformMetaDataCombi combi : this.transforms) {
                    ITransform transform = combi.transform;
                    boolean collect = true;
                    if (copyNr >= 0) {
                        boolean bl = collect = collect && copyNr == combi.copy;
                    }
                    if (componentName != null) {
                        boolean bl = collect = collect && componentName.equalsIgnoreCase(combi.transformName);
                    }
                    if (!collect) continue;
                    metrics.addComponent(combi.transform);
                    metrics.setComponentMetric(combi.transform, METRIC_INPUT, combi.transform.getLinesInput());
                    metrics.setComponentMetric(combi.transform, METRIC_OUTPUT, combi.transform.getLinesOutput());
                    metrics.setComponentMetric(combi.transform, METRIC_READ, combi.transform.getLinesRead());
                    metrics.setComponentMetric(combi.transform, METRIC_WRITTEN, combi.transform.getLinesWritten());
                    metrics.setComponentMetric(combi.transform, METRIC_UPDATED, combi.transform.getLinesUpdated());
                    metrics.setComponentMetric(combi.transform, METRIC_REJECTED, combi.transform.getLinesRejected());
                    metrics.setComponentMetric(combi.transform, METRIC_ERROR, combi.transform.getErrors());
                    long inputBufferSize = 0L;
                    for (IRowSet rowSet : transform.getInputRowSets()) {
                        inputBufferSize += (long)rowSet.size();
                    }
                    metrics.setComponentMetric(combi.transform, METRIC_BUFFER_IN, inputBufferSize);
                    long outputBufferSize = 0L;
                    for (IRowSet rowSet : transform.getOutputRowSets()) {
                        outputBufferSize += (long)rowSet.size();
                    }
                    metrics.setComponentMetric(combi.transform, METRIC_BUFFER_OUT, outputBufferSize);
                    TransformStatus transformStatus = new TransformStatus(combi.transform);
                    metrics.setComponentSpeed(combi.transform, transformStatus.getSpeed());
                    metrics.setComponentStatus(combi.transform, combi.transform.getStatus().getDescription());
                    metrics.setComponentRunning(combi.transform, combi.transform.isRunning());
                }
            }
        }
        if (this.transformPerformanceSnapShots != null) {
            object = this.transformPerformanceSnapShots.keySet().iterator();
            while (object.hasNext()) {
                IEngineComponent component;
                String componentString;
                String snapshotName = componentString = (String)object.next();
                int snapshotCopyNr = 0;
                int lastDot = componentString.lastIndexOf(46);
                if (lastDot > 0) {
                    componentString.substring(0, lastDot);
                    snapshotCopyNr = Const.toInt((String)componentString.substring(lastDot + 1), (int)0);
                }
                boolean collect = true;
                if (componentName != null) {
                    boolean bl = collect = collect && componentName.equalsIgnoreCase(componentString);
                }
                if (copyNr >= 0) {
                    boolean bl = collect = collect && snapshotCopyNr == copyNr;
                }
                if (!collect || (component = this.findComponent(snapshotName, snapshotCopyNr)) == null) continue;
                List<PerformanceSnapShot> snapShots = this.transformPerformanceSnapShots.get(componentString);
                metrics.getComponentPerformanceSnapshots().put(component, snapShots);
            }
        }
        return metrics;
    }

    @Override
    public String getComponentLogText(String componentName, int copyNr) {
        ITransform transform = this.getTransform(componentName, copyNr);
        if (transform == null) {
            return null;
        }
        StringBuffer logBuffer = HopLogStore.getAppender().getBuffer(transform.getLogChannel().getLogChannelId(), false);
        if (logBuffer == null) {
            return null;
        }
        return logBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IEngineComponent> getComponents() {
        ArrayList<IEngineComponent> list = new ArrayList<IEngineComponent>();
        if (this.transforms != null) {
            List<TransformMetaDataCombi> list2 = this.transforms;
            synchronized (list2) {
                for (TransformMetaDataCombi transform : this.transforms) {
                    list.add(transform.transform);
                }
            }
        }
        return list;
    }

    @Override
    public IEngineComponent findComponent(String name, int copyNr) {
        return this.getTransform(name, copyNr);
    }

    @Override
    public List<IEngineComponent> getComponentCopies(String name) {
        ArrayList<IEngineComponent> list = new ArrayList<IEngineComponent>();
        if (this.transforms != null) {
            for (TransformMetaDataCombi transform : this.transforms) {
                if (!transform.transformName.equalsIgnoreCase(name)) continue;
                list.add(transform.transform);
            }
        }
        return list;
    }

    @Override
    public String getPluginId() {
        return this.pluginId;
    }

    @Override
    public void setPluginId(String pluginId) {
        this.pluginId = pluginId;
    }

    @Override
    public IPipelineEngineRunConfiguration createDefaultPipelineEngineRunConfiguration() {
        return new EmptyPipelineRunConfiguration();
    }

    @Override
    public void retrieveComponentOutput(IVariables variables, final String componentName, final int copyNr, final int nrRows, final IPipelineComponentRowsReceived rowsReceived) throws HopException {
        ITransform iTransform = this.getTransform(componentName, copyNr);
        if (iTransform == null) {
            throw new HopException("Unable to find transform '" + componentName + "', copy " + copyNr + " to retrieve output rows from");
        }
        final RowBuffer rowBuffer = new RowBuffer(this.pipelineMeta.getTransformFields(variables, componentName));
        iTransform.addRowListener(new RowAdapter(){

            @Override
            public void rowWrittenEvent(IRowMeta rowMeta, Object[] row) throws HopTransformException {
                if (rowBuffer.getBuffer().size() < nrRows) {
                    rowBuffer.getBuffer().add(row);
                    if (rowBuffer.getBuffer().size() >= nrRows) {
                        try {
                            rowsReceived.rowsReceived(Pipeline.this, rowBuffer);
                        }
                        catch (HopException e) {
                            throw new HopTransformException("Error recieving rows from '" + componentName + " copy " + copyNr, (Throwable)e);
                        }
                    }
                }
            }
        });
    }

    public void addStartedListener(IExecutionStartedListener<IPipelineEngine<PipelineMeta>> listener) throws HopException {
        this.executionStartedListeners.add(listener);
    }

    public void addFinishedListener(IExecutionFinishedListener<IPipelineEngine<PipelineMeta>> listener) throws HopException {
        this.executionFinishedListeners.add(listener);
    }

    public int getRowSetSize() {
        return this.rowSetSize;
    }

    public void setRowSetSize(int rowSetSize) {
        this.rowSetSize = rowSetSize;
    }

    @Override
    public boolean isFeedbackShown() {
        return this.feedbackShown;
    }

    public void setFeedbackShown(boolean feedbackShown) {
        this.feedbackShown = feedbackShown;
    }

    @Override
    public int getFeedbackSize() {
        return this.feedbackSize;
    }

    public void setFeedbackSize(int feedbackSize) {
        this.feedbackSize = feedbackSize;
    }

    @Deprecated(since="2.9", forRemoval=true)
    public List<IExecutionStartedListener<IPipelineEngine<PipelineMeta>>> getExecutionStartedListeners() {
        return this.executionStartedListeners;
    }

    @Deprecated(since="2.9", forRemoval=true)
    public void setExecutionStartedListeners(List<IExecutionStartedListener<IPipelineEngine<PipelineMeta>>> executionStartedListeners) {
        this.executionStartedListeners = executionStartedListeners;
    }

    @Deprecated(since="2.9", forRemoval=true)
    public List<IExecutionFinishedListener<IPipelineEngine<PipelineMeta>>> getExecutionFinishedListeners() {
        return this.executionFinishedListeners;
    }

    @Deprecated(since="2.9", forRemoval=true)
    public void setExecutionFinishedListeners(List<IExecutionFinishedListener<IPipelineEngine<PipelineMeta>>> executionFinishedListeners) {
        this.executionFinishedListeners = executionFinishedListeners;
    }

    @Override
    public PipelineRunConfiguration getPipelineRunConfiguration() {
        return this.pipelineRunConfiguration;
    }

    @Override
    public void setPipelineRunConfiguration(PipelineRunConfiguration pipelineRunConfiguration) {
        this.pipelineRunConfiguration = pipelineRunConfiguration;
    }

    public Map<String, IPipelineEngine> getActiveSubPipelines() {
        return this.activeSubPipelines;
    }

    public void setActiveSubPipelines(Map<String, IPipelineEngine> activeSubPipelines) {
        this.activeSubPipelines = activeSubPipelines;
    }

    public void setActiveSubWorkflows(Map<String, IWorkflowEngine<WorkflowMeta>> activeSubWorkflows) {
        this.activeSubWorkflows = activeSubWorkflows;
    }

    public IVariables getVariables() {
        return this.variables;
    }

    public void setVariables(IVariables variables) {
        this.variables = variables;
    }

    public List<IExecutionDataSampler<? extends IExecutionDataSamplerStore>> getDataSamplers() {
        return this.dataSamplers;
    }

    public void setDataSamplers(List<IExecutionDataSampler<? extends IExecutionDataSamplerStore>> dataSamplers) {
        this.dataSamplers = dataSamplers;
    }

    @Override
    public <Store extends IExecutionDataSamplerStore, Sampler extends IExecutionDataSampler<Store>> void addExecutionDataSampler(Sampler sampler) {
        this.dataSamplers.add(sampler);
    }

    static enum BitMaskStatus {
        RUNNING(1),
        INITIALIZING(2),
        PREPARING(4),
        STOPPED(8),
        FINISHED(16),
        PAUSED(32);

        private final int mask;
        public static final int BIT_STATUS_SUM = 63;

        private BitMaskStatus(int mask) {
            this.mask = mask;
        }
    }
}

