/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.start;

import java.util.Calendar;
import java.util.List;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.Result;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.exception.HopWorkflowException;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.IAction;

@Action(id="SPECIAL", image="ui/images/start.svg", name="i18n::ActionStart.Name", description="i18n::ActionStart.Description", categoryDescription="i18n:org.apache.hop.workflow:ActionCategory.Category.General", keywords={"i18n::ActionStart.keyword"}, documentationUrl="/workflow/actions/start.html")
public class ActionStart
extends ActionBase
implements Cloneable,
IAction {
    public static final String ID = "SPECIAL";
    public static final int NOSCHEDULING = 0;
    public static final int INTERVAL = 1;
    public static final int DAILY = 2;
    public static final int WEEKLY = 3;
    public static final int MONTHLY = 4;
    @HopMetadataProperty
    private boolean repeat = false;
    @HopMetadataProperty
    private int schedulerType = 0;
    @HopMetadataProperty
    private int intervalSeconds = 0;
    @HopMetadataProperty
    private int intervalMinutes = 60;
    @HopMetadataProperty(key="DayOfMonth")
    private int dayOfMonth = 1;
    @HopMetadataProperty
    private int weekDay = 1;
    @HopMetadataProperty
    private int minutes = 0;
    @HopMetadataProperty
    private int hour = 12;

    public ActionStart() {
        this((String)null);
    }

    public ActionStart(String name) {
        super(name, "");
    }

    @Override
    public ActionStart clone() {
        return (ActionStart)super.clone();
    }

    @Override
    public Result execute(Result previousResult, int nr) throws HopWorkflowException {
        try {
            long sleepTime = this.getNextExecutionTime();
            if (sleepTime > 0L) {
                this.parentWorkflow.getLogChannel().logBasic(this.parentWorkflow.getWorkflowName(), new Object[]{"Sleeping: " + sleepTime / 1000L / 60L + " minutes (sleep time=" + sleepTime + ")"});
                for (long totalSleep = 0L; totalSleep < sleepTime && !this.parentWorkflow.isStopped(); totalSleep += 1000L) {
                    Thread.sleep(1000L);
                }
            }
        }
        catch (InterruptedException e) {
            throw new HopWorkflowException((Throwable)e);
        }
        previousResult.setResult(true);
        return previousResult;
    }

    private long getNextExecutionTime() {
        switch (this.schedulerType) {
            case 0: {
                return 0L;
            }
            case 1: {
                return this.getNextIntervalExecutionTime();
            }
            case 2: {
                return this.getNextDailyExecutionTime();
            }
            case 3: {
                return this.getNextWeeklyExecutionTime();
            }
            case 4: {
                return this.getNextMonthlyExecutionTime();
            }
        }
        return 0L;
    }

    private long getNextIntervalExecutionTime() {
        return this.intervalSeconds * 1000 + this.intervalMinutes * 1000 * 60;
    }

    private long getNextMonthlyExecutionTime() {
        Calendar calendar = Calendar.getInstance();
        long nowMillis = calendar.getTimeInMillis();
        int amHour = this.hour;
        if (amHour > 12) {
            amHour -= 12;
            calendar.set(9, 1);
        } else {
            calendar.set(9, 0);
        }
        calendar.set(10, amHour);
        calendar.set(12, this.minutes);
        calendar.set(5, this.dayOfMonth);
        if (calendar.getTimeInMillis() <= nowMillis) {
            calendar.add(2, 1);
        }
        return calendar.getTimeInMillis() - nowMillis;
    }

    private long getNextWeeklyExecutionTime() {
        Calendar calendar = Calendar.getInstance();
        long nowMillis = calendar.getTimeInMillis();
        int amHour = this.hour;
        if (amHour > 12) {
            amHour -= 12;
            calendar.set(9, 1);
        } else {
            calendar.set(9, 0);
        }
        calendar.set(10, amHour);
        calendar.set(12, this.minutes);
        calendar.set(7, this.weekDay + 1);
        if (calendar.getTimeInMillis() <= nowMillis) {
            calendar.add(3, 1);
        }
        return calendar.getTimeInMillis() - nowMillis;
    }

    private long getNextDailyExecutionTime() {
        Calendar calendar = Calendar.getInstance();
        long nowMillis = calendar.getTimeInMillis();
        int amHour = this.hour;
        if (amHour > 12) {
            amHour -= 12;
            calendar.set(9, 1);
        } else {
            calendar.set(9, 0);
        }
        calendar.set(10, amHour);
        calendar.set(12, this.minutes);
        if (calendar.getTimeInMillis() <= nowMillis) {
            calendar.add(5, 1);
        }
        return calendar.getTimeInMillis() - nowMillis;
    }

    public boolean evaluates() {
        return false;
    }

    @Override
    public boolean isUnconditional() {
        return true;
    }

    public int getSchedulerType() {
        return this.schedulerType;
    }

    public int getHour() {
        return this.hour;
    }

    public int getMinutes() {
        return this.minutes;
    }

    public int getWeekDay() {
        return this.weekDay;
    }

    public int getDayOfMonth() {
        return this.dayOfMonth;
    }

    public void setDayOfMonth(int dayOfMonth) {
        this.dayOfMonth = dayOfMonth;
    }

    public void setHour(int hour) {
        this.hour = hour;
    }

    public void setMinutes(int minutes) {
        this.minutes = minutes;
    }

    public void setWeekDay(int weekDay) {
        this.weekDay = weekDay;
    }

    public void setSchedulerType(int schedulerType) {
        this.schedulerType = schedulerType;
    }

    @Override
    public boolean isStart() {
        return true;
    }

    public boolean isRepeat() {
        return this.repeat;
    }

    public void setRepeat(boolean repeat) {
        this.repeat = repeat;
    }

    public int getIntervalSeconds() {
        return this.intervalSeconds;
    }

    public void setIntervalSeconds(int intervalSeconds) {
        this.intervalSeconds = intervalSeconds;
    }

    public int getIntervalMinutes() {
        return this.intervalMinutes;
    }

    public void setIntervalMinutes(int intervalMinutes) {
        this.intervalMinutes = intervalMinutes;
    }

    @Override
    public void check(List<ICheckResult> remarks, WorkflowMeta workflowMeta, IVariables variables, IHopMetadataProvider metadataProvider) {
    }
}

