/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.stone.UnionSerializer;
import com.dropbox.core.v2.files.LookupError;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public final class ExportError {
    public static final ExportError NON_EXPORTABLE = new ExportError().withTag(Tag.NON_EXPORTABLE);
    public static final ExportError INVALID_EXPORT_FORMAT = new ExportError().withTag(Tag.INVALID_EXPORT_FORMAT);
    public static final ExportError RETRY_ERROR = new ExportError().withTag(Tag.RETRY_ERROR);
    public static final ExportError OTHER = new ExportError().withTag(Tag.OTHER);
    private Tag _tag;
    private LookupError pathValue;

    private ExportError() {
    }

    private ExportError withTag(Tag _tag) {
        ExportError result = new ExportError();
        result._tag = _tag;
        return result;
    }

    private ExportError withTagAndPath(Tag _tag, LookupError pathValue) {
        ExportError result = new ExportError();
        result._tag = _tag;
        result.pathValue = pathValue;
        return result;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isPath() {
        return this._tag == Tag.PATH;
    }

    public static ExportError path(LookupError value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new ExportError().withTagAndPath(Tag.PATH, value);
    }

    public LookupError getPathValue() {
        if (this._tag != Tag.PATH) {
            throw new IllegalStateException("Invalid tag: required Tag.PATH, but was Tag." + this._tag.name());
        }
        return this.pathValue;
    }

    public boolean isNonExportable() {
        return this._tag == Tag.NON_EXPORTABLE;
    }

    public boolean isInvalidExportFormat() {
        return this._tag == Tag.INVALID_EXPORT_FORMAT;
    }

    public boolean isRetryError() {
        return this._tag == Tag.RETRY_ERROR;
    }

    public boolean isOther() {
        return this._tag == Tag.OTHER;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.pathValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof ExportError) {
            ExportError other = (ExportError)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case PATH: {
                    return this.pathValue == other.pathValue || this.pathValue.equals(other.pathValue);
                }
                case NON_EXPORTABLE: {
                    return true;
                }
                case INVALID_EXPORT_FORMAT: {
                    return true;
                }
                case RETRY_ERROR: {
                    return true;
                }
                case OTHER: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    public static class Serializer
    extends UnionSerializer<ExportError> {
        public static final Serializer INSTANCE = new Serializer();

        @Override
        public void serialize(ExportError value, JsonGenerator g) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case PATH: {
                    g.writeStartObject();
                    this.writeTag("path", g);
                    g.writeFieldName("path");
                    LookupError.Serializer.INSTANCE.serialize(value.pathValue, g);
                    g.writeEndObject();
                    break;
                }
                case NON_EXPORTABLE: {
                    g.writeString("non_exportable");
                    break;
                }
                case INVALID_EXPORT_FORMAT: {
                    g.writeString("invalid_export_format");
                    break;
                }
                case RETRY_ERROR: {
                    g.writeString("retry_error");
                    break;
                }
                default: {
                    g.writeString("other");
                }
            }
        }

        @Override
        public ExportError deserialize(JsonParser p) throws IOException, JsonParseException {
            ExportError value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("path".equals(tag)) {
                LookupError fieldValue = null;
                Serializer.expectField("path", p);
                fieldValue = LookupError.Serializer.INSTANCE.deserialize(p);
                value = ExportError.path(fieldValue);
            } else {
                value = "non_exportable".equals(tag) ? NON_EXPORTABLE : ("invalid_export_format".equals(tag) ? INVALID_EXPORT_FORMAT : ("retry_error".equals(tag) ? RETRY_ERROR : OTHER));
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        PATH,
        NON_EXPORTABLE,
        INVALID_EXPORT_FORMAT,
        RETRY_ERROR,
        OTHER;

    }
}

