/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatch.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudwatch.model.Dimension;
import com.amazonaws.services.cloudwatch.model.GetMetricStatisticsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.Date;

public class GetMetricStatisticsRequestMarshaller
implements Marshaller<Request<GetMetricStatisticsRequest>, GetMetricStatisticsRequest> {
    public Request<GetMetricStatisticsRequest> marshall(GetMetricStatisticsRequest getMetricStatisticsRequest) {
        if (getMetricStatisticsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getMetricStatisticsRequest, "AmazonCloudWatch");
        request.addParameter("Action", "GetMetricStatistics");
        request.addParameter("Version", "2010-08-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (getMetricStatisticsRequest.getNamespace() != null) {
            request.addParameter("Namespace", StringUtils.fromString((String)getMetricStatisticsRequest.getNamespace()));
        }
        if (getMetricStatisticsRequest.getMetricName() != null) {
            request.addParameter("MetricName", StringUtils.fromString((String)getMetricStatisticsRequest.getMetricName()));
        }
        if (!getMetricStatisticsRequest.getDimensions().isEmpty() || !((SdkInternalList)getMetricStatisticsRequest.getDimensions()).isAutoConstruct()) {
            SdkInternalList dimensionsList = (SdkInternalList)getMetricStatisticsRequest.getDimensions();
            int dimensionsListIndex = 1;
            for (Dimension dimensionsListValue : dimensionsList) {
                if (dimensionsListValue != null) {
                    if (dimensionsListValue.getName() != null) {
                        request.addParameter("Dimensions.member." + dimensionsListIndex + ".Name", StringUtils.fromString((String)dimensionsListValue.getName()));
                    }
                    if (dimensionsListValue.getValue() != null) {
                        request.addParameter("Dimensions.member." + dimensionsListIndex + ".Value", StringUtils.fromString((String)dimensionsListValue.getValue()));
                    }
                }
                ++dimensionsListIndex;
            }
        }
        if (getMetricStatisticsRequest.getStartTime() != null) {
            request.addParameter("StartTime", StringUtils.fromDate((Date)getMetricStatisticsRequest.getStartTime()));
        }
        if (getMetricStatisticsRequest.getEndTime() != null) {
            request.addParameter("EndTime", StringUtils.fromDate((Date)getMetricStatisticsRequest.getEndTime()));
        }
        if (getMetricStatisticsRequest.getPeriod() != null) {
            request.addParameter("Period", StringUtils.fromInteger((Integer)getMetricStatisticsRequest.getPeriod()));
        }
        if (!getMetricStatisticsRequest.getStatistics().isEmpty() || !((SdkInternalList)getMetricStatisticsRequest.getStatistics()).isAutoConstruct()) {
            SdkInternalList statisticsList = (SdkInternalList)getMetricStatisticsRequest.getStatistics();
            int statisticsListIndex = 1;
            for (String statisticsListValue : statisticsList) {
                if (statisticsListValue != null) {
                    request.addParameter("Statistics.member." + statisticsListIndex, StringUtils.fromString((String)statisticsListValue));
                }
                ++statisticsListIndex;
            }
        }
        if (!getMetricStatisticsRequest.getExtendedStatistics().isEmpty() || !((SdkInternalList)getMetricStatisticsRequest.getExtendedStatistics()).isAutoConstruct()) {
            SdkInternalList extendedStatisticsList = (SdkInternalList)getMetricStatisticsRequest.getExtendedStatistics();
            int extendedStatisticsListIndex = 1;
            for (String extendedStatisticsListValue : extendedStatisticsList) {
                if (extendedStatisticsListValue != null) {
                    request.addParameter("ExtendedStatistics.member." + extendedStatisticsListIndex, StringUtils.fromString((String)extendedStatisticsListValue));
                }
                ++extendedStatisticsListIndex;
            }
        }
        if (getMetricStatisticsRequest.getUnit() != null) {
            request.addParameter("Unit", StringUtils.fromString((String)getMetricStatisticsRequest.getUnit()));
        }
        return request;
    }
}

