/*
 * Decompiled with CFR 0.152.
 */
package autovalue.shaded.com.google.escapevelocity;

import autovalue.shaded.com.google.common.collect.ImmutableMap;
import autovalue.shaded.com.google.escapevelocity.BreakException;
import autovalue.shaded.com.google.escapevelocity.EvaluationContext;
import autovalue.shaded.com.google.escapevelocity.EvaluationException;
import autovalue.shaded.com.google.escapevelocity.Macro;
import autovalue.shaded.com.google.escapevelocity.MethodFinder;
import autovalue.shaded.com.google.escapevelocity.Node;
import autovalue.shaded.com.google.escapevelocity.Parser;
import java.io.IOException;
import java.io.Reader;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;

public class Template {
    private final Node root;
    private final ImmutableMap<String, Macro> macros;
    private final MethodFinder methodFinder = new MethodFinder();

    public static Template parseFrom(Reader reader) throws IOException {
        ResourceOpener resourceOpener = resourceName -> {
            if (resourceName == null) {
                return reader;
            }
            throw new IOException("No ResourceOpener has been configured to read " + resourceName);
        };
        try {
            Template template = Template.parseFrom(null, resourceOpener);
            return template;
        }
        finally {
            reader.close();
        }
    }

    public static Template parseFrom(String resourceName, ResourceOpener resourceOpener) throws IOException {
        TreeMap<String, Template> parseCache = new TreeMap<String, Template>();
        return Template.parseFrom(resourceName, resourceOpener, parseCache);
    }

    static Template parseFrom(String resourceName, ResourceOpener resourceOpener, Map<String, Template> parseCache) throws IOException {
        try (Reader reader = resourceOpener.openResource(resourceName);){
            Template template = new Parser(reader, resourceName, resourceOpener, parseCache).parse();
            return template;
        }
    }

    Template(Node root, ImmutableMap<String, Macro> macros) {
        this.root = root;
        this.macros = macros;
    }

    public String evaluate(Map<String, ?> vars) {
        StringBuilder output;
        block2: {
            LinkedHashMap<String, Macro> modifiableMacros = new LinkedHashMap<String, Macro>(this.macros);
            EvaluationContext.PlainEvaluationContext evaluationContext = new EvaluationContext.PlainEvaluationContext(vars, modifiableMacros, this.methodFinder);
            output = new StringBuilder(1024);
            try {
                this.render(evaluationContext, output);
            }
            catch (BreakException e) {
                if (!e.forEachScope()) break block2;
                throw new EvaluationException("#break($foreach) not inside #foreach: " + e.getMessage());
            }
        }
        return output.toString();
    }

    void render(EvaluationContext context, StringBuilder output) {
        this.root.render(context, output);
    }

    ImmutableMap<String, Macro> getMacros() {
        return this.macros;
    }

    @FunctionalInterface
    public static interface ResourceOpener {
        public Reader openResource(String var1) throws IOException;
    }
}

