/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.columnsexist;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.Result;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopDatabaseException;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.resource.IResourceHolder;
import org.apache.hop.resource.ResourceEntry;
import org.apache.hop.resource.ResourceReference;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.IAction;

@Action(id="COLUMNS_EXIST", name="i18n::ActionColumnsExist.Name", description="i18n::ActionColumnsExist.Description", image="ColumnsExist.svg", categoryDescription="i18n:org.apache.hop.workflow:ActionCategory.Category.Conditions", keywords={"i18n::ActionColumnsExist.keyword"}, documentationUrl="/workflow/actions/columnsexist.html")
public class ActionColumnsExist
extends ActionBase
implements Cloneable,
IAction {
    private static final Class<?> PKG = ActionColumnsExist.class;
    @HopMetadataProperty(key="schemaname")
    private String schemaName;
    @HopMetadataProperty(key="tablename")
    private String tableName;
    @HopMetadataProperty(key="connection", storeWithName=true)
    private DatabaseMeta databaseMeta;
    @HopMetadataProperty(groupKey="fields", key="field")
    private List<ColumnExist> columns;

    public ActionColumnsExist(String n) {
        super(n, "");
        this.schemaName = null;
        this.tableName = null;
        this.databaseMeta = null;
        this.columns = new ArrayList<ColumnExist>();
    }

    public ActionColumnsExist() {
        this("");
    }

    public ActionColumnsExist(ActionColumnsExist meta) {
        super(meta.getName(), meta.getDescription(), meta.getPluginId());
        this.schemaName = meta.schemaName;
        this.tableName = meta.tableName;
        this.databaseMeta = meta.databaseMeta;
        this.columns = meta.columns;
    }

    public Object clone() {
        return new ActionColumnsExist(this);
    }

    public boolean isEvaluation() {
        return true;
    }

    public boolean isUnconditional() {
        return false;
    }

    public Result execute(Result result, int nr) {
        int nrnotexistcolums;
        int nrexistcolums;
        block18: {
            result.setResult(false);
            result.setNrErrors(1L);
            nrexistcolums = 0;
            nrnotexistcolums = 0;
            if (Utils.isEmpty((CharSequence)this.tableName)) {
                this.logError(BaseMessages.getString(PKG, (String)"ActionColumnsExist.Error.TablenameEmpty", (String[])new String[0]));
                return result;
            }
            if (this.columns == null) {
                this.logError(BaseMessages.getString(PKG, (String)"ActionColumnsExist.Error.ColumnameEmpty", (String[])new String[0]));
                return result;
            }
            if (this.databaseMeta != null) {
                try (Database db = new Database((ILoggingObject)this, (IVariables)this, this.databaseMeta);){
                    String realSchemaName = this.resolve(this.schemaName);
                    String realTableName = this.resolve(this.tableName);
                    db.connect();
                    if (db.checkTableExists(realSchemaName, realTableName)) {
                        if (this.isDetailed()) {
                            this.logDetailed(BaseMessages.getString(PKG, (String)"ActionColumnsExist.Log.TableExists", (String[])new String[]{realTableName}));
                        }
                        for (ColumnExist column : this.columns) {
                            if (this.parentWorkflow.isStopped()) {
                                break block18;
                            }
                            String realColumnname = this.resolve(column.getName());
                            if (db.checkColumnExists(realSchemaName, realTableName, realColumnname)) {
                                if (this.isDetailed()) {
                                    this.logDetailed(BaseMessages.getString(PKG, (String)"ActionColumnsExist.Log.ColumnExists", (String[])new String[]{realColumnname, realTableName}));
                                }
                                ++nrexistcolums;
                                continue;
                            }
                            this.logError(BaseMessages.getString(PKG, (String)"ActionColumnsExist.Log.ColumnNotExists", (String[])new String[]{realColumnname, realTableName}));
                            ++nrnotexistcolums;
                        }
                        break block18;
                    }
                    this.logError(BaseMessages.getString(PKG, (String)"ActionColumnsExist.Log.TableNotExists", (String[])new String[]{realTableName}));
                }
                catch (HopDatabaseException dbe) {
                    this.logError(BaseMessages.getString(PKG, (String)"ActionColumnsExist.Error.UnexpectedError", (String[])new String[]{dbe.getMessage()}));
                }
            } else {
                this.logError(BaseMessages.getString(PKG, (String)"ActionColumnsExist.Error.NoDbConnection", (String[])new String[0]));
            }
        }
        result.setEntryNr((long)nrnotexistcolums);
        result.setNrLinesWritten((long)nrexistcolums);
        if (nrexistcolums == this.columns.size()) {
            result.setNrErrors(0L);
            result.setResult(true);
        }
        return result;
    }

    public List<ResourceReference> getResourceDependencies(IVariables variables, WorkflowMeta workflowMeta) {
        List references = super.getResourceDependencies(variables, workflowMeta);
        if (this.databaseMeta != null) {
            ResourceReference reference = new ResourceReference((IResourceHolder)this);
            reference.getEntries().add(new ResourceEntry(this.databaseMeta.getHostname(), ResourceEntry.ResourceType.SERVER));
            reference.getEntries().add(new ResourceEntry(this.databaseMeta.getDatabaseName(), ResourceEntry.ResourceType.DATABASENAME));
            references.add(reference);
        }
        return references;
    }

    public void check(List<ICheckResult> remarks, WorkflowMeta workflowMeta, IVariables variables, IHopMetadataProvider metadataProvider) {
        String message;
        if (StringUtils.isEmpty((CharSequence)variables.resolve(this.tableName))) {
            message = BaseMessages.getString(PKG, (String)"ActionColumnsExist.CheckResult.TableNameIsEmpty", (String[])new String[0]);
            remarks.add((ICheckResult)new CheckResult(4, message, (ICheckResultSource)this));
        }
        if (this.columns == null || this.columns.isEmpty()) {
            message = BaseMessages.getString(PKG, (String)"ActionColumnsExist.CheckResult.NothingToCheck", (String[])new String[0]);
            remarks.add((ICheckResult)new CheckResult(3, message, (ICheckResultSource)this));
        }
    }

    @Generated
    public String getSchemaName() {
        return this.schemaName;
    }

    @Generated
    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    @Generated
    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @Generated
    public String getTableName() {
        return this.tableName;
    }

    @Generated
    public void setDatabaseMeta(DatabaseMeta databaseMeta) {
        this.databaseMeta = databaseMeta;
    }

    @Generated
    public DatabaseMeta getDatabaseMeta() {
        return this.databaseMeta;
    }

    @Generated
    public void setColumns(List<ColumnExist> columns) {
        this.columns = columns;
    }

    @Generated
    public List<ColumnExist> getColumns() {
        return this.columns;
    }

    public static final class ColumnExist {
        @HopMetadataProperty(key="name")
        private String name;

        public ColumnExist() {
        }

        public ColumnExist(String name) {
            this.name = name;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public String getName() {
            return this.name;
        }
    }
}

