/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.tar;

import java.io.InputStream;
import java.util.HashSet;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.io.function.Uncheck;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileObject;
import org.apache.commons.vfs2.provider.tar.TarFileSystem;

public class TarFileObject
extends AbstractFileObject<TarFileSystem> {
    private TarArchiveEntry entry;
    private final HashSet<String> children = new HashSet();
    private FileType type;

    protected TarFileObject(AbstractFileName fileName, TarArchiveEntry entry, TarFileSystem fileSystem, boolean tarExists) {
        super(fileName, fileSystem);
        this.setTarEntry(entry);
        if (!tarExists) {
            this.type = FileType.IMAGINARY;
        }
    }

    protected void attachChild(FileName childName) {
        this.children.add(childName.getBaseName());
    }

    @Override
    protected long doGetContentSize() {
        if (this.entry == null) {
            return 0L;
        }
        return this.entry.getSize();
    }

    @Override
    protected InputStream doGetInputStream(int bufferSize) throws Exception {
        if (!this.getType().hasContent()) {
            throw new FileSystemException("vfs.provider/read-not-file.error", (Object)this.getName());
        }
        return ((TarFileSystem)this.getAbstractFileSystem()).getInputStream(this.entry);
    }

    @Override
    protected long doGetLastModifiedTime() throws Exception {
        if (this.entry == null) {
            return 0L;
        }
        return this.entry.getModTime().getTime();
    }

    @Override
    protected FileType doGetType() {
        return this.type;
    }

    @Override
    protected String[] doListChildren() {
        if (!((FileType)((Object)Uncheck.get(this::getType))).hasChildren()) {
            return null;
        }
        return this.children.toArray(ArrayUtils.EMPTY_STRING_ARRAY);
    }

    @Override
    public boolean isWriteable() throws FileSystemException {
        return false;
    }

    protected void setTarEntry(TarArchiveEntry entry) {
        if (this.entry != null) {
            return;
        }
        this.type = entry == null || entry.isDirectory() ? FileType.FOLDER : FileType.FILE;
        this.entry = entry;
    }
}

