/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.ExtendedIllegalArgumentException;

class PSLoad {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private int activeConnections_ = 0;
    private int balanceThreshold_ = -1;
    private int effectiveBalanceThreshold_ = -1;
    private int effectiveMaxConnections_ = -1;
    private int maxConnections_ = -1;

    public PSLoad() {
        this.computeEffective();
    }

    public PSLoad(int activeConnections, int balanceThreshold, int maxConnections) {
        this.activeConnections_ = activeConnections;
        this.balanceThreshold_ = balanceThreshold;
        this.maxConnections_ = maxConnections;
        this.computeEffective();
    }

    public void allConnectionsClosed() {
        this.activeConnections_ = 0;
    }

    private void computeEffective() {
        this.effectiveMaxConnections_ = this.maxConnections_ < 0 ? Integer.MAX_VALUE : this.maxConnections_;
        this.effectiveBalanceThreshold_ = this.balanceThreshold_ < 0 ? this.effectiveMaxConnections_ : this.balanceThreshold_;
    }

    public void connectionClosed() {
        if (this.activeConnections_ > 0) {
            --this.activeConnections_;
        }
    }

    public void connectionOpened() {
        ++this.activeConnections_;
    }

    public int getActiveConnections() {
        return this.activeConnections_;
    }

    public int getBalanceThreshold() {
        return this.balanceThreshold_;
    }

    public double getBusyFactor() {
        if (this.effectiveMaxConnections_ != 0) {
            return (double)this.activeConnections_ / (double)this.effectiveMaxConnections_;
        }
        return 1.0;
    }

    public int getEffectiveBalanceThreshold() {
        return this.effectiveBalanceThreshold_;
    }

    public int getEffectiveMaxConnections() {
        return this.effectiveMaxConnections_;
    }

    public int getMaxConnections() {
        return this.maxConnections_;
    }

    public void setBalanceThreshold(int balanceThreshold) {
        if (balanceThreshold < -1) {
            throw new ExtendedIllegalArgumentException("balanceThreshold", 4);
        }
        this.balanceThreshold_ = balanceThreshold;
        this.computeEffective();
    }

    public void setMaxConnections(int maxConnections) {
        if (maxConnections < -1) {
            throw new ExtendedIllegalArgumentException("maxConnections", 4);
        }
        this.maxConnections_ = maxConnections;
        this.computeEffective();
    }
}

