/*
 * Decompiled with CFR 0.152.
 */
package org.monetdb.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.monetdb.jdbc.MonetConnection;

public class FileTransferHandler
implements MonetConnection.UploadHandler,
MonetConnection.DownloadHandler {
    private final Path root;
    private final Charset encoding;

    public FileTransferHandler(Path path, Charset charset) {
        this.root = path.toAbsolutePath().normalize();
        this.encoding = charset != null ? charset : Charset.defaultCharset();
    }

    public FileTransferHandler(String string, Charset charset) {
        this(FileSystems.getDefault().getPath(string, new String[0]), charset);
    }

    @Override
    public void handleUpload(MonetConnection.Upload upload, String string, boolean bl, long l) throws IOException {
        if (string == null || string.isEmpty()) {
            upload.sendError("Missing file name");
            return;
        }
        Path path = this.root.resolve(string).normalize();
        if (!path.startsWith(this.root)) {
            upload.sendError("File is not in upload directory: " + this.root.toString());
            return;
        }
        if (!Files.isReadable(path)) {
            upload.sendError("Cannot read file " + path.toString());
            return;
        }
        if (string.endsWith(".bz2") || string.endsWith(".lz4") || string.endsWith(".xz") || string.endsWith(".zip")) {
            String string2 = string.substring(string.lastIndexOf(46));
            upload.sendError("Specified file compression format " + string2 + " is not supported. Only .gz is supported.");
            return;
        }
        InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);
        if (string.endsWith(".gz")) {
            inputStream = new GZIPInputStream(inputStream, 131072);
        }
        if (!bl || l == 0L && this.utf8Encoded()) {
            upload.uploadFrom(inputStream);
            inputStream.close();
        } else {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, this.encoding));
            upload.uploadFrom(bufferedReader, l);
            bufferedReader.close();
        }
    }

    @Override
    public void handleDownload(MonetConnection.Download download, String string, boolean bl) throws IOException {
        if (string == null || string.isEmpty()) {
            download.sendError("Missing file name");
            return;
        }
        Path path = this.root.resolve(string).normalize();
        if (!path.startsWith(this.root)) {
            download.sendError("File is not in download directory: " + this.root.toString());
            return;
        }
        if (Files.exists(path, new LinkOption[0])) {
            download.sendError("File already exists: " + path.toString());
            return;
        }
        if (string.endsWith(".bz2") || string.endsWith(".lz4") || string.endsWith(".xz") || string.endsWith(".zip")) {
            String string2 = string.substring(string.lastIndexOf(46));
            download.sendError("Requested file compression format " + string2 + " is not supported. Use .gz instead.");
            return;
        }
        OutputStream outputStream = Files.newOutputStream(path, StandardOpenOption.CREATE_NEW);
        if (string.endsWith(".gz")) {
            outputStream = new GZIPOutputStream(outputStream, 131072);
        }
        if (!bl || this.utf8Encoded()) {
            download.downloadTo(outputStream);
            outputStream.close();
        } else {
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, this.encoding));
            download.downloadTo(bufferedWriter);
            bufferedWriter.close();
        }
    }

    public boolean utf8Encoded() {
        return this.encoding.equals(StandardCharsets.UTF_8);
    }
}

